/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.swift.types;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.swift.SwiftStructure;
import ghidra.app.util.bin.format.swift.SwiftUtils;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class FieldRecord
implements SwiftStructure {
    public static final int SIZE = 12;
    private int flags;
    private String mangledTypeName;
    private String fieldName;

    public FieldRecord(BinaryReader reader) throws IOException {
        this.flags = reader.readNextInt();
        this.mangledTypeName = reader.readNext(SwiftUtils::relativeString);
        this.fieldName = reader.readNext(SwiftUtils::relativeString);
    }

    public int getFlags() {
        return this.flags;
    }

    public String getMangledTypeName() {
        return this.mangledTypeName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getStructureName() {
        return FieldRecord.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "field record";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getStructureName(), 0);
        struct.add(DWORD, "Flags", "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "MangledTypeName", "");
        struct.add((DataType)SwiftUtils.PTR_STRING, "FieldName", "");
        struct.setCategoryPath(new CategoryPath("/Swift"));
        return struct;
    }
}

