/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.asd;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.macos.asd.EntryFactory;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EntryDescriptor
implements StructConverter {
    private int entryID;
    private int offset;
    private int length;
    private Object _entry;

    EntryDescriptor(BinaryReader reader) throws IOException {
        this.entryID = reader.readNextInt();
        this.offset = reader.readNextInt();
        this.length = reader.readNextInt();
        this._entry = EntryFactory.getEntry(reader, this);
    }

    public EntryDescriptor(int entryID, int offset, int length) {
        this.entryID = entryID;
        this.offset = offset;
        this.length = length;
    }

    public int getEntryID() {
        return this.entryID;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Object getEntry() {
        return this._entry;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(EntryDescriptor.class);
    }
}

