/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.chained;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImport;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImports;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsInImage;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DyldChainedFixupHeader
implements StructConverter {
    private int fixupsVersion;
    private int startsOffset;
    private int importsOffset;
    private int symbolsOffset;
    private int importsCount;
    private int importsFormat;
    private int symbolsFormat;
    private DyldChainedStartsInImage chainedStartsInImage;
    private DyldChainedImports chainedImports;

    public DyldChainedFixupHeader(BinaryReader reader) throws IOException {
        long ptrIndex = reader.getPointerIndex();
        this.fixupsVersion = reader.readNextInt();
        this.startsOffset = reader.readNextInt();
        this.importsOffset = reader.readNextInt();
        this.symbolsOffset = reader.readNextInt();
        this.importsCount = reader.readNextInt();
        this.importsFormat = reader.readNextInt();
        this.symbolsFormat = reader.readNextInt();
        reader.setPointerIndex(ptrIndex + (long)this.startsOffset);
        this.chainedStartsInImage = new DyldChainedStartsInImage(reader);
        reader.setPointerIndex(ptrIndex + (long)this.importsOffset);
        this.chainedImports = new DyldChainedImports(reader, this);
        reader.setPointerIndex(ptrIndex + (long)this.symbolsOffset);
        this.chainedImports.initSymbols(reader, this);
    }

    public void markup(Program program, Address address, MachHeader header, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            if (this.startsOffset != 0) {
                Address startsAddr = address.add((long)this.startsOffset);
                DataUtilities.createData((Program)program, (Address)startsAddr, (DataType)this.chainedStartsInImage.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                this.chainedStartsInImage.markup(program, startsAddr, header, monitor, log);
            }
            if (this.importsOffset != 0 && this.symbolsOffset != 0) {
                ReferenceManager referenceManager = program.getReferenceManager();
                Address importsAddr = address.add((long)this.importsOffset);
                Address symbolsAddr = address.add((long)this.symbolsOffset);
                DyldChainedImport[] chainedImportArray = this.chainedImports.getChainedImports();
                for (int i = 0; i < this.importsCount; ++i) {
                    DyldChainedImport chainedImport = chainedImportArray[i];
                    DataType dt = chainedImport.toDataType();
                    Data d = DataUtilities.createData((Program)program, (Address)importsAddr.add((long)(i * dt.getLength())), (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    Address strAddr = symbolsAddr.add(chainedImport.getNameOffset());
                    DataUtilities.createData((Program)program, (Address)symbolsAddr.add(chainedImport.getNameOffset()), (DataType)STRING, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                    referenceManager.addMemoryReference(d.getMinAddress(), strAddr, RefType.DATA, SourceType.IMPORTED, 0);
                }
            }
        }
        catch (Exception e) {
            log.appendMsg(DyldChainedFixupHeader.class.getSimpleName(), "Failed to markup dyld_chained_fixups_header");
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_chained_fixups_header", 0);
        struct.add(DWORD, "fixups_version", "0");
        struct.add(DWORD, "starts_offset", "offset of dyld_chained_starts_in_image in chain_data");
        struct.add(DWORD, "imports_offset", "offset of imports table in chain_data");
        struct.add(DWORD, "symbols_offset", "offset of symbol strings in chain_data");
        struct.add(DWORD, "imports_count", "number of imported symbol names");
        struct.add(DWORD, "imports_format", "DYLD_CHAINED_IMPORT*");
        struct.add(DWORD, "symbols_format", "0 => uncompressed, 1 => zlib compressed");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public int getFixupsVersion() {
        return this.fixupsVersion;
    }

    public int getStartsOffset() {
        return this.startsOffset;
    }

    public int getImportsOffset() {
        return this.importsOffset;
    }

    public int getSymbolsOffset() {
        return this.symbolsOffset;
    }

    public int getImportsCount() {
        return this.importsCount;
    }

    public int getImportsFormat() {
        return this.importsFormat;
    }

    public int getSymbolsFormat() {
        return this.symbolsFormat;
    }

    public boolean isCompress() {
        return this.symbolsFormat != 0;
    }

    public DyldChainedStartsInImage getChainedStartsInImage() {
        return this.chainedStartsInImage;
    }

    public DyldChainedImports getChainedImports() {
        return this.chainedImports;
    }
}

