/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.ExportTrie;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.dyld.BindOpcode;
import ghidra.app.util.bin.format.macho.commands.dyld.BindingTable;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DyldInfoCommand
extends LoadCommand {
    private int rebaseOff;
    private int rebaseSize;
    private int bindOff;
    private int bindSize;
    private int weakBindOff;
    private int weakBindSize;
    private int lazyBindOff;
    private int lazyBindSize;
    private int exportOff;
    private int exportSize;
    private BindingTable bindingTable;
    private BindingTable weakBindingTable;
    private BindingTable lazyBindingTable;
    private ExportTrie exportTrie;

    DyldInfoCommand(BinaryReader loadCommandReader, BinaryReader dataReader, MachHeader header) throws IOException {
        super(loadCommandReader);
        this.rebaseOff = loadCommandReader.readNextInt();
        this.rebaseSize = loadCommandReader.readNextInt();
        this.bindOff = loadCommandReader.readNextInt();
        this.bindSize = loadCommandReader.readNextInt();
        this.weakBindOff = loadCommandReader.readNextInt();
        this.weakBindSize = loadCommandReader.readNextInt();
        this.lazyBindOff = loadCommandReader.readNextInt();
        this.lazyBindSize = loadCommandReader.readNextInt();
        this.exportOff = loadCommandReader.readNextInt();
        this.exportSize = loadCommandReader.readNextInt();
        if (this.bindOff > 0 && this.bindSize > 0) {
            dataReader.setPointerIndex(header.getStartIndex() + (long)this.bindOff);
            this.bindingTable = new BindingTable(dataReader, header, this.bindSize, false);
        } else {
            this.bindingTable = new BindingTable();
        }
        if (this.weakBindOff > 0 && this.weakBindSize > 0) {
            dataReader.setPointerIndex(header.getStartIndex() + (long)this.weakBindOff);
            this.weakBindingTable = new BindingTable(dataReader, header, this.weakBindSize, false);
        } else {
            this.weakBindingTable = new BindingTable();
        }
        if (this.lazyBindOff > 0 && this.lazyBindSize > 0) {
            dataReader.setPointerIndex(header.getStartIndex() + (long)this.lazyBindOff);
            this.lazyBindingTable = new BindingTable(dataReader, header, this.lazyBindSize, true);
        } else {
            this.lazyBindingTable = new BindingTable();
        }
        if (this.exportOff > 0 && this.exportSize > 0) {
            dataReader.setPointerIndex(header.getStartIndex() + (long)this.exportOff);
            this.exportTrie = new ExportTrie(dataReader);
        } else {
            this.exportTrie = new ExportTrie();
        }
    }

    public int getRebaseOffset() {
        return this.rebaseOff;
    }

    public int getRebaseSize() {
        return this.rebaseSize;
    }

    public int getBindOffset() {
        return this.bindOff;
    }

    public int getBindSize() {
        return this.bindSize;
    }

    public int getWeakBindOffset() {
        return this.weakBindOff;
    }

    public int getWeakBindSize() {
        return this.weakBindSize;
    }

    public int getLazyBindOffset() {
        return this.lazyBindOff;
    }

    public int getLazyBindSize() {
        return this.lazyBindSize;
    }

    public int getExportOffset() {
        return this.exportOff;
    }

    public int getExportSize() {
        return this.exportSize;
    }

    public BindingTable getBindingTable() {
        return this.bindingTable;
    }

    public BindingTable getLazyBindingTable() {
        return this.lazyBindingTable;
    }

    public BindingTable getWeakBindingTable() {
        return this.weakBindingTable;
    }

    public ExportTrie getExportTrie() {
        return this.exportTrie;
    }

    @Override
    public String getCommandName() {
        return "dyld_info_command";
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "rebase_off", "file offset to rebase info");
        struct.add(DWORD, "rebase_size", "size of rebase info");
        struct.add(DWORD, "bind_off", "file offset to binding info");
        struct.add(DWORD, "bind_size", "size of binding info");
        struct.add(DWORD, "weak_bind_off", "file offset to weak binding info");
        struct.add(DWORD, "weak_bind_size", "size of weak binding info");
        struct.add(DWORD, "lazy_bind_off", "file offset to lazy binding info");
        struct.add(DWORD, "lazy_bind_size", "size of lazy binding info");
        struct.add(DWORD, "export_off", "file offset to lazy binding info");
        struct.add(DWORD, "export_size", "size of lazy binding info");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.markupRebaseInfo(program, header, source, monitor, log);
        this.markupBindings(program, header, source, monitor, log);
        this.markupWeakBindings(program, header, source, monitor, log);
        this.markupLazyBindings(program, header, source, monitor, log);
        this.markupExportInfo(program, header, source, monitor, log);
    }

    private void markupRebaseInfo(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        this.markupPlateComment(program, this.fileOffsetToAddress(program, header, this.rebaseOff, this.rebaseSize), source, "rebase");
    }

    private void markupBindings(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address bindAddr = this.fileOffsetToAddress(program, header, this.bindOff, this.bindSize);
        this.markupPlateComment(program, bindAddr, source, "bind");
        this.markupBindingTable(program, bindAddr, this.bindingTable, source, "bind", log);
    }

    private void markupWeakBindings(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address addr = this.fileOffsetToAddress(program, header, this.weakBindOff, this.weakBindSize);
        this.markupPlateComment(program, addr, source, "weak bind");
        this.markupBindingTable(program, addr, this.weakBindingTable, source, "weak bind", log);
    }

    private void markupLazyBindings(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address addr = this.fileOffsetToAddress(program, header, this.lazyBindOff, this.lazyBindSize);
        this.markupPlateComment(program, addr, source, "lazy bind");
        this.markupBindingTable(program, addr, this.lazyBindingTable, source, "lazy bind", log);
    }

    private void markupBindingTable(Program program, Address addr, BindingTable table, String source, String additionalDescription, MessageLog log) {
        if (addr == null) {
            return;
        }
        try {
            DataType bindOpcodeDataType = BindOpcode.toDataType();
            for (long offset : table.getOpcodeOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)bindOpcodeDataType, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : table.getUlebOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)ULEB128, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : table.getSlebOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)SLEB128, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : table.getStringOffsets()) {
                DataUtilities.createData((Program)program, (Address)addr.add(offset), (DataType)STRING, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
        }
        catch (Exception e) {
            log.appendMsg(DyldInfoCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, additionalDescription));
        }
    }

    private void markupExportInfo(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) {
        Address exportAddr = this.fileOffsetToAddress(program, header, this.exportOff, this.exportSize);
        if (exportAddr == null) {
            return;
        }
        this.markupPlateComment(program, exportAddr, source, "export");
        try {
            for (long offset : this.exportTrie.getUlebOffsets()) {
                DataUtilities.createData((Program)program, (Address)exportAddr.add(offset), (DataType)ULEB128, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            for (long offset : this.exportTrie.getStringOffsets()) {
                DataUtilities.createData((Program)program, (Address)exportAddr.add(offset), (DataType)STRING, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
        }
        catch (Exception e) {
            log.appendMsg(DyldInfoCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, "export"));
        }
    }

    @Override
    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        try {
            Address start;
            super.markupRawBinary(header, api, baseAddress, parentModule, monitor, log);
            if (this.rebaseSize > 0) {
                start = baseAddress.getNewAddress((long)this.rebaseOff);
                api.createFragment(parentModule, this.getCommandName() + "_REBASE", start, this.rebaseSize);
            }
            if (this.bindSize > 0) {
                start = baseAddress.getNewAddress((long)this.bindOff);
                api.createFragment(parentModule, this.getCommandName() + "_BIND", start, this.bindSize);
            }
            if (this.weakBindSize > 0) {
                start = baseAddress.getNewAddress((long)this.weakBindOff);
                api.createFragment(parentModule, this.getCommandName() + "_WEAK_BIND", start, this.weakBindSize);
            }
            if (this.lazyBindSize > 0) {
                start = baseAddress.getNewAddress((long)this.lazyBindOff);
                api.createFragment(parentModule, this.getCommandName() + "_LAZY_BIND", start, this.lazyBindSize);
            }
            if (this.exportSize > 0) {
                start = baseAddress.getNewAddress((long)this.exportOff);
                api.createFragment(parentModule, this.getCommandName() + "_EXPORT", start, this.exportSize);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }
}

