/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.BundleHost;
import ghidra.app.plugin.core.osgi.OSGiException;
import ghidra.app.plugin.core.osgi.OSGiParallelLock;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.ScriptInfo;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import utilities.util.FileUtilities;

public class GhidraScriptUtil {
    public static String USER_SCRIPTS_DIR = GhidraScriptUtil.buildUserScriptsDirectory();
    private static BundleHost bundleHost;
    private static final String SCRIPTS_SUBDIR_NAME = "ghidra_scripts";
    private static final String DEV_SCRIPTS_SUBDIR_NAME = "developer_scripts";
    private static List<GhidraScriptProvider> providers;
    private static AtomicInteger referenceCount;

    public static BundleHost getBundleHost() {
        return bundleHost;
    }

    private static void setBundleHost(BundleHost aBundleHost) {
        if (bundleHost != null) {
            throw new RuntimeException("GhidraScriptUtil initialized multiple times!");
        }
        try (OSGiParallelLock lock = new OSGiParallelLock();){
            bundleHost = aBundleHost;
            bundleHost.startFramework();
        }
        catch (OSGiException | IOException e) {
            Msg.error(GhidraScriptUtil.class, (Object)"Failed to initialize BundleHost", (Throwable)e);
        }
    }

    public static void initialize(BundleHost aBundleHost, List<String> extraSystemPaths) {
        GhidraScriptUtil.setBundleHost(aBundleHost);
        if (extraSystemPaths != null) {
            for (String path : extraSystemPaths) {
                bundleHost.add(new ResourceFile(path), true, true);
            }
        }
        bundleHost.add(GhidraScriptUtil.getUserScriptDirectory(), true, false);
        bundleHost.add(GhidraScriptUtil.getSystemScriptDirectories(), true, true);
    }

    public static void dispose() {
        if (bundleHost != null) {
            bundleHost.stopFramework();
            bundleHost = null;
        }
        providers = null;
    }

    public static List<ResourceFile> getScriptSourceDirectories() {
        return bundleHost.getBundleFiles().stream().filter(ResourceFile::isDirectory).collect(Collectors.toList());
    }

    public static List<ResourceFile> getEnabledScriptSourceDirectories() {
        return bundleHost.getEnabledBundleFiles().stream().filter(ResourceFile::isDirectory).collect(Collectors.toList());
    }

    public static ResourceFile findSourceDirectoryContaining(ResourceFile sourceFile) {
        for (ResourceFile sourceDir : GhidraScriptUtil.getScriptSourceDirectories()) {
            if (FileUtilities.relativizePath((ResourceFile)sourceDir, (ResourceFile)sourceFile) == null) continue;
            return sourceDir;
        }
        Msg.error(GhidraScriptUtil.class, (Object)("Failed to find script in any script directory: " + sourceFile.toString()));
        return null;
    }

    public static ResourceFile findScriptByName(String scriptName) {
        return GhidraScriptUtil.findScriptFileInPaths(GhidraScriptUtil.getScriptSourceDirectories(), scriptName);
    }

    private static String buildUserScriptsDirectory() {
        String root = System.getProperty("user.home");
        String override = System.getProperty("ghidra.user.scripts.dir");
        if (override != null) {
            Msg.debug(GhidraScriptUtil.class, (Object)("Using Ghidra script source directory: " + root));
            root = override;
        }
        String sourcePath = root + File.separator + SCRIPTS_SUBDIR_NAME;
        return sourcePath;
    }

    public static List<ResourceFile> getSystemScriptDirectories() {
        ArrayList<ResourceFile> dirList = new ArrayList<ResourceFile>();
        GhidraScriptUtil.addScriptDirectories(dirList, SCRIPTS_SUBDIR_NAME);
        GhidraScriptUtil.addScriptDirectories(dirList, DEV_SCRIPTS_SUBDIR_NAME);
        Collections.sort(dirList);
        return dirList;
    }

    public static ResourceFile getUserScriptDirectory() {
        return new ResourceFile(USER_SCRIPTS_DIR);
    }

    private static void addScriptDirectories(List<ResourceFile> dirList, String directoryName) {
        dirList.addAll(Application.findModuleSubDirectories((String)directoryName));
    }

    public static boolean isSystemScript(ResourceFile file) {
        return GhidraScriptUtil.isSystemFile(file);
    }

    private static boolean isSystemFile(ResourceFile file) {
        try {
            String filePath = file.getCanonicalPath().replace('\\', '/');
            if (filePath.startsWith(USER_SCRIPTS_DIR)) {
                return false;
            }
            Collection roots = Application.getApplicationRootDirectories();
            for (ResourceFile resourceFile : roots) {
                String installPath = resourceFile.getCanonicalPath().replace('\\', '/');
                if (!filePath.startsWith(installPath)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            Msg.error(GhidraScriptUtil.class, (Object)("Failed to find file in system directories: " + file.toString()), (Throwable)e);
            return true;
        }
    }

    @Deprecated
    public static List<ResourceFile> getExplodedCompiledSourceBundlePaths() {
        List<ResourceFile> list;
        block8: {
            Stream<Path> pathStream = Files.list(BundleHost.getOsgiDir());
            try {
                list = pathStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(x -> new ResourceFile(x.toFile())).collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Msg.showError(GhidraScriptUtil.class, null, (String)"error", (Object)"error listing user osgi directory", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            pathStream.close();
        }
        return list;
    }

    public static String getBaseName(ResourceFile script) {
        String name = script.getName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return name;
        }
        return name.substring(0, pos);
    }

    public static synchronized List<GhidraScriptProvider> getProviders() {
        if (providers == null) {
            ArrayList<GhidraScriptProvider> newProviders = new ArrayList<GhidraScriptProvider>(ClassSearcher.getInstances(GhidraScriptProvider.class));
            Collections.sort(newProviders);
            providers = newProviders;
        }
        return providers;
    }

    public static GhidraScriptProvider getProvider(ResourceFile scriptFile) {
        return GhidraScriptUtil.findProvider(scriptFile.getName());
    }

    public static boolean hasScriptProvider(ResourceFile scriptFile) {
        return GhidraScriptUtil.findProvider(scriptFile.getName()) != null;
    }

    private static GhidraScriptProvider findProvider(String fileName) {
        fileName = fileName.toLowerCase();
        for (GhidraScriptProvider provider : GhidraScriptUtil.getProviders()) {
            if (!fileName.endsWith(provider.getExtension().toLowerCase())) continue;
            return provider;
        }
        return null;
    }

    public static ResourceFile createNewScript(GhidraScriptProvider provider, ResourceFile parentDirectory, List<ResourceFile> scriptDirectories) throws IOException {
        String baseName = "NewScript";
        String extension = provider.getExtension();
        return GhidraScriptUtil.createNewScript(baseName, extension, parentDirectory, scriptDirectories);
    }

    private static ResourceFile createNewScript(String scriptName, String extension, ResourceFile parentDirctory, List<ResourceFile> scriptDirectories) throws IOException {
        boolean exists;
        Object baseName = scriptName;
        String className = (String)baseName + extension;
        int counter = 1;
        boolean bl = exists = GhidraScriptUtil.findScriptFileInPaths(scriptDirectories, className) != null;
        while (exists) {
            boolean bl2 = exists = GhidraScriptUtil.findScriptFileInPaths(scriptDirectories, className = (String)(baseName = scriptName + counter++) + extension) != null;
            if (counter <= 1000) continue;
            throw new IOException("Unable to create new script file, temporary files exceeded.");
        }
        return new ResourceFile(parentDirctory, className);
    }

    public static ScriptInfo newScriptInfo(ResourceFile file) {
        return new ScriptInfo(GhidraScriptUtil.getProvider(file), file);
    }

    @Deprecated
    static String fixupName(String name) {
        GhidraScriptProvider provider = GhidraScriptUtil.findProvider((String)name);
        if (provider == null) {
            name = (String)name + ".java";
            provider = GhidraScriptUtil.findProvider(".java");
        }
        return provider.fixupName((String)name);
    }

    static ResourceFile findScriptFileInPaths(Collection<ResourceFile> scriptDirectories, String name) {
        String validatedName = GhidraScriptUtil.fixupName(name);
        for (ResourceFile resourceFile : scriptDirectories) {
            ResourceFile file;
            if (!resourceFile.isDirectory() || !(file = new ResourceFile(resourceFile, validatedName)).exists()) continue;
            return file;
        }
        return null;
    }

    public static BundleHost acquireBundleHostReference() {
        if (referenceCount.getAndIncrement() == 0) {
            GhidraScriptUtil.initialize(new BundleHost(), null);
        }
        return bundleHost;
    }

    public static void releaseBundleHostReference() {
        if (referenceCount.getAndDecrement() == 1) {
            GhidraScriptUtil.dispose();
        }
    }

    static {
        referenceCount = new AtomicInteger(0);
    }
}

