/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisClass;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisUtils;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDAActionTable;
import ghidra.app.util.bin.LEB128Info;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.SignedLeb128DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.task.TaskMonitor;

public class LSDAActionRecord
extends GccAnalysisClass {
    public static final long NO_ACTION = 0L;
    private final LSDAActionTable lsdaActionTable;
    private Address recordAddress;
    private Address nextAddress;
    private int typeFilter;
    private int displacementToNext;
    private Address nextActionAddress;
    private int size = 0;

    public LSDAActionRecord(TaskMonitor monitor, Program program, RegionDescriptor region, LSDAActionTable lsdaActionTable) {
        super(monitor, program);
        this.lsdaActionTable = lsdaActionTable;
    }

    public void create(Address address) throws MemoryAccessException {
        if (address == null) {
            throw new IllegalArgumentException("action record's address cannot be null.");
        }
        if (this.monitor.isCancelled()) {
            return;
        }
        this.recordAddress = address;
        Address addr = address;
        this.size = 0;
        addr = this.createTypeFilter(addr);
        addr = this.createNextActionRef(addr);
        SetCommentCmd commentCmd = new SetCommentCmd(address, 3, "(LSDA) Action Record");
        commentCmd.applyTo((DomainObject)this.program);
        this.nextAddress = addr;
    }

    private Address createTypeFilter(Address addr) throws MemoryAccessException {
        String comment = "(LSDA Action Table) Type Filter";
        LEB128Info sleb128 = GccAnalysisUtils.readSLEB128Info(this.program, addr);
        this.typeFilter = (int)sleb128.asLong();
        LSDAActionRecord.createAndCommentData(this.program, addr, (DataType)SignedLeb128DataType.dataType, comment, 0);
        this.size += sleb128.getLength();
        return addr.add((long)sleb128.getLength());
    }

    private Address createNextActionRef(Address addr) throws MemoryAccessException {
        String comment = "(LSDA Action Table) Next-Action Reference";
        LEB128Info sleb128 = GccAnalysisUtils.readSLEB128Info(this.program, addr);
        this.displacementToNext = (int)sleb128.asLong();
        this.nextActionAddress = this.displacementToNext == 0 ? Address.NO_ADDRESS : addr.add((long)this.displacementToNext);
        LSDAActionRecord.createAndCommentData(this.program, addr, (DataType)SignedLeb128DataType.dataType, comment, 0);
        this.size += sleb128.getLength();
        return addr.add((long)sleb128.getLength());
    }

    public int getActionTypeFilter() {
        return this.typeFilter;
    }

    public Address getNextActionAddress() {
        return this.nextActionAddress;
    }

    public Address getNextAddress() {
        return this.nextAddress;
    }

    public Address getAddress() {
        return this.recordAddress;
    }

    public LSDAActionRecord getNextAction() {
        Address recAddr = this.getNextActionAddress();
        if (this.lsdaActionTable.getAddress().equals((Object)recAddr)) {
            return null;
        }
        if (recAddr == Address.NO_ADDRESS) {
            return null;
        }
        for (LSDAActionRecord rec : this.lsdaActionTable.getActionRecords()) {
            if (!rec.getAddress().equals((Object)recAddr)) continue;
            return rec;
        }
        throw new IllegalArgumentException("Invalid action table record address");
    }

    public int getSize() {
        return this.size;
    }
}

