/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import ghidra.app.plugin.core.terminal.TerminalListener;
import ghidra.app.plugin.core.terminal.TerminalProvider;
import ghidra.app.services.Terminal;
import ghidra.util.Swing;
import java.nio.ByteBuffer;

public class DefaultTerminal
implements Terminal {
    protected final TerminalProvider provider;

    public DefaultTerminal(TerminalProvider provider) {
        this.provider = provider;
    }

    @Override
    public void close() {
        Swing.runIfSwingOrRunLater(() -> this.provider.removeFromTool());
    }

    @Override
    public void terminated() {
        this.provider.terminated();
    }

    @Override
    public boolean isTerminated() {
        return this.provider.isTerminated();
    }

    @Override
    public void addTerminalListener(TerminalListener listener) {
        this.provider.addTerminalListener(listener);
    }

    @Override
    public void removeTerminalListener(TerminalListener listener) {
        this.provider.removeTerminalListener(listener);
    }

    @Override
    public void injectDisplayOutput(ByteBuffer bb) {
        this.provider.processInput(bb);
    }

    @Override
    public void setSubTitle(String title) {
        Swing.runIfSwingOrRunLater(() -> this.provider.setSubTitle(title));
    }

    @Override
    public String getSubTitle() {
        return this.provider.getSubTitle();
    }

    @Override
    public void setFixedSize(short cols, short rows) {
        this.provider.setFixedSize(cols, rows);
    }

    @Override
    public void setDynamicSize() {
        this.provider.setDyanmicSize();
    }

    @Override
    public int getColumns() {
        return this.provider.getColumns();
    }

    @Override
    public int getRows() {
        return this.provider.getRows();
    }

    @Override
    public void setMaxScrollBackRows(int rows) {
        this.provider.setMaxScrollBackRows(rows);
    }

    @Override
    public int getScrollBackRows() {
        return this.provider.getScrollBackRows();
    }

    @Override
    public String getDisplayText() {
        return this.getRangeText(0, 0, this.getColumns(), this.getRows());
    }

    @Override
    public String getFullText() {
        return this.getRangeText(0, -this.getScrollBackRows(), this.getColumns(), this.getRows());
    }

    @Override
    public String getLineText(int line) {
        return this.getRangeText(0, line, this.getColumns(), line);
    }

    @Override
    public String getRangeText(int startCol, int startLine, int endCol, int endLine) {
        return this.provider.getRangeText(startCol, startLine, endCol, endLine);
    }

    @Override
    public int getCursorColumn() {
        return this.provider.getCursorColumn();
    }

    @Override
    public int getCursorRow() {
        return this.provider.getCursorRow();
    }

    @Override
    public void setTerminateAction(Runnable action) {
        Swing.runIfSwingOrRunLater(() -> this.provider.setTerminateAction(action));
    }
}

