/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string;

import ghidra.app.plugin.core.string.NGramUtils;
import ghidra.app.plugin.core.string.StringAndScores;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.string.FoundString;
import ghidra.program.util.string.FoundStringCallback;
import ghidra.program.util.string.StringSearcher;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class StringsAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "ASCII Strings";
    private static final String DESCRIPTION = "This analyzer searches for valid ASCII strings and automatically creates them in the binary.";
    private static final String MODELFILE_OPTION_NAME = "Model File";
    private static final String MODELFILE_OPTION_DESCRIPTION = "Any model files for this analyzer should be located in the Ghidra/Features/Base/data/stringngrams directory and end in \".sng\".";
    private static final String FORCE_MODEL_RELOAD_OPTION_NAME = "Force Model Reload";
    private static final String FORCE_MODEL_RELOAD_OPTION_DESCRIPTION = "When checked, forces reload of model files every time the analyzer is run. When unchecked, model files will only be reloaded when Ghidra is restarted or when model file option name is changed.";
    private static final String MINIMUM_STRING_LENGTH_OPTION_NAME = "Minimum String Length";
    private static final String MINIMUM_STRING_LENGTH_OPTION_DESCRIPTION = "The smallest number of characters in a string to be considered a valid string. (Smaller numbers will give more false positives). String length must be 4 or greater.";
    private static final String REQUIRE_NULL_TERMINATION_OPTION_NAME = "Require Null Termination for String";
    private static final String REQUIRE_NULL_TERMINATION_OPTION_DESCRIPTION = "If set to true, requires all strings to end in null.";
    private static final String ALLOW_STRING_CREATION_WITH_MIDDLE_REF_NAME = "Create Strings Containing References";
    private static final String ALLOW_STRING_CREATION_WITH_MIDDLE_REF_DESCRIPTION = "If checked, allows a string that contains, but does not start with, one or more references to be created.";
    private static final String ALLOW_STRING_CREATION_WITH_EXISTING_SUBSTR_NAME = "Create Strings Containing Existing Strings";
    private static final String ALLOW_STRING_CREATION_WITH_EXISTING_SUBSTR_DESCRIPTION = "If checked, allows a string to be created even if it contains existing strings (existing strings will be cleared). The string will be created only if existing strings (a) are wholly contained within the potential string, (b) do not share the same starting address as the potential string, (c) share the same ending address as the potential string, and (d) are the same datatype as the potential string.";
    private static final String START_ALIGNMENT_OPTION_NAME = "String Start Alignment";
    private static final String START_ALIGNMENT_OPTION_DESCRIPTION = "Specifies an alignment requirement for the start of the string. An alignment of 1 means the string can start at any address.  An alignment of 2 means the string must start on an even address and so on.  Only allowed values are 1,2, and 4.";
    private static final String END_ALIGNMENT_OPTION_NAME = "String end alignment";
    private static final String END_ALIGNMENT_OPTION_DESCRIPTION = "Specifies an alignment requirement for the end of the string. An alignment of 1 means the string can end at any address. Alignments greater than 1 require that (a) the 'require null termination' option be enabled, and (b) if the null-terminated string does not end at an aligned boundary, that there exist enough trailing '0' bytes following the string to allow alignment. If neither (a) nor (b) apply, end alignment is not enforced.";
    private static final String SEARCH_ONLY_ACCESSIBLE_MEM_BLOCKS_NAME = "Search Only in Accessible Memory Blocks";
    private static final String SEARCH_ONLY_ACCESSIBLE_MEM_BLOCKS_DESCRIPTION = "If checked, this analyzer only searches in memory blocks that have at least one of the Read (R), Write (W), or Execute (X) permissions set to true. Enabling this option ensures that strings are not created in areas such as overlays or debug sections.";
    private static final String MODEL_DEFAULT_NAME = "StringModel.sng";
    private static final boolean FORCE_MODEL_RELOAD_DEFAULT_VALUE = false;
    private static final boolean REQUIRE_NULL_TERMINATION_DEFAULT_VALUE = true;
    private static final boolean ALL_CHAR_WIDTHS_DEFAULT_VALUE = false;
    private static final boolean ALLOW_STRING_CREATION_WITH_MIDDLE_REF_DEFAULT = true;
    private static final boolean ALLOW_STRING_CREATION_WITH_EXISTING_SUBSTR_DEFAULT = true;
    private static final boolean SEARCH_ONLY_ACCESSIBLE_MEM_BLOCKS_DEFAULT = true;
    private static Alignment[] alignmentChoices = new Alignment[]{Alignment.ALIGN_1, Alignment.ALIGN_2, Alignment.ALIGN_4};
    private static Alignment START_ALIGNMENT_DEFAULT_VALUE = Alignment.ALIGN_1;
    private static int END_ALIGNMENT_DEFAULT_VALUE = 4;
    private static final MinStringLen MINIMUM_STRING_LENGTH_DEFAULT_VALUE = MinStringLen.LEN_5;
    private static final int ABSOLUTE_MIN_STR_LENGTH = NGramUtils.getMinimumStringLength();
    private String modelName = "StringModel.sng";
    private boolean forceModelReload = false;
    private int minStringLength = MINIMUM_STRING_LENGTH_DEFAULT_VALUE.getMinLength();
    private boolean requireNullEnd = true;
    private int startAlignment = START_ALIGNMENT_DEFAULT_VALUE.getAlignment();
    private int endAlignment = END_ALIGNMENT_DEFAULT_VALUE;
    private boolean allowStringCreationWithOffcutReferences = true;
    private boolean allowStringCreationWithExistringSubstring = true;
    private boolean searchOnlyAccessibleMemBlocks = true;
    private boolean allCharWidths = false;
    private String trigramFile = "StringModel.sng";
    private boolean isLowerCaseModel = false;
    private CodeUnitIterator instructionIterator;
    private CodeUnitIterator definedDataIterator;
    private CodeUnit currInstrCU;
    private CodeUnit currDataCU;
    private Address instrStart;
    private Address instrEnd;
    private Address dataStart;
    private Address dataEnd;

    public StringsAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.after().after().after().after().after());
    }

    @Override
    public boolean canAnalyze(Program program) {
        return program.getMinAddress() != null;
    }

    void setCreateStringOverExistingString(boolean b) {
        this.allowStringCreationWithExistringSubstring = b;
    }

    void setCreateStringOverExistingReference(boolean b) {
        this.allowStringCreationWithOffcutReferences = b;
    }

    void setMinStringLength(int length) {
        this.minStringLength = length;
    }

    void setRequireNullTermination(boolean b) {
        this.requireNullEnd = b;
    }

    void setStringStartAlignment(int alignment) {
        boolean validChoice = false;
        for (Alignment choice : alignmentChoices) {
            if (choice.getAlignment() != alignment) continue;
            validChoice = true;
            break;
        }
        if (validChoice) {
            this.startAlignment = alignment;
        } else {
            Msg.error((Object)this, (Object)("'" + alignment + " is not a valid string start alignment! Setting alignment to default of " + START_ALIGNMENT_DEFAULT_VALUE.getAlignment()));
            this.startAlignment = START_ALIGNMENT_DEFAULT_VALUE.getAlignment();
        }
    }

    void setModelName(String name) {
        this.modelName = name;
        this.setTrigramFileName(this.modelName);
    }

    void setForceModelReload(boolean b) {
        this.forceModelReload = b;
    }

    void setStringEndAlignment(int alignment) {
        this.endAlignment = alignment <= 0 ? 1 : alignment;
    }

    void setSearchAccessibleMemoryBlocks(boolean b) {
        this.searchOnlyAccessibleMemBlocks = b;
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AddressFactory factory = program.getAddressFactory();
        AddressSpace[] addressSpaces = factory.getAddressSpaces();
        AddressSetView initializedMemory = program.getMemory().getLoadedAndInitializedAddressSet();
        try {
            NGramUtils.startNewSession(this.trigramFile, this.forceModelReload);
            this.isLowerCaseModel = NGramUtils.isLowerCaseModel();
            if (set == null) {
                set = new AddressSet(initializedMemory);
            }
            AddressSet searchSet = initializedMemory.intersect(set);
            if (this.searchOnlyAccessibleMemBlocks) {
                AddressSpace[] blocks = program.getMemory().getBlocks();
                AddressSet memoryBlockAddresses = this.getMemoryBlockAddresses((MemoryBlock[])blocks);
                searchSet = searchSet.intersect((AddressSetView)memoryBlockAddresses);
            }
            for (AddressSpace space : addressSpaces) {
                monitor.checkCancelled();
                AddressSet intersecting = searchSet.intersectRange(space.getMinAddress(), space.getMaxAddress());
                this.instructionIterator = null;
                this.definedDataIterator = null;
                this.currInstrCU = null;
                this.currDataCU = null;
                this.findStrings(program, (AddressSetView)intersecting, this.minStringLength, this.startAlignment, this.requireNullEnd, this.allCharWidths, monitor);
            }
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (IOException e) {
            String msg = "Error accessing string model file: " + this.trigramFile + ": " + e.getMessage();
            log.appendMsg(msg);
            log.setStatus(msg);
            return false;
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Unexpected exception during string analysis", (Throwable)e);
            log.setStatus("Unexpected exception during string analysis (see console)");
            return false;
        }
        return true;
    }

    private AddressSet getMemoryBlockAddresses(MemoryBlock[] blocks) {
        AddressSet addresses = new AddressSet();
        for (MemoryBlock memBlock : blocks) {
            if (memBlock.getPermissions() <= 0) continue;
            addresses = addresses.union((AddressSetView)new AddressSet(memBlock.getStart(), memBlock.getEnd()));
        }
        return addresses;
    }

    private void createStringIfValid(FoundString foundString, Program program, AddressSetView addressSet, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        Memory memory = program.getMemory();
        StringAndScores candidate = new StringAndScores(foundString.getString(memory), this.isLowerCaseModel);
        int scoredLength = candidate.getScoredStringLength();
        if (scoredLength < ABSOLUTE_MIN_STR_LENGTH) {
            return;
        }
        NGramUtils.scoreString(candidate);
        if (!candidate.isScoreAboveThreshold()) {
            return;
        }
        Address start = foundString.getAddress();
        Address end = foundString.getEndAddress();
        DataType dataType = foundString.getDataType();
        Listing listing = program.getListing();
        if (!DataUtilities.isUndefinedRange((Program)program, (Address)start, (Address)end)) {
            if (this.allowStringCreationWithExistringSubstring) {
                Data definedData = listing.getDefinedDataContaining(end);
                if (definedData == null || definedData.getAddress().compareTo((Object)start) <= 0 || !dataType.isEquivalent(definedData.getDataType()) || !DataUtilities.isUndefinedRange((Program)program, (Address)start, (Address)definedData.getAddress().previous())) {
                    return;
                }
            } else {
                return;
            }
        }
        boolean hasOffcutReferences = false;
        if (!this.allowStringCreationWithOffcutReferences) {
            hasOffcutReferences = this.hasOffcut(start, end, program);
        }
        if (hasOffcutReferences && !this.allowStringCreationWithOffcutReferences) {
            return;
        }
        try {
            int padLength;
            int length = foundString.getLength();
            if (this.requireNullEnd && this.endAlignment > 1 && (padLength = this.getStringPadLength(program, end)) > 0) {
                length += this.getValidPadLength(program, end, padLength);
            }
            DataUtilities.createData((Program)program, (Address)start, (DataType)foundString.getDataType(), (int)length, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
            Msg.trace((Object)this, (Object)("Created string '" + candidate.getOriginalString() + "' at " + start));
            monitor.setMessage("Creating String at " + start);
        }
        catch (Exception e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
    }

    private int getStringPadLength(Program program, Address endAddress) {
        Address nextAddr = endAddress.next();
        if (nextAddr == null) {
            return 0;
        }
        long modResult = nextAddr.getOffset() % (long)this.endAlignment;
        if (modResult == 0L) {
            return 0;
        }
        int padBytesNeeded = this.endAlignment - (int)modResult;
        try {
            byte[] bytes = new byte[padBytesNeeded];
            if (program.getMemory().getBytes(nextAddr, bytes) == padBytesNeeded) {
                for (byte b : bytes) {
                    if (b == 0) continue;
                    return 0;
                }
            }
        }
        catch (Exception e) {
            return 0;
        }
        return padBytesNeeded;
    }

    private int getValidPadLength(Program program, Address stringEndAddress, int padLength) {
        Listing listing = program.getListing();
        Address address = stringEndAddress;
        for (int i = 0; i < padLength; ++i) {
            if ((address = address.next()) == null) {
                return 0;
            }
            CodeUnit cu = listing.getCodeUnitContaining(address);
            if (cu == null) {
                return 0;
            }
            if (cu instanceof Data && !((Data)cu).isDefined()) continue;
            return 0;
        }
        return padLength;
    }

    private boolean hasOffcut(Address startAddress, Address endAddress, Program program) {
        for (Address currentAddress = startAddress.next(); currentAddress != null && currentAddress.compareTo((Object)endAddress) <= 0; currentAddress = currentAddress.next()) {
            if (!program.getReferenceManager().hasReferencesTo(currentAddress)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(MODELFILE_OPTION_NAME, (Object)MODEL_DEFAULT_NAME, null, MODELFILE_OPTION_DESCRIPTION);
        options.registerOption(MINIMUM_STRING_LENGTH_OPTION_NAME, (Object)MINIMUM_STRING_LENGTH_DEFAULT_VALUE, null, MINIMUM_STRING_LENGTH_OPTION_DESCRIPTION);
        options.registerOption(REQUIRE_NULL_TERMINATION_OPTION_NAME, (Object)true, null, REQUIRE_NULL_TERMINATION_OPTION_DESCRIPTION);
        options.registerOption(START_ALIGNMENT_OPTION_NAME, (Object)START_ALIGNMENT_DEFAULT_VALUE, null, START_ALIGNMENT_OPTION_DESCRIPTION);
        options.registerOption(END_ALIGNMENT_OPTION_NAME, (Object)END_ALIGNMENT_DEFAULT_VALUE, null, END_ALIGNMENT_OPTION_DESCRIPTION);
        options.registerOption(FORCE_MODEL_RELOAD_OPTION_NAME, (Object)false, null, FORCE_MODEL_RELOAD_OPTION_DESCRIPTION);
        options.registerOption(ALLOW_STRING_CREATION_WITH_MIDDLE_REF_NAME, (Object)true, null, ALLOW_STRING_CREATION_WITH_MIDDLE_REF_DESCRIPTION);
        options.registerOption(ALLOW_STRING_CREATION_WITH_EXISTING_SUBSTR_NAME, (Object)true, null, ALLOW_STRING_CREATION_WITH_EXISTING_SUBSTR_DESCRIPTION);
        options.registerOption(SEARCH_ONLY_ACCESSIBLE_MEM_BLOCKS_NAME, (Object)true, null, SEARCH_ONLY_ACCESSIBLE_MEM_BLOCKS_DESCRIPTION);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.modelName = options.getString(MODELFILE_OPTION_NAME, MODEL_DEFAULT_NAME);
        this.setTrigramFileName(this.modelName);
        this.minStringLength = ((MinStringLen)options.getEnum(MINIMUM_STRING_LENGTH_OPTION_NAME, (Enum)MINIMUM_STRING_LENGTH_DEFAULT_VALUE)).getMinLength();
        this.requireNullEnd = options.getBoolean(REQUIRE_NULL_TERMINATION_OPTION_NAME, true);
        this.startAlignment = ((Alignment)options.getEnum(START_ALIGNMENT_OPTION_NAME, (Enum)START_ALIGNMENT_DEFAULT_VALUE)).getAlignment();
        this.setStringEndAlignment(options.getInt(END_ALIGNMENT_OPTION_NAME, END_ALIGNMENT_DEFAULT_VALUE));
        this.forceModelReload = options.getBoolean(FORCE_MODEL_RELOAD_OPTION_NAME, false);
        this.allowStringCreationWithOffcutReferences = options.getBoolean(ALLOW_STRING_CREATION_WITH_MIDDLE_REF_NAME, true);
        this.allowStringCreationWithExistringSubstring = options.getBoolean(ALLOW_STRING_CREATION_WITH_EXISTING_SUBSTR_NAME, true);
        this.searchOnlyAccessibleMemBlocks = options.getBoolean(SEARCH_ONLY_ACCESSIBLE_MEM_BLOCKS_NAME, true);
    }

    private void setTrigramFileName(String name) {
        this.trigramFile = name.endsWith(".sng") ? name : name + ".sng";
    }

    private void findStrings(Program program, AddressSetView addressSet, int minimumStringLength, int alignVal, boolean requireNullTermination, boolean includeAllCharWidths, TaskMonitor monitor) {
        FoundStringCallback foundStringCallback = foundString -> this.createStringIfValid(foundString, program, addressSet, monitor);
        StringSearcher searcher = new StringSearcher(program, minimumStringLength, alignVal, includeAllCharWidths, requireNullTermination);
        searcher.search(addressSet, foundStringCallback, true, monitor);
    }

    public static enum MinStringLen {
        LEN_4(4),
        LEN_5(5),
        LEN_6(6),
        LEN_7(7),
        LEN_8(8),
        LEN_9(9),
        LEN_10(10),
        LEN_11(11),
        LEN_12(12),
        LEN_13(13),
        LEN_14(14),
        LEN_15(15),
        LEN_16(16),
        LEN_17(17),
        LEN_18(18),
        LEN_19(19),
        LEN_20(20),
        LEN_21(21),
        LEN_22(22),
        LEN_23(23),
        LEN_24(24),
        LEN_25(25);

        private int minLength;

        private MinStringLen(int minLength) {
            this.minLength = minLength;
        }

        public int getMinLength() {
            return this.minLength;
        }
    }

    public static enum Alignment {
        ALIGN_1(1),
        ALIGN_2(2),
        ALIGN_4(4);

        private int alignment;

        private Alignment(int alignment) {
            this.alignment = alignment;
        }

        public int getAlignment() {
            return this.alignment;
        }
    }
}

