/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.ActionContext;
import docking.DefaultActionContext;
import docking.action.DockingAction;
import ghidra.app.events.ViewChangedPluginEvent;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreePanel;
import ghidra.app.plugin.core.programtree.ProgramTreePlugin;
import ghidra.app.plugin.core.programtree.TreeListener;
import ghidra.app.plugin.core.programtree.ViewProviderService;
import ghidra.app.services.GoToService;
import ghidra.app.services.ViewManagerService;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.GroupPath;
import ghidra.program.util.GroupView;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.RunManager;
import ghidra.util.task.SwingRunnable;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;

class TreeViewProvider
implements ViewProviderService {
    private ProgramTreePanel treePanel;
    private AddressSet view;
    private Program program;
    private GoToService goToService;
    private ViewManagerService viewManagerService;
    private ProgramTreePlugin plugin;
    private static final String NUMBER_OF_GROUPS = "NumberOfGroups";
    private static final String GROUP_NAME = "GroupName";
    private static final int DELAY = 500;

    public TreeViewProvider(String treeName, final ProgramTreePlugin plugin) {
        this.treePanel = new ProgramTreePanel(treeName, plugin);
        this.plugin = plugin;
        this.treePanel.addTreeListener(new TreeListener(){

            @Override
            public void treeViewChanged(ChangeEvent e) {
                TreeViewProvider.this.notifyListeners();
            }

            @Override
            public void goTo(Address addr) {
                TreeViewProvider.this.goToService.goTo((ProgramLocation)new AddressFieldLocation(plugin.getCurrentProgram(), addr));
            }
        });
    }

    @Override
    public JComponent getViewComponent() {
        return this.treePanel;
    }

    @Override
    public String getViewName() {
        return this.treePanel.getTreeName();
    }

    @Override
    public void setHasFocus(boolean hasFocus) {
        this.treePanel.setHasFocus(hasFocus);
        this.plugin.enableActions(this.program != null);
        if (hasFocus) {
            this.plugin.treeViewChanged(this);
            if (this.goToService == null) {
                this.goToService = this.plugin.getGoToService();
            }
            if (this.viewManagerService == null) {
                this.viewManagerService = this.plugin.getViewManagerService();
            }
            this.notifyListeners();
        }
    }

    @Override
    public Object getActivePopupObject(MouseEvent event) {
        return this.treePanel.prepareSelectionForPopup(event);
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        return new DefaultActionContext().setContextObject(this.getActivePopupObject(event));
    }

    @Override
    public Object getActiveObject() {
        return this.treePanel.getSelectedNode();
    }

    @Override
    public DockingAction[] getToolBarActions() {
        return this.plugin.getToolBarActions();
    }

    @Override
    public boolean viewClosed() {
        if (this.program == null) {
            return false;
        }
        if (this.plugin.closeView(this)) {
            this.dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean viewDeleted() {
        if (this.program == null) {
            return false;
        }
        if (this.plugin.deleteView(this)) {
            this.dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean viewRenamed(String newName) {
        if (this.program == null) {
            return false;
        }
        if (this.plugin.renameView(this, newName)) {
            this.treePanel.setTreeName(newName);
            this.plugin.reloadTree(this.treePanel.getDnDTree());
            return true;
        }
        return false;
    }

    @Override
    public AddressSetView addToView(ProgramLocation loc) {
        if (this.program != null && loc != null && loc.getAddress() != null) {
            this.addLocationToView(loc);
        } else {
            this.view = new AddressSet();
        }
        return this.view;
    }

    @Override
    public AddressSetView getCurrentView() {
        return this.view;
    }

    void selectPathsForLocation(ProgramLocation loc) {
        RunManager runMgr = this.plugin.getRunManager();
        runMgr.runNow((MonitoredRunnable)new SelectPathsRunnable(this.program, loc), "Select Fragment for Location", 500);
    }

    private void setAncestorList(Group group, LinkedList<String> list, ArrayList<LinkedList<String>> pathNameList) {
        ProgramModule root = this.program.getListing().getRootModule(group.getTreeName());
        ProgramModule[] parents = group.getParents();
        if (parents != null && parents.length > 0) {
            for (ProgramModule parent : parents) {
                LinkedList<String> myList = new LinkedList<String>(list);
                myList.addFirst(parent.getName());
                if (parent == root) {
                    pathNameList.add(myList);
                    continue;
                }
                this.setAncestorList((Group)parent, myList, pathNameList);
            }
        }
    }

    private GroupPath convertToGroupPath(LinkedList<String> list) {
        String[] names = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            names[i] = list.get(i);
        }
        return new GroupPath(names);
    }

    void setViewName(String newName) {
        String oldName = this.treePanel.getTreeName();
        this.treePanel.setTreeName(newName);
        if (this.viewManagerService == null) {
            this.viewManagerService = this.plugin.getViewManagerService();
        }
        this.viewManagerService.viewNameChanged(this, oldName);
    }

    void dispose() {
        this.treePanel.setProgram(null);
        this.program = null;
        this.view = null;
        this.goToService = null;
    }

    void setProgram(Program p) {
        if (this.program == p) {
            return;
        }
        this.program = p;
        this.plugin.enableActions(false);
        if (p == null) {
            this.view = null;
        }
        this.treePanel.setProgram(p);
        if (this.program != null) {
            this.plugin.enableActions(true);
        }
    }

    void setGroupSelection(GroupPath[] paths) {
        this.treePanel.setGroupSelection(paths);
    }

    void writeDataState(SaveState saveState) {
        GroupView currentView = this.treePanel.getGroupView();
        String treeName = this.treePanel.getTreeName();
        int numGroups = currentView.getCount();
        saveState.putInt(NUMBER_OF_GROUPS + treeName, numGroups);
        for (int i = 0; i < numGroups; ++i) {
            GroupPath groupPath = currentView.getPath(i);
            String[] path = groupPath.getPath();
            saveState.putStrings(GROUP_NAME + treeName + i, path);
        }
    }

    void readDataState(SaveState saveState) {
        String treeName = this.treePanel.getTreeName();
        int numGroups = saveState.getInt(NUMBER_OF_GROUPS + treeName, 0);
        GroupPath[] paths = new GroupPath[numGroups];
        for (int i = 0; i < numGroups; ++i) {
            String[] path = saveState.getStrings(GROUP_NAME + treeName + i, null);
            if (path == null) {
                numGroups = 0;
                break;
            }
            paths[i] = new GroupPath(path);
        }
        if (numGroups > 0) {
            GroupView newView = new GroupView(paths);
            this.treePanel.setGroupView(newView);
        }
    }

    ProgramDnDTree getProgramDnDTree() {
        return this.treePanel.getDnDTree();
    }

    AddressSet getView() {
        if (this.program == null) {
            return new AddressSet();
        }
        AddressSet set = new AddressSet();
        GroupPath[] gp = this.treePanel.getViewedGroups();
        if (gp == null || this.program == null) {
            return set;
        }
        String treeName = this.treePanel.getTreeName();
        for (GroupPath element : gp) {
            Group group = element.getGroup(this.program, treeName);
            if (group == null) continue;
            this.getAddressSet(group, set);
        }
        return set;
    }

    void replaceView(ProgramNode node) {
        this.treePanel.replaceView(node);
    }

    void notifyListeners() {
        if (this.plugin.getCurrentProvider() != this) {
            return;
        }
        this.view = this.getView();
        this.plugin.firePluginEvent(new ViewChangedPluginEvent(this.plugin.getName(), this.treePanel.getTreeName(), this.view));
    }

    private void addLocationToView(ProgramLocation loc) {
        ProgramFragment fragment = this.program.getListing().getFragment(this.treePanel.getTreeName(), loc.getAddress());
        if (fragment == null) {
            return;
        }
        LinkedList<String> list = new LinkedList<String>();
        list.add(fragment.getName());
        ProgramFragment group = fragment;
        while (group != null) {
            ProgramModule[] parents = group.getParents();
            group = null;
            if (parents == null || parents.length <= 0) continue;
            group = parents[0];
            list.addFirst(group.getName());
        }
        String[] groupNames = new String[list.size()];
        list.toArray(groupNames);
        this.treePanel.addGroupViewPath(new GroupPath(groupNames));
        this.notifyListeners();
    }

    private void getAddressSet(Group group, AddressSet set) {
        if (group instanceof ProgramFragment) {
            set.add((AddressSetView)((ProgramFragment)group));
        } else {
            Group[] groups;
            for (Group group2 : groups = ((ProgramModule)group).getChildren()) {
                this.getAddressSet(group2, set);
            }
        }
    }

    private class SelectPathsRunnable
    implements SwingRunnable {
        private ProgramLocation loc;
        private GroupPath[] paths;
        private Program myProgram;

        SelectPathsRunnable(Program program, ProgramLocation loc) {
            this.myProgram = program;
            this.loc = loc;
        }

        public void monitoredRun(TaskMonitor monitor) {
            block5: {
                if (TreeViewProvider.this.program == null || TreeViewProvider.this.program.isClosed()) {
                    return;
                }
                try {
                    ProgramFragment fragment = TreeViewProvider.this.program.getListing().getFragment(TreeViewProvider.this.treePanel.getTreeName(), this.loc.getAddress());
                    if (fragment == null) {
                        return;
                    }
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(fragment.getName());
                    ProgramFragment group = fragment;
                    ArrayList<LinkedList<String>> pathNameList = new ArrayList<LinkedList<String>>();
                    TreeViewProvider.this.setAncestorList((Group)group, list, pathNameList);
                    this.paths = new GroupPath[pathNameList.size()];
                    for (int i = 0; i < this.paths.length; ++i) {
                        LinkedList<String> l = pathNameList.get(i);
                        this.paths[i] = TreeViewProvider.this.convertToGroupPath(l);
                    }
                }
                catch (Exception e) {
                    if (this.myProgram != TreeViewProvider.this.program || TreeViewProvider.this.program == null || TreeViewProvider.this.program.isClosed()) break block5;
                    Msg.showError((Object)this, (Component)TreeViewProvider.this.treePanel, (String)"Error Finding Fragments", (Object)"Could not find fragments for location", (Throwable)e);
                }
            }
        }

        public void swingRun(boolean isCancelled) {
            if (isCancelled) {
                return;
            }
            if (this.paths != null && TreeViewProvider.this.program != null && !TreeViewProvider.this.program.isClosed()) {
                TreeViewProvider.this.setGroupSelection(this.paths);
            }
        }
    }
}

