/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPlugin;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.actions.NavigateToFunctionAction;
import ghidra.app.plugin.core.functioncompare.actions.NextFunctionAction;
import ghidra.app.plugin.core.functioncompare.actions.OpenFunctionTableAction;
import ghidra.app.plugin.core.functioncompare.actions.PreviousFunctionAction;
import ghidra.app.plugin.core.functioncompare.actions.RemoveFunctionsAction;

public class MultiFunctionComparisonProvider
extends FunctionComparisonProvider {
    private DockingAction openFunctionTableAction;

    protected MultiFunctionComparisonProvider(FunctionComparisonPlugin plugin) {
        super(plugin, "Functions Comparison Provider", plugin.getName());
    }

    @Override
    public FunctionComparisonPanel getComponent() {
        if (this.functionComparisonPanel == null) {
            this.functionComparisonPanel = new MultiFunctionComparisonPanel(this, this.tool);
        }
        return this.functionComparisonPanel;
    }

    @Override
    boolean isEmpty() {
        return this.model.getSourceFunctions().isEmpty();
    }

    @Override
    protected void initFunctionComparisonPanel() {
        super.initFunctionComparisonPanel();
        NextFunctionAction nextFunctionAction = new NextFunctionAction(this);
        PreviousFunctionAction previousFunctionAction = new PreviousFunctionAction(this);
        RemoveFunctionsAction removeFunctionsAction = new RemoveFunctionsAction(this);
        this.openFunctionTableAction = this.getOpenFunctionTableAction();
        NavigateToFunctionAction navigateToAction = new NavigateToFunctionAction(this);
        this.addLocalAction((DockingActionIf)nextFunctionAction);
        this.addLocalAction((DockingActionIf)previousFunctionAction);
        this.addLocalAction((DockingActionIf)removeFunctionsAction);
        this.addLocalAction((DockingActionIf)this.openFunctionTableAction);
        this.addLocalAction((DockingActionIf)navigateToAction);
    }

    protected DockingAction getOpenFunctionTableAction() {
        return new OpenFunctionTableAction(this.tool, this);
    }

    @Override
    public void removeAddFunctionsAction() {
        this.removeLocalAction(this.openFunctionTableAction);
    }
}

