/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.task.TaskMonitor;

public class ExternalEntryFunctionAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "External Entry References";
    private static final String DESCRIPTION = "Creates function definitions for external entry points where instructions already exist.";

    public ExternalEntryFunctionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.CODE_ANALYSIS.before().before());
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        Listing listing = program.getListing();
        AddressSet funcStarts = new AddressSet();
        monitor.setMessage("Finding External Entry Functions");
        AddressIterator entryIter = program.getSymbolTable().getExternalEntryPointIterator();
        while (entryIter.hasNext() && !monitor.isCancelled()) {
            Address entry = entryIter.next();
            if (!set.contains(entry) || listing.getInstructionAt(entry) == null) continue;
            funcStarts.addRange(entry, entry);
        }
        SymbolIterator iter = program.getSymbolTable().getSymbols((AddressSetView)funcStarts, SymbolType.FUNCTION, true);
        AddressSet alreadyFunctionSet = new AddressSet();
        while (iter.hasNext() && !monitor.isCancelled()) {
            Symbol element = iter.next();
            alreadyFunctionSet.addRange(element.getAddress(), element.getAddress());
        }
        funcStarts.delete((AddressSetView)alreadyFunctionSet);
        if (monitor.isCancelled()) {
            return false;
        }
        AutoAnalysisManager amgr = AutoAnalysisManager.getAnalysisManager(program);
        amgr.createFunction((AddressSetView)funcStarts, false);
        return true;
    }
}

