/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import db.Transaction;
import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;

class SetLengthOverrideAction
extends ListingContextAction {
    private DisassemblerPlugin plugin;

    public SetLengthOverrideAction(DisassemblerPlugin plugin, String groupName) {
        super("Modify Instruction Length", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Modify Instruction Length..."}, null, groupName));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        PluginTool tool = this.plugin.getTool();
        Address address = context.getAddress();
        if (address == null) {
            return;
        }
        Program program = context.getProgram();
        Listing listing = program.getListing();
        Instruction instr = listing.getInstructionAt(address);
        if (instr == null) {
            return;
        }
        int protoLen = instr.getPrototype().getLength();
        if (protoLen == 1) {
            Msg.showError((Object)((Object)this), null, (String)"Length Override Error", (Object)"Length override for 1-byte instruction not allowed");
            return;
        }
        String restoreTip = ", 0=restore";
        Object alignTip = "";
        int align = program.getLanguage().getInstructionAlignment();
        if (align != 1) {
            alignTip = ", must be multiple of " + align;
        }
        int minLength = 0;
        long maxLength = Math.min(7, protoLen - 1);
        Instruction nextInstr = listing.getInstructionAfter(address);
        if (nextInstr != null && nextInstr.getAddress().getAddressSpace().equals(address.getAddressSpace())) {
            long limit = nextInstr.getAddress().subtract(address);
            maxLength = Math.min(limit, maxLength);
            if (limit < (long)instr.getParsedLength()) {
                minLength = 1;
                restoreTip = "";
            }
        }
        if (maxLength == 0L) {
            Msg.showError((Object)((Object)this), null, (String)"Length Override Error", (Object)"Insufficient space to alter current length override of 1-byte");
            return;
        }
        int currentLengthOverride = 0;
        if (instr.isLengthOverridden()) {
            currentLengthOverride = instr.getLength();
        }
        NumberInputDialog dialog = new NumberInputDialog("Override/Restore Instruction Length", "Enter byte-length [" + minLength + ".." + maxLength + restoreTip + (String)alignTip + "]", Integer.valueOf(currentLengthOverride), minLength, (int)maxLength, false);
        tool.showDialog((DialogComponentProvider)dialog);
        if (dialog.wasCancelled()) {
            return;
        }
        String kind = "Set";
        int lengthOverride = dialog.getIntValue();
        if (lengthOverride == 0) {
            if (!instr.isLengthOverridden()) {
                return;
            }
            kind = "Clear";
        }
        try (Transaction tx = instr.getProgram().openTransaction(kind + " Length Override");){
            instr.setLengthOverride(lengthOverride);
        }
        catch (CodeUnitInsertionException e) {
            Msg.showError((Object)((Object)this), null, (String)"Length Override Error", (Object)e.getMessage());
        }
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        Program program = context.getProgram();
        Instruction instr = program.getListing().getInstructionAt(address);
        if (instr == null) {
            return false;
        }
        int alignment = program.getLanguage().getInstructionAlignment();
        return instr.getParsedLength() > alignment;
    }
}

