/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions.associate;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.BuiltInArchive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeTreeCopyMoveTask;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class AssociateDataTypeAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public AssociateDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Associate With Archive", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Associate With Archive"}, null, "Sync"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        return this.hasOnlyDtNodes(((DataTypesActionContext)context).getSelectedNodes());
    }

    private boolean hasOnlyDtNodes(List<GTreeNode> nodes) {
        if (nodes.isEmpty()) {
            return false;
        }
        for (GTreeNode node : nodes) {
            if (node instanceof DataTypeNode) continue;
            return false;
        }
        return true;
    }

    private boolean isAlreadyAssociated(DataTypesActionContext dtContext) {
        List<DataTypeNode> nodes = dtContext.getDisassociatableNodes();
        return !nodes.isEmpty();
    }

    private Archive getSingleDTArchive(List<GTreeNode> nodes) {
        Archive dtArchive = null;
        for (GTreeNode node : nodes) {
            Archive archive = AssociateDataTypeAction.findArchive(node);
            if (dtArchive == null) {
                dtArchive = archive;
                continue;
            }
            if (dtArchive == archive) continue;
            return null;
        }
        return dtArchive;
    }

    private static Archive findArchive(GTreeNode node) {
        while (node != null) {
            if (node instanceof ArchiveNode) {
                return ((ArchiveNode)node).getArchive();
            }
            node = node.getParent();
        }
        return null;
    }

    private List<Archive> getDestinationArchives() {
        List<Archive> archives = this.plugin.getAllArchives();
        List<Archive> sourceArchives = archives.stream().filter(a -> !(a instanceof ProgramArchive)).filter(a -> !(a instanceof BuiltInArchive)).sorted((a1, a2) -> a1.getName().compareToIgnoreCase(a2.getName())).collect(Collectors.toList());
        return sourceArchives;
    }

    public void actionPerformed(ActionContext context) {
        List<GTreeNode> nodes = ((DataTypesActionContext)context).getSelectedNodes();
        Archive dtArchive = this.getSingleDTArchive(nodes);
        if (dtArchive == null) {
            Msg.showInfo((Object)((Object)this), (Component)this.getProviderComponent(), (String)"Multiple Data Type Archives", (Object)"The currently selected nodes are from multiple archives.\nPlease select only nodes from a single archvie.");
            return;
        }
        if (!dtArchive.isModifiable()) {
            DataTypeUtils.showUnmodifiableArchiveErrorMessage(context.getSourceComponent(), "Disassociate Failed", dtArchive.getDataTypeManager());
            return;
        }
        if (this.isAlreadyAssociated((DataTypesActionContext)context)) {
            Msg.showInfo((Object)((Object)this), (Component)this.getProviderComponent(), (String)"Already Associated", (Object)"One or more of the currently selected nodes are already associated\nwith a source archive.");
            return;
        }
        List<Archive> archives = this.getDestinationArchives();
        if (archives.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getProviderComponent(), (String)"No Source Archives Open", (Object)"No source archives open.  Please open the desired source archive.");
            return;
        }
        ChooseArchiveDialog dialog = new ChooseArchiveDialog(archives);
        dialog.show();
        if (dialog.isCancelled()) {
            return;
        }
        Archive destinationArchive = dialog.getArchive();
        Category destinationCategory = dialog.getCategory();
        DataTypeTreeCopyMoveTask task = new DataTypeTreeCopyMoveTask(destinationArchive, destinationCategory, nodes, DataTypeTreeCopyMoveTask.ActionType.COPY, this.plugin.getProvider().getGTree(), this.plugin.getConflictHandler());
        task.setPromptToAssociateTypes(false);
        TaskLauncher.launch((Task)task);
    }

    private JComponent getProviderComponent() {
        return this.plugin.getProvider().getComponent();
    }

    private class ChooseArchiveDialog
    extends DialogComponentProvider {
        private Category category;
        private Archive archive;
        private boolean isCancelled;
        private GhidraComboBox<Archive> archivesBox;
        private JTextField categoryField;

        ChooseArchiveDialog(List<Archive> archives) {
            super("Choose New Source Archive", true);
            this.isCancelled = true;
            this.archivesBox = new GhidraComboBox();
            this.categoryField = new JTextField(20);
            this.addWorkPanel(this.buildWorkPanel());
            this.archivesBox.addToModel(archives);
            this.categoryField.setText("/");
            this.addOKButton();
            this.addCancelButton();
        }

        private JComponent buildWorkPanel() {
            this.archivesBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel renderer = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    Archive a = (Archive)value;
                    renderer.setText(a.getName());
                    return renderer;
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            JPanel archivePanel = new JPanel((LayoutManager)new PairLayout());
            archivePanel.add((Component)new GLabel("New Source Archive: "));
            archivePanel.add((Component)this.archivesBox);
            JPanel categoryPanel = new JPanel((LayoutManager)new PairLayout());
            categoryPanel.add((Component)new GLabel("Destination Category: "));
            categoryPanel.add(this.categoryField);
            panel.add((Component)archivePanel, "North");
            panel.add((Component)categoryPanel, "South");
            return panel;
        }

        protected void okCallback() {
            this.clearStatusText();
            this.archive = (Archive)this.archivesBox.getSelectedItem();
            if (this.archive == null) {
                this.setStatusText("Please choose an archive");
                return;
            }
            if (!this.archive.isModifiable()) {
                this.setStatusText("Archive is not modifiable. You must first open this archive for edit.");
                return;
            }
            if (!this.updateCategory()) {
                return;
            }
            this.isCancelled = false;
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateCategory() {
            String categoryText = this.categoryField.getText();
            if (StringUtils.isBlank((CharSequence)categoryText)) {
                this.setStatusText("Category must be specified.  Use '/' for the root.");
                return false;
            }
            DataTypeManager dtm = this.archive.getDataTypeManager();
            CategoryPath categoryPath = new CategoryPath(categoryText);
            this.category = dtm.getCategory(categoryPath);
            if (this.category != null) {
                return true;
            }
            int choice = OptionDialog.showYesNoDialog(null, (String)"Create Category?", (String)("Category '" + categoryText + "' does not exist.  Create it now?"));
            if (choice != 1) {
                this.setStatusText("Category does not exist");
                return false;
            }
            boolean noErrors = false;
            int tx = dtm.startTransaction("Create Category");
            try {
                this.category = dtm.createCategory(categoryPath);
                noErrors = true;
            }
            finally {
                dtm.endTransaction(tx, noErrors);
            }
            if (this.category == null) {
                this.setStatusText("Unable to create category");
                return false;
            }
            return true;
        }

        protected void cancelCallback() {
            super.cancelCallback();
        }

        boolean isCancelled() {
            return this.isCancelled;
        }

        void show() {
            JComponent parent = AssociateDataTypeAction.this.getProviderComponent();
            DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
        }

        Archive getArchive() {
            return this.archive;
        }

        Category getCategory() {
            return this.category;
        }
    }
}

