/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.PointerTypedef;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import java.awt.Component;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractTypeDefAction
extends DockingAction {
    protected final DataTypeManagerPlugin plugin;

    AbstractTypeDefAction(String name, DataTypeManagerPlugin plugin) {
        super(name, plugin.getName());
        this.plugin = plugin;
    }

    protected DataType createTypeDef(DataTypeManager dataTypeManager, DataType dataType, CategoryPath categoryPath, ActionContext context, GTreeNode parentNode, String typeDefName) {
        ComponentProvider componentProvider;
        JComponent comp;
        DataTypeArchiveGTree gTree = (DataTypeArchiveGTree)((Object)context.getContextObject());
        if (dataTypeManager == null || dataTypeManager instanceof BuiltInDataTypeManager) {
            dataTypeManager = this.plugin.getProgramDataTypeManager();
        }
        if (dataType instanceof FunctionDefinition) {
            dataType = PointerDataType.getPointer((DataType)dataType, (DataTypeManager)dataTypeManager);
        }
        JComponent jComponent = comp = (componentProvider = context.getComponentProvider()) != null ? componentProvider.getComponent() : null;
        if (!DataTypeManagerPlugin.isValidTypeDefBaseType(comp, dataType)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)typeDefName)) {
            if (dataType instanceof Pointer) {
                PointerTypedef typedef = new PointerTypedef(null, (Pointer)dataType, dataTypeManager);
                return this.createNewTypeDef((Component)((Object)gTree), (TypeDef)typedef, categoryPath, dataTypeManager);
            }
            String baseName = AbstractTypeDefAction.getBaseName(dataType) + "Typedef";
            typeDefName = dataTypeManager.getUniqueName(dataType.getCategoryPath(), baseName);
        }
        TypedefDataType typedef = new TypedefDataType(categoryPath, typeDefName, dataType);
        return this.createNewTypeDef((Component)((Object)gTree), (TypeDef)typedef, categoryPath, dataTypeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataType createNewTypeDef(Component parentComponent, TypeDef typedef, CategoryPath categoryPath, DataTypeManager dataTypeManager) {
        DataType newdt = null;
        int transactionID = dataTypeManager.startTransaction("Create Typedef");
        try {
            newdt = dataTypeManager.addDataType((DataType)typedef, this.plugin.getConflictHandler());
        }
        finally {
            dataTypeManager.endTransaction(transactionID, true);
        }
        return newdt;
    }

    protected static String getBaseName(DataType dt) {
        if (dt instanceof Pointer) {
            DataType dataType = ((Pointer)dt).getDataType();
            if (dataType == null) {
                return dt.getName();
            }
            return AbstractTypeDefAction.getBaseName(dataType) + "Ptr";
        }
        return dt.getDisplayName();
    }
}

