/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.util.HelpLocation;
import ghidra.util.data.DataTypeParser;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.UsrException;

public class DataTypeHelper {
    public static String stripWhiteSpace(String original) {
        if (original == null) {
            return null;
        }
        int length = original.length();
        char[] result = new char[length];
        int resultIndex = 0;
        for (int origIndex = 0; origIndex < length; ++origIndex) {
            char c = original.charAt(origIndex);
            if (c <= ' ') continue;
            result[resultIndex++] = c;
        }
        return new String(result, 0, resultIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataType resolveDataType(DataType dt, DataTypeManager resolveDtm, DataTypeConflictHandler conflictHandler) {
        int txID = 0;
        try {
            txID = resolveDtm.startTransaction("Apply data type \"" + dt.getName() + "\"");
            dt = resolveDtm.resolve(dt, conflictHandler);
            resolveDtm.endTransaction(txID, dt != null);
        }
        catch (Throwable throwable) {
            resolveDtm.endTransaction(txID, dt != null);
            throw throwable;
        }
        return dt;
    }

    public static DataType parseDataType(int index, String dtValue, CompositeEditorModel editModel, DataTypeManager dtManager, DataTypeManagerService dtmService) throws InvalidDataTypeException, UsrException {
        String dtName = DataTypeHelper.stripWhiteSpace(dtValue);
        if (dtName == null || dtName.length() < 1) {
            throw new InvalidDataTypeException("No data type was specified.");
        }
        DataTypeParser dtp = new DataTypeParser(dtManager, editModel.viewDTM, dtmService, DataTypeParser.AllowedDataTypes.SIZABLE_DYNAMIC);
        DataType newDt = dtp.parse(dtName);
        if (newDt == null) {
            throw new InvalidDataTypeException("valid data-type not specified");
        }
        editModel.checkIsAllowableDataType(newDt);
        int mrl = editModel.getMaxReplaceLength(index);
        if (mrl != -1 && newDt.getLength() > mrl) {
            throw new InvalidDataTypeException(newDt.getDisplayName() + " doesn't fit within " + mrl + " bytes, need " + newDt.getLength() + " bytes");
        }
        return newDt;
    }

    static DataTypeInstance getSizedDataType(CompositeEditorProvider provider, DataType dt, int defaultSize, int maxSize) throws InvalidDataTypeException {
        int dtLen;
        if (dt instanceof FactoryDataType) {
            throw new InvalidDataTypeException("Factory data types are not allowed.");
        }
        if (dt instanceof Dynamic && !((Dynamic)dt).canSpecifyLength()) {
            throw new InvalidDataTypeException("Non-sizable Dynamic data types are not allowed.");
        }
        boolean isFunctionDef = dt instanceof FunctionDefinition;
        if (dt instanceof TypeDef) {
            isFunctionDef = ((TypeDef)dt).getBaseDataType() instanceof FunctionDefinition;
        }
        if (isFunctionDef) {
            dt = new PointerDataType(dt, -1, dt.getDataTypeManager());
        }
        if ((dtLen = dt.getLength()) == 0) {
            throw new InvalidDataTypeException("Data types of size 0 are not allowed.");
        }
        if (dtLen < 0 && dt instanceof Dynamic && ((Dynamic)dt).canSpecifyLength()) {
            try {
                dtLen = DataTypeHelper.requestDtSize(provider, dt.getDisplayName(), defaultSize, maxSize);
            }
            catch (CancelledException e) {
                return null;
            }
        }
        if (dtLen < 0) {
            throw new InvalidDataTypeException("Data type " + dt.getDisplayName() + " has no size and is not allowed.");
        }
        return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)dtLen, (boolean)provider.editorModel.usesAlignedLengthComponents());
    }

    public static int requestDtSize(CompositeEditorProvider provider, String dtName, int defaultSize, int maxBytes) throws CancelledException {
        NumberInputDialog dtSizeDialog = new NumberInputDialog(dtName + " bytes", defaultSize, 1, maxBytes);
        String helpAnchor = provider.getHelpName() + "_Bytes_NumberInputDialog";
        HelpLocation helpLoc = new HelpLocation(provider.getHelpTopic(), helpAnchor);
        dtSizeDialog.setHelpLocation(helpLoc);
        if (!dtSizeDialog.show()) {
            throw new CancelledException();
        }
        int resultBytes = dtSizeDialog.getValue();
        CompositeEditorModel model = provider.getModel();
        model.setLastNumBytes(resultBytes);
        return resultBytes;
    }

    public static DataTypeInstance getFixedLength(CompositeEditorModel model, int index, DataType dt, boolean useAlignedLength) {
        if (dt instanceof FactoryDataType) {
            model.setStatus("Factory data types are not allowed in a composite data type.");
            return null;
        }
        if (dt instanceof Dynamic && !((Dynamic)dt).canSpecifyLength()) {
            model.setStatus("Non-sizable Dynamic data types are not allowed in a composite data type.");
            return null;
        }
        if (dt.getLength() == 0) {
            model.setStatus("Data types of size 0 are not allowed.");
            return null;
        }
        int length = dt.getLength();
        if (length < 0) {
            int maxBytes = model.getMaxReplaceLength(index);
            return DataTypeHelper.requestBytes(model, dt, maxBytes);
        }
        return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)length, (boolean)useAlignedLength);
    }

    public static DataTypeInstance requestBytes(CompositeEditorModel model, DataType dt, int maxBytes) {
        int size;
        CompositeEditorProvider provider = model.getProvider();
        DataType actualDt = dt;
        if (actualDt instanceof TypeDef) {
            actualDt = ((TypeDef)actualDt).getBaseDataType();
        }
        int maxDtBytes = maxBytes;
        int dtBytes = model.getLastNumBytes();
        dtBytes = maxDtBytes > 0 && dtBytes > maxDtBytes ? maxDtBytes : dtBytes;
        try {
            size = DataTypeHelper.requestDtSize(provider, dt.getName(), dtBytes, maxDtBytes);
        }
        catch (CancelledException e) {
            return null;
        }
        if (size >= 1) {
            model.setLastNumBytes(size);
            return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)size, (boolean)model.usesAlignedLengthComponents());
        }
        return null;
    }

    public static DataType getBaseType(DataType dt) {
        DataType testTypeDefDt = dt;
        if (testTypeDefDt instanceof TypeDef) {
            return ((TypeDef)testTypeDefDt).getBaseDataType();
        }
        if (dt instanceof Array) {
            return ((Array)dt).getDataType();
        }
        if (dt instanceof Pointer) {
            DataType pdt = ((Pointer)dt).getDataType();
            if (pdt == null) {
                return dt;
            }
            return pdt;
        }
        return dt;
    }
}

