/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import generic.theme.GColor;
import ghidra.app.plugin.core.compositeeditor.CompositeChangeListener;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.layout.VerticalLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import javax.help.UnsupportedOperationException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import resources.icons.ColorIcon;

public class BitFieldPlacementComponent
extends JPanel
implements Scrollable {
    private static final int CELL_HEIGHT = 25;
    private static final int ZERO_BIT_WIDTH = 3;
    private static final int BIT_SEPARATOR_THICKNESS = 1;
    private static final int BYTE_SEPARATOR_THICKNESS = 2;
    private static final int SCROLLBAR_THICKNESS = 15;
    private static final int MY_HEIGHT = 56;
    private static final int BYTE_ROW_HEIGHT = 29;
    private static final int LENEND_BOX_SIZE = 16;
    private static final Color TEXT_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.text");
    private static final Color LINE_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.line");
    private static final Color BYTE_HEADER_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.byte.header");
    private static final Color UNDEFINED_BIT_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.bit.undefined");
    private static final Color BITFIELD_COMPONENT_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.bit.component");
    private static final Color ACTIVE_BITFIELD_BITS_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.bit.active");
    private static final Color CONFLICT_BITS_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.bit.conflict");
    private static final Color NON_BITFIELD_COMPONENT_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.non.bit");
    private static final Color INTERIOR_LINE_COLOR = new GColor("color.bg.plugin.editors.compositeeditor.line.interior");
    private int bitWidth = 10;
    private int byteWidth = BitFieldPlacementComponent.getByteWidth(this.bitWidth);
    private final boolean editUseEnabled;
    private Composite composite;
    private boolean bigEndian;
    private int allocationByteOffset;
    private int allocationByteSize = 1;
    private BitFieldAllocation bitFieldAllocation;
    private EditMode editMode = EditMode.NONE;
    private int editOrdinal = -1;
    private DataTypeComponent editComponent;
    private boolean showOffsetsInHex = false;
    private static Comparator<Object> bitAttributesXComparator = (o1, o2) -> {
        BitAttributes attrs = (BitAttributes)o1;
        int x = (Integer)o2;
        if (attrs.rectangle == null) {
            return -1;
        }
        if (x >= attrs.rectangle.x && x < attrs.rectangle.x + attrs.rectangle.width) {
            return 0;
        }
        return attrs.rectangle.x - x;
    };
    private static final Stroke DASH = new BasicStroke(1.0f, 2, 0, 2.0f, new float[]{3.0f, 3.0f}, 0.0f);

    BitFieldPlacementComponent(Composite composite, boolean editUseEnabled) {
        this.composite = composite;
        this.editUseEnabled = editUseEnabled;
        if (composite != null) {
            this.bigEndian = composite.getDataOrganization().isBigEndian();
        }
        this.updatePreferredSize();
        this.setSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseWheelListener(new MyMouseWheelListener());
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
        if (composite != null) {
            this.bigEndian = composite.getDataOrganization().isBigEndian();
        }
        this.allocationByteOffset = 0;
        this.allocationByteSize = 1;
        if (!this.editUseEnabled && composite != null) {
            this.allocationByteSize = composite.getLength();
        }
        this.init(null);
    }

    public void setShowOffsetsInHex(boolean useHex) {
        this.showOffsetsInHex = useHex;
        if (this.bitFieldAllocation != null) {
            this.bitFieldAllocation.refresh(true);
            this.repaint();
        }
    }

    public boolean isShowOffsetsInHex() {
        return this.showOffsetsInHex;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.byteWidth;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    private static int getByteWidth(int bitWidth) {
        return 8 * (bitWidth + 1);
    }

    void setBitWidth(int width) {
        this.bitWidth = width;
        this.byteWidth = BitFieldPlacementComponent.getByteWidth(this.bitWidth);
        if (this.bitFieldAllocation != null) {
            this.bitFieldAllocation.layoutBits();
        }
        this.updatePreferredSize();
        this.repaint();
    }

    public int getPreferredHeight() {
        return 71;
    }

    public boolean isWithinBitCell(Point p) {
        return p.y < 56 && p.y > 29;
    }

    private int getPreferredWidth() {
        int extraLineSpace = 1;
        return this.allocationByteSize * this.byteWidth + 2 + extraLineSpace;
    }

    boolean isBigEndian() {
        return this.bigEndian;
    }

    BitFieldAllocation getBitFieldAllocation() {
        return this.bitFieldAllocation;
    }

    int getBitOffset(Point point) {
        int bitWidthWithLine = this.bitWidth + 1;
        int cellIndex = (point.x - 2) / bitWidthWithLine;
        return 8 * this.allocationByteSize - cellIndex - 1;
    }

    private void updatePreferredSize() {
        this.setPreferredSize(new Dimension(this.getPreferredWidth(), this.getPreferredHeight()));
        this.revalidate();
    }

    void refresh(int bitSize, int bitOffset) {
        this.bitFieldAllocation = new BitFieldAllocation(bitSize, bitOffset);
        this.updatePreferredSize();
        this.repaint();
    }

    void refresh(int byteSize, int byteOffset, int bitSize, int bitOffset) {
        this.allocationByteOffset = byteOffset;
        this.allocationByteSize = byteSize;
        this.bitFieldAllocation = new BitFieldAllocation(bitSize, bitOffset);
        this.updatePreferredSize();
        this.repaint();
    }

    void updateAllocation(int byteSize, int byteOffset) {
        this.allocationByteOffset = byteOffset;
        this.allocationByteSize = byteSize;
        this.setBounds(0, 0, this.getPreferredWidth(), this.getPreferredHeight());
        this.invalidate();
        if (this.bitFieldAllocation != null) {
            if (this.editMode == EditMode.EDIT && this.editComponent.getOffset() > this.composite.getLength()) {
                this.editMode = EditMode.NONE;
                this.editOrdinal = -1;
                this.editComponent = null;
            }
            this.bitFieldAllocation.refresh(true);
            this.repaint();
        }
    }

    int getAllocationOffset() {
        return this.allocationByteOffset;
    }

    int getAllocationByteSize() {
        return this.allocationByteSize;
    }

    void initAdd(int bitSize, int bitOffset) {
        if (!this.editUseEnabled) {
            throw new IllegalStateException("component not constructed for edit use");
        }
        this.editMode = EditMode.ADD;
        this.editOrdinal = -1;
        this.editComponent = null;
        this.refresh(bitSize, bitOffset);
    }

    void init(DataTypeComponent editDtc) {
        if (editDtc == null) {
            this.editMode = EditMode.NONE;
            this.editOrdinal = -1;
            this.editComponent = null;
            this.refresh(0, 0);
            return;
        }
        this.editMode = EditMode.EDIT;
        this.editOrdinal = editDtc.getOrdinal();
        this.editComponent = editDtc;
        BitFieldPlacement placement = new BitFieldPlacement(editDtc);
        int bitSize = placement.zeroBitField ? 0 : placement.rightBit - placement.leftBit + 1;
        this.bitFieldAllocation = new BitFieldAllocation(bitSize, 8 * this.allocationByteSize - placement.rightBit - 1);
        this.updatePreferredSize();
        this.repaint();
    }

    boolean hasApplyConflict() {
        if (!this.editUseEnabled) {
            throw new IllegalStateException("component not constructed for edit use");
        }
        if (this.composite == null || this.bitFieldAllocation == null) {
            throw new IllegalStateException();
        }
        if (this.composite instanceof Union) {
            return false;
        }
        return this.bitFieldAllocation.hasConflict;
    }

    boolean isEditing() {
        return this.editUseEnabled && this.editMode != EditMode.NONE;
    }

    boolean isAdding() {
        return this.editMode == EditMode.ADD;
    }

    void cancelEdit() {
        if (this.editMode != EditMode.NONE) {
            this.editMode = EditMode.NONE;
            this.editOrdinal = -1;
            this.refresh(0, 0);
        }
    }

    void componentDeleted(int ordinal) {
        if (this.editMode == EditMode.EDIT) {
            if (ordinal == this.editOrdinal) {
                this.editMode = EditMode.ADD;
                this.editOrdinal = -1;
                this.editComponent = null;
            } else if (ordinal < this.editOrdinal) {
                --this.editOrdinal;
            }
        }
        this.bitFieldAllocation.refresh(true);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyBitField(DataType baseDataType, String fieldName, String fieldComment, boolean deleteConflicts, CompositeChangeListener listener) {
        int i;
        int sizeChange;
        if (!this.editUseEnabled) {
            throw new IllegalStateException("component not constructed for edit use");
        }
        if (this.composite == null) {
            throw new IllegalStateException("Composite not loaded");
        }
        HashSet<Integer> ordinalDeleteSet = new HashSet<Integer>();
        if (this.editOrdinal >= 0) {
            int initialLength = this.composite.getLength();
            this.composite.delete(this.editOrdinal);
            sizeChange = initialLength - this.composite.getLength();
            if (!this.composite.isPackingEnabled() && this.editOrdinal < this.composite.getNumComponents()) {
                for (i = 0; i < sizeChange; ++i) {
                    this.composite.insert(this.editOrdinal, DataType.DEFAULT);
                }
            }
        }
        if (deleteConflicts) {
            BitAttributes[] initialLength = this.bitFieldAllocation.bitAttributes;
            sizeChange = initialLength.length;
            for (i = 0; i < sizeChange; ++i) {
                BitAttributes attrs = initialLength[i];
                if (!attrs.hasConflict() || !attrs.isAddBitField() && !attrs.isEditField()) continue;
                ordinalDeleteSet.add(attrs.getConflict().getOrdinal());
            }
        }
        Object[] ordinalsToDelete = ordinalDeleteSet.toArray(new Integer[ordinalDeleteSet.size()]);
        Arrays.sort(ordinalsToDelete);
        int ordinal = this.composite.getNumComponents();
        for (i = ordinalsToDelete.length - 1; i >= 0; --i) {
            ordinal = (Integer)ordinalsToDelete[i];
            this.composite.delete(ordinal);
        }
        try {
            String comment;
            String name = fieldName != null && fieldName.length() != 0 ? fieldName : null;
            String string = comment = fieldComment != null && fieldComment.length() != 0 ? fieldComment : null;
            if (this.composite instanceof Union) {
                throw new UnsupportedOperationException("Union modification not currently supported");
            }
            Structure struct = (Structure)this.composite;
            DataTypeComponent dtc = struct.insertBitFieldAt(this.allocationByteOffset, this.allocationByteSize, this.bitFieldAllocation.bitOffset, baseDataType, this.bitFieldAllocation.bitSize, name, comment);
            if (listener != null) {
                listener.componentChanged(dtc.getOrdinal());
            }
        }
        catch (InvalidDataTypeException | ArrayIndexOutOfBoundsException e) {
            Msg.error((Object)this, (Object)"Unexpected bitfield apply error", (Throwable)e);
        }
        finally {
            this.editMode = EditMode.NONE;
            this.editOrdinal = -1;
            this.editComponent = null;
            this.bitFieldAllocation.refresh(true);
            this.repaint();
        }
    }

    BitAttributes getBitAttributes(Point p) {
        if (this.bitFieldAllocation == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.bitFieldAllocation.bitAttributes, p.x, bitAttributesXComparator);
        if (index >= 0) {
            return this.bitFieldAllocation.bitAttributes[index];
        }
        return null;
    }

    int getBitIndex(int x) {
        if (this.bitFieldAllocation == null) {
            return -1;
        }
        int index = Arrays.binarySearch(this.bitFieldAllocation.bitAttributes, x, bitAttributesXComparator);
        if (index >= 0) {
            return index;
        }
        return -1;
    }

    Rectangle getComponentRectangle(DataTypeComponent dtc) {
        if (this.bitFieldAllocation == null || dtc == null) {
            return null;
        }
        int offset = dtc.getOffset() - this.allocationByteOffset;
        if (!this.bigEndian) {
            offset = this.allocationByteSize - offset - dtc.getLength();
        }
        int x = offset * this.byteWidth;
        int y = 29;
        int width = dtc.getLength() * this.byteWidth + 4;
        return new Rectangle(x, y, width, 25);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        BitAttributes attrs = this.getBitAttributes(e.getPoint());
        if (attrs == null) {
            return null;
        }
        String tip = attrs.getTip();
        if (tip == null) {
            return null;
        }
        Object conflictMsg = "";
        DataTypeComponent conflict = attrs.getConflict();
        if (conflict != null) {
            if (tip.length() != 0) {
                conflictMsg = "<br>";
            }
            String conflictName = conflict.getFieldName();
            String conflictTip = "'" + conflict.getDataType().getDisplayName() + (String)(conflictName != null ? " " + conflictName : "") + "' at offset " + conflict.getOffset();
            conflictMsg = (String)conflictMsg + "<div style=\"color: red;font-style: italic\">overlaps " + HTMLUtilities.escapeHTML((String)conflictTip) + "</div>";
        }
        return "<html><div style=\"text-align:center\">" + HTMLUtilities.escapeHTML((String)tip) + (String)conflictMsg + "<div style=\"color: gray;font-style: italic\">(Shift-wheel to zoom)</div></div>";
    }

    @Override
    public void paintComponent(Graphics g) {
        int height = this.getHeight();
        int width = this.getWidth();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        if (this.bitFieldAllocation == null) {
            return;
        }
        width = this.getPreferredWidth();
        height = 56;
        g.setColor(LINE_COLOR);
        g.fillRect(0, 0, width, 2);
        g.fillRect(0, 0, 2, height);
        g.fillRect(width - 2, 0, 2, height);
        int y = 27;
        g.fillRect(0, y, width, 2);
        g.fillRect(0, y += 27, width, 2);
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.paintByteHeader(g, 2, this.allocationByteOffset);
        this.paintBits((Graphics2D)g, 29);
    }

    private void paintByteHeader(Graphics g, int y, int baseOffset) {
        int byteSize = this.allocationByteSize;
        int x = 2;
        JViewport viewPort = (JViewport)this.getParent();
        Rectangle bounds = viewPort.getViewRect();
        int maxX = bounds.x + bounds.width - 1;
        int startIndex = bounds.x / this.byteWidth;
        x += startIndex * this.byteWidth;
        for (int i = startIndex; i < byteSize; ++i) {
            int w = this.byteWidth;
            if (i == byteSize - 1) {
                ++w;
            }
            if (x > maxX) break;
            this.paintByte(g, x, y, w, i, baseOffset);
            g.fillRect((x += w) - 2, y, 2, 25);
        }
    }

    private void paintByte(Graphics g, int x, int y, int width, int byteIndex, int baseOffset) {
        Color curColor = g.getColor();
        int offset = byteIndex;
        if (!this.bigEndian) {
            offset = this.allocationByteSize - byteIndex - 1;
        }
        g.setColor(BYTE_HEADER_COLOR);
        g.fillRect(x, y, width - 2, 25);
        g.setColor(TEXT_COLOR);
        Object offsetStr = this.showOffsetsInHex ? "0x" + Integer.toHexString(offset) : Integer.toString(offset += baseOffset);
        FontMetrics fontMetrics = g.getFontMetrics();
        int textY = y + (25 + fontMetrics.getMaxAscent() - 2) / 2;
        int textX = x + (width - 2 - fontMetrics.stringWidth((String)offsetStr)) / 2;
        g.drawString((String)offsetStr, textX, textY);
        g.setColor(curColor);
    }

    private void paintBits(Graphics2D g, int y) {
        int bitIndex;
        this.bitFieldAllocation.refresh(false);
        Color curColor = g.getColor();
        BitAttributes[] bitAttributes = this.bitFieldAllocation.bitAttributes;
        int x = 2;
        if (bitAttributes[0] != null && bitAttributes[0].leftEndType == EndBitType.TRUNCATED_END) {
            this.drawTruncationLine(g, --x, y, 25);
            ++x;
        }
        Rectangle dtcRectangle = null;
        DataTypeComponent prevDtc = null;
        BitAttributes prevAttrs = null;
        JViewport viewPort = (JViewport)this.getParent();
        Rectangle bounds = viewPort.getViewRect();
        int maxX = bounds.x + bounds.width - 1;
        int width = bitAttributes[0].rectangle.width;
        int startIndex = bounds.x / bitAttributes[0].rectangle.width - 8 * this.bitFieldAllocation.leftChopBytes;
        x += startIndex * width;
        for (bitIndex = startIndex; bitIndex < bitAttributes.length; ++bitIndex) {
            BitAttributes attrs = bitAttributes[bitIndex];
            if (x > maxX) break;
            boolean paintRightLine = bitIndex != bitAttributes.length - 1;
            attrs.paint(g, prevAttrs, paintRightLine);
            DataTypeComponent dtc = attrs.getDataTypeComponent(false);
            if (prevDtc != null && prevDtc != dtc) {
                this.paintComponentLabel(g, prevDtc, dtcRectangle);
                prevDtc = null;
            }
            Rectangle visibleBitRect = attrs.rectangle.intersection(bounds);
            if (prevDtc == null) {
                prevDtc = dtc;
                dtcRectangle = visibleBitRect;
            } else {
                dtcRectangle.add(visibleBitRect);
            }
            if (attrs.unallocated) {
                this.paintDit(g, attrs.rectangle);
            }
            prevAttrs = attrs;
            x += width;
        }
        if (prevDtc != null) {
            this.paintComponentLabel(g, prevDtc, dtcRectangle);
        }
        if (bitIndex == bitAttributes.length && prevAttrs != null && prevAttrs.rightEndType == EndBitType.TRUNCATED_END) {
            this.drawTruncationLine(g, --x, y, 25);
        }
        g.setColor(curColor);
    }

    private void paintDit(Graphics2D g, Rectangle r) {
        Color curColor = g.getColor();
        g.setColor(INTERIOR_LINE_COLOR);
        int x = r.x + r.width / 2 - 1;
        int y = r.y + r.height / 2 - 1;
        g.fillRect(x, y, 2, 2);
        g.setColor(curColor);
    }

    private void paintComponentLabel(Graphics g, DataTypeComponent dtc, Rectangle r) {
        if (dtc.getDataType() == DataType.DEFAULT) {
            return;
        }
        Object name = dtc.getFieldName();
        if (name == null) {
            return;
        }
        name = " " + (String)name + " ";
        FontMetrics fontMetrics = g.getFontMetrics();
        int strWidth = fontMetrics.stringWidth((String)name);
        if (strWidth >= r.width) {
            return;
        }
        Color curColor = g.getColor();
        g.setColor(TEXT_COLOR);
        int textY = r.y + (r.height + fontMetrics.getMaxAscent() - 2) / 2;
        int textX = r.x + (r.width - 2 - strWidth) / 2;
        g.drawString((String)name, textX, textY);
        g.setColor(curColor);
    }

    private void drawTruncationLine(Graphics2D g, int x, int y, int height) {
        Color c = g.getColor();
        Stroke s = g.getStroke();
        g.setColor(this.getBackground());
        g.setStroke(DASH);
        g.drawLine(x, y, x, y + height - 1);
        g.setColor(c);
        g.setStroke(s);
    }

    private static enum EditMode {
        NONE,
        ADD,
        EDIT;

    }

    private class MyMouseWheelListener
    implements MouseWheelListener {
        private MyMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (BitFieldPlacementComponent.this.bitFieldAllocation == null || e.getModifiersEx() != 64 || e.isConsumed()) {
                return;
            }
            if (e.getScrollType() != 0) {
                return;
            }
            e.consume();
            Point p = e.getPoint();
            int index = BitFieldPlacementComponent.this.getBitIndex(p.x);
            if (index < 0) {
                return;
            }
            int w = BitFieldPlacementComponent.this.bitWidth + e.getWheelRotation();
            if (w >= 10) {
                Rectangle visibleRect = BitFieldPlacementComponent.this.getVisibleRect();
                double offsetX = p.getX() - visibleRect.getX();
                BitFieldPlacementComponent.this.setBitWidth(w);
                Rectangle bitRec = BitFieldPlacementComponent.this.bitFieldAllocation.bitAttributes[index].rectangle;
                int x = (int)(bitRec.getCenterX() - offsetX);
                Rectangle r = new Rectangle(x, visibleRect.y, visibleRect.width, visibleRect.height);
                BitFieldPlacementComponent.this.scrollRectToVisible(r);
            }
        }
    }

    class BitFieldAllocation {
        private final int bitSize;
        private final int bitOffset;
        private boolean hasConflict;
        private Rectangle visibleArea;
        private int allocationBytes;
        private int rightChopBytes;
        private int leftChopBytes;
        private BitAttributes[] bitAttributes;

        BitFieldAllocation(int bitSize, int bitOffset) {
            int maxBitOffset = 8 * BitFieldPlacementComponent.this.allocationByteSize - 1;
            if (BitFieldPlacementComponent.this.allocationByteSize <= 0 || bitOffset < 0 || bitSize < 0 || bitSize + bitOffset - 1 > maxBitOffset) {
                throw new IllegalArgumentException("bitfield not contained within allocation window");
            }
            this.bitSize = bitSize;
            this.bitOffset = bitOffset;
            this.refresh(true);
        }

        private int getLeftByteChop() {
            if (BitFieldPlacementComponent.this.editUseEnabled) {
                return 0;
            }
            if (this.visibleArea.width == 0) {
                return BitFieldPlacementComponent.this.allocationByteSize - 1;
            }
            int visibleStart = this.visibleArea.x;
            return visibleStart / BitFieldPlacementComponent.this.byteWidth;
        }

        private int getRightByteChop() {
            if (BitFieldPlacementComponent.this.editUseEnabled) {
                return 0;
            }
            if (this.visibleArea.width == 0) {
                return 0;
            }
            int visibleEnd = this.visibleArea.x + this.visibleArea.width - 1;
            int chop = BitFieldPlacementComponent.this.allocationByteSize - (visibleEnd + BitFieldPlacementComponent.this.byteWidth) / BitFieldPlacementComponent.this.byteWidth;
            return Math.max(0, chop);
        }

        private void refresh(boolean force) {
            Rectangle visibleRect = BitFieldPlacementComponent.this.getVisibleRect();
            if (!force && (BitFieldPlacementComponent.this.editUseEnabled || visibleRect.equals(this.visibleArea))) {
                return;
            }
            this.visibleArea = visibleRect;
            int leftChop = this.getLeftByteChop();
            int rightChop = this.getRightByteChop();
            if (!force && leftChop == this.leftChopBytes && rightChop == this.rightChopBytes) {
                return;
            }
            this.leftChopBytes = leftChop;
            this.rightChopBytes = rightChop;
            this.allocationBytes = BitFieldPlacementComponent.this.allocationByteSize - this.leftChopBytes - this.rightChopBytes;
            this.allocateBits();
            this.layoutBits();
        }

        private void allocateBits() {
            if (BitFieldPlacementComponent.this.composite == null) {
                this.bitAttributes = new BitAttributes[0];
                return;
            }
            this.bitAttributes = new BitAttributes[8 * this.allocationBytes];
            if (BitFieldPlacementComponent.this.composite instanceof Structure) {
                this.allocateStructureMembers((Structure)BitFieldPlacementComponent.this.composite);
            }
            if (BitFieldPlacementComponent.this.editMode != EditMode.NONE) {
                int rightMostBit = 8 * BitFieldPlacementComponent.this.allocationByteSize - this.bitOffset - 1;
                if (this.bitSize == 0) {
                    this.allocateZeroBitField(BitFieldPlacementComponent.this.editComponent, rightMostBit);
                } else {
                    int leftMostBit = rightMostBit - this.bitSize + 1;
                    this.allocateBits(BitFieldPlacementComponent.this.editComponent, leftMostBit, rightMostBit, false, false);
                }
            }
            for (int i = 0; i < this.bitAttributes.length; ++i) {
                if (this.bitAttributes[i] != null) continue;
                this.bitAttributes[i] = new BitAttributes();
            }
        }

        private void layoutBits() {
            int x = 2;
            int y = 29;
            int width = BitFieldPlacementComponent.this.bitWidth + 1;
            x += 8 * this.leftChopBytes * width;
            for (BitAttributes attrs : this.bitAttributes) {
                attrs.layout(x, y, width, 25);
                x += width;
            }
        }

        private void allocateStructureMembers(Structure struct) {
            int offset = BitFieldPlacementComponent.this.allocationByteOffset;
            int allocationEndOffset = (offset += BitFieldPlacementComponent.this.isBigEndian() ? this.leftChopBytes : this.rightChopBytes) + this.allocationBytes - 1;
            int numComponents = struct.getNumComponents();
            DataTypeComponent component = struct.getDefinedComponentAtOrAfterOffset(offset);
            while (component != null && component.getOffset() <= allocationEndOffset) {
                int nextOrdinal;
                if (component.getOrdinal() != BitFieldPlacementComponent.this.editOrdinal) {
                    BitFieldPlacement placement = new BitFieldPlacement(component);
                    if (placement.zeroBitField) {
                        this.allocateZeroBitField(component, placement.rightBit);
                    } else {
                        this.allocateBits(component, placement.leftBit, placement.rightBit, placement.truncateLeft, placement.truncateRight);
                    }
                }
                if ((nextOrdinal = component.getOrdinal() + 1) >= numComponents) break;
                component = struct.getComponent(nextOrdinal);
            }
        }

        private void allocateBits(DataTypeComponent dtc, int leftBit, int rightBit, boolean truncatedLeft, boolean truncatedRight) {
            if (truncatedLeft && truncatedRight && leftBit == rightBit) {
                throw new AssertException();
            }
            int adjust = 8 * this.leftChopBytes;
            int startIndex = Math.max(0, leftBit -= adjust);
            int endIndex = Math.min(8 * this.allocationBytes - 1, rightBit -= adjust);
            for (int i = startIndex; i <= endIndex; ++i) {
                EndBitType leftEndType = EndBitType.NOT_END;
                EndBitType rightEndType = EndBitType.NOT_END;
                if (dtc != null) {
                    if (i == leftBit) {
                        EndBitType endBitType = leftEndType = truncatedLeft ? EndBitType.TRUNCATED_END : EndBitType.END;
                    }
                    if (i == rightBit) {
                        rightEndType = truncatedRight ? EndBitType.TRUNCATED_END : EndBitType.END;
                    }
                }
                this.bitAttributes[i] = new BitAttributes(dtc, leftEndType, rightEndType, this.bitAttributes[i]);
                this.hasConflict |= this.bitAttributes[i].hasConflict();
            }
        }

        private void allocateZeroBitField(DataTypeComponent dtc, int bitIndex) {
            int index = bitIndex - 8 * this.leftChopBytes;
            if (index >= 0 && index < this.bitAttributes.length) {
                this.bitAttributes[index] = new BitAttributes(dtc, this.bitAttributes[index]);
            }
        }

        public int getBitOffset() {
            return this.bitOffset;
        }

        public int getBitSize() {
            return this.bitSize;
        }
    }

    private class BitFieldPlacement {
        int leftBit;
        int rightBit;
        boolean truncateLeft;
        boolean truncateRight;
        boolean zeroBitField;

        BitFieldPlacement(DataTypeComponent component) {
            int startOffset = component.getOffset();
            int componentLength = component.getLength();
            int offsetAdjBytes = startOffset - BitFieldPlacementComponent.this.allocationByteOffset;
            if (!BitFieldPlacementComponent.this.bigEndian) {
                offsetAdjBytes = BitFieldPlacementComponent.this.allocationByteSize - offsetAdjBytes - componentLength;
            }
            int leftAdj = 8 * offsetAdjBytes;
            if (componentLength == 0) {
                this.zeroBitField = true;
                this.rightBit = leftAdj - 8;
                if (!BitFieldPlacementComponent.this.isBigEndian()) {
                    this.rightBit += 7;
                }
                this.leftBit = this.rightBit;
            } else if (component.isBitFieldComponent()) {
                BitFieldDataType bitfield = (BitFieldDataType)component.getDataType();
                int storageSize = 8 * bitfield.getStorageSize();
                this.rightBit = leftAdj + storageSize - bitfield.getBitOffset() - 1;
                int bitSize = bitfield.getBitSize();
                this.leftBit = this.rightBit - bitSize + 1;
            } else {
                int componentSize = 8 * component.getLength();
                this.rightBit = leftAdj + componentSize - 1;
                this.leftBit = leftAdj;
            }
            int allocBitSize = 8 * BitFieldPlacementComponent.this.allocationByteSize;
            this.truncateRight = false;
            if (this.rightBit >= allocBitSize) {
                this.truncateRight = true;
                this.rightBit = allocBitSize - 1;
            }
            this.truncateLeft = false;
            if (this.leftBit < 0) {
                this.truncateLeft = true;
                this.leftBit = 0;
            }
        }
    }

    class BitAttributes {
        private final DataTypeComponent dtc;
        private final EndBitType leftEndType;
        private final EndBitType rightEndType;
        private final BitAttributes conflict;
        private boolean zeroBitfield;
        private boolean unallocated;
        private Rectangle rectangle;

        BitAttributes() {
            this.dtc = null;
            this.leftEndType = EndBitType.NOT_END;
            this.rightEndType = EndBitType.NOT_END;
            this.conflict = null;
            this.unallocated = true;
        }

        BitAttributes(DataTypeComponent dtc, BitAttributes conflict) {
            this(dtc, dtc != null ? EndBitType.END : EndBitType.NOT_END, dtc != null ? EndBitType.END : EndBitType.NOT_END, conflict);
            this.zeroBitfield = true;
        }

        BitAttributes(DataTypeComponent dtc, EndBitType leftEndType, EndBitType rightEndType, BitAttributes conflict) {
            this.dtc = dtc;
            this.leftEndType = leftEndType;
            this.rightEndType = rightEndType;
            this.conflict = conflict;
            if (conflict != null) {
                leftEndType = conflict.leftEndType;
                rightEndType = conflict.rightEndType;
            }
        }

        private boolean isAddBitField() {
            return !this.unallocated && this.dtc == null;
        }

        private boolean isEditField() {
            return this.dtc != null && this.dtc.getOrdinal() == BitFieldPlacementComponent.this.editOrdinal;
        }

        private boolean hasConflict() {
            return this.getConflict() != null;
        }

        private DataTypeComponent getConflict() {
            BitAttributes c = this.conflict;
            while (c != null && c.dtc.getLength() == 0 && c.conflict != null) {
                c = c.conflict;
            }
            return c != null && c.dtc.getDataType() != DataType.DEFAULT ? c.dtc : null;
        }

        void layout(int x, int y, int width, int height) {
            this.rectangle = new Rectangle(x, y, width, height);
            if (this.conflict != null) {
                this.conflict.layout(x, y, width, height);
            }
        }

        private void paint(Graphics g, BitAttributes bitAttrsToLeft, boolean paintRightLine) {
            Color lineColor;
            Color c = this.getColor();
            g.setColor(c);
            if (this.zeroBitfield) {
                if (this.conflict != null) {
                    this.conflict.paint(g, bitAttrsToLeft, paintRightLine);
                }
                if (!BitFieldPlacementComponent.this.bigEndian) {
                    bitAttrsToLeft = null;
                }
                c = ACTIVE_BITFIELD_BITS_COLOR;
                lineColor = INTERIOR_LINE_COLOR;
                if (this.dtc != null && this.dtc != BitFieldPlacementComponent.this.editComponent) {
                    c = BITFIELD_COMPONENT_COLOR;
                    lineColor = LINE_COLOR;
                }
                int xStrip = BitFieldPlacementComponent.this.bigEndian ? this.rectangle.x : this.rectangle.x + BitFieldPlacementComponent.this.bitWidth - 3;
                int xLine = BitFieldPlacementComponent.this.bigEndian ? xStrip + 3 : xStrip - 1;
                g.setColor(c);
                g.fillRect(xStrip, this.rectangle.y, 3, 25);
                g.setColor(lineColor);
                g.fillRect(xLine, this.rectangle.y, 1, 25);
            } else {
                g.fillRect(this.rectangle.x, this.rectangle.y, BitFieldPlacementComponent.this.bitWidth, 25);
                if (this.conflict != null && this.conflict.dtc.getLength() == 0) {
                    this.conflict.paint(g, null, false);
                }
            }
            if (bitAttrsToLeft != null && this.dtc != null && bitAttrsToLeft.unallocated) {
                g.setColor(LINE_COLOR);
                g.fillRect(this.rectangle.x - 1, this.rectangle.y, 1, 25);
            }
            if (paintRightLine) {
                lineColor = LINE_COLOR;
                if (this.rightEndType == EndBitType.NOT_END) {
                    lineColor = INTERIOR_LINE_COLOR;
                }
                g.setColor(lineColor);
                g.fillRect(this.rectangle.x + BitFieldPlacementComponent.this.bitWidth, this.rectangle.y, 1, 25);
            }
        }

        private Color getColor() {
            if (this.unallocated) {
                return UNDEFINED_BIT_COLOR;
            }
            if (this.conflict != null && !this.conflict.unallocated && !this.conflict.zeroBitfield && this.conflict.dtc.getDataType() != DataType.DEFAULT) {
                return CONFLICT_BITS_COLOR;
            }
            if (this.dtc == BitFieldPlacementComponent.this.editComponent) {
                return ACTIVE_BITFIELD_BITS_COLOR;
            }
            if (this.dtc.getDataType() == DataType.DEFAULT) {
                return UNDEFINED_BIT_COLOR;
            }
            return this.dtc.isBitFieldComponent() ? BITFIELD_COMPONENT_COLOR : NON_BITFIELD_COMPONENT_COLOR;
        }

        private String getTip() {
            if (this.unallocated) {
                return "<padding>";
            }
            if (this.dtc == null) {
                return null;
            }
            String name = this.dtc.getFieldName();
            return this.dtc.getDataType().getDisplayName() + (String)(name != null ? " " + name : "");
        }

        DataTypeComponent getDataTypeComponent(boolean ignoreActiveComponent) {
            if (!(this.dtc == null || this.dtc.getOrdinal() == BitFieldPlacementComponent.this.editOrdinal && ignoreActiveComponent)) {
                return this.dtc;
            }
            if (this.conflict != null) {
                return this.conflict.dtc;
            }
            return null;
        }

        Rectangle getRectangle() {
            return this.rectangle;
        }
    }

    private static enum EndBitType {
        NOT_END,
        END,
        TRUNCATED_END;

    }

    public static class BitFieldLegend
    extends JPanel {
        BitFieldLegend(DataTypeComponent viewedBitfield) {
            JPanel legendPanel;
            if (viewedBitfield != null) {
                this.setLayout((LayoutManager)new VerticalLayout(10));
                legendPanel = new JPanel(new GridLayout(1, 3, 5, 5));
                String viewComponentText = "Selected bitfield  { " + viewedBitfield.getDataType().getDisplayName();
                String viewComponentName = viewedBitfield.getFieldName();
                if (viewComponentName != null) {
                    viewComponentText = viewComponentText + "  " + viewComponentName;
                }
                viewComponentText = viewComponentText + " }";
                this.add(new JLabel(viewComponentText, (Icon)new ColorIcon(ACTIVE_BITFIELD_BITS_COLOR, INTERIOR_LINE_COLOR, 16), 2));
                this.add(legendPanel);
            } else {
                this.setLayout(new GridLayout(2, 3, 5, 5));
                legendPanel = this;
            }
            legendPanel.add(new JLabel("Defined bitfield", (Icon)new ColorIcon(BITFIELD_COMPONENT_COLOR, INTERIOR_LINE_COLOR, 16), 2));
            legendPanel.add(new JLabel("Defined non-bitfield  ", (Icon)new ColorIcon(NON_BITFIELD_COMPONENT_COLOR, INTERIOR_LINE_COLOR, 16), 2));
            legendPanel.add(new JLabel("Undefined bits", (Icon)new ColorIcon(UNDEFINED_BIT_COLOR, INTERIOR_LINE_COLOR, 16), 2));
            if (viewedBitfield == null) {
                legendPanel.add(new JLabel("Edit bitfield bits", (Icon)new ColorIcon(ACTIVE_BITFIELD_BITS_COLOR, INTERIOR_LINE_COLOR, 16), 2));
                legendPanel.add(new JLabel("Conflict bits", (Icon)new ColorIcon(CONFLICT_BITS_COLOR, INTERIOR_LINE_COLOR, 16), 2));
            }
        }
    }
}

