/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import com.google.common.base.Predicate;
import docking.ActionContext;
import docking.DefaultActionContext;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.OptionDialog;
import docking.widgets.button.GButton;
import docking.widgets.label.GDLabel;
import generic.theme.GIcon;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.compositeeditor.BitFieldPlacementComponent;
import ghidra.app.plugin.core.compositeeditor.CompositeChangeListener;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.app.util.datatype.NavigationDirection;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Structure;
import ghidra.util.data.DataTypeParser;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.TwoColumnPairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

public class BitFieldEditorPanel
extends JPanel {
    private static final Icon DECREMENT_ICON = new GIcon("icon.plugin.composite.editor.bit.field.editor.decrement");
    private static final Icon INCREMENT_ICON = new GIcon("icon.plugin.composite.editor.bit.field.editor.increment");
    private DataTypeManagerService dtmService;
    private Composite composite;
    private Predicate<DataType> dataTypeValidator;
    private JLabel allocationOffsetLabel;
    JButton decrementButton;
    JButton incrementButton;
    private BitFieldPlacementComponent placementComponent;
    private DataType baseDataType;
    private DataTypeSelectionEditor dtChoiceEditor;
    private JTextField fieldNameTextField;
    private JTextField fieldCommentTextField;
    private SpinnerNumberModel allocSizeModel;
    private JSpinnerWithMouseWheel allocSizeInput;
    private SpinnerNumberModel bitOffsetModel;
    private JSpinnerWithMouseWheel bitOffsetInput;
    private SpinnerNumberModel bitSizeModel;
    private JSpinnerWithMouseWheel bitSizeInput;
    private GDLabel statusTextField;
    private BitSelectionHandler bitSelectionHandler;
    private boolean updating = false;

    BitFieldEditorPanel(Composite composite, DataTypeManagerService dtmService, Predicate<DataType> dataTypeValidator) {
        this.composite = composite;
        if (composite.isPackingEnabled()) {
            throw new IllegalArgumentException("composite must be non-packed");
        }
        this.setLayout((LayoutManager)new VerticalLayout(5));
        this.setFocusTraversalKeysEnabled(true);
        this.dtmService = dtmService;
        this.dataTypeValidator = dataTypeValidator;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        if (composite instanceof Structure) {
            this.add(this.createAllocationOffsetPanel());
        }
        this.add(this.createPlacementPanel());
        this.add(this.createLegendPanel());
        this.add(this.createEntryPanel());
        this.add(this.createStatusPanel());
        this.enableControls(false);
    }

    void setShowOffsetsInHex(boolean useHex) {
        this.placementComponent.setShowOffsetsInHex(useHex);
        this.updateAllocationOffsetLabel();
    }

    boolean isShowOffsetsInHex() {
        return this.placementComponent.isShowOffsetsInHex();
    }

    private JPanel createLegendPanel() {
        JPanel legendPanel = new JPanel(new BorderLayout());
        legendPanel.add((Component)new BitFieldPlacementComponent.BitFieldLegend(null), "West");
        return legendPanel;
    }

    private JPanel createAllocationOffsetPanel() {
        JPanel panel = new JPanel((LayoutManager)new HorizontalLayout(5));
        this.decrementButton = new GButton(DECREMENT_ICON);
        this.decrementButton.setFocusable(false);
        this.decrementButton.setToolTipText("Decrement allocation unit offset");
        this.decrementButton.addActionListener(e -> this.adjustAllocationOffset(-1));
        panel.add(this.decrementButton);
        this.incrementButton = new GButton(INCREMENT_ICON);
        this.incrementButton.setFocusable(false);
        this.incrementButton.setToolTipText("Increment allocation unit offset");
        this.incrementButton.addActionListener(e -> this.adjustAllocationOffset(1));
        panel.add(this.incrementButton);
        this.allocationOffsetLabel = new JLabel();
        this.allocationOffsetLabel.setHorizontalTextPosition(2);
        panel.add(this.allocationOffsetLabel);
        return panel;
    }

    private void adjustAllocationOffset(int delta) {
        int adjustedOffset = this.placementComponent.getAllocationOffset() + delta;
        if (adjustedOffset < 0 || adjustedOffset > this.composite.getLength()) {
            return;
        }
        this.placementComponent.updateAllocation(this.placementComponent.getAllocationByteSize(), adjustedOffset);
        this.updateAllocationOffsetLabel();
    }

    private void updateAllocationOffsetLabel() {
        if (this.composite instanceof Structure) {
            int allocOffset = this.placementComponent.getAllocationOffset();
            Object allocOffsetStr = this.placementComponent.isShowOffsetsInHex() ? "0x" + Integer.toHexString(allocOffset) : Integer.toString(allocOffset);
            String text = "Structure Offset of Allocation Unit: " + (String)allocOffsetStr;
            this.allocationOffsetLabel.setText(text);
            int offset = this.placementComponent.getAllocationOffset();
            this.decrementButton.setEnabled(offset > 0);
            int length = this.composite.isZeroLength() ? 0 : this.composite.getLength();
            this.incrementButton.setEnabled(offset < length);
        }
    }

    private Component createStatusPanel() {
        JPanel statusPanel = new JPanel(new BorderLayout());
        this.statusTextField = new GDLabel(" ");
        this.statusTextField.setHorizontalAlignment(0);
        this.statusTextField.setForeground((Color)GThemeDefaults.Colors.Messages.ERROR);
        int height = this.statusTextField.getPreferredSize().height;
        statusPanel.add(Box.createVerticalStrut(height), "West");
        statusPanel.add((Component)this.statusTextField, "Center");
        return statusPanel;
    }

    private void setStatus(String text) {
        this.statusTextField.setText(text);
    }

    private void clearStatus() {
        this.statusTextField.setText("");
    }

    private JPanel createEntryPanel() {
        JComponent baseDataTypeEditor = this.createDataTypeChoiceEditor();
        this.fieldNameTextField = new JTextField(20);
        this.fieldNameTextField.setFocusable(true);
        this.fieldCommentTextField = new JTextField(20);
        this.fieldCommentTextField.setFocusable(true);
        this.allocSizeModel = new SpinnerNumberModel((Number)4L, Long.valueOf(1L), Long.valueOf(16L), (Number)1L);
        this.allocSizeInput = new JSpinnerWithMouseWheel(this.allocSizeModel);
        this.bitOffsetModel = new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(31L), (Number)1L);
        this.bitOffsetInput = new JSpinnerWithMouseWheel(this.bitOffsetModel);
        this.bitSizeModel = new SpinnerNumberModel((Number)4L, Long.valueOf(0L), Long.valueOf(32L), (Number)1L);
        this.bitSizeInput = new JSpinnerWithMouseWheel(this.bitSizeModel);
        this.allocSizeModel.addChangeListener(e -> this.update());
        this.bitSizeModel.addChangeListener(e -> this.update());
        this.bitOffsetModel.addChangeListener(e -> this.update());
        JPanel entryPanel = new JPanel((LayoutManager)new TwoColumnPairLayout(5, 15, 5, 0));
        entryPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        entryPanel.setFocusCycleRoot(true);
        entryPanel.add(new JLabel("Base Datatype:"));
        entryPanel.add(baseDataTypeEditor);
        entryPanel.add(new JLabel("Allocation Bytes:"));
        entryPanel.add(this.allocSizeInput);
        entryPanel.add(new JLabel("Field Name:"));
        entryPanel.add(this.fieldNameTextField);
        entryPanel.add(new JLabel("Bit Size:"));
        entryPanel.add(this.bitSizeInput);
        entryPanel.add(new JLabel("Comment:"));
        entryPanel.add(this.fieldCommentTextField);
        entryPanel.add(new JLabel("Bit Offset:"));
        entryPanel.add(this.bitOffsetInput);
        return entryPanel;
    }

    private JComponent createDataTypeChoiceEditor() {
        this.dtChoiceEditor = new DataTypeSelectionEditor(this.dtmService, DataTypeParser.AllowedDataTypes.BITFIELD_BASE_TYPE);
        this.dtChoiceEditor.setConsumeEnterKeyPress(false);
        this.dtChoiceEditor.setTabCommitsEdit(true);
        final DropDownSelectionTextField<DataType> dtChoiceTextField = this.dtChoiceEditor.getDropDownTextField();
        dtChoiceTextField.setBorder(new JTextField().getBorder());
        this.dtChoiceEditor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component other = e.getOppositeComponent();
                if (other != null && SwingUtilities.isDescendingFrom(other, BitFieldEditorPanel.this) && !SwingUtilities.isDescendingFrom(other, BitFieldEditorPanel.this.dtChoiceEditor.getEditorComponent())) {
                    BitFieldEditorPanel.this.dtChoiceEditor.stopCellEditing();
                }
            }
        });
        this.dtChoiceEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                BitFieldEditorPanel.this.dtChoiceEditor.setCellEditorValue(BitFieldEditorPanel.this.baseDataType);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                if (!BitFieldEditorPanel.this.checkValidBaseDataType()) {
                    dtChoiceTextField.selectAll();
                    dtChoiceTextField.requestFocus();
                } else {
                    BitFieldEditorPanel.this.updateBitSizeModel();
                    NavigationDirection direction = BitFieldEditorPanel.this.dtChoiceEditor.getNavigationDirection();
                    if (direction == NavigationDirection.FORWARD) {
                        BitFieldEditorPanel.this.allocSizeInput.requestFocus();
                    } else if (direction == NavigationDirection.BACKWARD) {
                        BitFieldEditorPanel.this.bitOffsetInput.requestFocus();
                    }
                }
            }
        });
        this.dtChoiceEditor.getBrowseButton().setFocusable(false);
        JComponent editorComponent = this.dtChoiceEditor.getEditorComponent();
        Dimension preferredSize = editorComponent.getPreferredSize();
        editorComponent.setPreferredSize(new Dimension(200, preferredSize.height));
        return editorComponent;
    }

    private JPanel createPlacementPanel() {
        this.placementComponent = new BitFieldPlacementComponent(this.composite, true);
        this.placementComponent.setFont(UIManager.getFont("TextField.font"));
        this.placementComponent.addMouseWheelListener(e -> this.bitSizeInput.mouseWheelMoved(e));
        this.bitSelectionHandler = new BitSelectionHandler();
        this.placementComponent.addMouseListener(this.bitSelectionHandler);
        this.placementComponent.addMouseMotionListener(this.bitSelectionHandler);
        JPanel bitViewPanel = new JPanel((LayoutManager)new PairLayout(0, 5));
        JPanel labelPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(7, 5, 0, 0));
        JLabel byteOffsetLabel = new JLabel("Byte Offset:", 4);
        labelPanel.add(byteOffsetLabel);
        labelPanel.add(new JLabel("Component Bits:", 4));
        bitViewPanel.add(labelPanel);
        JScrollPane scrollPane = new JScrollPane(this.placementComponent, 21, 30);
        scrollPane.getViewport().setBackground((Color)GThemeDefaults.Colors.Viewport.UNEDITABLE_BACKGROUND);
        scrollPane.setBorder(null);
        bitViewPanel.add(scrollPane);
        return bitViewPanel;
    }

    private boolean checkValidBaseDataType() {
        DropDownSelectionTextField<DataType> textField = this.dtChoiceEditor.getDropDownTextField();
        String dtName = textField.getText().trim();
        boolean isValid = true;
        try {
            if (dtName.length() == 0 || !this.dtChoiceEditor.validateUserSelection()) {
                this.setStatus("Valid bitfield base datatype entry required");
                isValid = false;
            }
        }
        catch (InvalidDataTypeException e) {
            this.setStatus("Invalid bitfield base datatype: " + e.getMessage());
            isValid = false;
        }
        if (isValid) {
            DataType dt = this.dtChoiceEditor.getCellEditorValueAsDataType();
            if (!this.dataTypeValidator.apply((Object)this.baseDataType)) {
                this.setStatus("Valid bitfield base datatype entry required");
                isValid = false;
            } else {
                this.baseDataType = dt.clone(this.composite.getDataTypeManager());
                this.clearStatus();
            }
        } else {
            this.dataTypeValidator.apply(null);
        }
        return isValid;
    }

    void initAdd(DataType initialBaseDataType, int allocationOffset, int bitOffset, boolean useCurrentAllocation) {
        if (initialBaseDataType == null) {
            initialBaseDataType = this.baseDataType;
        }
        if (!BitFieldDataType.isValidBaseDataType((DataType)initialBaseDataType)) {
            initialBaseDataType = IntegerDataType.dataType.clone(this.composite.getDataTypeManager());
        }
        long allocationSize = useCurrentAllocation ? (Long)this.allocSizeModel.getValue() : (long)initialBaseDataType.getLength();
        this.placementComponent.updateAllocation((int)allocationSize, allocationOffset);
        this.placementComponent.initAdd(1, bitOffset);
        this.initControls(null, null, initialBaseDataType, 1);
        this.enableControls(true);
    }

    void initEdit(DataTypeComponent bitfieldDtc, int allocationOffset, boolean useExistingAllocationSize) {
        String initialFieldName = null;
        String initialComment = null;
        DataType initialBaseDataType = null;
        int allocationSize = -1;
        if (useExistingAllocationSize) {
            allocationSize = this.placementComponent.getAllocationByteSize();
        }
        if (bitfieldDtc != null) {
            int allocationAdjust;
            if (!bitfieldDtc.isBitFieldComponent()) {
                throw new IllegalArgumentException("unsupport data type component");
            }
            initialFieldName = bitfieldDtc.getFieldName();
            initialComment = bitfieldDtc.getComment();
            BitFieldDataType bitfieldDt = (BitFieldDataType)bitfieldDtc.getDataType();
            initialBaseDataType = bitfieldDt.getBaseDataType();
            if (allocationSize < 1) {
                allocationSize = initialBaseDataType.getLength();
            }
            if ((allocationAdjust = this.composite.getLength() - allocationOffset - allocationSize) < 0) {
                allocationSize += allocationAdjust;
            }
        }
        if (allocationSize < 1) {
            allocationSize = 4;
        }
        this.placementComponent.updateAllocation(allocationSize, allocationOffset);
        this.placementComponent.init(bitfieldDtc);
        BitFieldPlacementComponent.BitFieldAllocation bitFieldAllocation = this.placementComponent.getBitFieldAllocation();
        this.initControls(initialFieldName, initialComment, initialBaseDataType, bitFieldAllocation.getBitSize());
        this.enableControls(bitfieldDtc != null);
    }

    void componentDeleted(int ordinal) {
        this.placementComponent.componentDeleted(ordinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initControls(String initialFieldName, String initialComment, DataType initialBaseDataType, int initialBitSize) {
        this.updating = true;
        try {
            this.baseDataType = initialBaseDataType;
            this.dataTypeValidator.apply((Object)this.baseDataType);
            this.dtChoiceEditor.setCellEditorValue(initialBaseDataType);
            this.fieldNameTextField.setText(initialFieldName);
            this.fieldCommentTextField.setText(initialComment);
            this.allocSizeModel.setValue(this.placementComponent.getAllocationByteSize());
            int allocBits = 8 * this.placementComponent.getAllocationByteSize();
            this.bitSizeModel.setValue(initialBitSize);
            this.bitOffsetModel.setMaximum(Long.valueOf((long)allocBits - 1L));
            BitFieldPlacementComponent.BitFieldAllocation bitFieldAllocation = this.placementComponent.getBitFieldAllocation();
            this.bitOffsetModel.setValue(bitFieldAllocation.getBitOffset());
            this.updateBitSizeModel();
            this.updateAllocationOffsetLabel();
        }
        finally {
            this.updating = false;
        }
    }

    boolean isEditing() {
        return this.placementComponent.isEditing();
    }

    boolean isAdding() {
        return this.placementComponent.isAdding();
    }

    boolean endCurrentEdit() {
        if (this.placementComponent.isEditing()) {
            this.placementComponent.cancelEdit();
            this.enableControls(false);
        }
        return true;
    }

    boolean apply(CompositeChangeListener listener) {
        if (!this.checkValidBaseDataType()) {
            DropDownSelectionTextField<DataType> dtChoiceTextField = this.dtChoiceEditor.getDropDownTextField();
            dtChoiceTextField.selectAll();
            dtChoiceTextField.requestFocus();
            return false;
        }
        boolean deleteConflicts = false;
        if (this.placementComponent.hasApplyConflict()) {
            long allocationSize = (Long)this.allocSizeModel.getValue();
            int option = OptionDialog.showOptionDialog((Component)this, (String)"Bitfield Conflict(s)", (String)("Bitfield placement conflicts with one or more components.\nWould you like to delete conflicts or move conflicts by " + allocationSize + " bytes?"), (String)"Delete Conflicts", (String)"Move Conflicts", (int)2);
            if (option == 0) {
                return false;
            }
            deleteConflicts = option == 1;
        }
        this.placementComponent.applyBitField(this.baseDataType, this.fieldNameTextField.getText().trim(), this.fieldCommentTextField.getText().trim(), deleteConflicts, listener);
        this.enableControls(false);
        return true;
    }

    private void enableControls(boolean enable) {
        this.dtChoiceEditor.getBrowseButton().setEnabled(enable);
        this.dtChoiceEditor.getDropDownTextField().setEnabled(enable);
        this.fieldNameTextField.setEnabled(enable);
        this.fieldCommentTextField.setEnabled(enable);
        this.allocSizeInput.setEnabled(enable);
        this.bitSizeInput.setEnabled(enable);
        this.bitOffsetInput.setEnabled(enable);
        if (!enable) {
            this.dtChoiceEditor.getDropDownTextField().setText("");
            this.fieldNameTextField.setText(null);
            this.fieldCommentTextField.setText(null);
            this.bitOffsetModel.setValue(0L);
            this.bitSizeModel.setValue(1L);
        }
    }

    private int setBitFieldOffset(Point point) {
        int bitOffset = this.placementComponent.getBitOffset(point);
        if (bitOffset >= 0) {
            this.bitOffsetModel.setValue(bitOffset);
        }
        return bitOffset;
    }

    private DataTypeComponent getDataTypeComponent(Point p) {
        BitFieldPlacementComponent.BitAttributes attrs = this.placementComponent.getBitAttributes(p);
        if (attrs != null) {
            return attrs.getDataTypeComponent(true);
        }
        return null;
    }

    private void updateBitSizeModel() {
        int allocSize = this.allocSizeModel.getNumber().intValue();
        int allocBits = 8 * allocSize;
        int baseTypeBits = this.baseDataType != null ? 8 * this.baseDataType.getLength() : allocBits;
        long maxBitSize = Math.min(allocBits, baseTypeBits);
        this.bitSizeModel.setMaximum(Long.valueOf(maxBitSize));
        if (maxBitSize < (Long)this.bitSizeModel.getValue()) {
            this.bitSizeModel.setValue(maxBitSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            int allocSize = this.allocSizeModel.getNumber().intValue();
            int allocBits = 8 * allocSize;
            this.updateBitSizeModel();
            this.bitOffsetModel.setMaximum(Long.valueOf(allocBits - 1));
            int bitSize = this.bitSizeModel.getNumber().intValue();
            int boff = this.bitOffsetModel.getNumber().intValue();
            int total = bitSize + boff;
            if (total > allocBits && (boff -= total - allocBits) < 0) {
                boff = 0;
            }
            if (bitSize == 0) {
                boff = 8 * (boff / 8);
                if (this.placementComponent.isBigEndian()) {
                    boff += 7;
                }
                this.bitOffsetModel.setStepSize(8L);
            } else {
                this.bitOffsetModel.setStepSize(1L);
            }
            this.bitOffsetModel.setValue(boff);
            if (bitSize > allocBits) {
                bitSize = allocBits;
                this.bitSizeModel.setValue(bitSize);
            }
            this.placementComponent.refresh(allocSize, this.placementComponent.getAllocationOffset(), bitSize, boff);
        }
        finally {
            this.updating = false;
        }
    }

    ActionContext getActionContext(MouseEvent event) {
        if (this.placementComponent == event.getSource()) {
            Point p = event.getPoint();
            return new BitFieldEditorContext(this.getDataTypeComponent(p), this.placementComponent.getBitOffset(p));
        }
        return null;
    }

    private static class JSpinnerWithMouseWheel
    extends JSpinner
    implements MouseWheelListener {
        JSpinnerWithMouseWheel(SpinnerNumberModel model) {
            super(model);
            this.addMouseWheelListener(this);
        }

        @Override
        public void requestFocus() {
            JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
            editor.getTextField().requestFocus();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mwe) {
            Long value;
            if (!this.isEnabled() || mwe.getModifiersEx() != 0 || mwe.isConsumed()) {
                return;
            }
            if (mwe.getScrollType() != 0) {
                return;
            }
            mwe.consume();
            SpinnerNumberModel m = (SpinnerNumberModel)this.getModel();
            Long l = value = mwe.getUnitsToScroll() > 0 ? (Long)m.getPreviousValue() : (Long)m.getNextValue();
            if (value != null) {
                this.setValue(value);
            }
        }
    }

    private class BitSelectionHandler
    extends MouseAdapter {
        private boolean selectionActive = false;
        private int startBit;
        private int lastBit;
        private int lastX;

        private BitSelectionHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (BitFieldEditorPanel.this.bitOffsetInput.isEnabled() || e.isConsumed() || e.getClickCount() != 2 || !BitFieldEditorPanel.this.placementComponent.isWithinBitCell(e.getPoint())) {
                return;
            }
            BitFieldPlacementComponent.BitAttributes bitAttributes = BitFieldEditorPanel.this.placementComponent.getBitAttributes(e.getPoint());
            if (bitAttributes != null) {
                DataTypeComponent dtc = bitAttributes.getDataTypeComponent(true);
                if (dtc == null || !dtc.isBitFieldComponent()) {
                    return;
                }
                e.consume();
                BitFieldEditorPanel.this.initEdit(dtc, BitFieldEditorPanel.this.placementComponent.getAllocationOffset(), true);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.selectionActive && BitFieldEditorPanel.this.bitOffsetInput.isEnabled()) {
                boolean inBounds = BitFieldEditorPanel.this.placementComponent.isWithinBitCell(e.getPoint());
                BitFieldEditorPanel.this.setCursor(Cursor.getPredefinedCursor(inBounds ? 12 : 0));
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this.selectionActive && BitFieldEditorPanel.this.bitOffsetInput.isEnabled() && BitFieldEditorPanel.this.placementComponent.isWithinBitCell(e.getPoint())) {
                BitFieldEditorPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.selectionActive) {
                BitFieldEditorPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (!BitFieldEditorPanel.this.placementComponent.isWithinBitCell(e.getPoint())) {
                return;
            }
            if (e.getButton() == 1) {
                e.consume();
                this.selectionActive = false;
                if (BitFieldEditorPanel.this.bitOffsetInput.isEnabled()) {
                    BitFieldEditorPanel.this.bitSizeModel.setValue(1L);
                    this.lastBit = this.startBit = BitFieldEditorPanel.this.setBitFieldOffset(e.getPoint());
                    boolean bl = this.selectionActive = this.startBit >= 0;
                    if (this.selectionActive) {
                        this.lastX = e.getPoint().x;
                        BitFieldEditorPanel.this.setCursor(Cursor.getPredefinedCursor(10));
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            BitFieldPlacementComponent.BitAttributes bitAttributes;
            if (!this.selectionActive || e.isConsumed()) {
                return;
            }
            e.consume();
            Point p = e.getPoint();
            if (p.x == this.lastX) {
                return;
            }
            Cursor cursor = Cursor.getPredefinedCursor(p.x < this.lastX ? 10 : 11);
            BitFieldEditorPanel.this.setCursor(cursor);
            this.lastX = p.x;
            int bitOffset = BitFieldEditorPanel.this.placementComponent.getBitOffset(p);
            if (bitOffset == this.lastBit) {
                return;
            }
            if (!BitFieldEditorPanel.this.placementComponent.getVisibleRect().contains(p) && (bitAttributes = BitFieldEditorPanel.this.placementComponent.getBitAttributes(e.getPoint())) != null) {
                BitFieldEditorPanel.this.placementComponent.scrollRectToVisible(bitAttributes.getRectangle());
            }
            if (bitOffset >= 0) {
                this.lastBit = bitOffset;
                if (bitOffset <= this.startBit) {
                    int start = Math.min(this.startBit, bitOffset);
                    BitFieldEditorPanel.this.bitOffsetModel.setValue(start);
                }
                long bitSize = Math.abs(bitOffset - this.startBit) + 1;
                BitFieldEditorPanel.this.bitSizeModel.setValue(bitSize);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.selectionActive && !e.isConsumed()) {
                e.consume();
                this.selectionActive = false;
                Point p = e.getPoint();
                boolean inBounds = BitFieldEditorPanel.this.placementComponent.getVisibleRect().contains(p);
                BitFieldEditorPanel.this.setCursor(Cursor.getPredefinedCursor(inBounds ? 12 : 0));
            }
        }
    }

    class BitFieldEditorContext
    extends DefaultActionContext {
        private int selectedBitOffset;
        private DataTypeComponent selectedDtc;

        private BitFieldEditorContext(DataTypeComponent selectedDtc, int selectedBitOffset) {
            this.selectedDtc = selectedDtc;
            this.selectedBitOffset = selectedBitOffset;
        }

        DataTypeComponent getSelectedComponent() {
            return this.selectedDtc;
        }

        public int getAllocationOffset() {
            return BitFieldEditorPanel.this.placementComponent.getAllocationOffset();
        }

        public int getSelectedBitOffset() {
            return this.selectedBitOffset;
        }
    }
}

