/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.commentwindow;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.commentwindow.CommentWindowProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays a list of comments", description="This plugin provides a component for showing all the comments in the current program.  The comment window can be filtered and used for navigation.", servicesRequired={GoToService.class})
public class CommentWindowPlugin
extends ProgramPlugin
implements DomainObjectListener {
    private DockingAction selectAction;
    private CommentWindowProvider provider;
    private SwingUpdateManager reloadUpdateMgr = new SwingUpdateManager(1000, 60000, () -> this.doReload());

    public CommentWindowPlugin(PluginTool tool) {
        super(tool);
    }

    public void init() {
        super.init();
        this.provider = new CommentWindowProvider(this);
        this.createActions();
    }

    public void dispose() {
        this.reloadUpdateMgr.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.provider.dispose();
        super.dispose();
    }

    private int getCommentType(int type) {
        if (type == 91) {
            return 1;
        }
        if (type == 92) {
            return 2;
        }
        if (type == 90) {
            return 0;
        }
        if (type == 95) {
            return 3;
        }
        if (type == 96 || type == 94 || type == 97 || type == 93 || type == 98) {
            return 4;
        }
        return -1;
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (ev.containsEvent(4) || ev.containsEvent(31)) {
            this.reload();
            return;
        }
        if (ev.containsEvent(91) || ev.containsEvent(92) || ev.containsEvent(90) || ev.containsEvent(95) || ev.containsEvent(96) || ev.containsEvent(94) || ev.containsEvent(97) || ev.containsEvent(93) || ev.containsEvent(94) || ev.containsEvent(98)) {
            for (DomainObjectChangeRecord record : ev) {
                int type = record.getEventType();
                int commentType = this.getCommentType(type);
                if (commentType == -1) continue;
                ProgramChangeRecord pRec = (ProgramChangeRecord)record;
                String oldComment = (String)pRec.getOldValue();
                String newComment = (String)pRec.getNewValue();
                Address commentAddress = pRec.getStart();
                if (oldComment == null) {
                    this.provider.commentAdded(commentAddress, this.getCommentType(type));
                    continue;
                }
                if (newComment == null) {
                    this.provider.commentRemoved(commentAddress, this.getCommentType(type));
                    continue;
                }
                this.provider.getComponent().repaint();
            }
        }
    }

    private void reload() {
        this.reloadUpdateMgr.update();
    }

    private void doReload() {
        this.provider.reload();
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.provider.programOpened(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.provider.programClosed();
    }

    Program getProgram() {
        return this.currentProgram;
    }

    CommentWindowProvider getProvider() {
        return this.provider;
    }

    private void createActions() {
        this.selectAction = new MakeProgramSelectionAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.selectAction);
        SelectionNavigationAction selectionAction = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)selectionAction);
    }

    private void selectComment(ProgramSelection selection) {
        ProgramSelectionPluginEvent pspe = new ProgramSelectionPluginEvent("Selection", selection, this.currentProgram);
        this.firePluginEvent(pspe);
        this.processEvent(pspe);
    }
}

