/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.bookmark.BookmarkEditCmd;
import ghidra.app.plugin.core.bookmark.BookmarkRowObject;
import ghidra.app.plugin.core.bookmark.FilterState;
import ghidra.docking.settings.Settings;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Program;
import ghidra.util.LongIterator;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.CodeUnitTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class BookmarkTableModel
extends AddressBasedTableModel<BookmarkRowObject> {
    static final int TYPE_COL = 0;
    static final int CATEGORY_COL = 1;
    static final int COMMENT_COL = 2;
    static final int LOCATION_COL = 3;
    static final int LABEL_COL = 4;
    static final int PREVIEW_COL = 5;
    private BookmarkManager bookmarkMgr;
    private Bookmark lastBookmark;
    private Set<String> types = new HashSet<String>();
    private PluginTool tool;

    BookmarkTableModel(PluginTool tool, Program program) {
        super("Bookmarks", (ServiceProvider)tool, program, null);
        this.tool = tool;
        this.initialize(program);
    }

    @Override
    protected TableColumnDescriptor<BookmarkRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new TypeTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new CategoryTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new DescriptionTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new CodeUnitTableColumn()));
        return descriptor;
    }

    int getKeyCount() {
        if (this.bookmarkMgr == null) {
            return 0;
        }
        return this.bookmarkMgr.getBookmarkCount();
    }

    private int getIteratorKeyCount() {
        if (this.bookmarkMgr == null) {
            return 0;
        }
        int cnt = 0;
        for (String type : this.types) {
            cnt += this.bookmarkMgr.getBookmarkCount(type);
        }
        return cnt;
    }

    protected void doLoad(Accumulator<BookmarkRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        LongIterator it = LongIterator.EMPTY;
        if (this.bookmarkMgr != null && !this.types.isEmpty()) {
            it = new BookmarkKeyIterator(this.bookmarkMgr);
        }
        monitor.initialize((long)this.getIteratorKeyCount());
        int i = 0;
        while (it.hasNext()) {
            monitor.checkCancelled();
            monitor.setProgress((long)i++);
            long key = it.next();
            accumulator.add((Object)new BookmarkRowObject(key));
        }
    }

    boolean hasTypeFilterApplied() {
        if (this.bookmarkMgr == null) {
            return false;
        }
        BookmarkType[] programTypes = this.bookmarkMgr.getBookmarkTypes();
        int allKnownTypesSize = programTypes.length;
        return !this.types.isEmpty() && this.types.size() != allKnownTypesSize;
    }

    FilterState getFilterState() {
        return new FilterState(new HashSet<String>(this.types));
    }

    void restoreFilterState(FilterState filterState) {
        Set<String> newTypes = filterState.getBookmarkTypes();
        this.types = newTypes;
    }

    private void adjustTypeFilter(BookmarkType[] bmTypes) {
        HashSet<String> defaultTypesSet = new HashSet<String>();
        for (BookmarkType element : bmTypes) {
            defaultTypesSet.add(element.getTypeString());
        }
        if (this.types.isEmpty()) {
            this.types = defaultTypesSet;
        } else {
            this.types.retainAll(defaultTypesSet);
        }
    }

    void bookmarkAdded(Bookmark bookmark) {
        if (this.isShowingType(bookmark.getTypeString())) {
            long key = bookmark.getId();
            this.addObject(new BookmarkRowObject(key));
        }
    }

    void bookmarkChanged(Bookmark bookmark) {
        if (this.isShowingType(bookmark.getTypeString())) {
            long key = bookmark.getId();
            this.updateObject(new BookmarkRowObject(key));
        }
    }

    void bookmarkRemoved(Bookmark bookmark) {
        if (this.isShowingType(bookmark.getTypeString())) {
            long key = bookmark.getId();
            this.removeObject(new BookmarkRowObject(key));
        }
    }

    Collection<String> getAllTypes() {
        return Collections.unmodifiableCollection(this.types);
    }

    void showType(String type) {
        this.types.add(type);
    }

    boolean isShowingType(String type) {
        return this.types.contains(type);
    }

    void hideAllTypes() {
        this.types.clear();
    }

    public void typeAdded() {
        this.initialize(this.program);
    }

    Bookmark getBookmark(long key) {
        return this.bookmarkMgr.getBookmark(key);
    }

    void reload(Program newProgram) {
        this.setProgram(newProgram);
        this.initialize(this.getProgram());
        this.reload();
    }

    private void initialize(Program newProgram) {
        if (newProgram == null) {
            this.bookmarkMgr = null;
            return;
        }
        this.bookmarkMgr = newProgram.getBookmarkManager();
        BookmarkType[] bmTypes = this.bookmarkMgr.getBookmarkTypes();
        this.adjustTypeFilter(bmTypes);
    }

    public boolean isCellEditable(int row, int columnIndex) {
        return columnIndex == 1 || columnIndex == 2;
    }

    public void setValueAt(Object aValue, int row, int columnIndex) {
        if (row < 0 || row >= this.filteredData.size()) {
            return;
        }
        BookmarkRowObject rowObject = (BookmarkRowObject)this.filteredData.get(row);
        Bookmark bm = this.getBookmarkForRowObject(rowObject);
        if (bm == null) {
            return;
        }
        switch (columnIndex) {
            case 1: {
                this.tool.execute((Command)new BookmarkEditCmd(bm, (String)aValue, bm.getComment()), (DomainObject)this.getProgram());
                break;
            }
            case 2: {
                this.tool.execute((Command)new BookmarkEditCmd(bm, bm.getCategory(), (String)aValue), (DomainObject)this.getProgram());
            }
        }
    }

    @Override
    public Address getAddress(int row) {
        Bookmark bookmark = this.getBookmarkForRowObject((BookmarkRowObject)this.getRowObject(row));
        return bookmark != null ? bookmark.getAddress() : null;
    }

    private Bookmark getBookmarkForRowObject(BookmarkRowObject storageObject) {
        if (this.getProgram() == null) {
            return null;
        }
        long key = storageObject.getKey();
        if (this.lastBookmark == null || this.lastBookmark.getId() != key) {
            this.lastBookmark = this.bookmarkMgr.getBookmark(key);
        }
        return this.lastBookmark;
    }

    private class TypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<BookmarkRowObject, String> {
        private TypeTableColumn() {
        }

        public String getColumnDisplayName(Settings settings) {
            return this.getColumnName();
        }

        public String getColumnName() {
            return "Type";
        }

        public String getValue(BookmarkRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Bookmark bookmark = BookmarkTableModel.this.getBookmarkForRowObject(rowObject);
            if (bookmark == null) {
                return null;
            }
            return bookmark.getTypeString();
        }
    }

    private class CategoryTableColumn
    extends AbstractProgramBasedDynamicTableColumn<BookmarkRowObject, String> {
        private CategoryTableColumn() {
        }

        public String getColumnName() {
            return "Category";
        }

        public String getValue(BookmarkRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Bookmark bookmark = BookmarkTableModel.this.getBookmarkForRowObject(rowObject);
            if (bookmark == null) {
                return null;
            }
            return bookmark.getCategory();
        }
    }

    private class DescriptionTableColumn
    extends AbstractProgramBasedDynamicTableColumn<BookmarkRowObject, String> {
        private DescriptionTableColumn() {
        }

        public String getColumnName() {
            return "Description";
        }

        public String getValue(BookmarkRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Bookmark bookmark = BookmarkTableModel.this.getBookmarkForRowObject(rowObject);
            if (bookmark == null) {
                return null;
            }
            return bookmark.getComment();
        }
    }

    private class BookmarkKeyIterator
    implements LongIterator {
        private int nextIter = 1;
        private List<Iterator<Bookmark>> iters = new ArrayList<Iterator<Bookmark>>();
        private Iterator<Bookmark> currIter;

        BookmarkKeyIterator(BookmarkManager bookmarkMgr) {
            for (String type : BookmarkTableModel.this.types) {
                Iterator bkIt = bookmarkMgr.getBookmarksIterator(type);
                if (!bkIt.hasNext()) continue;
                this.iters.add(bkIt);
            }
            if (this.iters.size() > 0) {
                this.currIter = this.iters.get(0);
            }
        }

        public boolean hasNext() {
            if (this.currIter == null) {
                return false;
            }
            return this.currIter.hasNext() || this.nextIter < this.iters.size();
        }

        public long next() {
            if (!this.currIter.hasNext()) {
                this.currIter = this.iters.get(this.nextIter++);
            }
            Bookmark bookmark = this.currIter.next();
            return bookmark.getId();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public long previous() {
            throw new UnsupportedOperationException();
        }
    }
}

