/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.util.datastruct.IntObjectHashtable;
import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;
import java.util.Iterator;

class OffsetRanges {
    IntObjectHashtable<SortedRangeList> firstUseRanges = new IntObjectHashtable();

    OffsetRanges() {
    }

    public void addRangeList(int firstUse, SortedRangeList commonSrl) {
        SortedRangeList srl = (SortedRangeList)this.firstUseRanges.get(firstUse);
        if (srl == null) {
            srl = new SortedRangeList();
            this.firstUseRanges.put(firstUse, (Object)srl);
        }
        Iterator iter = commonSrl.getRanges();
        while (iter.hasNext()) {
            Range range = (Range)iter.next();
            srl.addRange(range.min, range.max);
        }
    }

    void addRange(int firstUse, int min, int max) {
        SortedRangeList srl = (SortedRangeList)this.firstUseRanges.get(firstUse);
        if (srl == null) {
            srl = new SortedRangeList();
            this.firstUseRanges.put(firstUse, (Object)srl);
        }
        srl.addRange(min, max);
    }

    boolean contains(int firstUse, int value) {
        SortedRangeList srl = (SortedRangeList)this.firstUseRanges.get(firstUse);
        return srl != null ? srl.contains(value) : false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int[] keys = this.firstUseRanges.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            int firstUse = keys[i];
            SortedRangeList srl = (SortedRangeList)this.firstUseRanges.get(firstUse);
            buf.append("FirstUse=" + firstUse + " Offsets = " + srl + "\n");
        }
        return buf.toString();
    }

    OffsetRanges intersect(OffsetRanges otherChangeRanges) {
        int[] keys;
        OffsetRanges ranges = new OffsetRanges();
        for (int firstUseOffset : keys = this.firstUseRanges.getKeys()) {
            SortedRangeList intersectedList;
            SortedRangeList firstUseList = (SortedRangeList)this.firstUseRanges.get(firstUseOffset);
            SortedRangeList otherList = (SortedRangeList)otherChangeRanges.firstUseRanges.get(firstUseOffset);
            if (otherList == null || (intersectedList = firstUseList.intersect(otherList)).isEmpty()) continue;
            ranges.addRangeList(firstUseOffset, intersectedList);
        }
        return ranges;
    }

    OffsetRanges union(OffsetRanges otherChangeRanges) {
        Range r;
        Iterator it;
        SortedRangeList combinedList;
        SortedRangeList otherList;
        SortedRangeList firstUseList;
        OffsetRanges ranges = new OffsetRanges();
        int[] keys = this.firstUseRanges.getKeys();
        int[] otherKeys = otherChangeRanges.firstUseRanges.getKeys();
        for (int firstUseOffset : keys) {
            firstUseList = (SortedRangeList)this.firstUseRanges.get(firstUseOffset);
            otherList = (SortedRangeList)otherChangeRanges.firstUseRanges.get(firstUseOffset);
            combinedList = new SortedRangeList();
            it = firstUseList.getRanges();
            while (it.hasNext()) {
                r = (Range)it.next();
                combinedList.addRange(r.min, r.max);
            }
            if (otherList != null) {
                it = otherList.getRanges();
                while (it.hasNext()) {
                    r = (Range)it.next();
                    combinedList.addRange(r.min, r.max);
                }
            }
            ranges.addRangeList(firstUseOffset, combinedList);
        }
        for (int firstUseOffset : otherKeys) {
            if (ranges.firstUseRanges.contains(firstUseOffset)) continue;
            firstUseList = (SortedRangeList)this.firstUseRanges.get(firstUseOffset);
            otherList = (SortedRangeList)otherChangeRanges.firstUseRanges.get(firstUseOffset);
            combinedList = new SortedRangeList();
            it = otherList.getRanges();
            while (it.hasNext()) {
                r = (Range)it.next();
                combinedList.addRange(r.min, r.max);
            }
            if (firstUseList != null) {
                it = firstUseList.getRanges();
                while (it.hasNext()) {
                    r = (Range)it.next();
                    combinedList.addRange(r.min, r.max);
                }
            }
            ranges.addRangeList(firstUseOffset, combinedList);
        }
        return ranges;
    }
}

