/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.stack;

import ghidra.app.services.DebuggerControlService;
import ghidra.async.AsyncFence;
import ghidra.pcode.eval.ArithmeticVarnodeEvaluator;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.util.TraceRegisterUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public class SavedRegisterMap {
    private final NavigableMap<Address, SavedEntry> saved;
    private final SavedEntrySetter setter = new SavedEntrySetter();

    public SavedRegisterMap() {
        this.saved = new TreeMap<Address, SavedEntry>();
    }

    public SavedRegisterMap(TreeMap<Address, SavedEntry> saved) {
        this.saved = new TreeMap<Address, SavedEntry>();
    }

    private NavigableMap<Address, SavedEntry> subMap(Address lower, Address upper) {
        Map.Entry<Address, SavedEntry> adjEnt = this.saved.floorEntry(lower);
        if (adjEnt != null && adjEnt.getValue().contains(upper)) {
            lower = adjEnt.getKey();
        }
        return this.saved.subMap(lower, true, upper, true);
    }

    static AddressRange rangeForVarnode(Varnode vn) {
        return new AddressRangeImpl(vn.getAddress(), vn.getAddress().add((long)(vn.getSize() - 1)));
    }

    public void put(Register from, Varnode stackVar) {
        this.put(TraceRegisterUtils.rangeForRegister((Register)from), SavedRegisterMap.rangeForVarnode(stackVar));
    }

    public void put(AddressRange from, AddressRange to) {
        if (from.getLength() != to.getLength()) {
            throw new IllegalArgumentException("from and to must match in length");
        }
        this.put(from, to.getMinAddress());
    }

    public void put(AddressRange from, Address to) {
        this.setter.set(from, new SavedEntry(from, to));
    }

    public SavedRegisterMap fork() {
        return new SavedRegisterMap(new TreeMap<Address, SavedEntry>((SortedMap<Address, SavedEntry>)this.saved));
    }

    public <T> T getVar(final PcodeExecutorState<T> state, Address address, final int size, final PcodeExecutorStatePiece.Reason reason) {
        final PcodeArithmetic arithmetic = state.getArithmetic();
        return (T)new PieceVisitor<T>(){

            @Override
            T visitPiece(Address address, int sz, T value) {
                Object piece = state.getVar(address, size, true, reason);
                return ArithmeticVarnodeEvaluator.catenate((PcodeArithmetic)arithmetic, (int)size, value, (Object)piece, (int)sz);
            }
        }.visitVarnode(address, size, arithmetic.fromConst(0L, size));
    }

    public CompletableFuture<Void> setVar(final DebuggerControlService.StateEditor editor, Address address, byte[] bytes) {
        final AsyncFence fence = new AsyncFence();
        new PieceVisitor<ByteBuffer>(){

            @Override
            ByteBuffer visitPiece(Address address, int size, ByteBuffer buf) {
                byte[] sub = new byte[size];
                buf.get(sub);
                fence.include(editor.setVariable(address, sub));
                return buf;
            }
        }.visitVarnode(address, bytes.length, ByteBuffer.wrap(bytes));
        return fence.ready();
    }

    protected class SavedEntrySetter
    extends DBTraceUtils.AddressRangeMapSetter<Map.Entry<Address, SavedEntry>, SavedEntry> {
        protected SavedEntrySetter() {
        }

        protected AddressRange getRange(Map.Entry<Address, SavedEntry> entry) {
            return entry.getValue().from;
        }

        protected SavedEntry getValue(Map.Entry<Address, SavedEntry> entry) {
            return entry.getValue();
        }

        protected void remove(Map.Entry<Address, SavedEntry> entry) {
            SavedRegisterMap.this.saved.remove(entry.getKey());
        }

        protected Iterable<Map.Entry<Address, SavedEntry>> getIntersecting(Address lower, Address upper) {
            return SavedRegisterMap.this.subMap(lower, upper).entrySet();
        }

        protected Map.Entry<Address, SavedEntry> put(AddressRange range, SavedEntry value) {
            SavedRegisterMap.this.saved.put(range.getMinAddress(), value.truncate(range));
            return null;
        }
    }

    record SavedEntry(AddressRange from, Address to) {
        boolean contains(Address address) {
            return this.from.contains(address);
        }

        public SavedEntry truncate(AddressRange range) {
            int right = (int)this.from.getMaxAddress().subtract(range.getMaxAddress());
            if (right < 0) {
                throw new AssertionError((Object)"Cannot grow");
            }
            int left = (int)this.from.getMinAddress().subtract(range.getMinAddress());
            if (left < 0) {
                throw new AssertionError((Object)"Cannot grow");
            }
            if (left == 0 && right == 0) {
                return this;
            }
            return new SavedEntry(range, this.to.add((long)left));
        }

        public SavedEntry intersect(AddressRange range) {
            AddressRange intersection = this.from.intersect(range);
            return intersection == null ? null : this.truncate(intersection);
        }

        public SavedEntry truncateMax(Address max) {
            if (this.from.getMaxAddress().compareTo((Object)max) <= 0) {
                return this;
            }
            if (this.from.getMinAddress().compareTo((Object)max) <= 0) {
                return this.truncate((AddressRange)new AddressRangeImpl(this.from.getMinAddress(), max));
            }
            return null;
        }

        public SavedEntry truncateMin(Address min) {
            if (this.from.getMinAddress().compareTo((Object)min) >= 0) {
                return this;
            }
            if (this.from.getMaxAddress().compareTo((Object)min) >= 0) {
                return this.truncate((AddressRange)new AddressRangeImpl(min, this.from.getMaxAddress()));
            }
            return null;
        }

        public int size() {
            return (int)this.from.getLength();
        }
    }

    private abstract class PieceVisitor<U> {
        private PieceVisitor() {
        }

        public U visitVarnode(Address address, int size, U user) {
            AddressRangeImpl range = new AddressRangeImpl(address, address.add((long)(size - 1)));
            SavedEntry identity = new SavedEntry((AddressRange)range, address);
            for (SavedEntry se : SavedRegisterMap.this.subMap(range.getMinAddress(), range.getMaxAddress()).values()) {
                SavedEntry idLeft;
                Address prev = se.from.getMinAddress().previous();
                if (prev != null && (idLeft = identity.truncateMax(prev)) != null) {
                    user = this.visitPiece(idLeft.to, idLeft.size(), user);
                }
                SavedEntry piece = se.intersect((AddressRange)range);
                user = this.visitPiece(piece.to, piece.size(), user);
                Address next = se.from.getMaxAddress().next();
                if (next == null) {
                    return user;
                }
                identity = identity.truncateMin(next);
            }
            if (identity != null) {
                user = this.visitPiece(identity.to, identity.size(), user);
            }
            return user;
        }

        abstract U visitPiece(Address var1, int var2, U var3);
    }
}

