/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import docking.ActionContext;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.gui.model.DebuggerObjectActionContext;
import ghidra.app.plugin.core.debug.gui.objects.components.DebuggerMethodInvocationDialog;
import ghidra.app.plugin.core.debug.service.target.AbstractTarget;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetDeletable;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetStackFrame;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.TargetTogglable;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.debug.api.model.TraceRecorder;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public class TraceRecorderTarget
extends AbstractTarget {
    private final TraceRecorder recorder;

    protected static boolean isSameFocus(DebuggerCoordinates prev, DebuggerCoordinates resolved) {
        if (!Objects.equals(prev.getObject(), resolved.getObject())) {
            return false;
        }
        if (!Objects.equals(prev.getFrame(), resolved.getFrame())) {
            return false;
        }
        if (!Objects.equals(prev.getThread(), resolved.getThread())) {
            return false;
        }
        return Objects.equals(prev.getTrace(), resolved.getTrace());
    }

    protected static boolean checkTargetActivation(DebuggerCoordinates prev, DebuggerCoordinates resolved) {
        if (!resolved.isAlive()) {
            return false;
        }
        return !TraceRecorderTarget.isSameFocus(prev, resolved);
    }

    public TraceRecorderTarget(PluginTool tool, TraceRecorder recorder) {
        super(tool);
        this.recorder = recorder;
    }

    public boolean isValid() {
        return this.recorder.isRecording();
    }

    protected <T extends TargetObject> T findObjectInContext(ActionContext context, Class<T> iface) {
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            List<TraceObjectValue> values = ctx.getObjectValues();
            if (values.size() != 1) {
                return null;
            }
            TraceObjectValue single = values.get(0);
            if (!single.isObject()) {
                return null;
            }
            TraceObject suitable = single.getChild().querySuitableTargetInterface(iface);
            if (suitable == null) {
                return null;
            }
            return (T)((TargetObject)iface.cast(this.recorder.getTargetObject(suitable)));
        }
        return null;
    }

    protected <T extends TargetObject> T findObjectInTrace(ActionContext context, Class<T> iface) {
        DebuggerTraceManagerService traceManager = (DebuggerTraceManagerService)this.tool.getService(DebuggerTraceManagerService.class);
        TraceObject focus = traceManager.getCurrentObject();
        if (focus == null) {
            return null;
        }
        TraceObject suitable = focus.querySuitableTargetInterface(iface);
        if (suitable == null) {
            return null;
        }
        return (T)((TargetObject)iface.cast(this.recorder.getTargetObject(suitable)));
    }

    protected <T extends TargetObject> T findObjectInRecorder(ActionContext context, Class<T> iface) {
        if (!this.isValid()) {
            return null;
        }
        TargetObject focus = this.recorder.getFocus();
        if (focus == null) {
            return null;
        }
        return (T)focus.getCachedSuitable(iface);
    }

    protected <T extends TargetObject> T findObject(ActionContext context, Class<T> iface) {
        T object = this.findObjectInContext(context, iface);
        if (object != null) {
            return object;
        }
        object = this.findObjectInTrace(context, iface);
        if (object != null) {
            return object;
        }
        return this.findObjectInRecorder(context, iface);
    }

    private Map<String, Object> collectArgumentsReqAddr(TargetMethod.TargetParameterMap params, Address address) {
        TargetMethod.ParameterDescription addrParam = null;
        for (TargetMethod.ParameterDescription p : params.values()) {
            if (p.type == Address.class) {
                if (addrParam != null) {
                    return null;
                }
                addrParam = p;
                continue;
            }
            if (!p.required || p.defaultValue != null) continue;
            return null;
        }
        if (addrParam == null) {
            return null;
        }
        return Map.of(addrParam.name, address);
    }

    private List<MethodWithArgs> findAddressMethods(ProgramLocationActionContext context) {
        Address address = this.findAddress((ActionContext)context);
        if (address == null) {
            return List.of();
        }
        TargetObject object = this.findObject((ActionContext)context, TargetObject.class);
        if (object == null) {
            return List.of();
        }
        ArrayList<MethodWithArgs> result = new ArrayList<MethodWithArgs>();
        PathPredicates matcher = object.getModel().getRootSchema().matcherForSuitable(TargetMethod.class, object.getPath());
        for (TargetObject obj : matcher.getCachedSuccessors(object.getModel().getModelRoot()).values()) {
            TargetMethod method;
            Map<String, Object> arguments;
            if (!(obj instanceof TargetMethod) || (arguments = this.collectArgumentsReqAddr((method = (TargetMethod)obj).getParameters(), address)) == null) continue;
            result.add(new MethodWithArgs(method, arguments));
        }
        return result;
    }

    private static String getDisplay(TargetMethod method) {
        String display = method.getDisplay();
        if (display != null) {
            return display;
        }
        return method.getName();
    }

    private Map<String, ?> promptArgs(TargetMethod method, Map<String, ?> defaults) {
        Map<String, ?> args;
        DebuggerMethodInvocationDialog dialog = new DebuggerMethodInvocationDialog(this.tool, method.getDisplay(), method.getDisplay(), null);
        do {
            for (TargetMethod.ParameterDescription param : method.getParameters().values()) {
                Object val = defaults.get(param.name);
                if (val == null) continue;
                dialog.setMemorizedArgument(param.name, param.type.asSubclass(Object.class), val);
            }
            args = dialog.promptArguments((Map<String, TargetMethod.ParameterDescription<?>>)method.getParameters());
            if (args != null) continue;
            return null;
        } while (dialog.isResetRequested());
        return args;
    }

    private CompletableFuture<?> invokeMethod(boolean prompt, TargetMethod method, Map<String, ?> arguments) {
        Map<String, ?> chosenArgs = prompt ? this.promptArgs(method, arguments) : arguments;
        return method.invoke(chosenArgs).thenAccept(result -> {
            DebuggerConsoleService consoleService = (DebuggerConsoleService)this.tool.getService(DebuggerConsoleService.class);
            if (consoleService != null && method.getReturnType() != Void.class) {
                consoleService.log(null, TraceRecorderTarget.getDisplay(method) + " returned " + result);
            }
        });
    }

    private Target.ActionEntry makeEntry(boolean requiresPrompt, TargetMethod method, Map<String, ?> arguments) {
        return new Target.ActionEntry(method.getDisplay(), null, null, requiresPrompt, () -> true, prompt -> this.invokeMethod((boolean)prompt, method, arguments));
    }

    @Override
    public Map<String, Target.ActionEntry> collectAddressActions(ProgramLocationActionContext context) {
        HashMap<String, Target.ActionEntry> result = new HashMap<String, Target.ActionEntry>();
        for (MethodWithArgs mwa : this.findAddressMethods(context)) {
            result.put(mwa.method.getJoinedPath("."), this.makeEntry(mwa.requiresPrompt(), mwa.method, mwa.arguments));
        }
        return result;
    }

    protected <T extends TargetObject> Map<String, Target.ActionEntry> collectIfaceActions(ActionContext context, Class<T> iface, String display, ActionName name, String description, Predicate<T> enabled, Function<T, CompletableFuture<?>> action) {
        Object object = this.findObject(context, iface);
        if (object == null) {
            return Map.of();
        }
        return Map.of(display, new Target.ActionEntry(display, name, description, false, () -> enabled.test(object), prompt -> (CompletableFuture)action.apply(object)));
    }

    private TargetExecutionStateful.TargetExecutionState getStateOf(TargetObject object) {
        TargetExecutionStateful stateful = (TargetExecutionStateful)object.getCachedSuitable(TargetExecutionStateful.class);
        return stateful == null ? null : stateful.getExecutionState();
    }

    private <T extends TargetObject> Predicate<T> stateNullOr(Predicate<TargetExecutionStateful.TargetExecutionState> predicate) {
        return object -> {
            TargetExecutionStateful.TargetExecutionState state = this.getStateOf((TargetObject)object);
            return state == null || predicate.test(state);
        };
    }

    @Override
    protected Map<String, Target.ActionEntry> collectResumeActions(ActionContext context) {
        return this.collectIfaceActions(context, TargetResumable.class, "Resume", ActionName.RESUME, "Resume, i.e., go or continue execution of the target", this.stateNullOr(TargetExecutionStateful.TargetExecutionState::isStopped), TargetResumable::resume);
    }

    @Override
    protected Map<String, Target.ActionEntry> collectInterruptActions(ActionContext context) {
        return this.collectIfaceActions(context, TargetInterruptible.class, "Interrupt", ActionName.INTERRUPT, "Interrupt, i.e., suspend, the target", this.stateNullOr(TargetExecutionStateful.TargetExecutionState::isRunning), TargetInterruptible::interrupt);
    }

    @Override
    protected Map<String, Target.ActionEntry> collectKillActions(ActionContext context) {
        return this.collectIfaceActions(context, TargetKillable.class, "Kill", ActionName.KILL, "Kill, i.e., forcibly terminate the target", this.stateNullOr(TargetExecutionStateful.TargetExecutionState::isAlive), TargetKillable::kill);
    }

    @Override
    protected Map<String, Target.ActionEntry> collectStepIntoActions(ActionContext context) {
        return this.collectIfaceActions(context, TargetSteppable.class, "Step Into", ActionName.STEP_INTO, "Step the target a single instruction, descending into calls", this.stateNullOr(TargetExecutionStateful.TargetExecutionState::isStopped), steppable -> steppable.step(TargetSteppable.TargetStepKind.INTO));
    }

    @Override
    protected Map<String, Target.ActionEntry> collectStepOverActions(ActionContext context) {
        return this.collectIfaceActions(context, TargetSteppable.class, "Step Over", ActionName.STEP_OVER, "Step the target a single instruction, without following calls", this.stateNullOr(TargetExecutionStateful.TargetExecutionState::isStopped), steppable -> steppable.step(TargetSteppable.TargetStepKind.OVER));
    }

    @Override
    protected Map<String, Target.ActionEntry> collectStepOutActions(ActionContext context) {
        return this.collectIfaceActions(context, TargetSteppable.class, "Step Out", ActionName.STEP_OUT, "Step the target until it completes the current frame", this.stateNullOr(TargetExecutionStateful.TargetExecutionState::isStopped), steppable -> steppable.step(TargetSteppable.TargetStepKind.FINISH));
    }

    @Override
    protected Map<String, Target.ActionEntry> collectStepExtActions(ActionContext context) {
        return this.collectIfaceActions(context, TargetSteppable.class, "Step Last", ActionName.STEP_EXT, "Step the target in a target-defined way", this.stateNullOr(TargetExecutionStateful.TargetExecutionState::isStopped), steppable -> steppable.step(TargetSteppable.TargetStepKind.EXTENDED));
    }

    public Trace getTrace() {
        return this.recorder.getTrace();
    }

    public long getSnap() {
        return this.recorder.getSnap();
    }

    public TargetExecutionStateful.TargetExecutionState getThreadExecutionState(TraceThread thread) {
        return this.recorder.getTargetThreadState(thread);
    }

    public boolean isSupportsFocus() {
        return this.recorder.isSupportsFocus();
    }

    public TraceObjectKeyPath getFocus() {
        TargetObject object = this.recorder.getFocus();
        if (object == null) {
            return null;
        }
        return TraceObjectKeyPath.of((List)object.getPath());
    }

    protected TargetObject toTargetObject(DebuggerCoordinates coords) {
        TargetObject object;
        TraceObject obj = coords.getObject();
        if (obj != null && (object = this.recorder.getTarget().getSuccessor(obj.getCanonicalPath().getKeyList())) != null) {
            return object;
        }
        TargetStackFrame frame = this.recorder.getTargetStackFrame(coords.getThread(), coords.getFrame());
        if (frame != null) {
            return frame;
        }
        TargetThread thread = this.recorder.getTargetThread(coords.getThread());
        if (thread != null) {
            return thread;
        }
        return this.recorder.getTarget();
    }

    public CompletableFuture<Void> activateAsync(DebuggerCoordinates prev, DebuggerCoordinates coords) {
        if (!TraceRecorderTarget.checkTargetActivation(prev, coords)) {
            return AsyncUtils.nil();
        }
        if (!this.recorder.isRecording() || this.recorder.getSnap() != coords.getSnap() || !coords.getTime().isSnapOnly()) {
            return AsyncUtils.nil();
        }
        TargetObject obj = this.toTargetObject(coords);
        if (obj == null) {
            return AsyncUtils.nil();
        }
        return this.recorder.requestActivation(obj).thenApply(__ -> null);
    }

    public TraceThread getThreadForSuccessor(TraceObjectKeyPath path) {
        if (path == null) {
            return null;
        }
        TargetObject object = this.recorder.getTargetObject(path);
        if (object == null) {
            return null;
        }
        return this.recorder.getTraceThreadForSuccessor(object);
    }

    public TraceStackFrame getStackFrameForSuccessor(TraceObjectKeyPath path) {
        if (path == null) {
            return null;
        }
        TargetObject object = this.recorder.getTargetObject(path);
        if (object == null) {
            return null;
        }
        return this.recorder.getTraceStackFrameForSuccessor(object);
    }

    public CompletableFuture<Void> invalidateMemoryCachesAsync() {
        TargetObject target = this.recorder.getTarget();
        DebuggerObjectModel model = target.getModel();
        model.invalidateAllLocalCaches();
        PathMatcher memMatcher = target.getSchema().searchFor(TargetMemory.class, true);
        Collection memories = memMatcher.getCachedSuccessors(target).values();
        CompletableFuture[] requests = (CompletableFuture[])memories.stream().map(TargetObject::invalidateCaches).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(requests);
    }

    public CompletableFuture<Void> readMemoryAsync(AddressSetView set, TaskMonitor monitor) {
        return ((CompletableFuture)((CompletableFuture)this.recorder.readMemoryBlocks(set, monitor).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.recorder.getTrace().flushEvents());
    }

    public CompletableFuture<Void> readRegistersAsync(TracePlatform platform, TraceThread thread, int frame, Set<Register> registers) {
        if (registers.isEmpty()) {
            return AsyncUtils.nil();
        }
        return ((CompletableFuture)((CompletableFuture)this.recorder.captureThreadRegisters(platform, thread, frame, registers).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> platform.getTrace().flushEvents());
    }

    public boolean isVariableExists(TracePlatform platform, TraceThread thread, int frame, Address address, int length) {
        return this.recorder.isVariableOnTarget(platform, thread, frame, address, length);
    }

    public CompletableFuture<Void> writeMemoryAsync(Address address, byte[] data) {
        return ((CompletableFuture)((CompletableFuture)this.recorder.writeMemory(address, data).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.recorder.getTrace().flushEvents());
    }

    public CompletableFuture<Void> writeRegisterAsync(TracePlatform platform, TraceThread thread, int frame, RegisterValue value) {
        return ((CompletableFuture)((CompletableFuture)this.recorder.writeThreadRegisters(platform, thread, frame, Map.of(value.getRegister(), value)).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.recorder.getTrace().flushEvents());
    }

    @Override
    public CompletableFuture<Void> writeRegisterAsync(TracePlatform platform, TraceThread thread, int frame, Address address, byte[] data) {
        return ((CompletableFuture)((CompletableFuture)this.recorder.writeRegister(platform, thread, frame, address, data).thenCompose(__ -> this.recorder.getTarget().getModel().flushEvents())).thenCompose(__ -> this.recorder.flushTransactions())).thenAccept(__ -> this.recorder.getTrace().flushEvents());
    }

    public CompletableFuture<Void> writeVariableAsync(TracePlatform platform, TraceThread thread, int frame, Address address, byte[] data) {
        return this.recorder.writeVariable(platform, thread, frame, address, data);
    }

    public CompletableFuture<Void> placeBreakpointAsync(AddressRange range, Set<TraceBreakpointKind> kinds, String condition, String commands) {
        if (condition != null && !condition.isBlank()) {
            Msg.warn((Object)this, (Object)"breakpoint condition not supported by recorder-based targets");
        }
        if (commands != null && !commands.isBlank()) {
            Msg.warn((Object)this, (Object)"breakpoint commands not supported by recorder-based targets");
        }
        Set tKinds = TraceRecorder.traceToTargetBreakpointKinds(kinds);
        AddressRange targetRange = this.recorder.getMemoryMapper().traceToTarget(range);
        AsyncFence fence = new AsyncFence();
        for (TargetBreakpointSpecContainer cont : this.recorder.collectBreakpointContainers(null)) {
            LinkedHashSet stKinds = new LinkedHashSet(tKinds);
            stKinds.retainAll((Collection<?>)cont.getSupportedBreakpointKinds());
            fence.include(cont.placeBreakpoint(targetRange, stKinds));
        }
        return fence.ready();
    }

    public Set<TraceBreakpointKind> getSupportedBreakpointKinds() {
        return this.recorder.getSupportedBreakpointKinds();
    }

    public boolean isBreakpointValid(TraceBreakpoint breakpoint) {
        return this.recorder.getTargetBreakpoint(breakpoint) != null;
    }

    public CompletableFuture<Void> deleteBreakpointAsync(TraceBreakpoint breakpoint) {
        TargetBreakpointLocation loc = this.recorder.getTargetBreakpoint(breakpoint);
        if (loc == null) {
            Msg.warn((Object)this, (Object)("Breakpoint not valid on target: " + loc));
            return AsyncUtils.nil();
        }
        if (loc instanceof TargetDeletable) {
            TargetDeletable del = (TargetDeletable)loc;
            return del.delete();
        }
        TargetBreakpointSpec spec = loc.getSpecification();
        if (spec instanceof TargetDeletable) {
            TargetDeletable del = (TargetDeletable)spec;
            return del.delete();
        }
        Msg.warn((Object)this, (Object)("Neither location nor specification for breakpoint is deletable: " + loc));
        return AsyncUtils.nil();
    }

    public CompletableFuture<Void> toggleBreakpointAsync(TraceBreakpoint breakpoint, boolean enabled) {
        TargetBreakpointLocation loc = this.recorder.getTargetBreakpoint(breakpoint);
        if (loc == null) {
            Msg.warn((Object)this, (Object)("Breakpoint not valid on target: " + loc));
            return AsyncUtils.nil();
        }
        if (loc instanceof TargetTogglable) {
            TargetTogglable tog = (TargetTogglable)loc;
            return tog.toggle(enabled);
        }
        TargetBreakpointSpec spec = loc.getSpecification();
        return spec.toggle(enabled);
    }

    public CompletableFuture<Void> forceTerminateAsync() {
        this.recorder.stopRecording();
        return AsyncUtils.nil();
    }

    public CompletableFuture<Void> disconnectAsync() {
        return this.recorder.getTarget().getModel().close().orTimeout(10000L, TimeUnit.MILLISECONDS);
    }

    private record MethodWithArgs(TargetMethod method, Map<String, Object> arguments) {
        public boolean requiresPrompt() {
            for (TargetMethod.ParameterDescription param : this.method.getParameters().values()) {
                if (!param.required || this.arguments.containsKey(param.name)) continue;
                return true;
            }
            return false;
        }
    }
}

