/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.RecorderBreakpointLocationResolver;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedBreakpointRecorder;
import ghidra.dbg.target.TargetBreakpointLocation;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetBreakpointSpecContainer;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathUtils;
import ghidra.debug.api.model.TraceRecorder;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DefaultBreakpointRecorder
implements ManagedBreakpointRecorder {
    private final DefaultTraceRecorder recorder;
    private final Trace trace;
    private final TraceBreakpointManager breakpointManager;
    protected TargetBreakpointSpecContainer breakpointContainer;

    protected static String nameBreakpoint(TargetBreakpointLocation bpt) {
        if (bpt instanceof TargetBreakpointSpec) {
            return bpt.getIndex();
        }
        return bpt.getSpecification().getIndex() + "." + bpt.getIndex();
    }

    public DefaultBreakpointRecorder(DefaultTraceRecorder recorder) {
        this.recorder = recorder;
        this.trace = recorder.getTrace();
        this.breakpointManager = this.trace.getBreakpointManager();
    }

    @Override
    public void offerBreakpointContainer(TargetBreakpointSpecContainer bc) {
        if (this.breakpointContainer != null) {
            Msg.warn((Object)this, (Object)"Already have a breakpoint container for this process");
        }
        this.breakpointContainer = bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offerBreakpointLocation(TargetObject containerParent, TargetBreakpointLocation bpt) {
        DefaultBreakpointRecorder defaultBreakpointRecorder = this;
        synchronized (defaultBreakpointRecorder) {
            if (this.recorder.getMemoryMapper() == null) {
                return;
            }
        }
        RecorderBreakpointLocationResolver resolver = new RecorderBreakpointLocationResolver(this.recorder, bpt);
        resolver.updateBreakpoint(containerParent, bpt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRecordBreakpoint(long snap, TargetBreakpointLocation loc, Set<TraceThread> traceThreads) {
        DefaultBreakpointRecorder defaultBreakpointRecorder = this;
        synchronized (defaultBreakpointRecorder) {
            if (this.recorder.getMemoryMapper() == null) {
                throw new IllegalStateException("No memory mapper! Have not recorded a region, yet.");
            }
        }
        String path = PathUtils.toString((List)loc.getPath());
        String name = DefaultBreakpointRecorder.nameBreakpoint(loc);
        AddressRange traceRange = this.recorder.getMemoryMapper().targetToTrace(loc.getRange());
        try {
            TargetBreakpointSpec spec = loc.getSpecification();
            boolean enabled = spec.isEnabled();
            Set traceKinds = TraceRecorder.targetToTraceBreakpointKinds((Collection)spec.getKinds());
            TraceBreakpoint traceBpt = this.breakpointManager.placeBreakpoint(path, snap, traceRange, traceThreads, (Collection)traceKinds, enabled, spec.getExpression());
            traceBpt.setName(name);
        }
        catch (DuplicateNameException e) {
            Msg.error((Object)this, (Object)("Could not record placed breakpoint: " + e));
        }
    }

    @Override
    public void recordBreakpoint(TargetBreakpointLocation loc, Set<TraceThread> traceThreads) {
        String path = loc.getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Breakpoint " + path + " placed", () -> this.doRecordBreakpoint(snap, loc, traceThreads), path);
    }

    protected void doRemoveBreakpointLocation(long snap, TargetBreakpointLocation loc) {
        String path = loc.getJoinedPath(".");
        for (TraceBreakpoint traceBpt : this.breakpointManager.getBreakpointsByPath(path)) {
            try {
                if (traceBpt.getPlacedSnap() > snap) {
                    Msg.error((Object)this, (Object)("Tracked, now removed breakpoint was placed in the future? " + path));
                    continue;
                }
                if (traceBpt.getPlacedSnap() == snap) {
                    traceBpt.delete();
                    continue;
                }
                traceBpt.setClearedSnap(snap - 1L);
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Could not record breakpoint removal: " + e));
            }
        }
    }

    @Override
    public void removeBreakpointLocation(TargetBreakpointLocation loc) {
        String path = loc.getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Breakpoint " + path + " deleted", () -> this.doRemoveBreakpointLocation(snap, loc), path);
    }

    protected void doBreakpointLocationChanged(long snap, AddressRange traceRng, String path) {
        for (TraceBreakpoint traceBpt : this.breakpointManager.getBreakpointsByPath(path)) {
            if (traceBpt.getRange().equals(traceRng)) continue;
            try {
                if (traceBpt.getPlacedSnap() == snap) {
                    traceBpt.delete();
                } else {
                    traceBpt.setClearedSnap(snap - 1L);
                }
                TraceBreakpoint newtraceBpt = this.breakpointManager.placeBreakpoint(path, snap, traceRng, (Collection)traceBpt.getThreads(), (Collection)traceBpt.getKinds(), traceBpt.isEnabled(snap), traceBpt.getComment());
                newtraceBpt.setName(traceBpt.getName());
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Could not record breakpoint length change: " + e));
            }
        }
    }

    @Override
    public void breakpointLocationChanged(AddressRange traceRng, String path) throws AssertionError {
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Breakpoint length changed", () -> this.doBreakpointLocationChanged(snap, traceRng, path), path);
    }

    protected void doBreakpointSpecChanged(long snap, Collection<? extends TargetBreakpointLocation> bpts, boolean enabled, Collection<TraceBreakpointKind> kinds) {
        for (TargetBreakpointLocation targetBreakpointLocation : bpts) {
            String path = PathUtils.toString((List)targetBreakpointLocation.getPath());
            this.recorder.parTx.execute("Breakpoint " + path + " changed", () -> {
                TraceBreakpoint traceBpt = this.recorder.getTraceBreakpoint(bl);
                if (traceBpt == null) {
                    Msg.warn((Object)this, (Object)("Cannot find toggled trace breakpoint for " + path));
                    return;
                }
                traceBpt.splitAndSet(snap, enabled, kinds);
            }, path);
        }
    }

    @Override
    public void breakpointSpecChanged(TargetBreakpointSpec spec, boolean enabled, Collection<TraceBreakpointKind> kinds) {
        long snap = this.recorder.getSnap();
        ((CompletableFuture)spec.getLocations().thenAccept(bpts -> this.doBreakpointSpecChanged(snap, (Collection<? extends TargetBreakpointLocation>)bpts, enabled, kinds))).exceptionally(ex -> {
            Msg.error((Object)this, (Object)("Error recording changed breakpoint spec: " + spec.getJoinedPath(".")), (Throwable)ex);
            return null;
        });
    }

    @Override
    public TraceBreakpoint getTraceBreakpoint(TargetBreakpointLocation bpt) {
        String path = PathUtils.toString((List)bpt.getPath());
        return this.breakpointManager.getPlacedBreakpointByPath(this.recorder.getSnap(), path);
    }

    @Override
    public TargetBreakpointSpecContainer getBreakpointContainer() {
        return this.breakpointContainer;
    }
}

