/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.gdb;

import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerMappingOffer;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerRegisterMapper;
import ghidra.app.plugin.core.debug.mapping.DefaultDebuggerTargetTraceMapper;
import ghidra.dbg.target.TargetEnvironment;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.TargetRegisterContainer;
import ghidra.debug.api.model.DebuggerMappingOffer;
import ghidra.debug.api.model.DebuggerMappingOpinion;
import ghidra.debug.api.model.DebuggerRegisterMapper;
import ghidra.debug.api.model.DebuggerTargetTraceMapper;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.Set;

public class GdbX86DebuggerMappingOpinion
implements DebuggerMappingOpinion {
    protected static final LanguageID LANG_ID_X86 = new LanguageID("x86:LE:32:default");
    protected static final LanguageID LANG_ID_X86_64 = new LanguageID("x86:LE:64:default");
    protected static final CompilerSpecID COMP_ID_GCC = new CompilerSpecID("gcc");
    protected static final CompilerSpecID COMP_ID_VS = new CompilerSpecID("windows");

    public Set<DebuggerMappingOffer> offersForEnv(TargetEnvironment env, TargetObject target, boolean includeOverrides) {
        if (!(target instanceof TargetProcess)) {
            return Set.of();
        }
        TargetProcess process = (TargetProcess)target;
        if (!env.getDebugger().toLowerCase().contains("gdb")) {
            return Set.of();
        }
        String arch = env.getArchitecture();
        if (!arch.startsWith("i386")) {
            return Set.of();
        }
        boolean is64Bit = arch.contains("x86-64") || arch.contains("x64-32");
        String os = env.getOperatingSystem();
        Msg.info((Object)this, (Object)("Generating offer for os=" + os + " arch=" + arch));
        if (os.contains("Linux")) {
            if (is64Bit) {
                return Set.of(new GdbI386X86_64LinuxOffer(process));
            }
            return Set.of(new GdbI386LinuxOffer(process));
        }
        if (os.contains("Cygwin") || os.contains("Windows")) {
            if (is64Bit) {
                return Set.of(new GdbI386X86_64WindowsOffer(process));
            }
            return Set.of(new GdbI386WindowsOffer(process));
        }
        return Set.of();
    }

    protected static class GdbI386X86_64LinuxOffer
    extends DefaultDebuggerMappingOffer {
        public GdbI386X86_64LinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux x86_64", LANG_ID_X86_64, COMP_ID_GCC, Set.of());
        }

        @Override
        public DebuggerTargetTraceMapper createMapper() throws LanguageNotFoundException, CompilerSpecNotFoundException {
            return new GdbI386X86_64TraceMapper(this.target, this.langID, this.csID, this.extraRegNames);
        }
    }

    protected static class GdbI386LinuxOffer
    extends DefaultDebuggerMappingOffer {
        public GdbI386LinuxOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Linux i386", LANG_ID_X86, COMP_ID_GCC, Set.of());
        }
    }

    protected static class GdbI386X86_64WindowsOffer
    extends DefaultDebuggerMappingOffer {
        public GdbI386X86_64WindowsOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Cygwin/MSYS2 (Windows) x64", LANG_ID_X86_64, COMP_ID_VS, Set.of());
        }

        @Override
        public DebuggerTargetTraceMapper createMapper() throws LanguageNotFoundException, CompilerSpecNotFoundException {
            return new GdbI386X86_64TraceMapper(this.target, this.langID, this.csID, this.extraRegNames);
        }
    }

    protected static class GdbI386WindowsOffer
    extends DefaultDebuggerMappingOffer {
        public GdbI386WindowsOffer(TargetProcess process) {
            super((TargetObject)process, 100, "GDB on Cygwin/MSYS (Windows) i386", LANG_ID_X86, COMP_ID_VS, Set.of());
        }
    }

    protected static class GdbI386X86_64TraceMapper
    extends DefaultDebuggerTargetTraceMapper {
        public GdbI386X86_64TraceMapper(TargetObject target, LanguageID langID, CompilerSpecID csId, Collection<String> extraRegNames) throws LanguageNotFoundException, CompilerSpecNotFoundException {
            super(target, langID, csId, extraRegNames);
        }

        @Override
        protected DebuggerRegisterMapper createRegisterMapper(TargetRegisterContainer registers) {
            return new GdbI386X86_64RegisterMapper(this.cSpec, registers);
        }
    }

    protected static class GdbI386X86_64RegisterMapper
    extends DefaultDebuggerRegisterMapper {
        public GdbI386X86_64RegisterMapper(CompilerSpec cSpec, TargetRegisterContainer targetRegContainer) {
            super(cSpec, targetRegContainer, false);
        }

        @Override
        protected String normalizeName(String name) {
            if ("rflags".equals(name = super.normalizeName(name))) {
                return "eflags";
            }
            return name;
        }
    }
}

