/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.platform.arm;

import ghidra.app.plugin.core.debug.disassemble.DisassemblyInject;
import ghidra.app.plugin.core.debug.disassemble.DisassemblyInjectInfo;
import ghidra.app.plugin.core.debug.disassemble.TraceDisassembleCommand;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import java.math.BigInteger;

@DisassemblyInjectInfo(compilers={@DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:v8"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:v8T"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LEBE:32:v8LEInstruction"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:v8"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:v8T"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:v7"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LEBE:32:v7LEInstruction"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:v7"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:Cortex"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:Cortex"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:v6"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:v6"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:v5t"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:v5t"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:v5"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:v5"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:v4t"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:v4t"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:LE:32:v4"), @DisassemblyInjectInfo.CompilerInfo(langID="ARM:BE:32:v4")})
public class ArmDisassemblyInject
implements DisassemblyInject {
    protected static final long THUMB_BIT = 32L;

    protected boolean isThumbMode(RegisterValue cpsr) {
        return (cpsr.getUnsignedValue().longValue() & 0x20L) != 0L;
    }

    @Override
    public void pre(PluginTool tool, TraceDisassembleCommand command, Trace trace, Language language, long snap, TraceThread thread, AddressSetView startSet, AddressSetView restricted) {
        Register cpsrReg = language.getRegister("cpsr");
        Register tModeReg = language.getRegister("TMode");
        if (cpsrReg == null || tModeReg == null) {
            Msg.error((Object)this, (Object)("No cpsr or TMode register in ARM language?: " + language.getLanguageID()));
            return;
        }
        TraceMemorySpace regs = trace.getMemoryManager().getMemoryRegisterSpace(thread, false);
        if (regs == null || regs.getState(snap, cpsrReg) != TraceMemoryState.KNOWN) {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ONE));
            return;
        }
        RegisterValue cpsrVal = regs.getValue(snap, cpsrReg);
        if (this.isThumbMode(cpsrVal)) {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ONE));
        } else {
            command.setInitialContext(new RegisterValue(tModeReg, BigInteger.ZERO));
        }
    }
}

