/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.mapping;

import ghidra.app.plugin.core.debug.mapping.DebuggerPlatformOffer;
import ghidra.program.model.lang.CompilerSpec;
import java.util.Objects;

public abstract class AbstractDebuggerPlatformOffer
implements DebuggerPlatformOffer {
    private final String description;
    protected final CompilerSpec cSpec;
    private final int hash;

    public AbstractDebuggerPlatformOffer(String description, CompilerSpec cSpec) {
        this.description = description;
        this.cSpec = cSpec;
        this.hash = Objects.hash(description, cSpec);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public CompilerSpec getCompilerSpec() {
        return this.cSpec;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDebuggerPlatformOffer that = (AbstractDebuggerPlatformOffer)obj;
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        return Objects.equals(this.cSpec, that.cSpec);
    }
}

