/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack.vars;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.hover.DataTypeDecompilerHover;
import ghidra.app.decompiler.component.hover.DecompilerHoverService;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.debug.gui.stack.vars.VariableValueRow;
import ghidra.app.plugin.core.debug.gui.stack.vars.VariableValueTable;
import ghidra.app.plugin.core.debug.gui.stack.vars.VariableValueUtils;
import ghidra.app.plugin.core.debug.stack.ListingUnwoundFrame;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarning;
import ghidra.app.plugin.core.debug.stack.StackUnwindWarningSet;
import ghidra.app.plugin.core.debug.stack.UnwoundFrame;
import ghidra.app.plugin.core.debug.utils.BackgroundUtils;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.AsyncUtils;
import ghidra.async.SwingExecutorService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.pcode.exec.DebuggerPcodeUtils;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.listing.TraceCodeUnitsView;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.listing.TraceInstruction;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.task.TaskMonitor;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;

public class VariableValueHoverService
extends AbstractConfigurableHover
implements ListingHoverService,
DecompilerHoverService {
    private static final String NAME = "Variable Value Display";
    private static final String DESCRIPTION = "Show a variable's value when hovering over it and debugging";
    private static final int PRIORITY = 100;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerStaticMappingService mappingService;
    private final AutoService.Wiring autoServiceWiring;
    private final Map<DebuggerCoordinates, VariableValueUtils.VariableEvaluator> cachedEvaluators = new LRUCache<DebuggerCoordinates, VariableValueUtils.VariableEvaluator>(){

        @Override
        protected void removed(Map.Entry<DebuggerCoordinates, VariableValueUtils.VariableEvaluator> eldest) {
            eldest.getValue().dispose();
        }
    };

    public VariableValueHoverService(PluginTool tool) {
        super(tool, 100);
        this.autoServiceWiring = AutoService.wireServicesConsumed((PluginTool)tool, (Object)((Object)this));
    }

    public void dispose() {
        super.dispose();
        for (VariableValueUtils.VariableEvaluator eval : this.cachedEvaluators.values()) {
            eval.dispose();
        }
    }

    protected String getName() {
        return NAME;
    }

    protected String getDescription() {
        return DESCRIPTION;
    }

    protected String getOptionsCategory() {
        return "Decompiler Popups";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<VariableValueTable> fillVariableValueTable(VariableValueTable table, ProgramLocation programLocation, DebuggerCoordinates current, FieldLocation fieldLocation, Field field, StackUnwindWarningSet warnings) {
        VariableValueUtils.VariableEvaluator eval;
        if (this.traceManager == null || this.mappingService == null || current.getPlatform() == null) {
            return null;
        }
        Map<DebuggerCoordinates, VariableValueUtils.VariableEvaluator> map = this.cachedEvaluators;
        synchronized (map) {
            eval = this.cachedEvaluators.computeIfAbsent(current, c -> new VariableValueUtils.VariableEvaluator(this.tool, (DebuggerCoordinates)c));
        }
        TableFiller filler = new TableFiller(table, this.tool, current, eval, warnings);
        if (field instanceof ClangTextField) {
            ClangTextField clangField = (ClangTextField)field;
            return filler.fillToken(clangField.getToken(fieldLocation));
        }
        if (programLocation == null) {
            return null;
        }
        Address refAddress = programLocation.getRefAddress();
        CodeUnit unit = programLocation.getProgram().getListing().getCodeUnitContaining(programLocation.getAddress());
        if (programLocation instanceof OperandFieldLocation) {
            OperandFieldLocation opLoc = (OperandFieldLocation)programLocation;
            if (unit instanceof Instruction) {
                Instruction ins = (Instruction)unit;
                return filler.fillOperand(opLoc, ins);
            }
        }
        if (programLocation instanceof OperandFieldLocation && refAddress != null && refAddress.isMemoryAddress()) {
            return filler.fillReference(unit, refAddress);
        }
        if (programLocation instanceof VariableLocation) {
            VariableLocation varLoc = (VariableLocation)programLocation;
            return filler.fillVariable(varLoc.getVariable());
        }
        return null;
    }

    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        JComponent component;
        CompletableFuture<VariableValueTable> future;
        if (!this.enabled || this.traceManager == null) {
            return null;
        }
        VariableValueTable table = new VariableValueTable();
        StackUnwindWarningSet warnings = new StackUnwindWarningSet();
        try {
            future = this.fillVariableValueTable(table, programLocation, this.traceManager.getCurrent(), fieldLocation, field, warnings);
        }
        catch (Exception e) {
            table.add(new VariableValueRow.ErrorRow(e));
            JComponent component2 = this.createTooltipComponent("<html>" + table.toHtml());
            this.addErrorDetailsListener(component2, table);
            return component2;
        }
        if (future == null) {
            return null;
        }
        if (!future.isDone()) {
            table.add(new VariableValueRow.StatusRow("In Progress"));
        }
        if (!((component = this.createTooltipComponent("<html>" + table.toHtml())) instanceof JToolTip)) {
            throw new AssertionError((Object)"Expected a JToolTip");
        }
        JToolTip tooltip = (JToolTip)component;
        this.addErrorDetailsListener(component, table);
        future.handleAsync((__, ex) -> {
            table.remove(VariableValueRow.RowKey.STATUS);
            if (ex != null) {
                table.add(new VariableValueRow.ErrorRow(AsyncUtils.unwrapThrowable((Throwable)ex)));
            } else {
                table.add(new VariableValueRow.WarningsRow(warnings));
            }
            tooltip.setTipText("<html>" + table.toHtml());
            Window window = SwingUtilities.getWindowAncestor(tooltip);
            if (window != null) {
                window.pack();
            }
            return null;
        }, (Executor)SwingExecutorService.MAYBE_NOW);
        return tooltip;
    }

    protected void addErrorDetailsListener(JComponent component, final VariableValueTable table) {
        component.addMouseListener(new MouseAdapter(){

            private boolean isShiftDoubleClick(MouseEvent evt) {
                if (evt.getClickCount() != 2) {
                    return false;
                }
                return (evt.getModifiersEx() & 0x40) != 0;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (this.isShiftDoubleClick(evt)) {
                    table.reportDetails();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceClosed(Trace trace) {
        Map<DebuggerCoordinates, VariableValueUtils.VariableEvaluator> map = this.cachedEvaluators;
        synchronized (map) {
            this.cachedEvaluators.keySet().removeIf(coords -> coords.getTrace() == trace);
        }
    }

    public static class TableFiller {
        private final VariableValueTable table;
        private final PluginTool tool;
        private final DebuggerCoordinates current;
        private final StackUnwindWarningSet warnings;
        private final DebuggerStaticMappingService mappingService;
        private final VariableValueUtils.VariableEvaluator eval;

        public TableFiller(VariableValueTable table, PluginTool tool, DebuggerCoordinates current, VariableValueUtils.VariableEvaluator eval, StackUnwindWarningSet warnings) {
            this.table = table;
            this.tool = tool;
            this.current = current;
            this.warnings = warnings;
            this.mappingService = (DebuggerStaticMappingService)tool.getService(DebuggerStaticMappingService.class);
            this.eval = eval;
        }

        protected <T> CompletableFuture<T> executeBackground(java.util.function.Function<TaskMonitor, T> command) {
            BackgroundUtils.PluginToolExecutorService executor = new BackgroundUtils.PluginToolExecutorService(this.tool, "Get Variable Value", (UndoableDomainObject)this.current.getTrace(), 250, BackgroundUtils.PluginToolExecutorService.TaskOpt.IS_BACKGROUND, BackgroundUtils.PluginToolExecutorService.TaskOpt.CAN_CANCEL);
            return CompletableFuture.supplyAsync(() -> command.apply(executor.getLastMonitor()), executor);
        }

        public VariableValueTable fillUndefinedUnit(TraceData dynData, Program stProg, Address stAddr) {
            if (stProg == null) {
                return this.fillDefinedData(dynData);
            }
            CodeUnit stUnit = stProg.getListing().getCodeUnitAt(stAddr);
            if (stUnit == null) {
                return this.fillDefinedData(dynData);
            }
            if (stUnit instanceof Data) {
                Data stData = (Data)stUnit;
                DataType stType = stData.getDataType();
                if (stType == DataType.DEFAULT) {
                    return this.fillDefinedData(dynData);
                }
                this.table.add(VariableValueRow.StorageRow.fromCodeUnit(stUnit));
                this.table.add(new VariableValueRow.TypeRow(stType));
                AddressRangeImpl dynRange = new AddressRangeImpl(dynData.getMinAddress(), dynData.getMinAddress().add((long)(stData.getLength() - 1)));
                this.table.add(VariableValueRow.LocationRow.fromRange((AddressRange)dynRange));
                VariableValueRow.BytesRow bytesRow = VariableValueRow.BytesRow.fromRange(this.current.getPlatform(), (AddressRange)dynRange, this.current.getViewSnap());
                this.table.add(bytesRow);
                this.table.add(new VariableValueRow.IntegerRow(bytesRow));
                String repr = this.eval.getRepresentation(dynData.getAddress(), bytesRow.bytes().bytes(), stType, (Settings)stData);
                if (repr != null) {
                    this.table.add(new VariableValueRow.ValueRow(repr, bytesRow.state()));
                }
                return this.table;
            }
            if (stUnit instanceof Instruction) {
                Instruction stIns = (Instruction)stUnit;
                this.fillDefinedData(dynData);
                this.table.add(new VariableValueRow.InstructionRow(stIns));
                this.table.add(new VariableValueRow.WarningsRow(StackUnwindWarningSet.custom("Instruction taken from static listing")));
                return this.table;
            }
            throw new AssertionError();
        }

        public VariableValueTable fillDefinedData(TraceData data) {
            this.table.add(new VariableValueRow.TypeRow(data.getDataType()));
            this.table.add(VariableValueRow.LocationRow.fromCodeUnit((CodeUnit)data));
            VariableValueRow.BytesRow bytesRow = VariableValueRow.BytesRow.fromCodeUnit((TraceCodeUnit)data, this.current.getViewSnap());
            this.table.add(bytesRow);
            this.table.add(new VariableValueRow.IntegerRow(bytesRow));
            String repr = data.getDefaultValueRepresentation();
            if (repr != null) {
                this.table.add(new VariableValueRow.ValueRow(repr, bytesRow.state()));
            }
            return this.table;
        }

        public VariableValueTable fillInstruction(TraceInstruction ins) {
            this.table.add(VariableValueRow.LocationRow.fromCodeUnit((CodeUnit)ins));
            this.table.add(VariableValueRow.BytesRow.fromCodeUnit((TraceCodeUnit)ins, this.current.getViewSnap()));
            this.table.add(new VariableValueRow.InstructionRow((Instruction)ins));
            return this.table;
        }

        public VariableValueTable fillCodeUnit(TraceCodeUnit unit, Program stProg, Address stAddr) {
            Symbol[] stSymbols;
            Symbol[] dynSymbols = unit.getSymbols();
            if (dynSymbols.length != 0) {
                this.table.add(new VariableValueRow.NameRow(dynSymbols[0].getName(true)));
            } else if (stProg != null && (stSymbols = stProg.getSymbolTable().getSymbols(stAddr)).length != 0) {
                this.table.add(new VariableValueRow.NameRow(stSymbols[0].getName(true)));
            }
            if (unit instanceof TraceData) {
                TraceData data = (TraceData)unit;
                if (data.getDataType() == DataType.DEFAULT) {
                    return this.fillUndefinedUnit(data, stProg, stAddr);
                }
                return this.fillDefinedData(data);
            }
            if (unit instanceof TraceInstruction) {
                TraceInstruction ins = (TraceInstruction)unit;
                return this.fillInstruction(ins);
            }
            throw new AssertionError();
        }

        protected MappedLocation mapLocation(Program programOrView, Address address) {
            if (programOrView instanceof TraceProgramView) {
                TraceProgramView view = (TraceProgramView)programOrView;
                ProgramLocation stLoc = this.mappingService.getStaticLocationFromDynamic(new ProgramLocation((Program)view, address));
                return stLoc == null ? new MappedLocation(null, null, address) : new MappedLocation(stLoc.getProgram(), stLoc.getAddress(), address);
            }
            ProgramLocation dynLoc = this.mappingService.getDynamicLocationFromStatic(this.current.getView(), new ProgramLocation(programOrView, address));
            return new MappedLocation(programOrView, address, dynLoc == null ? null : dynLoc.getAddress());
        }

        public CompletableFuture<VariableValueTable> fillMemory(Program programOrView, Address refAddress) {
            MappedLocation mapped = this.mapLocation(programOrView, refAddress);
            if (mapped.dynAddr == null) {
                return null;
            }
            DebuggerPcodeUtils.WatchValuePcodeExecutorState state = DebuggerPcodeUtils.buildWatchState(this.tool, this.current);
            TraceCodeUnitsView codeUnits = this.current.getTrace().getCodeManager().codeUnits();
            TraceCodeUnit unit = codeUnits.getContaining(this.current.getViewSnap(), mapped.dynAddr);
            if (unit == null) {
                return null;
            }
            return CompletableFuture.supplyAsync(() -> {
                state.getVar(mapped.dynAddr, unit.getLength(), true, PcodeExecutorStatePiece.Reason.INSPECT);
                TraceCodeUnit unitAfterUpdate = codeUnits.getContaining(this.current.getViewSnap(), mapped.dynAddr);
                return this.fillCodeUnit(unitAfterUpdate, mapped.stProg, mapped.stAddr);
            });
        }

        public CompletableFuture<VariableValueTable> fillStack(Instruction ins, Address stackAddress) {
            Function function = ins.getProgram().getFunctionManager().getFunctionContaining(ins.getMinAddress());
            if (function == null) {
                return null;
            }
            Variable variable = VariableValueUtils.findStackVariable(function, stackAddress);
            return this.executeBackground(monitor -> {
                TraceData data;
                UnwoundFrame<DebuggerPcodeUtils.WatchValue> frame = this.eval.getStackFrame(function, this.warnings, (TaskMonitor)monitor, true);
                if (variable != null) {
                    return this.fillFrameStorage(frame, variable.getName(), variable.getDataType(), variable.getProgram(), variable.getVariableStorage());
                }
                Address dynAddr = frame.getBasePointer().add(stackAddress.getOffset());
                TraceCodeUnit unit = this.current.getTrace().getCodeManager().codeUnits().getContaining(this.current.getViewSnap(), dynAddr);
                if (unit instanceof TraceData && ListingUnwoundFrame.isFrame(data = (TraceData)unit)) {
                    int offset = (int)dynAddr.subtract(data.getMinAddress());
                    TraceData comp = data.getComponentContaining(offset);
                    return this.fillCodeUnit((TraceCodeUnit)comp, null, null);
                }
                return this.fillCodeUnit(unit, null, null);
            });
        }

        public CompletableFuture<VariableValueTable> fillReference(CodeUnit unit, Address refAddress) {
            if (refAddress.isMemoryAddress()) {
                return this.fillMemory(unit.getProgram(), refAddress);
            }
            if (refAddress.isStackAddress() && unit instanceof Instruction) {
                Instruction ins = (Instruction)unit;
                return this.fillStack(ins, refAddress);
            }
            return null;
        }

        public VariableValueTable fillRegisterNoFrame(Register register) {
            TraceData data = this.eval.getRegisterUnit(register);
            if (data != null) {
                this.table.add(new VariableValueRow.NameRow(register.getName()));
                this.table.add(new VariableValueRow.TypeRow(data.getDataType()));
                VariableValueRow.IntegerRow intRow = VariableValueRow.IntegerRow.fromCodeUnit((TraceCodeUnit)data, this.current.getSnap());
                this.table.add(intRow);
                this.table.add(new VariableValueRow.ValueRow(data.getDefaultValueRepresentation(), intRow.state()));
                return this.table;
            }
            this.table.add(new VariableValueRow.NameRow(register.getName()));
            DebuggerPcodeUtils.WatchValue raw = this.eval.getRawRegisterValue(register);
            this.table.add(new VariableValueRow.IntegerRow(raw));
            return this.table;
        }

        public CompletableFuture<VariableValueTable> fillRegister(Instruction ins, Register register) {
            Function function = ins.getProgram().getFunctionManager().getFunctionContaining(ins.getMinAddress());
            Variable variable = function == null ? null : VariableValueUtils.findVariable(function, register);
            return this.executeBackground(monitor -> {
                ListingUnwoundFrame frame;
                if (function == null) {
                    this.warnings.add(new StackUnwindWarning.CustomStackUnwindWarning("Instruction is not in a function. Using innermost frame."));
                    frame = VariableValueUtils.locateInnermost(this.tool, this.current);
                } else {
                    frame = this.eval.getStackFrame(function, this.warnings, (TaskMonitor)monitor, false);
                }
                if (frame == null) {
                    return this.fillRegisterNoFrame(register);
                }
                if (variable != null) {
                    return this.fillFrameStorage(frame, variable.getName(), variable.getDataType(), variable.getProgram(), variable.getVariableStorage());
                }
                if (frame.getLevel() == 0) {
                    return this.fillRegisterNoFrame(register);
                }
                this.table.add(new VariableValueRow.NameRow(register.getName()));
                if (!frame.isFake()) {
                    this.table.add(new VariableValueRow.FrameRow(frame));
                }
                DebuggerPcodeUtils.WatchValue value = (DebuggerPcodeUtils.WatchValue)frame.getValue(register);
                this.table.add(VariableValueRow.LocationRow.fromWatchValue(value, this.current.getPlatform().getLanguage()));
                this.table.add(new VariableValueRow.IntegerRow(value));
                return this.table;
            });
        }

        public CompletableFuture<VariableValueTable> fillOperand(OperandFieldLocation opLoc, Instruction ins) {
            RefType refType = ins.getOperandRefType(opLoc.getOperandIndex());
            if (refType.isFlow()) {
                return null;
            }
            Object operand = ins.getDefaultOperandRepresentationList(opLoc.getOperandIndex()).get(opLoc.getSubOperandIndex());
            if (operand instanceof Register) {
                Register register = (Register)operand;
                return this.fillRegister(ins, register);
            }
            Address refAddress = opLoc.getRefAddress();
            if (operand instanceof Scalar) {
                Scalar scalar = (Scalar)operand;
                if (refAddress != null) {
                    return this.fillReference((CodeUnit)ins, refAddress);
                }
            }
            if (operand instanceof Address) {
                Address address = (Address)operand;
                return this.fillReference((CodeUnit)ins, address);
            }
            return null;
        }

        public CompletableFuture<VariableValueTable> fillStorage(Function function, String name, DataType type, Program program, VariableStorage storage, AddressSetView symbolStorage) {
            return this.executeBackground(monitor -> {
                UnwoundFrame<DebuggerPcodeUtils.WatchValue> frame = VariableValueUtils.requiresFrame(program, storage, symbolStorage) ? this.eval.getStackFrame(function, this.warnings, (TaskMonitor)monitor, true) : this.eval.getGlobalsFakeFrame();
                return this.fillFrameStorage(frame, name, type, program, storage);
            });
        }

        public CompletableFuture<VariableValueTable> fillPcodeOp(Function function, String name, DataType type, PcodeOp op, AddressSetView symbolStorage) {
            return this.executeBackground(monitor -> {
                UnwoundFrame<DebuggerPcodeUtils.WatchValue> frame = VariableValueUtils.requiresFrame(op, symbolStorage) ? this.eval.getStackFrame(function, this.warnings, (TaskMonitor)monitor, true) : this.eval.getGlobalsFakeFrame();
                return this.fillFrameOp(frame, function.getProgram(), name, type, op, symbolStorage);
            });
        }

        public VariableValueTable fillWatchValue(UnwoundFrame<DebuggerPcodeUtils.WatchValue> frame, Address address, DataType type, DebuggerPcodeUtils.WatchValue value) {
            this.table.add(VariableValueRow.LocationRow.fromWatchValue(value, this.current.getPlatform().getLanguage()));
            if (value.address() != null && !value.address().isRegisterAddress()) {
                this.table.add(new VariableValueRow.BytesRow(value));
            }
            this.table.add(new VariableValueRow.IntegerRow(value));
            if (type != DataType.DEFAULT) {
                String repr = this.eval.getRepresentation(frame, address, value, type);
                this.table.add(new VariableValueRow.ValueRow(repr, value.state()));
            }
            return this.table;
        }

        public VariableValueTable fillFrameStorage(UnwoundFrame<DebuggerPcodeUtils.WatchValue> frame, String name, DataType type, Program program, VariableStorage storage) {
            this.table.add(new VariableValueRow.NameRow(name));
            if (!frame.isFake()) {
                this.table.add(new VariableValueRow.FrameRow(frame));
            }
            this.table.add(new VariableValueRow.StorageRow(storage));
            this.table.add(new VariableValueRow.TypeRow(type));
            DebuggerPcodeUtils.WatchValue value = frame.getValue(program, storage);
            return this.fillWatchValue(frame, storage.getMinAddress(), type, value);
        }

        public VariableValueTable fillFrameOp(UnwoundFrame<DebuggerPcodeUtils.WatchValue> frame, Program program, String name, DataType type, PcodeOp op, AddressSetView symbolStorage) {
            this.table.add(new VariableValueRow.NameRow(name));
            if (!frame.isFake()) {
                this.table.add(new VariableValueRow.FrameRow(frame));
            }
            this.table.add(new VariableValueRow.TypeRow(type));
            DebuggerPcodeUtils.WatchValue value = frame.evaluate(program, op, symbolStorage);
            if (type.getLength() != value.length()) {
                value = frame.zext(value, type.getLength());
            }
            return this.fillWatchValue(frame, op.getOutput().getAddress(), type, value);
        }

        public CompletableFuture<VariableValueTable> fillHighVariable(HighVariable hVar, String name, AddressSetView symbolStorage) {
            Function function = hVar.getHighFunction().getFunction();
            VariableStorage storage = VariableValueUtils.fabricateStorage(hVar);
            if (storage.isUniqueStorage()) {
                this.table.add(new VariableValueRow.NameRow(name));
                this.table.add(new VariableValueRow.StorageRow(storage));
                this.table.add(new VariableValueRow.ValueRow("(Unique)", TraceMemoryState.KNOWN));
                return CompletableFuture.completedFuture(this.table);
            }
            return this.fillStorage(function, name, hVar.getDataType(), function.getProgram(), storage, symbolStorage);
        }

        public CompletableFuture<VariableValueTable> fillHighVariable(HighVariable hVar, AddressSetView symbolStorage) {
            return this.fillHighVariable(hVar, hVar.getName(), symbolStorage);
        }

        public CompletableFuture<VariableValueTable> fillComponent(ClangFieldToken token, AddressSetView symbolStorage) {
            Function function = token.getClangFunction().getHighFunction().getFunction();
            Program program = function.getProgram();
            PcodeOp op = token.getPcodeOp();
            Varnode vn = op.getOutput();
            HighVariable hVar = vn.getHigh();
            DataType type = DataTypeDecompilerHover.getFieldDataType((ClangFieldToken)token);
            if (hVar.getDataType().isEquivalent((DataType)new PointerDataType(type))) {
                op = VariableValueUtils.findDeref(program.getAddressFactory(), vn);
            }
            return this.fillPcodeOp(function, token.getText(), type, op, symbolStorage);
        }

        public CompletableFuture<VariableValueTable> fillComposite(HighSymbol hSym, HighVariable hVar, AddressSetView symbolStorage) {
            return this.fillStorage(hVar.getHighFunction().getFunction(), hSym.getName(), hSym.getDataType(), hSym.getProgram(), hSym.getStorage(), symbolStorage);
        }

        public CompletableFuture<VariableValueTable> fillToken(ClangToken token) {
            Varnode representative;
            if (token == null) {
                return null;
            }
            AddressSet symbolStorage = VariableValueUtils.collectSymbolStorage(token.getLineParent());
            if (token instanceof ClangFieldToken) {
                ClangFieldToken fieldToken = (ClangFieldToken)token;
                return this.fillComponent(fieldToken, (AddressSetView)symbolStorage);
            }
            HighVariable hVar = token.getHighVariable();
            if (hVar == null) {
                return null;
            }
            HighSymbol hSym = hVar.getSymbol();
            if (hSym == null) {
                return null;
            }
            VariableStorage storage = hSym.getStorage();
            String name = hVar.getName();
            if (name == null) {
                name = hSym.getName();
            }
            if (!storage.contains((representative = hVar.getRepresentative()).getAddress())) {
                return this.fillHighVariable(hVar, (AddressSetView)symbolStorage);
            }
            if (Arrays.asList(storage.getVarnodes()).equals(List.of(representative))) {
                return this.fillHighVariable(hVar, (AddressSetView)symbolStorage);
            }
            return this.fillComposite(hSym, hVar, (AddressSetView)symbolStorage);
        }

        public CompletableFuture<VariableValueTable> fillVariable(Variable variable) {
            Function function = variable.getFunction();
            return this.executeBackground(monitor -> {
                UnwoundFrame<DebuggerPcodeUtils.WatchValue> frame = this.eval.getStackFrame(function, this.warnings, (TaskMonitor)monitor, true);
                return this.fillFrameStorage(frame, variable.getName(), variable.getDataType(), variable.getProgram(), variable.getVariableStorage());
            });
        }

        record MappedLocation(Program stProg, Address stAddr, Address dynAddr) {
        }
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int DEFAULT_MAX_SIZE = 5;
        private int maxSize;

        public LRUCache() {
            this(5);
        }

        public LRUCache(int maxSize) {
            super(maxSize, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() > this.maxSize) {
                this.removed(eldest);
                return true;
            }
            return false;
        }

        protected void removed(Map.Entry<K, V> eldest) {
        }
    }
}

