/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.stack;

import docking.ActionContext;
import docking.DefaultActionContext;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerLegacyStackPanel;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackPanel;
import ghidra.app.plugin.core.debug.gui.stack.DebuggerStackPlugin;
import ghidra.app.plugin.core.debug.stack.UnwindStackCommand;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.ArrayUtils;

public class DebuggerStackProvider
extends ComponentProviderAdapter {
    final DebuggerStackPlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    @AutoServiceConsumed
    DebuggerStaticMappingService mappingService;
    private final AutoService.Wiring autoServiceWiring;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    DebuggerStackPanel panel;
    DebuggerLegacyStackPanel legacyPanel;
    DockingAction actionUnwindStack;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getThread(), b.getThread())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        return Objects.equals(a.getFrame(), b.getFrame());
    }

    public DebuggerStackProvider(DebuggerStackPlugin plugin) {
        super(plugin.getTool(), "Stack", plugin.getName());
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.setTitle("Stack");
        this.setIcon(DebuggerResources.ICON_PROVIDER_STACK);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_STACK);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        this.createActions();
        this.setVisible(true);
    }

    protected void buildMainPanel() {
        this.panel = new DebuggerStackPanel(this);
        this.mainPanel.add(this.panel);
        this.legacyPanel = new DebuggerLegacyStackPanel(this.plugin, this);
    }

    protected void createActions() {
        this.actionUnwindStack = (DockingAction)((ActionBuilder)((ActionBuilder)UnwindStackAction.builder(this.plugin).enabledWhen(ctx -> this.current.getTrace() != null)).onAction(this::activatedUnwindStack)).buildAndInstall((Tool)this.tool);
    }

    private void activatedUnwindStack(ActionContext ignored) {
        new UnwindStackCommand(this.tool, this.current).run(this.tool, (UndoableDomainObject)this.current.getTrace());
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        DefaultActionContext context = Trace.isLegacy((Trace)this.current.getTrace()) ? this.legacyPanel.getActionContext() : this.panel.getActionContext();
        if (context != null) {
            return context;
        }
        return super.getActionContext(event);
    }

    protected String computeSubTitle() {
        TraceThread curThread = this.current.getThread();
        return curThread == null ? "" : curThread.getName();
    }

    protected void updateSubTitle() {
        this.setSubTitle(this.computeSubTitle());
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerStackProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        if (Trace.isLegacy((Trace)coordinates.getTrace())) {
            this.panel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.legacyPanel.coordinatesActivated(coordinates);
            if (ArrayUtils.indexOf((Object[])this.mainPanel.getComponents(), (Object)this.legacyPanel) == -1) {
                this.mainPanel.remove(this.panel);
                this.mainPanel.add(this.legacyPanel);
                this.mainPanel.validate();
            }
        } else {
            this.legacyPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.panel.coordinatesActivated(coordinates);
            if (ArrayUtils.indexOf((Object[])this.mainPanel.getComponents(), (Object)this.panel) == -1) {
                this.mainPanel.remove(this.legacyPanel);
                this.mainPanel.add(this.panel);
                this.mainPanel.validate();
            }
        }
        this.updateSubTitle();
    }

    public void traceClosed(Trace trace) {
        if (trace == this.current.getTrace()) {
            this.panel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
            this.legacyPanel.coordinatesActivated(DebuggerCoordinates.NOWHERE);
        }
    }

    public Function getFunction(Address pc) {
        if (pc == null) {
            return null;
        }
        if (this.mappingService == null) {
            return null;
        }
        TraceThread curThread = this.current.getThread();
        if (curThread == null) {
            return null;
        }
        DefaultTraceLocation dloc = new DefaultTraceLocation(curThread.getTrace(), curThread, Lifespan.at((long)this.current.getSnap()), pc);
        ProgramLocation sloc = this.mappingService.getOpenMappedLocation((TraceLocation)dloc);
        if (sloc == null) {
            return null;
        }
        return sloc.getProgram().getFunctionManager().getFunctionContaining(sloc.getAddress());
    }

    public static interface UnwindStackAction {
        public static final String NAME = "Unwind from frame 0";
        public static final String DESCRIPTION = "Unwind the stack, placing frames in the dynamic listing";
        public static final String HELP_ANCHOR = "unwind_stack";
        public static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(85, 0);

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", "Analysis", NAME})).keyBinding(KEY_STROKE)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }
}

