/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.objects.components;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeSlowLoadingNode;
import docking.widgets.tree.TreeTaskMonitor;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.objects.DebuggerObjectsProvider;
import ghidra.app.plugin.core.debug.gui.objects.ObjectContainer;
import ghidra.app.plugin.core.debug.gui.objects.components.DummyTargetObject;
import ghidra.app.plugin.core.debug.gui.objects.components.ObjectTree;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetObject;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;

public class ObjectNode
extends GTreeSlowLoadingNode {
    static final Icon ICON_POPULATED = new GIcon("icon.debugger.node.object.populated");
    static final Icon ICON_EMPTY = new GIcon("icon.debugger.node.object.empty");
    static final Icon ICON_RUNNING = new GIcon("icon.debugger.node.object.running");
    static final Icon ICON_TERMINATED = new GIcon("icon.debugger.node.object.terminated");
    static final Icon ICON_EVENT = new GIcon("icon.debugger.node.object.event");
    private ObjectContainer container;
    private String name;
    private ObjectTree tree;
    private Set<GTreeNode> oldChildren;
    private boolean restructured = false;

    public ObjectNode(ObjectTree tree, ObjectContainer parent, ObjectContainer container) {
        this.tree = tree;
        this.setContainer(tree, parent, container);
    }

    public ObjectContainer getContainer() {
        return this.container;
    }

    public void setContainer(ObjectTree tree, ObjectContainer parent, ObjectContainer container) {
        this.container = container;
        this.name = container.getName();
        if (parent != null) {
            tree.addToMap(parent, container, this);
        }
    }

    public TargetObject getTargetObject() {
        return this.container.getTargetObject();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.container.getDecoratedName();
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        if (!this.container.isImmutable() || this.isInProgress()) {
            try {
                CompletableFuture<ObjectContainer> cf = this.container.getOffspring(DebuggerObjectModel.RefreshBehavior.REFRESH_WHEN_ABSENT);
                if (cf != null) {
                    ObjectContainer oc = cf.get(this.tree.getProvider().getNodeTimeout(), TimeUnit.SECONDS);
                    return this.tree.update(oc);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Msg.warn((Object)((Object)this), (Object)e);
            }
            catch (TimeoutException e) {
                Msg.showWarn((Object)((Object)this), (Component)this.container.getProvider().getComponent(), (String)"Timeout Exception", (Object)"Request for children timed - out - try refreshing the node");
            }
        }
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        if (this.oldChildren != null) {
            list.addAll(this.oldChildren);
        }
        return list;
    }

    public DebuggerObjectsProvider getProvider() {
        return this.container.getProvider();
    }

    public String getDisplayText() {
        return this.getContainer().getDecoratedName();
    }

    public int loadAll(TaskMonitor monitor) throws CancelledException {
        int count = 1;
        if (!this.isLoaded()) {
            return count;
        }
        List children = this.children();
        monitor = new TreeTaskMonitor(monitor, (long)children.size());
        for (GTreeNode child : children) {
            monitor.checkCancelled();
            count += child.loadAll(monitor);
            monitor.incrementProgress(1L);
        }
        return count;
    }

    public Icon getIcon(boolean expanded) {
        ObjectContainer rootContainer;
        Map<String, Object> rootMap;
        DebuggerObjectsProvider provider;
        TargetObject targetObject = this.container.getTargetObject();
        if (targetObject instanceof TargetExecutionStateful) {
            TargetExecutionStateful stateful = (TargetExecutionStateful)targetObject;
            if (stateful.getExecutionState().equals((Object)TargetExecutionStateful.TargetExecutionState.RUNNING)) {
                return ICON_RUNNING;
            }
            if (stateful.getExecutionState().equals((Object)TargetExecutionStateful.TargetExecutionState.TERMINATED)) {
                return ICON_TERMINATED;
            }
        }
        if ((provider = this.getProvider()) != null && (rootMap = (rootContainer = provider.getRoot()).getAttributeMap()).containsKey("_event_thread")) {
            TargetObject targetProcess = (TargetObject)rootMap.get("_event_thread");
            if (this.container.getTargetObject().equals((Object)targetProcess)) {
                return ICON_EVENT;
            }
        }
        return this.container.hasElements() ? ICON_POPULATED : ICON_EMPTY;
    }

    public String getToolTip() {
        return this.container.getDecoratedName();
    }

    public boolean isLeaf() {
        TargetObject to = this.container.getTargetObject();
        return to != null && to instanceof DummyTargetObject;
    }

    public boolean isVisible() {
        return this.container.isVisible();
    }

    public void markExpanded() {
    }

    public void markCollapsed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpOldChildren(List<GTreeNode> newChildren) {
        if (this.oldChildren != null) {
            Set<GTreeNode> set = this.oldChildren;
            synchronized (set) {
                this.oldChildren.removeAll(newChildren);
                for (GTreeNode node : this.oldChildren) {
                    this.setRestructured(true);
                    this.tree.cleanupOldNode((ObjectNode)node);
                }
            }
        }
        this.oldChildren = new HashSet<GTreeNode>(newChildren);
    }

    public void callUpdate() {
        CompletableFuture.runAsync(() -> {
            List<GTreeNode> updateNodes = this.tree.update(this.container);
            if (this.isRestructured()) {
                this.setChildren(updateNodes);
            }
        });
    }

    public void callModified() {
        CompletableFuture.runAsync(() -> {
            List<GTreeNode> updateNodes = this.tree.update(this.container);
            for (GTreeNode n : updateNodes) {
                n.fireNodeChanged();
            }
        });
    }

    public boolean isRestructured() {
        return this.restructured;
    }

    public void setRestructured(boolean restructured) {
        this.restructured = restructured;
    }
}

