/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ComponentProvider;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(shortDescription="Debugger module and section manager", description="GUI to manage modules and sections", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramClosedPluginEvent.class, TraceActivatedPluginEvent.class}, servicesRequired={DebuggerStaticMappingService.class, DebuggerTraceManagerService.class, ProgramManager.class})
public class DebuggerModulesPlugin
extends AbstractDebuggerPlugin {
    protected DebuggerModulesProvider provider;

    public DebuggerModulesPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.provider = new DebuggerModulesProvider(this);
        super.init();
    }

    protected void dispose() {
        this.provider.dispose();
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            this.provider.setProgram(ev.getActiveProgram());
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
            this.provider.setLocation(ev.getLocation());
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent ev = (ProgramClosedPluginEvent)event;
            this.provider.programClosed(ev.getProgram());
        } else if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.provider.coordinatesActivated(ev.getActiveCoordinates());
        }
    }

    public void readConfigState(SaveState saveState) {
        this.provider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.provider.writeConfigState(saveState);
    }
}

