/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.copying;

import db.Transaction;
import docking.ReusableDialogComponentProvider;
import docking.widgets.table.CellEditorUtils;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.copying.DebuggerCopyPlan;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.MathUtilities;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerCopyIntoProgramDialog
extends ReusableDialogComponentProvider {
    static final int GAP = 5;
    static final int BUTTON_SIZE = 32;
    protected static final CopyDestination TEMP_PROGRAM = new CopyDestination(){

        public String toString() {
            return "<Temporary Program>";
        }

        @Override
        public Program getOrCreateProgram(TraceProgramView source, Object consumer) throws IOException {
            return new ProgramDB(source.getName(), source.getLanguage(), source.getCompilerSpec(), consumer);
        }
    };
    protected final CopyDestination NEW_PROGRAM = new CopyDestination(){

        public String toString() {
            return "<New Program>";
        }

        @Override
        public Program getOrCreateProgram(TraceProgramView source, Object consumer) throws IOException {
            return new ProgramDB(source.getName(), source.getLanguage(), source.getCompilerSpec(), consumer);
        }

        @Override
        public void saveIfApplicable(Program program) {
            DebuggerCopyIntoProgramDialog.this.programManager.saveProgramAs(program);
        }
    };
    protected DebuggerTargetService targetService;
    protected ProgramManager programManager;
    protected DebuggerStaticMappingService staticMappingService;
    protected TraceProgramView source;
    protected AddressSetView set;
    protected CompletableFuture<Void> lastTask;
    protected final DefaultComboBoxModel<CopyDestination> comboDestinationModel = new DefaultComboBoxModel();
    protected JComboBox<CopyDestination> comboDestination;
    protected final Map<Program, CopyDestination> programDestinations = new HashMap<Program, CopyDestination>();
    protected JCheckBox cbCapture;
    protected JCheckBox cbRelocate;
    protected JCheckBox cbUseOverlays;
    protected DebuggerCopyPlan plan = new DebuggerCopyPlan();
    protected final RangeTableModel tableModel;
    protected GTable table;
    protected GhidraTableFilterPanel<RangeEntry> filterPanel;
    protected JButton resetButton;

    public DebuggerCopyIntoProgramDialog(PluginTool tool) {
        super("Copy Into Program", true, true, true, true);
        this.tableModel = new RangeTableModel(tool);
        this.populateComponents();
    }

    protected void populateComponents() {
        this.plan.selectAll();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel opts = new JPanel();
        opts.setLayout(new BoxLayout(opts, 1));
        Box progBox = Box.createHorizontalBox();
        progBox.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        progBox.add(new JLabel("Destination:"));
        this.comboDestination = new JComboBox<CopyDestination>(this.comboDestinationModel);
        this.comboDestination.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.comboDestination.addActionListener(e -> {
            if (!this.isVisible()) {
                return;
            }
            this.syncCbRelocateEnabled(this.getDestination());
            this.reset();
        });
        progBox.add(this.comboDestination);
        opts.add(progBox);
        JPanel inner = new JPanel(new BorderLayout());
        inner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.cbCapture = new JCheckBox("<html>Read live target's memory");
        this.cbCapture.addActionListener(e -> {
            if (!this.isVisible()) {
                return;
            }
            this.reset();
        });
        inner.add(this.cbCapture);
        opts.add(inner);
        inner = new JPanel(new BorderLayout());
        inner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.cbRelocate = new JCheckBox("<html>Relocate via Mappings. <b>WARNING:</b> No fixups");
        this.cbRelocate.addActionListener(e -> {
            if (!this.isVisible()) {
                return;
            }
            this.reset();
        });
        inner.add(this.cbRelocate);
        opts.add(inner);
        inner = new JPanel(new BorderLayout());
        inner.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.cbUseOverlays = new JCheckBox("<html>Use overlays where blocks already exist");
        this.cbUseOverlays.addActionListener(e -> {
            if (!this.isVisible()) {
                return;
            }
            this.reset();
        });
        inner.add(this.cbUseOverlays);
        opts.add(inner);
        JPanel panelInclude = new JPanel(new GridLayout(0, 2, 5, 5));
        panelInclude.setBorder(BorderFactory.createTitledBorder("Include:"));
        JButton buttonSelectNone = new JButton("Select None");
        buttonSelectNone.addActionListener(e -> this.plan.selectNone());
        panelInclude.add(buttonSelectNone);
        JButton buttonSelectAll = new JButton("Select All");
        buttonSelectAll.addActionListener(e -> this.plan.selectAll());
        panelInclude.add(buttonSelectAll);
        for (DebuggerCopyPlan.Copier copier : this.plan.getAllCopiers()) {
            panelInclude.add(this.plan.getCheckBox(copier));
        }
        opts.add(panelInclude);
        panel.add((Component)opts, "North");
        JPanel tablePanel = new JPanel(new BorderLayout());
        this.table = new GTable((TableModel)((Object)this.tableModel));
        this.table.setSelectionMode(2);
        tablePanel.add(new JScrollPane((Component)this.table));
        this.filterPanel = new GhidraTableFilterPanel((JTable)this.table, (RowObjectTableModel)this.tableModel);
        tablePanel.add((Component)this.filterPanel, "South");
        panel.add((Component)tablePanel, "Center");
        panel.setMinimumSize(new Dimension(600, 600));
        this.addWorkPanel(panel);
        this.addOKButton();
        this.okButton.setText("Copy");
        this.addCancelButton();
        this.addResetButton();
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn removeCol = columnModel.getColumn(RangeTableColumns.REMOVE.ordinal());
        CellEditorUtils.installButton((JTable)this.table, this.filterPanel, (TableColumn)removeCol, (Icon)DebuggerResources.ICON_DELETE, (int)32, this::removeEntry);
    }

    protected void addResetButton() {
        this.resetButton = new JButton("Reset");
        this.resetButton.setMnemonic('R');
        this.resetButton.setName("Reset");
        this.resetButton.addActionListener(e -> this.resetCallback());
        this.addButton(this.resetButton);
    }

    protected void okCallback() {
        super.okCallback();
        this.lastTask = new CompletableFuture();
        Task task = new Task("Copy Into Program", true, true, false){

            public void run(TaskMonitor monitor) throws CancelledException {
                try {
                    DebuggerCopyIntoProgramDialog.this.executePlan(monitor);
                    Swing.runLater(() -> {
                        DebuggerCopyIntoProgramDialog.this.setStatusText("");
                        DebuggerCopyIntoProgramDialog.this.close();
                    });
                }
                catch (Exception e) {
                    Msg.error((Object)((Object)this), (Object)"Error copying into program", (Throwable)e);
                    DebuggerCopyIntoProgramDialog.this.setStatusText("Error: " + e.getMessage());
                }
            }
        };
        task.addTaskListener(new TaskListener(){

            public void taskCancelled(Task task) {
                DebuggerCopyIntoProgramDialog.this.lastTask.cancel(false);
            }

            public void taskCompleted(Task task) {
                DebuggerCopyIntoProgramDialog.this.lastTask.complete(null);
            }
        });
        this.executeProgressTask(task, 500);
    }

    protected void resetCallback() {
        this.reset();
    }

    protected void removeEntry(RangeEntry entry) {
        this.tableModel.delete(entry);
    }

    protected Target getTargetIfReadsPresent() {
        if (this.targetService == null) {
            return null;
        }
        Target target = this.targetService.getTarget(this.source.getTrace());
        if (target == null) {
            return null;
        }
        if (!DebuggerCoordinates.NOWHERE.view(this.source).target(target).isAliveAndReadsPresent()) {
            return null;
        }
        return target;
    }

    protected void checkCbCaptureEnabled() {
        boolean en = this.getTargetIfReadsPresent() != null;
        this.cbCapture.setEnabled(en);
        this.cbCapture.setSelected(en);
    }

    public void setTargetService(DebuggerTargetService targetService) {
        this.targetService = targetService;
        this.checkCbCaptureEnabled();
    }

    public void setSource(TraceProgramView source, AddressSetView set) {
        this.source = source;
        this.set = set;
        this.checkCbCaptureEnabled();
    }

    public void setProgramManager(ProgramManager programManager) {
        this.programManager = programManager;
        this.setSelectablePrograms(programManager.getAllOpenPrograms());
    }

    protected void setSelectablePrograms(Program[] programs) {
        this.setSelectablePrograms(Arrays.asList(programs));
    }

    protected void setSelectablePrograms(Collection<Program> programs) {
        this.programDestinations.clear();
        this.comboDestinationModel.removeAllElements();
        this.comboDestinationModel.addElement(this.NEW_PROGRAM);
        this.comboDestinationModel.addElement(TEMP_PROGRAM);
        for (Program program : new LinkedHashSet<Program>(programs)) {
            OpenProgramDestination destination = new OpenProgramDestination(program);
            this.programDestinations.put(program, destination);
            this.comboDestinationModel.addElement(destination);
        }
    }

    public void setDestination(Program program) {
        this.setDestination(this.programDestinations.get(program));
    }

    protected void syncCbRelocateEnabled(CopyDestination dest) {
        this.cbRelocate.setEnabled(dest.getExistingProgram() != null);
    }

    public void setDestination(CopyDestination dest) {
        Objects.requireNonNull(dest);
        this.syncCbRelocateEnabled(dest);
        this.comboDestinationModel.setSelectedItem(dest);
    }

    public CopyDestination getDestination() {
        return (CopyDestination)this.comboDestinationModel.getSelectedItem();
    }

    public void setCapture(boolean capture) {
        if (capture && this.getTargetIfReadsPresent() == null) {
            throw new IllegalStateException("Cannot enable capture unless live and reading the present");
        }
        this.cbCapture.setSelected(capture);
    }

    public boolean isCapture() {
        return this.cbCapture.isSelected() && this.getTargetIfReadsPresent() != null;
    }

    public void setRelocate(boolean relocate) {
        if (relocate && !this.getDestination().isExisting()) {
            throw new IllegalStateException("Cannot relocate when creating a new program");
        }
        this.cbRelocate.setSelected(relocate);
    }

    public boolean isRelocate() {
        return this.cbRelocate.isSelected() && this.staticMappingService != null && this.getDestination().isExisting();
    }

    public void setUseOverlays(boolean useOverlays) {
        if (useOverlays && !this.getDestination().isExisting()) {
            throw new IllegalStateException("Cannot use overlays when creating a new program");
        }
        this.cbUseOverlays.setSelected(useOverlays);
    }

    public boolean isUseOverlays() {
        return this.cbUseOverlays.isSelected() && this.getDestination().isExisting();
    }

    public void setStaticMappingService(DebuggerStaticMappingService staticMappingService) {
        this.staticMappingService = staticMappingService;
        this.cbRelocate.setEnabled(staticMappingService != null);
    }

    public void reset() {
        Program dest = this.getDestination().getExistingProgram();
        this.plan.syncCopiersEnabled(this.source, dest);
        if (this.isRelocate()) {
            this.resetWithRelocation(this.isUseOverlays(), dest);
        } else {
            this.resetWithoutRelocation(this.isUseOverlays(), dest);
        }
    }

    protected String createName(String desired, Set<String> taken) {
        if (taken.add(desired)) {
            return desired;
        }
        Object candidate = desired;
        int i = 2;
        while (!taken.add((String)(candidate = desired + "_" + i))) {
            ++i;
        }
        return candidate;
    }

    protected String computeRegionString(AddressRange rng) {
        TraceMemoryManager mm = this.source.getTrace().getMemoryManager();
        Collection regions = mm.getRegionsIntersecting(Lifespan.at((long)this.source.getSnap()), rng);
        return regions.isEmpty() ? "UNKNOWN" : ((TraceMemoryRegion)regions.iterator().next()).getName();
    }

    protected String computeModulesString(AddressRange rng) {
        TraceModuleManager mm = this.source.getTrace().getModuleManager();
        Collection modules = mm.getModulesIntersecting(Lifespan.at((long)this.source.getSnap()), rng);
        return modules.stream().map(m -> m.getName()).collect(Collectors.joining(","));
    }

    protected String computeSectionsString(AddressRange rng) {
        TraceModuleManager mm = this.source.getTrace().getModuleManager();
        Collection sections = mm.getSectionsIntersecting(Lifespan.at((long)this.source.getSnap()), rng);
        return sections.stream().map(s -> s.getName()).collect(Collectors.joining(","));
    }

    protected void createEntry(Collection<RangeEntry> result, AddressRange srcRange, AddressRange dstRange, boolean overlay, Set<String> taken, MemoryBlock dstBlock) {
        String srcName = this.computeRegionString(srcRange);
        String dstName = dstBlock != null ? dstBlock.getName() : this.createName(srcName, taken);
        String srcModules = this.computeModulesString(srcRange);
        String srcSections = this.computeSectionsString(srcRange);
        result.add(new RangeEntry(srcName, srcModules, srcSections, srcRange, dstName, dstBlock == null, overlay, dstRange));
    }

    protected void createEntries(Collection<RangeEntry> result, boolean useOverlays, DebuggerStaticMappingService.MappedAddressRange mappedRng, AddressRange srcRange, AddressRange dstRange, Set<String> taken, Program dest) {
        if (dest == null) {
            this.createEntry(result, srcRange, dstRange, false, taken, null);
            return;
        }
        Memory memory = dest.getMemory();
        AddressSet hits = memory.intersectRange(dstRange.getMinAddress(), dstRange.getMaxAddress());
        if (!hits.isEmpty() && useOverlays) {
            this.createEntry(result, srcRange, dstRange, true, taken, null);
            return;
        }
        AddressSet misses = new AddressSet(dstRange).subtract((AddressSetView)hits);
        for (AddressRange miss : misses) {
            this.createEntry(result, mappedRng.mapDestinationToSource(miss), miss, false, taken, null);
        }
        for (AddressRange hit : hits) {
            Address next = hit.getMinAddress();
            while (next != null && hit.contains(next)) {
                MemoryBlock block = memory.getBlock(next);
                AddressRange dr = hit.intersectRange(block.getStart(), block.getEnd());
                this.createEntry(result, mappedRng.mapDestinationToSource(dr), dr, false, taken, block);
                next = block.getEnd().next();
            }
        }
    }

    protected void collectBlockNames(Collection<String> result, Program program) {
        if (program == null) {
            return;
        }
        for (MemoryBlock b : program.getMemory().getBlocks()) {
            result.add(b.getName());
        }
    }

    protected List<AddressRange> breakRangeByRegions(AddressRange srcRange) {
        AddressSet remains = new AddressSet(srcRange);
        ArrayList<AddressRange> result = new ArrayList<AddressRange>();
        for (TraceMemoryRegion region : this.source.getTrace().getMemoryManager().getRegionsIntersecting(Lifespan.at((long)this.source.getSnap()), srcRange)) {
            AddressRange range = region.getRange().intersect(srcRange);
            result.add(range);
            remains.delete(range);
        }
        remains.iterator().forEachRemaining(result::add);
        return result;
    }

    protected void resetWithRelocation(boolean useOverlays, Program dest) {
        Objects.requireNonNull(dest);
        this.tableModel.clear();
        ArrayList<RangeEntry> result = new ArrayList<RangeEntry>();
        HashSet<String> taken = new HashSet<String>();
        this.collectBlockNames(taken, dest);
        Collection mappedSet = (Collection)this.staticMappingService.getOpenMappedViews(this.source.getTrace(), this.set, this.source.getSnap()).get(dest);
        if (mappedSet == null) {
            return;
        }
        for (DebuggerStaticMappingService.MappedAddressRange mappedRng : mappedSet) {
            for (AddressRange src : this.breakRangeByRegions(mappedRng.getSourceAddressRange())) {
                AddressRange dst = mappedRng.mapSourceToDestination(src);
                this.createEntries(result, useOverlays, mappedRng, src, dst, taken, dest);
            }
        }
        this.tableModel.addAll(result);
    }

    protected DebuggerStaticMappingService.MappedAddressRange identityMapped(AddressRange srng, Program dest) {
        long maxOff;
        if (dest == null) {
            return new DebuggerStaticMappingService.MappedAddressRange(srng, srng);
        }
        AddressSpace srcSpace = srng.getAddressSpace();
        AddressSpace dstSpace = dest.getAddressFactory().getAddressSpace(srcSpace.getName());
        if (dstSpace == null) {
            return null;
        }
        long minOff = MathUtilities.unsignedMax((long)srng.getMinAddress().getOffset(), (long)dstSpace.getMinAddress().getOffset());
        if (Long.compareUnsigned(minOff, maxOff = MathUtilities.unsignedMin((long)srng.getMaxAddress().getOffset(), (long)dstSpace.getMaxAddress().getOffset())) > 0) {
            return null;
        }
        return new DebuggerStaticMappingService.MappedAddressRange((AddressRange)new AddressRangeImpl(srcSpace.getAddress(minOff), srcSpace.getAddress(maxOff)), (AddressRange)new AddressRangeImpl(dstSpace.getAddress(minOff), dstSpace.getAddress(maxOff)));
    }

    protected void resetWithoutRelocation(boolean useOverlays, Program dest) {
        this.tableModel.clear();
        ArrayList<RangeEntry> result = new ArrayList<RangeEntry>();
        HashSet<String> taken = new HashSet<String>();
        this.collectBlockNames(taken, dest);
        for (AddressRange rng : this.set) {
            for (AddressRange src : this.breakRangeByRegions(rng)) {
                DebuggerStaticMappingService.MappedAddressRange id = this.identityMapped(src, dest);
                if (id == null) continue;
                this.createEntries(result, useOverlays, id, id.getSourceAddressRange(), id.getDestinationAddressRange(), taken, dest);
            }
        }
        this.tableModel.addAll(result);
    }

    protected MemoryBlock executeEntryBlock(RangeEntry entry, Program dest, TaskMonitor monitor) throws Exception {
        if (entry.isCreate()) {
            return dest.getMemory().createInitializedBlock(entry.getBlockName(), entry.getDstMinAddress(), entry.getDstRange().getLength(), (byte)0, monitor, entry.isOverlay());
        }
        MemoryBlock block = dest.getMemory().getBlock(entry.getDstMinAddress());
        if (this.plan.isRequiresInitializedMemory(this.source, dest) && !block.isInitialized()) {
            return dest.getMemory().convertToInitialized(block, (byte)0);
        }
        return block;
    }

    protected void executeEntry(RangeEntry entry, Program dest, Target target, TaskMonitor monitor) throws Exception {
        MemoryBlock block = this.executeEntryBlock(entry, dest, monitor);
        Address dstMin = entry.getDstRange().getMinAddress();
        if (block.isOverlay()) {
            dstMin = block.getStart().getAddressSpace().getAddress(dstMin.getOffset());
        }
        if (target != null) {
            this.executeCapture(entry.getSrcRange(), target, monitor);
        }
        this.plan.execute(this.source, entry.getSrcRange(), dest, dstMin, monitor);
    }

    protected Target getTargetIfEnabledAndReadsPresent() {
        if (!this.cbCapture.isSelected()) {
            return null;
        }
        return this.getTargetIfReadsPresent();
    }

    protected void executeCapture(AddressRange range, Target target, TaskMonitor monitor) throws Exception {
        target.readMemory((AddressSetView)new AddressSet(range), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePlan(TaskMonitor monitor) throws Exception {
        Program dest = this.getDestination().getOrCreateProgram(this.source, (Object)this);
        boolean doRelease = !Arrays.asList(this.programManager.getAllOpenPrograms()).contains(dest);
        Target target = this.getTargetIfEnabledAndReadsPresent();
        try (Transaction tx = dest.openTransaction("Copy From Trace");){
            monitor.initialize((long)this.tableModel.getRowCount());
            for (RangeEntry entry : this.tableModel.getModelData()) {
                monitor.setMessage("Copying into " + entry.getDstRange());
                this.executeEntry(entry, dest, target, monitor);
                monitor.incrementProgress(1L);
            }
            this.programManager.openProgram(dest);
        }
        finally {
            if (doRelease) {
                dest.release((Object)this);
            }
        }
        this.getDestination().saveIfApplicable(dest);
    }

    protected static interface CopyDestination {
        default public Program getExistingProgram() {
            return null;
        }

        default public boolean isExisting() {
            return this.getExistingProgram() != null;
        }

        public Program getOrCreateProgram(TraceProgramView var1, Object var2) throws IOException;

        default public void saveIfApplicable(Program program) {
        }
    }

    protected static class RangeTableModel
    extends DefaultEnumeratedColumnTableModel<RangeTableColumns, RangeEntry> {
        public RangeTableModel(PluginTool tool) {
            super(tool, "Ranges", RangeTableColumns.class);
        }

        public List<RangeTableColumns> defaultSortOrder() {
            return List.of(RangeTableColumns.SRC_MIN);
        }
    }

    protected static enum RangeTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<RangeTableColumns, RangeEntry>
    {
        REMOVE("Remove", String.class, e -> "Remove Range", (e, v) -> RangeTableColumns.nop(), null),
        REGION("Region", String.class, RangeEntry::getRegionName),
        MODULES("Modules", String.class, RangeEntry::getModuleNames),
        SECTIONS("Sections", String.class, RangeEntry::getSectionNames),
        SRC_MIN("SrcMin", Address.class, RangeEntry::getSrcMinAddress),
        SRC_MAX("SrcMax", Address.class, RangeEntry::getSrcMaxAddress),
        BLOCK("Block", String.class, RangeEntry::getBlockName, RangeEntry::setBlockName, RangeEntry::isCreate),
        OVERLAY("Overlay", Boolean.class, RangeEntry::isOverlay),
        DST_MIN("DstMin", Address.class, RangeEntry::getDstMinAddress),
        DST_MAX("DstMax", Address.class, RangeEntry::getDstMaxAddress);

        private final String header;
        private final Class<?> cls;
        private final Function<RangeEntry, ?> getter;
        private final BiConsumer<RangeEntry, Object> setter;
        private final Predicate<RangeEntry> editable;

        private static void nop() {
        }

        private <T> RangeTableColumns(String header, Class<T> cls, Function<RangeEntry, T> getter, BiConsumer<RangeEntry, T> setter, Predicate<RangeEntry> editable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.editable = editable;
        }

        private <T> RangeTableColumns(String header, Class<T> cls, Function<RangeEntry, T> getter) {
            this(header, cls, getter, null, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(RangeEntry row) {
            return this.getter.apply(row);
        }

        public boolean isEditable(RangeEntry row) {
            return this.setter != null && (this.editable == null || this.editable.test(row));
        }

        public void setValueOf(RangeEntry row, Object value) {
            this.setter.accept(row, value);
        }
    }

    protected static class OpenProgramDestination
    implements CopyDestination {
        private final Program program;

        public OpenProgramDestination(Program program) {
            this.program = program;
        }

        public String toString() {
            return this.program.getName();
        }

        @Override
        public Program getExistingProgram() {
            return this.program;
        }

        @Override
        public Program getOrCreateProgram(TraceProgramView source, Object consumer) {
            return this.program;
        }
    }

    protected static class RangeEntry {
        private final String regionName;
        private final String moduleNames;
        private final String sectionNames;
        private final AddressRange srcRange;
        private String blockName;
        private final boolean create;
        private final boolean overlay;
        private final AddressRange dstRange;

        protected RangeEntry(String regionName, String moduleNames, String sectionNames, AddressRange srcRange, String blockName, boolean create, boolean overlay, AddressRange dstRange) {
            this.regionName = regionName;
            this.moduleNames = moduleNames;
            this.sectionNames = sectionNames;
            this.srcRange = srcRange;
            this.blockName = blockName;
            this.create = create;
            this.overlay = overlay;
            this.dstRange = dstRange;
        }

        public String getRegionName() {
            return this.regionName;
        }

        public String getModuleNames() {
            return this.moduleNames;
        }

        public String getSectionNames() {
            return this.sectionNames;
        }

        public AddressRange getSrcRange() {
            return this.srcRange;
        }

        public Address getSrcMinAddress() {
            return this.srcRange.getMinAddress();
        }

        public Address getSrcMaxAddress() {
            return this.srcRange.getMaxAddress();
        }

        public AddressRange getDstRange() {
            return this.dstRange;
        }

        public String getBlockName() {
            return this.create ? this.blockName : this.blockName + " *";
        }

        public void setBlockName(String blockName) {
            if (!this.create) {
                throw new IllegalStateException("Cannot modify name of existing block");
            }
            this.blockName = blockName;
        }

        public boolean isCreate() {
            return this.create;
        }

        public boolean isOverlay() {
            return this.overlay;
        }

        public Address getDstMinAddress() {
            return this.dstRange.getMinAddress();
        }

        public Address getDstMaxAddress() {
            return this.dstRange.getMaxAddress();
        }
    }
}

