/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingType;
import ghidra.app.plugin.core.debug.gui.control.DebuggerControlPlugin;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;

class TargetDockingAction
extends DockingAction {
    private final DebuggerControlPlugin plugin;
    private final ActionName action;
    private final String defaultDescription;
    private Target.ActionEntry entry;

    public TargetDockingAction(String name, String owner, KeyBindingType keyBindingType, DebuggerControlPlugin plugin, ActionName action, String defaultDescription) {
        super(name, owner, keyBindingType);
        this.plugin = plugin;
        this.action = action;
        this.defaultDescription = defaultDescription;
    }

    private Target.ActionEntry findEntry(ActionContext context) {
        Target target = this.plugin.current.getTarget();
        if (target == null) {
            return null;
        }
        for (Target.ActionEntry ent : target.collectActions(this.action, context).values()) {
            if (ent.requiresPrompt()) continue;
            return ent;
        }
        return null;
    }

    protected void updateFromContext(ActionContext context) {
        this.entry = this.findEntry(context);
        if (this.entry == null) {
            this.setDescription(this.defaultDescription);
        } else {
            this.setDescription(this.entry.details());
        }
    }

    public boolean isEnabledForContext(ActionContext context) {
        this.updateFromContext(context);
        return this.entry != null && this.entry.isEnabled();
    }

    public void actionPerformed(ActionContext context) {
        if (this.entry == null) {
            return;
        }
        this.plugin.runTask(this.getName(), this.entry);
    }
}

