/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.action.GoToInput;
import ghidra.debug.api.action.LocationTracker;
import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.stack.TraceStack;
import ghidra.trace.util.TraceAddressSpace;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public enum NoneLocationTrackingSpec implements LocationTrackingSpec,
LocationTracker
{
    INSTANCE;

    public static final String CONFIG_NAME = "TRACK_NONE";

    public String getConfigName() {
        return CONFIG_NAME;
    }

    public String getMenuName() {
        return "Do Not Track";
    }

    public Icon getMenuIcon() {
        return DebuggerResources.TrackLocationAction.ICON_NONE;
    }

    public String computeTitle(DebuggerCoordinates coordinates) {
        return null;
    }

    public String getLocationLabel() {
        return null;
    }

    public LocationTracker getTracker() {
        return this;
    }

    public CompletableFuture<Address> computeTraceAddress(PluginTool tool, DebuggerCoordinates coordinates) {
        return AsyncUtils.nil();
    }

    public GoToInput getDefaultGoToInput(PluginTool tool, DebuggerCoordinates coordinates, ProgramLocation location) {
        if (location == null) {
            return GoToInput.fromString((String)"00000000");
        }
        return GoToInput.fromAddress((Address)location.getAddress());
    }

    public boolean affectedByBytesChange(TraceAddressSpace space, TraceAddressSnapRange range, DebuggerCoordinates coordinates) {
        return false;
    }

    public boolean affectedByStackChange(TraceStack stack, DebuggerCoordinates coordinates) {
        return false;
    }

    public boolean shouldDisassemble() {
        return false;
    }
}

