/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.util.LanguageTranslator;
import ghidra.program.util.LanguageTranslatorFactory;
import ghidra.program.util.OldLanguageFactory;
import ghidra.util.Msg;
import ghidra.util.exception.VersionException;

public class LanguageVersionException
extends VersionException {
    private Language oldLanguage;
    private LanguageTranslator languageTranslator;

    public LanguageVersionException(String msg, boolean upgradable) {
        super(msg, upgradable ? 1 : 0, upgradable);
    }

    public LanguageVersionException(Language oldLanguage, LanguageTranslator languageTranslator) {
        super(true);
        this.oldLanguage = oldLanguage;
        this.languageTranslator = languageTranslator;
    }

    public Language getOldLanguage() {
        return this.oldLanguage;
    }

    public LanguageTranslator getLanguageTranslator() {
        return this.languageTranslator;
    }

    public static LanguageVersionException check(Language language, int languageVersion, int languageMinorVersion) throws LanguageNotFoundException {
        LanguageID languageID = language.getLanguageID();
        if (language.getVersion() > languageVersion) {
            Language newLanguage = language;
            Language oldLanguage = OldLanguageFactory.getOldLanguageFactory().getOldLanguage(languageID, languageVersion);
            if (oldLanguage == null) {
                String msg = "Old language specification not found: " + languageID + " (Version " + languageVersion + "), translation not possible";
                Msg.error(LanguageVersionException.class, (Object)msg);
                return new LanguageVersionException(msg, false);
            }
            LanguageTranslator languageUpgradeTranslator = LanguageTranslatorFactory.getLanguageTranslatorFactory().getLanguageTranslator(oldLanguage, newLanguage);
            if (languageUpgradeTranslator == null) {
                throw new LanguageNotFoundException(language.getLanguageID(), "(Ver " + languageVersion + "." + languageMinorVersion + " -> " + newLanguage.getVersion() + "." + newLanguage.getMinorVersion() + ") language version translation not supported");
            }
            language = oldLanguage;
            return new LanguageVersionException(oldLanguage, languageUpgradeTranslator);
        }
        if (language.getVersion() == languageVersion && languageMinorVersion < 0) {
            return null;
        }
        if (language.getVersion() == languageVersion && language.getMinorVersion() > languageMinorVersion) {
            String fromVer = languageVersion + "." + languageMinorVersion;
            String toVer = languageVersion + "." + language.getMinorVersion();
            return new LanguageVersionException("Minor language change " + fromVer + " -> " + toVer, true);
        }
        if (language.getMinorVersion() != languageMinorVersion || language.getVersion() != languageVersion) {
            throw new LanguageNotFoundException(language.getLanguageID(), languageVersion, languageMinorVersion);
        }
        return null;
    }

    public static LanguageVersionException checkForLanguageChange(LanguageNotFoundException e, LanguageID languageID, int languageVersion) throws LanguageNotFoundException {
        LanguageTranslator languageUpgradeTranslator = LanguageTranslatorFactory.getLanguageTranslatorFactory().getLanguageTranslator(languageID, languageVersion);
        if (languageUpgradeTranslator == null) {
            throw e;
        }
        Language oldLanguage = languageUpgradeTranslator.getOldLanguage();
        LanguageID oldLanguageID = oldLanguage.getLanguageID();
        LanguageVersionException ve = new LanguageVersionException(oldLanguage, languageUpgradeTranslator);
        LanguageID newLangName = languageUpgradeTranslator.getNewLanguage().getLanguageID();
        Object message = oldLanguageID.equals(newLangName) ? "Program requires a processor language version change" : "Program requires a processor language change to: " + newLangName;
        ve.setDetailMessage((String)message);
        return ve;
    }
}

