/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import com.google.common.collect.ImmutableList;
import db.DBHandle;
import db.Transaction;
import db.util.ErrorHandler;
import generic.jar.ResourceFile;
import ghidra.framework.model.RuntimeIOException;
import ghidra.framework.store.LockException;
import ghidra.program.database.DBStringMapAdapter;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.symbol.VariableStorageManager;
import ghidra.program.database.symbol.VariableStorageManagerDB;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.ProgramArchitectureTranslator;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageVersionException;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.listing.IncompatibleLanguageException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.InvalidNameException;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import javax.help.UnsupportedOperationException;

public class StandAloneDataTypeManager
extends DataTypeManagerDB
implements Closeable {
    private static final String LANGUAGE_VERSION = "Language Version";
    private static final String LANGUAGE_ID = "Language ID";
    private static final String COMPILER_SPEC_ID = "Compiler Spec ID";
    private int transactionCount;
    private Long transaction;
    private boolean commitTransaction;
    private LanguageTranslator languageUpgradeTranslator;
    private String programArchitectureSummary;
    protected String name;
    private ArchiveWarning warning;
    private Exception warningDetail;

    public StandAloneDataTypeManager(String rootName) throws RuntimeIOException {
        super(DataOrganizationImpl.getDefaultOrganization());
        this.name = rootName;
    }

    public StandAloneDataTypeManager(String rootName, DataOrganization dataOrganzation) throws RuntimeIOException {
        super(dataOrganzation);
        this.name = rootName;
    }

    protected StandAloneDataTypeManager(ResourceFile packedDbfile, int openMode, TaskMonitor monitor) throws IOException, CancelledException {
        super(packedDbfile, openMode, monitor);
    }

    protected StandAloneDataTypeManager(DBHandle handle, int openMode, ErrorHandler errHandler, Lock lock, TaskMonitor monitor) throws CancelledException, VersionException, IOException {
        super(handle, null, openMode, null, errHandler, lock, monitor);
        if (openMode != 0 && this.hasDataOrganizationChange(true)) {
            this.handleDataOrganizationChange(openMode, monitor);
        }
    }

    public ArchiveWarning getWarning() {
        return this.warning;
    }

    public Exception getWarningDetail() {
        return this.warningDetail;
    }

    public String getWarningMessage(boolean includeDetails) {
        Object msg = null;
        switch (this.warning) {
            case LANGUAGE_NOT_FOUND: {
                msg = "Language not found for Archive";
                if (!includeDetails) break;
                msg = (String)msg + " '" + this.getName() + "': " + this.warningDetail.getMessage();
                break;
            }
            case COMPILER_SPEC_NOT_FOUND: {
                msg = "Compiler specification not found for Archive";
                if (!includeDetails) break;
                msg = (String)msg + " '" + this.getName() + "': " + this.warningDetail.getMessage();
                break;
            }
            case LANGUAGE_UPGRADE_REQURED: {
                msg = "Language upgrade required for Archive";
                if (!includeDetails) break;
                msg = (String)msg + " '" + this.getName() + "': " + this.programArchitectureSummary;
                break;
            }
            case UPGRADED_LANGUAGE_VERSION: {
                msg = "Upgraded program-architecture for Archive";
                if (!includeDetails) break;
                ProgramArchitecture arch = this.getProgramArchitecture();
                LanguageDescription languageDescription = arch.getLanguage().getLanguageDescription();
                msg = (String)msg + " '" + this.getName() + "'\n   Language: " + languageDescription.getLanguageID() + " Version " + languageDescription.getVersion() + ".x, CompilerSpec: " + arch.getCompilerSpec().getCompilerSpecID();
                break;
            }
            case DATA_ORG_CHANGED: {
                msg = "Data organization upgrade required for Archive";
                if (!includeDetails) break;
                msg = (String)msg + " '" + this.getName() + "': " + this.programArchitectureSummary;
                break;
            }
        }
        return msg;
    }

    protected void logWarning() {
        String msg = this.getWarningMessage(true);
        if (msg == null) {
            return;
        }
        switch (this.warning.level) {
            case ERROR: {
                Msg.error((Object)this, (Object)msg);
                break;
            }
            case WARN: {
                Msg.warn((Object)this, (Object)msg);
                break;
            }
            default: {
                Msg.info((Object)this, (Object)msg);
            }
        }
    }

    @Override
    protected void initializeOtherAdapters(int openMode, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        CompilerSpec compilerSpec;
        this.warning = ArchiveWarning.NONE;
        if (openMode == 0) {
            this.saveDataOrganization();
            return;
        }
        DBStringMapAdapter dataMap = this.getDataMap(false);
        if (dataMap == null) {
            return;
        }
        String languageIdStr = dataMap.get(LANGUAGE_ID);
        if (languageIdStr == null) {
            return;
        }
        LanguageID languageId = new LanguageID(languageIdStr);
        CompilerSpecID compilerSpecId = new CompilerSpecID(dataMap.get(COMPILER_SPEC_ID));
        int languageVersion = 1;
        try {
            languageVersion = Integer.parseInt(dataMap.get(LANGUAGE_VERSION));
        }
        catch (Exception exception) {
            // empty catch block
        }
        VariableStorageManagerDB variableStorageMgr = null;
        if (VariableStorageManagerDB.exists(this.dbHandle)) {
            variableStorageMgr = new VariableStorageManagerDB(this.dbHandle, null, openMode, this.errHandler, this.lock, monitor);
        }
        this.programArchitectureSummary = StandAloneDataTypeManager.getProgramArchitectureSummary(languageId, languageVersion, compilerSpecId);
        Language language = null;
        LanguageVersionException languageVersionExc = null;
        try {
            language = DefaultLanguageService.getLanguageService().getLanguage(languageId);
            languageVersionExc = LanguageVersionException.check(language, languageVersion, -1);
        }
        catch (LanguageNotFoundException e) {
            this.warning = ArchiveWarning.LANGUAGE_NOT_FOUND;
            this.warningDetail = e;
            try {
                languageVersionExc = LanguageVersionException.checkForLanguageChange(e, languageId, languageVersion);
            }
            catch (LanguageNotFoundException e2) {
                this.warningDetail = e2;
                return;
            }
        }
        if (languageVersionExc != null && !languageVersionExc.isUpgradable()) {
            this.warning = ArchiveWarning.LANGUAGE_NOT_FOUND;
            this.warningDetail = languageVersionExc;
        } else if (languageVersionExc != null) {
            this.warning = ArchiveWarning.LANGUAGE_UPGRADE_REQURED;
            this.languageUpgradeTranslator = languageVersionExc.getLanguageTranslator();
            if (openMode == 2) {
                return;
            }
            if (openMode == 1) {
                throw languageVersionExc;
            }
            language = this.languageUpgradeTranslator.getNewLanguage();
            compilerSpecId = this.languageUpgradeTranslator.getNewCompilerSpecID(compilerSpecId);
        }
        assert (language != null);
        try {
            compilerSpec = language.getCompilerSpecByID(compilerSpecId);
        }
        catch (CompilerSpecNotFoundException e) {
            this.warning = ArchiveWarning.COMPILER_SPEC_NOT_FOUND;
            this.warningDetail = e;
            return;
        }
        if (this.warning == ArchiveWarning.LANGUAGE_UPGRADE_REQURED) {
            if (variableStorageMgr != null) {
                variableStorageMgr.setLanguage(this.languageUpgradeTranslator, monitor);
            }
            dataMap.put(LANGUAGE_ID, language.getLanguageID().getIdAsString());
            dataMap.put(LANGUAGE_VERSION, Integer.toString(language.getVersion()));
            dataMap.put(COMPILER_SPEC_ID, compilerSpecId.getIdAsString());
            this.warning = ArchiveWarning.UPGRADED_LANGUAGE_VERSION;
        }
        this.programArchitectureSummary = null;
        final Language lang = language;
        final CompilerSpec cspec = compilerSpec;
        final ProgramAddressFactory addrFactory = new ProgramAddressFactory(lang, cspec, s -> null);
        super.setProgramArchitecture(new ProgramArchitecture(){

            @Override
            public Language getLanguage() {
                return lang;
            }

            @Override
            public CompilerSpec getCompilerSpec() {
                return cspec;
            }

            @Override
            public AddressFactory getAddressFactory() {
                return addrFactory;
            }
        }, variableStorageMgr, false, monitor);
        if (variableStorageMgr != null) {
            variableStorageMgr.setProgramArchitecture(this.getProgramArchitecture());
        }
    }

    @Override
    protected void handleDataOrganizationChange(int openMode, TaskMonitor monitor) throws LanguageVersionException, CancelledException, IOException {
        if (openMode == 2) {
            this.warning = ArchiveWarning.DATA_ORG_CHANGED;
        }
        super.handleDataOrganizationChange(openMode, monitor);
    }

    @Override
    public String getProgramArchitectureSummary() {
        if (this.programArchitectureSummary != null) {
            return this.programArchitectureSummary;
        }
        return super.getProgramArchitectureSummary();
    }

    private void deleteAllProgramArchitectureData(TaskMonitor monitor) throws IOException, CancelledException {
        this.clearCustomStorageUse(monitor);
        DBStringMapAdapter dataMap = this.getDataMap(false);
        if (dataMap != null) {
            dataMap.delete(LANGUAGE_ID);
            dataMap.delete(LANGUAGE_VERSION);
            dataMap.delete(COMPILER_SPEC_ID);
        }
        VariableStorageManagerDB.delete(this.dbHandle);
        this.warning = ArchiveWarning.NONE;
        this.programArchitectureSummary = null;
    }

    private VariableStorageManagerDB createProgramArchitectureData(ProgramArchitecture programArchitecture, VariableStorageManagerDB variableStorageMgr) throws IOException {
        Language newLanguage = programArchitecture.getLanguage();
        LanguageID newLanguageId = newLanguage.getLanguageID();
        CompilerSpec newCompilerSpec = programArchitecture.getCompilerSpec();
        CompilerSpecID newCmpilerSpecID = newCompilerSpec.getCompilerSpecID();
        DBStringMapAdapter dataMap = this.getDataMap(true);
        dataMap.put(LANGUAGE_ID, newLanguageId.getIdAsString());
        dataMap.put(COMPILER_SPEC_ID, newCmpilerSpecID.getIdAsString());
        dataMap.put(LANGUAGE_VERSION, Integer.toString(newLanguage.getVersion()));
        if (variableStorageMgr == null) {
            try {
                variableStorageMgr = new VariableStorageManagerDB(this.dbHandle, null, 0, this.errHandler, this.lock, TaskMonitor.DUMMY);
                variableStorageMgr.setProgramArchitecture(programArchitecture);
            }
            catch (CancelledException | VersionException e) {
                throw new AssertException(e);
            }
        }
        variableStorageMgr.setProgramArchitecture(programArchitecture);
        this.warning = ArchiveWarning.NONE;
        this.programArchitectureSummary = null;
        return variableStorageMgr;
    }

    public boolean isProgramArchitectureUpgradeRequired() {
        return this.warning == ArchiveWarning.LANGUAGE_UPGRADE_REQURED;
    }

    public boolean isProgramArchitectureMissing() {
        return this.warning == ArchiveWarning.LANGUAGE_NOT_FOUND || this.warning == ArchiveWarning.COMPILER_SPEC_NOT_FOUND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProgramArchitecture(TaskMonitor monitor) throws CancelledException, IOException, LockException {
        this.lock.acquire();
        try {
            if (!this.isArchitectureChangeAllowed()) {
                throw new UnsupportedOperationException("Program-architecture change not permitted");
            }
            if (!this.dbHandle.canUpdate()) {
                throw new ReadOnlyException("Read-only Archive: " + this.getName());
            }
            if (this.getProgramArchitecture() == null && !this.isProgramArchitectureMissing()) {
                return;
            }
            Msg.info((Object)this, (Object)("Removing program-architecture for Archive: " + this.getName()));
            int txId = this.startTransaction("Remove Program Architecture");
            try {
                if (!this.isArchitectureChangeAllowed()) {
                    throw new UnsupportedOperationException("Program-architecture change not permitted");
                }
                this.deleteAllProgramArchitectureData(monitor);
                super.setProgramArchitecture(null, null, true, monitor);
            }
            catch (Throwable throwable) {
                this.endTransaction(txId, !monitor.isCancelled());
                throw throwable;
            }
            this.endTransaction(txId, !monitor.isCancelled());
            this.defaultListener.programArchitectureChanged(this);
        }
        finally {
            this.invalidateCache();
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgramArchitecture(final Language language, CompilerSpecID compilerSpecId, LanguageUpdateOption updateOption, TaskMonitor monitor) throws CompilerSpecNotFoundException, LanguageNotFoundException, IOException, CancelledException, LockException, UnsupportedOperationException, IncompatibleLanguageException {
        this.lock.acquire();
        try {
            if (!this.isArchitectureChangeAllowed()) {
                throw new UnsupportedOperationException("Program-architecture change not permitted");
            }
            if (this.readOnlyMode) {
                throw new ReadOnlyException("Read-only Archive: " + this.getName());
            }
            Msg.info((Object)this, (Object)("Updating program-architecture for Archive: " + this.getName() + "\n   Language: " + language.getLanguageID() + " version " + language.getVersion() + ".x, CompilerSpec: " + compilerSpecId));
            final CompilerSpec compilerSpec = language.getCompilerSpecByID(compilerSpecId);
            VariableStorageManagerDB variableStorageMgr = (VariableStorageManagerDB)this.getVariableStorageManager();
            int txId = this.startTransaction("Set Program Architecture");
            try {
                ProgramArchitectureTranslator translator = null;
                ProgramArchitecture oldArch = this.getProgramArchitecture();
                if (oldArch != null || this.isProgramArchitectureMissing()) {
                    if (updateOption == LanguageUpdateOption.CLEAR) {
                        this.deleteAllProgramArchitectureData(monitor);
                        variableStorageMgr = null;
                    } else if (this.isProgramArchitectureMissing()) {
                        assert (variableStorageMgr == null);
                        if (updateOption == LanguageUpdateOption.TRANSLATE) {
                            DBStringMapAdapter dataMap = this.getDataMap(false);
                            LanguageID oldLanguageId = new LanguageID(this.getDataMap(false).get(LANGUAGE_ID));
                            CompilerSpecID oldCompilerSpecId = new CompilerSpecID(dataMap.get(COMPILER_SPEC_ID));
                            translator = new ProgramArchitectureTranslator(oldLanguageId, -1, oldCompilerSpecId, language, compilerSpecId);
                        }
                        if (VariableStorageManagerDB.exists(this.dbHandle)) {
                            try {
                                variableStorageMgr = new VariableStorageManagerDB(this.dbHandle, null, 1, this.errHandler, this.lock, monitor);
                            }
                            catch (VersionException e) {
                                throw new IOException("Unexpected version error for VariableStorageManagerDB");
                            }
                        }
                    } else if (updateOption == LanguageUpdateOption.TRANSLATE) {
                        translator = new ProgramArchitectureTranslator(oldArch.getLanguage(), oldArch.getCompilerSpec().getCompilerSpecID(), language, compilerSpecId);
                    }
                    if (translator != null && variableStorageMgr != null) {
                        variableStorageMgr.setLanguage(translator, monitor);
                    }
                }
                ProgramArchitecture programArchitecture = new ProgramArchitecture(){

                    @Override
                    public Language getLanguage() {
                        return language;
                    }

                    @Override
                    public CompilerSpec getCompilerSpec() {
                        return compilerSpec;
                    }

                    @Override
                    public AddressFactory getAddressFactory() {
                        return language.getAddressFactory();
                    }
                };
                variableStorageMgr = this.createProgramArchitectureData(programArchitecture, variableStorageMgr);
                super.setProgramArchitecture(programArchitecture, variableStorageMgr, true, monitor);
            }
            catch (Throwable throwable) {
                this.endTransaction(txId, !monitor.isCancelled());
                throw throwable;
            }
            this.endTransaction(txId, !monitor.isCancelled());
            this.defaultListener.programArchitectureChanged(this);
        }
        finally {
            this.invalidateCache();
            this.lock.release();
        }
    }

    @Override
    protected void setProgramArchitecture(ProgramArchitecture programArchitecture, VariableStorageManager variableStorageMgr, boolean store, TaskMonitor monitor) throws IOException, CancelledException {
        if (programArchitecture == null) {
            throw new IllegalArgumentException("ProgramArchitecture must be specified");
        }
        if (variableStorageMgr != null) {
            throw new IllegalArgumentException("VariableStorageManager may not be specified");
        }
        if (this.getProgramArchitecture() != null || this.isProgramArchitectureUpgradeRequired() || this.isProgramArchitectureMissing()) {
            throw new UnsupportedOperationException("Program-architecture change not permitted with this method");
        }
        if (store) {
            variableStorageMgr = this.createProgramArchitectureData(programArchitecture, null);
        }
        super.setProgramArchitecture(programArchitecture, variableStorageMgr, store, monitor);
    }

    protected boolean isArchitectureChangeAllowed() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name is invalid: " + name);
        }
        this.name = name;
        this.defaultListener.categoryRenamed(this, CategoryPath.ROOT, CategoryPath.ROOT);
    }

    @Override
    public Transaction openTransaction(final String description) throws IllegalStateException {
        return new Transaction(){
            private int txId;
            {
                this.txId = StandAloneDataTypeManager.this.startTransaction(description);
            }

            protected boolean endTransaction(boolean commit) {
                StandAloneDataTypeManager.this.endTransaction(this.txId, commit);
                return StandAloneDataTypeManager.this.commitTransaction;
            }

            public boolean isSubTransaction() {
                return true;
            }
        };
    }

    @Override
    public synchronized int startTransaction(String description) {
        if (this.transaction == null) {
            this.transaction = this.dbHandle.startTransaction();
            this.commitTransaction = true;
        }
        ++this.transactionCount;
        return this.transaction.intValue();
    }

    @Override
    public void flushEvents() {
    }

    @Override
    public synchronized void endTransaction(int transactionID, boolean commit) {
        if (this.transaction == null) {
            throw new IllegalStateException("No Transaction Open");
        }
        if (this.transaction.intValue() != transactionID) {
            throw new IllegalArgumentException("Transaction id does not match current transaction");
        }
        if (!commit) {
            this.commitTransaction = false;
        }
        if (--this.transactionCount == 0) {
            try {
                this.dbHandle.endTransaction(this.transaction.longValue(), this.commitTransaction);
                this.transaction = null;
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
    }

    @Override
    protected void replaceDataTypeIDs(long oldID, long newID) {
    }

    @Override
    protected void deleteDataTypeIDs(LinkedList<Long> deletedIds, TaskMonitor monitor) {
    }

    @Override
    public void close() {
        if (!this.dbHandle.isClosed()) {
            this.dbHandle.close();
        }
        super.close();
    }

    public void finalize() {
        this.close();
    }

    @Override
    protected String getDomainFileID() {
        return null;
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.TEST;
    }

    private void clearCustomStorageUse(TaskMonitor monitor) throws CancelledException {
        ImmutableList defs = ImmutableList.copyOf(this.getAllFunctionDefinitions());
        monitor.initialize((long)defs.size());
        monitor.setMessage("Clear custom storage use...");
        monitor.checkCancelled();
    }

    public static enum ArchiveWarning {
        NONE(ArchiveWarningLevel.INFO),
        UPGRADED_LANGUAGE_VERSION(ArchiveWarningLevel.INFO),
        LANGUAGE_NOT_FOUND(ArchiveWarningLevel.ERROR),
        COMPILER_SPEC_NOT_FOUND(ArchiveWarningLevel.ERROR),
        LANGUAGE_UPGRADE_REQURED(ArchiveWarningLevel.WARN),
        DATA_ORG_CHANGED(ArchiveWarningLevel.WARN);

        final ArchiveWarningLevel level;

        private ArchiveWarning(ArchiveWarningLevel level) {
            this.level = level;
        }

        public ArchiveWarningLevel level() {
            return this.level;
        }
    }

    public static enum ArchiveWarningLevel {
        INFO,
        WARN,
        ERROR;

    }

    public static enum LanguageUpdateOption {
        CLEAR,
        TRANSLATE,
        UNCHANGED;

    }
}

