/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AnnotationHandler;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultAnnotationHandler;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.VoidDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DataTypeWriter {
    private static String[] INTEGRAL_TYPES = new String[]{"char", "short", "int", "long", "long long", "__int64", "float", "double", "long double", "void"};
    private static String[] INTEGRAL_MODIFIERS = new String[]{"signed", "unsigned", "const", "static", "volatile", "mutable"};
    private static String EOL = System.getProperty("line.separator");
    private Set<DataType> resolved = new HashSet<DataType>();
    private Map<String, DataType> resolvedTypeMap = new HashMap<String, DataType>();
    private Set<Composite> deferredCompositeDeclarations = new HashSet<Composite>();
    private ArrayDeque<DataType> deferredTypeFIFO = new ArrayDeque();
    private Set<DataType> deferredTypes = new HashSet<DataType>();
    private int writerDepth = 0;
    private Writer writer;
    private DataTypeManager dtm;
    private DataOrganization dataOrganization;
    private AnnotationHandler annotator;
    private boolean cppStyleComments = false;

    public DataTypeWriter(DataTypeManager dtm, Writer writer) throws IOException {
        this(dtm, writer, new DefaultAnnotationHandler());
    }

    public DataTypeWriter(DataTypeManager dtm, Writer writer, boolean cppStyleComments) throws IOException {
        this(dtm, writer, new DefaultAnnotationHandler(), cppStyleComments);
    }

    public DataTypeWriter(DataTypeManager dtm, Writer writer, AnnotationHandler annotator) throws IOException {
        this(dtm, writer, annotator, false);
    }

    public DataTypeWriter(DataTypeManager dtm, Writer writer, AnnotationHandler annotator, boolean cppStyleComments) throws IOException {
        this.dtm = dtm;
        if (dtm != null) {
            this.dataOrganization = dtm.getDataOrganization();
        }
        if (this.dataOrganization == null) {
            this.dataOrganization = DataOrganizationImpl.getDefaultOrganization();
        }
        this.writer = writer;
        this.annotator = annotator;
        this.cppStyleComments = cppStyleComments;
        if (dtm != null) {
            this.writeBuiltInDeclarations(dtm);
        }
    }

    private String comment(String text) {
        if (text == null) {
            return "";
        }
        if (this.cppStyleComments) {
            return "// " + text;
        }
        return "/* " + text + " */";
    }

    public void write(DataTypeManager dataTypeManager, TaskMonitor monitor) throws IOException, CancelledException {
        this.write(dataTypeManager.getRootCategory(), monitor);
    }

    public void write(Category category, TaskMonitor monitor) throws IOException, CancelledException {
        Category[] subCategories;
        DataType[] dataTypes = category.getDataTypes();
        this.write(dataTypes, monitor);
        for (Category subCategory : subCategories = category.getCategories()) {
            if (monitor.isCancelled()) {
                return;
            }
            this.write(subCategory, monitor);
        }
    }

    public void write(DataType[] dataTypes, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.initialize((long)dataTypes.length);
        int cnt = 0;
        for (DataType dataType : dataTypes) {
            monitor.checkCancelled();
            this.write(dataType, monitor);
            monitor.setProgress((long)(++cnt));
        }
    }

    public void write(List<DataType> dataTypes, TaskMonitor monitor) throws IOException, CancelledException {
        this.write(dataTypes, monitor, true);
    }

    public void write(List<DataType> dataTypes, TaskMonitor monitor, boolean throwExceptionOnInvalidType) throws IOException, CancelledException {
        monitor.initialize((long)dataTypes.size());
        int cnt = 0;
        for (DataType dataType : dataTypes) {
            monitor.checkCancelled();
            this.write(dataType, monitor, throwExceptionOnInvalidType);
            monitor.setProgress((long)(++cnt));
        }
    }

    private void deferWrite(DataType dt) {
        if (!this.resolved.contains(dt) && !this.deferredTypes.contains(dt)) {
            this.deferredTypes.add(dt);
            this.deferredTypeFIFO.addLast(dt);
        }
    }

    void write(DataType dt, TaskMonitor monitor) throws IOException, CancelledException {
        this.doWrite(dt, monitor, true);
    }

    void write(DataType dt, TaskMonitor monitor, boolean throwExceptionOnInvalidType) throws IOException, CancelledException {
        this.doWrite(dt, monitor, throwExceptionOnInvalidType);
    }

    private void doWrite(DataType dt, TaskMonitor monitor, boolean throwExceptionOnInvalidType) throws IOException, CancelledException {
        if (dt == null) {
            return;
        }
        if (dt instanceof FunctionDefinition) {
            return;
        }
        if (dt instanceof FactoryDataType) {
            IllegalArgumentException iae = new IllegalArgumentException("Factory data types may not be written");
            if (throwExceptionOnInvalidType) {
                throw iae;
            }
            Msg.error((Object)this, (Object)("Factory data types may not be written - type: " + dt));
        }
        if (dt instanceof Pointer || dt instanceof Array || dt instanceof BitFieldDataType) {
            this.write(this.getBaseDataType(dt), monitor);
            return;
        }
        if (this.resolved.contains(dt = dt.clone(this.dtm))) {
            return;
        }
        this.resolved.add(dt);
        DataType resolvedType = this.resolvedTypeMap.get(dt.getName());
        if (resolvedType != null) {
            if (resolvedType.isEquivalent(dt)) {
                return;
            }
            if (dt instanceof TypeDef) {
                DataType baseType = ((TypeDef)dt).getBaseDataType();
                if ((resolvedType instanceof Composite || resolvedType instanceof Enum) && baseType.isEquivalent(resolvedType)) {
                    return;
                }
            }
            this.writer.write(EOL);
            this.writer.write(this.comment("WARNING! conflicting data type names: " + dt.getPathName() + " - " + resolvedType.getPathName()));
            this.writer.write(EOL);
            this.writer.write(EOL);
            return;
        }
        this.resolvedTypeMap.put(dt.getName(), dt);
        ++this.writerDepth;
        if (dt.equals(DataType.DEFAULT)) {
            this.writer.write("typedef unsigned char   " + DataType.DEFAULT.getName() + ";");
            this.writer.write(EOL);
            this.writer.write(EOL);
        } else if (dt instanceof Dynamic) {
            this.writeDynamicBuiltIn((Dynamic)dt, monitor);
        } else if (dt instanceof Structure) {
            Structure struct = (Structure)dt;
            this.writeCompositePreDeclaration(struct, monitor);
            this.deferredCompositeDeclarations.add(struct);
        } else if (dt instanceof Union) {
            Union union = (Union)dt;
            this.writeCompositePreDeclaration(union, monitor);
            this.deferredCompositeDeclarations.add(union);
        } else if (dt instanceof Enum) {
            this.writeEnum((Enum)dt, monitor);
        } else if (dt instanceof TypeDef) {
            this.writeTypeDef((TypeDef)dt, monitor);
        } else if (dt instanceof BuiltInDataType) {
            this.writeBuiltIn((BuiltInDataType)dt, monitor);
        } else if (!(dt instanceof BitFieldDataType)) {
            this.writer.write(EOL);
            this.writer.write(EOL);
            this.writer.write(this.comment("Unable to write datatype. Type unrecognized: " + dt.getClass()));
            this.writer.write(EOL);
            this.writer.write(EOL);
        }
        if (this.writerDepth == 1) {
            this.writeDeferredDeclarations(monitor);
        }
        --this.writerDepth;
    }

    private void writeDeferredDeclarations(TaskMonitor monitor) throws IOException, CancelledException {
        while (!this.deferredTypes.isEmpty()) {
            DataType dt = this.deferredTypeFIFO.removeFirst();
            this.deferredTypes.remove(dt);
            this.write(dt, monitor);
        }
        this.writeDeferredCompositeDeclarations(monitor);
        this.deferredCompositeDeclarations.clear();
    }

    private DataType getBaseArrayTypedefType(DataType dt) {
        while (dt != null) {
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
                continue;
            }
            if (!(dt instanceof Array)) break;
            dt = ((Array)dt).getDataType();
        }
        return dt;
    }

    private boolean containsComposite(Composite container, Composite contained) {
        for (DataTypeComponent component : container.getDefinedComponents()) {
            DataType dt = this.getBaseArrayTypedefType(component.getDataType());
            if (!(dt instanceof Composite) || !dt.getName().equals(contained.getName()) || !dt.isEquivalent(contained)) continue;
            return true;
        }
        return false;
    }

    private void writeDeferredCompositeDeclarations(TaskMonitor monitor) throws IOException, CancelledException {
        int cnt = this.deferredCompositeDeclarations.size();
        if (cnt == 0) {
            return;
        }
        LinkedList<Composite> list = new LinkedList<Composite>(this.deferredCompositeDeclarations);
        if (list.size() > 1) {
            int sortChange = 1;
            while (sortChange != 0) {
                sortChange = 0;
                for (int i = cnt - 1; i > 0; --i) {
                    if (!this.resortComposites(list, i)) continue;
                    ++sortChange;
                }
            }
        }
        for (Composite composite : list) {
            this.writeCompositeBody(composite, monitor);
        }
    }

    private boolean resortComposites(List<Composite> list, int index) {
        int listSize = list.size();
        if (listSize <= 0) {
            return false;
        }
        Composite composite = list.get(index);
        for (int i = 0; i < index; ++i) {
            Composite other = list.get(i);
            if (!this.containsComposite(other, composite)) continue;
            list.remove(index);
            list.add(i, composite);
            composite = null;
            return true;
        }
        return false;
    }

    private String getDynamicComponentString(Dynamic dynamicType, String fieldName, int length) {
        DataType replacementBaseType;
        if (dynamicType.canSpecifyLength() && (replacementBaseType = dynamicType.getReplacementBaseType()) != null) {
            int elementLen = (replacementBaseType = replacementBaseType.clone(this.dtm)).getLength();
            if (elementLen <= 0) {
                Msg.error((Object)this, (Object)(dynamicType.getClass().getSimpleName() + " returned bad replacementBaseType: " + replacementBaseType.getClass().getSimpleName()));
            } else {
                int elementCnt = (length + elementLen - 1) / elementLen;
                return replacementBaseType.getDisplayName() + " " + fieldName + "[" + elementCnt + "]";
            }
        }
        return null;
    }

    private void writeCompositePreDeclaration(Composite composite, TaskMonitor monitor) throws IOException, CancelledException {
        String compositeType = composite instanceof Structure ? "struct" : "union";
        this.writer.write("typedef " + compositeType + " " + composite.getDisplayName() + " " + composite.getDisplayName() + ", *P" + composite.getDisplayName() + ";");
        this.writer.write(EOL);
        this.writer.write(EOL);
        for (DataTypeComponent component : composite.getComponents()) {
            if (monitor.isCancelled()) break;
            DataType componentType = component.getDataType();
            this.deferWrite(componentType);
            this.getTypeDeclaration(null, componentType, component.getLength(), true, monitor);
        }
    }

    private void writeCompositeBody(Composite composite, TaskMonitor monitor) throws IOException, CancelledException {
        String compositeType = composite instanceof Structure ? "struct" : "union";
        StringBuilder sb = new StringBuilder();
        sb.append(compositeType + " " + composite.getDisplayName() + " {");
        String descrip = composite.getDescription();
        if (descrip != null && descrip.length() > 0) {
            sb.append(" " + this.comment(descrip));
        }
        sb.append(EOL);
        for (DataTypeComponent component : composite.getComponents()) {
            monitor.checkCancelled();
            this.writeComponent(component, composite, sb, monitor);
        }
        sb.append(this.annotator.getSuffix(composite, null));
        sb.append("};");
        this.writer.write(sb.toString());
        this.writer.write(EOL);
        this.writer.write(EOL);
    }

    private void writeComponent(DataTypeComponent component, Composite composite, StringBuilder sb, TaskMonitor monitor) throws IOException, CancelledException {
        sb.append("    ");
        sb.append(this.annotator.getPrefix(composite, component));
        String fieldName = component.getFieldName();
        if (fieldName == null || fieldName.length() == 0) {
            fieldName = component.getDefaultFieldName();
        }
        DataType componentDataType = component.getDataType();
        sb.append(this.getTypeDeclaration(fieldName, componentDataType, component.getLength(), false, monitor));
        sb.append(";");
        sb.append(this.annotator.getSuffix(composite, component));
        String comment = component.getComment();
        if (comment != null && comment.length() > 0) {
            sb.append(" " + this.comment(comment));
        }
        sb.append(EOL);
    }

    private String getTypeDeclaration(String name, DataType dataType, int instanceLength, boolean writeEnabled, TaskMonitor monitor) throws IOException, CancelledException {
        if (name == null) {
            name = "";
        }
        StringBuilder sb = new StringBuilder();
        Object componentString = null;
        if (dataType instanceof Dynamic) {
            componentString = this.getDynamicComponentString((Dynamic)dataType, (String)name, instanceLength);
            if (componentString != null) {
                sb.append((String)componentString);
            } else {
                sb.append(this.comment("ignoring dynamic datatype inside composite: " + dataType.getDisplayName()));
                sb.append(EOL);
            }
        }
        if (componentString == null) {
            if (dataType instanceof BitFieldDataType) {
                BitFieldDataType bfDt = (BitFieldDataType)dataType;
                name = (String)name + ":" + bfDt.getDeclaredBitSize();
                dataType = bfDt.getBaseDataType();
            }
            while (true) {
                Pointer pointer;
                DataType elem;
                if (dataType instanceof Array) {
                    Array array = (Array)dataType;
                    name = (String)name + "[" + array.getNumElements() + "]";
                    dataType = array.getDataType();
                    continue;
                }
                if (!(dataType instanceof Pointer) || (elem = (pointer = (Pointer)dataType).getDataType()) == null) break;
                name = "*" + (String)name;
                dataType = elem;
                if (!(dataType instanceof Array)) continue;
                name = "(" + (String)name + ")";
            }
            DataType baseDataType = this.getBaseDataType(dataType);
            if (baseDataType instanceof FunctionDefinition) {
                componentString = this.getFunctionPointerString((FunctionDefinition)baseDataType, (String)name, dataType, writeEnabled, monitor);
            } else {
                componentString = this.getDataTypePrefix(dataType) + dataType.getDisplayName();
                if (((String)name).length() != 0) {
                    componentString = (String)componentString + " " + (String)name;
                }
            }
            sb.append((String)componentString);
        }
        return sb.toString();
    }

    private String getDataTypePrefix(DataType dataType) {
        if ((dataType = this.getBaseDataType(dataType)) instanceof Structure) {
            return "struct ";
        }
        if (dataType instanceof Union) {
            return "union ";
        }
        if (dataType instanceof Enum) {
            return "enum ";
        }
        return "";
    }

    private void writeEnum(Enum enumm, TaskMonitor monitor) throws IOException {
        String enumName = enumm.getDisplayName();
        if (enumName.startsWith("define_") && enumName.length() > 7 && enumm.getCount() == 1) {
            long val = enumm.getValues()[0];
            this.writer.append("#define " + enumName.substring(7) + " " + Long.toString(val));
            this.writer.write(EOL);
            this.writer.write(EOL);
            return;
        }
        this.writer.write("typedef enum " + enumName + " {");
        String description = enumm.getDescription();
        if (description != null && description.length() != 0) {
            this.writer.write(" " + this.comment(description));
        }
        this.writer.write(EOL);
        String[] names = enumm.getNames();
        for (int j = 0; j < names.length; ++j) {
            this.writer.write("    ");
            this.writer.write(this.annotator.getPrefix(enumm, names[j]));
            this.writer.write(names[j]);
            this.writer.write("=");
            this.writer.write(Long.toString(enumm.getValue(names[j])));
            String comment = enumm.getComment(names[j]);
            if (!StringUtils.isBlank((CharSequence)comment)) {
                this.writer.write(" " + this.comment(comment));
            }
            this.writer.write(this.annotator.getSuffix(enumm, names[j]));
            if (j < names.length - 1) {
                this.writer.write(",");
            }
            this.writer.write(EOL);
        }
        this.writer.write("} " + enumName + ";");
        this.writer.write(EOL);
        this.writer.write(EOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTypeDef(TypeDef typeDef, TaskMonitor monitor) throws IOException, CancelledException {
        DataType dataType;
        String dataTypeName;
        String typedefName = typeDef.getDisplayName();
        if (this.isIntegral(typedefName, dataTypeName = (dataType = typeDef.getDataType()).getDisplayName())) {
            return;
        }
        DataType baseType = typeDef.getBaseDataType();
        try {
            if (baseType instanceof Composite || baseType instanceof Enum) {
                if (typedefName.equals(baseType.getName())) {
                    this.resolvedTypeMap.remove(typedefName);
                    return;
                }
            } else if (baseType instanceof Pointer && typedefName.startsWith("P")) {
                DataType dt = ((Pointer)baseType).getDataType();
                if (dt instanceof TypeDef) {
                    dt = ((TypeDef)dt).getBaseDataType();
                }
                if (dt instanceof Composite && dt.getName().equals(typedefName.substring(1))) {
                    this.resolvedTypeMap.remove(typedefName);
                    return;
                }
            }
        }
        finally {
            this.write(dataType, monitor);
        }
        if (baseType instanceof Array && this.getBaseArrayTypedefType(baseType) instanceof Composite) {
            this.writeDeferredDeclarations(monitor);
        }
        String typedefString = this.getTypeDeclaration(typedefName, dataType, -1, true, monitor);
        this.writer.write("typedef " + typedefString + ";");
        this.writer.write(EOL);
        this.writer.write(EOL);
    }

    private boolean isIntegral(String typedefName, String basetypeName) {
        for (String type : INTEGRAL_TYPES) {
            if (!typedefName.equals(type)) continue;
            return true;
        }
        boolean endsWithIntegralType = false;
        for (String type : INTEGRAL_TYPES) {
            if (!typedefName.endsWith(" " + type)) continue;
            endsWithIntegralType = true;
            break;
        }
        boolean containsIntegralModifier = false;
        for (String modifier : INTEGRAL_MODIFIERS) {
            if (typedefName.indexOf(modifier + " ") < 0 && typedefName.indexOf(" " + modifier) < 0) continue;
            return true;
        }
        if (endsWithIntegralType && containsIntegralModifier) {
            return true;
        }
        if (typedefName.endsWith(" " + basetypeName)) {
            return containsIntegralModifier;
        }
        return false;
    }

    private void writeDynamicBuiltIn(Dynamic dt, TaskMonitor monitor) throws IOException, CancelledException {
        DataType baseDt = dt.getReplacementBaseType();
        if (baseDt != null) {
            this.write(baseDt, monitor);
        }
    }

    private void writeBuiltIn(BuiltInDataType dt, TaskMonitor monitor) throws IOException {
        String declaration = dt.getCTypeDeclaration(this.dataOrganization);
        if (declaration != null) {
            this.writer.write(declaration);
            this.writer.write(EOL);
        }
    }

    private void writeBuiltInDeclarations(DataTypeManager manager) throws IOException {
        try {
            this.write(DataType.DEFAULT, TaskMonitor.DUMMY);
            SourceArchive builtInArchive = manager.getSourceArchive(DataTypeManager.BUILT_IN_ARCHIVE_UNIVERSAL_ID);
            if (builtInArchive == null) {
                return;
            }
            for (DataType dt : manager.getDataTypes(builtInArchive)) {
                if (dt instanceof Pointer || dt instanceof FactoryDataType || dt instanceof Dynamic) continue;
                this.write(dt, TaskMonitor.DUMMY);
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        this.writer.flush();
    }

    private static String getArrayDimensions(Array arrayDt) {
        String dimensionString = "[" + arrayDt.getNumElements() + "]";
        DataType dataType = arrayDt.getDataType();
        if (dataType instanceof Array) {
            dimensionString = dimensionString + DataTypeWriter.getArrayDimensions((Array)dataType);
        }
        return dimensionString;
    }

    private DataType getBaseDataType(DataType dt) {
        while (dt != null) {
            if (dt instanceof Array) {
                Array array = (Array)dt;
                dt = array.getDataType();
                continue;
            }
            if (dt instanceof Pointer) {
                Pointer pointer = (Pointer)dt;
                dt = pointer.getDataType();
                continue;
            }
            if (!(dt instanceof BitFieldDataType)) break;
            BitFieldDataType bitfieldDt = (BitFieldDataType)dt;
            dt = bitfieldDt.getBaseDataType();
        }
        return dt;
    }

    private DataType getArrayBaseType(Array arrayDt) {
        DataType dataType = arrayDt.getDataType();
        while (dataType instanceof Array) {
            dataType = ((Array)dataType).getDataType();
        }
        return dataType;
    }

    private DataType getPointerBaseDataType(Pointer p) {
        DataType dt = p.getDataType();
        while (dt instanceof Pointer) {
            dt = ((Pointer)dt).getDataType();
        }
        return dt;
    }

    private int getPointerDepth(Pointer p) {
        int depth = 1;
        DataType dt = p.getDataType();
        while (dt instanceof Pointer) {
            ++depth;
            dt = ((Pointer)dt).getDataType();
        }
        return depth;
    }

    private String getFunctionPointerString(FunctionDefinition fd, String name, DataType functionPointerArrayType, boolean writeEnabled, TaskMonitor monitor) throws IOException, CancelledException {
        DataType originalType = functionPointerArrayType;
        StringBuilder sb = new StringBuilder();
        DataType returnType = fd.getReturnType();
        if (writeEnabled) {
            this.write(returnType, monitor);
        }
        sb.append("(");
        String arrayDecorations = "";
        if (functionPointerArrayType instanceof Array) {
            Array a = (Array)functionPointerArrayType;
            functionPointerArrayType = this.getArrayBaseType(a);
            arrayDecorations = DataTypeWriter.getArrayDimensions(a);
        }
        if (functionPointerArrayType instanceof Pointer) {
            Pointer p = (Pointer)functionPointerArrayType;
            for (int i = 0; i < this.getPointerDepth(p); ++i) {
                sb.append('*');
            }
            if (name != null) {
                sb.append(' ');
            }
            functionPointerArrayType = this.getPointerBaseDataType(p);
        }
        if (!(functionPointerArrayType instanceof FunctionDefinition)) {
            this.writer.append(this.comment("Attempting output of invalid function pointer type declaration: " + originalType.getDisplayName()));
        }
        if (name != null) {
            sb.append(name);
        }
        if (arrayDecorations.length() != 0) {
            sb.append(arrayDecorations);
        }
        sb.append(")");
        sb.append(this.getParameterListString(fd, false, writeEnabled, monitor));
        DataType baseReturnType = this.getBaseDataType(returnType);
        if (baseReturnType instanceof FunctionDefinition) {
            return this.getFunctionPointerString((FunctionDefinition)baseReturnType, sb.toString(), returnType, writeEnabled, monitor);
        }
        return returnType.getDisplayName() + " " + sb.toString();
    }

    private String getParameterListString(FunctionDefinition fd, boolean includeParamNames, boolean writeEnabled, TaskMonitor monitor) throws IOException, CancelledException {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        boolean hasVarArgs = fd.hasVarArgs();
        ParameterDefinition[] parameters = fd.getArguments();
        int n = parameters.length;
        for (int i = 0; i < n; ++i) {
            ParameterDefinition param = parameters[i];
            String paramName = includeParamNames ? param.getName() : null;
            DataType dataType = param.getDataType();
            if (writeEnabled) {
                this.write(dataType, monitor);
            }
            String argument = this.getTypeDeclaration(paramName, dataType, param.getLength(), writeEnabled, monitor);
            buf.append(argument);
            if (i >= n - 1 && !hasVarArgs) continue;
            buf.append(", ");
        }
        if (hasVarArgs) {
            buf.append("...");
        }
        if (n == 0 && !hasVarArgs) {
            buf.append(VoidDataType.dataType.getName());
        }
        buf.append(")");
        return buf.toString();
    }
}

