/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.KeyToRecordIterator;
import db.LongField;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressIndexPrimaryKeyIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

class SymbolDatabaseAdapterV0
extends SymbolDatabaseAdapter {
    private static final int SYMBOL_VERSION = 0;
    private static final int V0_SYMBOL_NAME_COL = 0;
    private static final int V0_SYMBOL_IS_DYNAMIC_COL = 1;
    private static final int V0_SYMBOL_LOCAL_COL = 2;
    private static final int V0_SYMBOL_PRIMARY_COL = 3;
    private static final int V0_SYMBOL_ADDR_COL = 4;
    private Table symbolTable;
    private AddressMap addrMap;

    SymbolDatabaseAdapterV0(DBHandle handle, AddressMap addrMap) throws VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.symbolTable = handle.getTable("Symbols");
        if (this.symbolTable == null) {
            throw new VersionException("Missing Table: Symbols");
        }
        if (this.symbolTable.getSchema().getVersion() != 0) {
            throw new VersionException(false);
        }
    }

    long extractLocalSymbols(DBHandle handle, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Extracting Local Symbols...");
        monitor.initialize((long)this.symbolTable.getRecordCount());
        int cnt = 0;
        RecordIterator iter = this.symbolTable.iterator();
        while (iter.hasNext()) {
            monitor.checkCancelled();
            DBRecord rec = iter.next();
            if (rec.getBooleanValue(2)) {
                SymbolManager.saveLocalSymbol(handle, rec.getKey(), rec.getLongValue(4), rec.getString(0), rec.getBooleanValue(3));
            }
            monitor.setProgress((long)(++cnt));
        }
        return this.symbolTable.getKey();
    }

    private DBRecord convertRecord(DBRecord record) {
        if (record == null) {
            return null;
        }
        if (record.getBooleanValue(1) || record.getBooleanValue(2)) {
            throw new AssertException("Unexpected Symbol");
        }
        DBRecord rec = SymbolDatabaseAdapter.SYMBOL_SCHEMA.createRecord(record.getKey());
        String symbolName = record.getString(0);
        rec.setString(0, symbolName);
        long addressKey = record.getLongValue(4);
        rec.setLongValue(1, addressKey);
        boolean isPrimary = record.getBooleanValue(3);
        if (isPrimary) {
            rec.setLongValue(7, addressKey);
        }
        rec.setByteValue(3, SymbolType.LABEL.getID());
        long namespaceId = 0L;
        rec.setLongValue(2, namespaceId);
        rec.setByteValue(5, (byte)SourceType.USER_DEFINED.ordinal());
        LongField hash = SymbolDatabaseAdapterV0.computeLocatorHash(symbolName, namespaceId, addressKey);
        rec.setField(6, (Field)hash);
        return rec;
    }

    @Override
    DBRecord createSymbol(String name, Address address, long namespaceID, SymbolType symbolType, String stringData, Long dataTypeId, Integer varOffset, SourceType source, boolean isPrimary) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void removeSymbol(long symbolID) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean hasSymbol(Address addr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Field[] getSymbolIDs(Address addr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    DBRecord getSymbolRecord(long symbolID) throws IOException {
        return this.convertRecord(this.symbolTable.getRecord(symbolID));
    }

    @Override
    int getSymbolCount() {
        return this.symbolTable.getRecordCount();
    }

    @Override
    RecordIterator getSymbolsByAddress(boolean forward) throws IOException {
        return new V0ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 4, this.addrMap, forward)));
    }

    @Override
    RecordIterator getSymbolsByAddress(Address startAddr, boolean forward) throws IOException {
        return new V0ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 4, this.addrMap, startAddr, forward)));
    }

    @Override
    void updateSymbolRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbols() throws IOException {
        return new V0ConvertedRecordIterator(this.symbolTable.iterator());
    }

    @Override
    RecordIterator getSymbols(Address start, Address end, boolean forward) throws IOException {
        return new V0ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 4, this.addrMap, start, end, forward)));
    }

    @Override
    RecordIterator getSymbols(AddressSetView set, boolean forward) throws IOException {
        return new V0ConvertedRecordIterator((RecordIterator)new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 4, this.addrMap, set, forward)));
    }

    @Override
    RecordIterator getPrimarySymbols(AddressSetView set, boolean forward) throws IOException {
        KeyToRecordIterator it = new KeyToRecordIterator(this.symbolTable, (DBFieldIterator)new AddressIndexPrimaryKeyIterator(this.symbolTable, 1, this.addrMap, set, forward));
        return SymbolDatabaseAdapterV0.getPrimaryFilterRecordIterator(new V0ConvertedRecordIterator((RecordIterator)it));
    }

    @Override
    DBRecord getPrimarySymbol(Address address) throws IOException {
        RecordIterator it = this.getPrimarySymbols(new AddressSet(address, address), true);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    @Override
    void moveAddress(Address oldAddr, Address newAddr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    Set<Address> deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbolsByNamespace(long id) throws IOException {
        if (id == 0L) {
            return new V0ConvertedRecordIterator(this.symbolTable.iterator());
        }
        return null;
    }

    @Override
    RecordIterator getSymbolsByName(String name) throws IOException {
        StringField val = new StringField(name);
        return new V0ConvertedRecordIterator(this.symbolTable.indexIterator(0, (Field)val, (Field)val, true));
    }

    @Override
    RecordIterator scanSymbolsByName(String startName) throws IOException {
        StringField val = new StringField(startName);
        return new V0ConvertedRecordIterator(this.symbolTable.indexIterator(0, (Field)val, null, true));
    }

    @Override
    Table getTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    Address getMaxSymbolAddress(AddressSpace space) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RecordIterator getSymbolsByNameAndNamespace(String name, long id) throws IOException {
        RecordIterator symbolsByName = this.getSymbolsByName(name);
        return SymbolDatabaseAdapterV0.getNameAndNamespaceFilterIterator(name, id, symbolsByName);
    }

    @Override
    DBRecord getSymbolRecord(Address address, String name, long id) throws IOException {
        StringField value = new StringField(name);
        RecordIterator it = this.symbolTable.indexIterator(0, (Field)value, (Field)value, true);
        long addressKey = this.addrMap.getKey(address, false);
        RecordIterator filtered = SymbolDatabaseAdapterV0.getNameNamespaceAddressFilterIterator(name, id, addressKey, it);
        if (filtered.hasNext()) {
            return filtered.next();
        }
        return null;
    }

    private class V0ConvertedRecordIterator
    implements RecordIterator {
        private RecordIterator symIter;
        private DBRecord rec;

        V0ConvertedRecordIterator(RecordIterator symIter) {
            this.symIter = symIter;
        }

        public boolean hasNext() throws IOException {
            if (this.rec == null) {
                while (this.rec == null && this.symIter.hasNext()) {
                    this.rec = this.symIter.next();
                    if (!this.rec.getBooleanValue(2) && !this.rec.getBooleanValue(1)) continue;
                    this.rec = null;
                }
            }
            return this.rec != null;
        }

        public boolean hasPrevious() throws IOException {
            throw new UnsupportedOperationException();
        }

        public DBRecord next() throws IOException {
            if (this.hasNext()) {
                DBRecord r = this.rec;
                this.rec = null;
                return SymbolDatabaseAdapterV0.this.convertRecord(r);
            }
            return null;
        }

        public DBRecord previous() throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean delete() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

