/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.SettingsDBAdapterV0;
import ghidra.program.database.data.SettingsDBAdapterV1;
import ghidra.program.database.map.AddressMap;
import ghidra.program.model.address.Address;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Set;

abstract class SettingsDBAdapter {
    static final Schema SETTINGS_SCHEMA = SettingsDBAdapterV1.V1_SETTINGS_SCHEMA;
    static final int SETTINGS_ASSOCIATION_ID_COL = 0;
    static final int SETTINGS_NAME_INDEX_COL = 1;
    static final int SETTINGS_LONG_VALUE_COL = 2;
    static final int SETTINGS_STRING_VALUE_COL = 3;

    SettingsDBAdapter() {
    }

    static SettingsDBAdapter getAdapter(String tableName, DBHandle handle, int openMode, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (openMode == 0) {
            return new SettingsDBAdapterV1(tableName, handle, true);
        }
        if (openMode == 2) {
            return SettingsDBAdapter.findReadOnlyAdapter(tableName, handle);
        }
        try {
            SettingsDBAdapterV1 adapter = new SettingsDBAdapterV1(tableName, handle, false);
            if (addrMap != null && addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            SettingsDBAdapter adapter = SettingsDBAdapter.findReadOnlyAdapter(tableName, handle);
            if (openMode == 3) {
                adapter = SettingsDBAdapter.upgrade(handle, adapter, addrMap, monitor);
            }
            return adapter;
        }
    }

    private static SettingsDBAdapter findReadOnlyAdapter(String tableName, DBHandle dbHandle) throws VersionException, IOException {
        try {
            return new SettingsDBAdapterV1(tableName, dbHandle, false);
        }
        catch (VersionException e) {
            return new SettingsDBAdapterV0(tableName, dbHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SettingsDBAdapter upgrade(DBHandle dbHandle, SettingsDBAdapter oldAdapter, AddressMap addrMap, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        String tableName = oldAdapter.getTableName();
        monitor.setMessage("Upgrading " + tableName + "...");
        monitor.initialize((long)(2 * oldAdapter.getRecordCount()));
        int cnt = 0;
        AddressMap oldAddrMap = addrMap != null ? addrMap.getOldAddressMap() : null;
        SettingsDBAdapterV1 tmpAdapter = null;
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            tmpAdapter = new SettingsDBAdapterV1(tableName, tmpHandle, true);
            RecordIterator iter = oldAdapter.getRecords();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                DBRecord rec = iter.next();
                if (oldAddrMap != addrMap) {
                    Address addr = oldAddrMap.decodeAddress(rec.getLongValue(0));
                    rec.setLongValue(0, addrMap.getKey(addr, true));
                }
                ((SettingsDBAdapter)tmpAdapter).createSettingsRecord(rec.getLongValue(0), oldAdapter.getSettingName(rec), rec.getString(3), rec.getLongValue(2));
                monitor.setProgress((long)(++cnt));
            }
            dbHandle.deleteTable(tableName);
            SettingsDBAdapterV1 newAdapter = new SettingsDBAdapterV1(tableName, dbHandle, true);
            iter = ((SettingsDBAdapter)tmpAdapter).getRecords();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                DBRecord rec = iter.next();
                ((SettingsDBAdapter)newAdapter).createSettingsRecord(rec.getLongValue(0), ((SettingsDBAdapter)tmpAdapter).getSettingName(rec), rec.getString(3), rec.getLongValue(2));
                monitor.setProgress((long)(++cnt));
            }
            SettingsDBAdapterV1 settingsDBAdapterV1 = newAdapter;
            return settingsDBAdapterV1;
        }
    }

    abstract String getTableName();

    abstract int getRecordCount();

    abstract RecordIterator getRecords() throws IOException;

    abstract RecordIterator getRecords(long var1, long var3) throws IOException;

    abstract void delete(long var1, long var3, TaskMonitor var5) throws CancelledException, IOException;

    abstract DBRecord createSettingsRecord(long var1, String var3, String var4, long var5) throws IOException;

    abstract Field[] getSettingsKeys(long var1) throws IOException;

    abstract void removeAllSettingsRecords(long var1) throws IOException;

    abstract boolean removeSettingsRecord(long var1) throws IOException;

    abstract boolean removeSettingsRecord(long var1, String var3) throws IOException;

    abstract DBRecord getSettingsRecord(long var1) throws IOException;

    abstract DBRecord getSettingsRecord(long var1, String var3) throws IOException;

    abstract void updateSettingsRecord(DBRecord var1) throws IOException;

    abstract DBRecord updateSettingsRecord(long var1, String var3, String var4, long var5) throws IOException;

    abstract String[] getSettingsNames(long var1) throws IOException;

    abstract void addAllValues(String var1, Set<String> var2) throws IOException;

    abstract String getSettingName(DBRecord var1) throws IOException;

    abstract void invalidateNameCache();
}

