/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import ghidra.program.database.data.CallingConventionDBAdapter;
import ghidra.program.database.data.FunctionDefinitionDBAdapterNoTable;
import ghidra.program.database.data.FunctionDefinitionDBAdapterV0;
import ghidra.program.database.data.FunctionDefinitionDBAdapterV1;
import ghidra.program.database.data.FunctionDefinitionDBAdapterV2;
import ghidra.program.database.util.DBRecordAdapter;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class FunctionDefinitionDBAdapter
implements DBRecordAdapter {
    static final String FUNCTION_DEF_TABLE_NAME = "Function Definitions";
    static final Schema FUN_DEF_SCHEMA = FunctionDefinitionDBAdapterV2.V2_FUN_DEF_SCHEMA;
    static final int FUNCTION_DEF_NAME_COL = 0;
    static final int FUNCTION_DEF_COMMENT_COL = 1;
    static final int FUNCTION_DEF_CAT_ID_COL = 2;
    static final int FUNCTION_DEF_RETURN_ID_COL = 3;
    static final int FUNCTION_DEF_FLAGS_COL = 4;
    static final int FUNCTION_DEF_CALLCONV_COL = 5;
    static final int FUNCTION_DEF_SOURCE_ARCHIVE_ID_COL = 6;
    static final int FUNCTION_DEF_SOURCE_DT_ID_COL = 7;
    static final int FUNCTION_DEF_SOURCE_SYNC_TIME_COL = 8;
    static final int FUNCTION_DEF_LAST_CHANGE_TIME_COL = 9;
    static final byte FUNCTION_DEF_VARARG_FLAG = 1;
    static final byte FUNCTION_DEF_NORETURN_FLAG = 2;

    FunctionDefinitionDBAdapter() {
    }

    static FunctionDefinitionDBAdapter getAdapter(DBHandle handle, int openMode, String tablePrefix, CallingConventionDBAdapter callConvAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        if (openMode == 0) {
            return new FunctionDefinitionDBAdapterV2(handle, tablePrefix, true);
        }
        try {
            return new FunctionDefinitionDBAdapterV2(handle, tablePrefix, false);
        }
        catch (VersionException e) {
            FunctionDefinitionDBAdapter adapter;
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            if (openMode == 3) {
                adapter = FunctionDefinitionDBAdapter.findReadOnlyAdapter(handle, tablePrefix, callConvAdapter);
                adapter = FunctionDefinitionDBAdapter.upgrade(handle, adapter, tablePrefix, monitor);
            } else {
                adapter = FunctionDefinitionDBAdapter.findReadOnlyAdapter(handle, tablePrefix, null);
            }
            return adapter;
        }
    }

    private static FunctionDefinitionDBAdapter findReadOnlyAdapter(DBHandle handle, String tablePrefix, CallingConventionDBAdapter callConvAdapter) throws VersionException {
        try {
            return new FunctionDefinitionDBAdapterV1(handle, tablePrefix, callConvAdapter);
        }
        catch (VersionException versionException) {
            try {
                return new FunctionDefinitionDBAdapterV0(handle);
            }
            catch (VersionException versionException2) {
                return new FunctionDefinitionDBAdapterNoTable(handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FunctionDefinitionDBAdapter upgrade(DBHandle handle, FunctionDefinitionDBAdapter oldAdapter, String tablePrefix, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DBHandle tmpHandle = new DBHandle();
        long id = tmpHandle.startTransaction();
        FunctionDefinitionDBAdapterV2 tmpAdapter = null;
        try {
            tmpAdapter = new FunctionDefinitionDBAdapterV2(tmpHandle, tablePrefix, true);
            RecordIterator it = oldAdapter.getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((FunctionDefinitionDBAdapter)tmpAdapter).updateRecord(rec, false);
            }
            oldAdapter.deleteTable(handle);
            FunctionDefinitionDBAdapterV2 newAdapter = new FunctionDefinitionDBAdapterV2(handle, tablePrefix, true);
            it = ((FunctionDefinitionDBAdapter)tmpAdapter).getRecords();
            while (it.hasNext()) {
                monitor.checkCancelled();
                DBRecord rec = it.next();
                ((FunctionDefinitionDBAdapter)newAdapter).updateRecord(rec, false);
            }
            FunctionDefinitionDBAdapterV2 functionDefinitionDBAdapterV2 = newAdapter;
            return functionDefinitionDBAdapterV2;
        }
        finally {
            tmpHandle.endTransaction(id, true);
            tmpHandle.close();
        }
    }

    abstract DBRecord createRecord(String var1, String var2, long var3, long var5, boolean var7, boolean var8, byte var9, long var10, long var12, long var14) throws IOException;

    abstract DBRecord getRecord(long var1) throws IOException;

    @Override
    public abstract RecordIterator getRecords() throws IOException;

    abstract boolean removeRecord(long var1) throws IOException;

    abstract void updateRecord(DBRecord var1, boolean var2) throws IOException;

    abstract void deleteTable(DBHandle var1) throws IOException;

    abstract Field[] getRecordIdsInCategory(long var1) throws IOException;

    abstract Field[] getRecordIdsForSourceArchive(long var1) throws IOException;

    abstract DBRecord getRecordWithIDs(UniversalID var1, UniversalID var2) throws IOException;

    boolean usesGenericCallingConventionId() {
        return false;
    }

    static String getGenericCallingConventionName(int ordinal) {
        GenericCallingConvention genericCallingConvention = GenericCallingConvention.get(ordinal);
        return genericCallingConvention != GenericCallingConvention.unknown ? genericCallingConvention.getDeclarationName() : "unknown";
    }
}

