/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.languages.sleigh.SleighLanguages;
import ghidra.app.plugin.languages.sleigh.SubtableEntryVisitor;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.ContextChange;
import ghidra.app.plugin.processors.sleigh.ContextOp;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class AssemblyConstructorSemantic
implements Comparable<AssemblyConstructorSemantic> {
    protected static final RecursiveDescentSolver SOLVER = RecursiveDescentSolver.getSolver();
    protected static final DbgTimer DBG = AssemblyTreeResolver.DBG;
    protected final Set<AssemblyResolvedPatterns> patterns = new HashSet<AssemblyResolvedPatterns>();
    protected final Constructor cons;
    protected final List<Integer> indices;
    protected final List<ContextChange> contextChanges;
    protected final List<ContextChange> reversedChanges;
    protected Set<AssemblyResolvedPatterns> upatterns;

    public AssemblyConstructorSemantic(Constructor cons, List<Integer> indices) {
        this.cons = cons;
        this.indices = Collections.unmodifiableList(indices);
        ArrayList<ContextChange> changes = new ArrayList<ContextChange>(cons.getContextChanges());
        this.contextChanges = List.copyOf(changes);
        Collections.reverse(changes);
        this.reversedChanges = List.copyOf(changes);
    }

    public void addPattern(DisjointPattern pat) {
        this.addPattern(AssemblyResolution.fromPattern(pat, this.cons.getMinimumLength(), "Generated constructor pattern " + this.getLocation(), this.cons));
    }

    public void addPattern(AssemblyResolvedPatterns pat) {
        if (this.upatterns != null) {
            throw new IllegalStateException("Cannot add patterns after a call to getPatterns()");
        }
        this.patterns.add(pat);
    }

    public String toString() {
        return this.getLocation();
    }

    public static String getLocation(Constructor cons) {
        return cons.getSourceFile() + ":" + cons.getLineno();
    }

    public String getLocation() {
        return AssemblyConstructorSemantic.getLocation(this.cons);
    }

    public Constructor getConstructor() {
        return this.cons;
    }

    public Collection<AssemblyResolvedPatterns> getPatterns() {
        if (this.upatterns == null) {
            this.computeAllForbids();
        }
        return this.upatterns;
    }

    public int getOperandIndex(int printpos) {
        return this.indices.get(printpos);
    }

    public List<Integer> getOperandIndices() {
        return this.indices;
    }

    public Iterator<Integer> getOperandIndexIterator() {
        return Collections.unmodifiableList(this.indices).iterator();
    }

    protected void computeAllForbids() {
        if (this.upatterns != null) {
            throw new IllegalStateException("Already computed all forbidden patterns for this constructor");
        }
        HashSet<AssemblyResolvedPatterns> result = new HashSet<AssemblyResolvedPatterns>();
        for (AssemblyResolvedPatterns pat : this.patterns) {
            AssemblyResolvedPatterns fpat = this.withComputedForbids(pat);
            result.add(fpat);
        }
        this.upatterns = Collections.unmodifiableSet(result);
    }

    protected AssemblyResolvedPatterns withComputedForbids(final AssemblyResolvedPatterns pat) {
        final HashSet<AssemblyResolvedPatterns> forbids = new HashSet<AssemblyResolvedPatterns>();
        SubtableSymbol parent = this.cons.getParent();
        SleighLanguages.traverseConstructors(parent, new SubtableEntryVisitor(){

            @Override
            public int visit(DisjointPattern sibDP, Constructor sibcons) {
                if (sibcons == AssemblyConstructorSemantic.this.cons) {
                    return 0;
                }
                AssemblyResolvedPatterns sibpat = AssemblyResolution.fromPattern(sibDP, sibcons.getMinimumLength(), "For specialization check", sibcons);
                AssemblyResolvedPatterns comb = pat.combine(sibpat);
                if (null == comb) {
                    return 0;
                }
                if (comb.bitsEqual(sibpat)) {
                    forbids.add(sibpat.withDescription(AssemblyConstructorSemantic.getLocation(sibcons) + " forbids " + AssemblyConstructorSemantic.getLocation(AssemblyConstructorSemantic.this.cons) + " by pattern specificity"));
                    return 0;
                }
                if (comb.bitsEqual(pat)) {
                    return 0;
                }
                if (!comb.ctx.equals(pat.ctx)) {
                    return 0;
                }
                if (sibcons.getId() < AssemblyConstructorSemantic.this.cons.getId()) {
                    forbids.add(sibpat.withDescription(AssemblyConstructorSemantic.getLocation(sibcons) + " forbids " + AssemblyConstructorSemantic.getLocation(AssemblyConstructorSemantic.this.cons) + " by rule position"));
                    return 0;
                }
                return 0;
            }
        });
        return pat.withForbids(forbids);
    }

    public AssemblyResolution solveContextChanges(AssemblyResolvedPatterns res, Map<String, Long> vals) {
        for (ContextChange chg : this.reversedChanges) {
            if (!(chg instanceof ContextOp)) continue;
            DBG.println("Current: " + res.lineToString());
            ContextOp cop = (ContextOp)chg;
            DBG.println("Handling context change: " + cop);
            MaskedLong reqval = res.readContextOp(cop);
            if (reqval.equals(MaskedLong.UNKS)) {
                DBG.println("Doesn't affect a current requirement");
                continue;
            }
            DBG.println("'read' " + reqval);
            res = res.maskOut(cop);
            DBG.println("Masked out: " + res.lineToString());
            AssemblyResolution sol = AssemblyTreeResolver.solveOrBackfill(cop.getPatternExpression(), reqval, vals, res, "Solution to " + cop);
            DBG.println("Solution: " + sol.lineToString());
            if (sol.isError()) {
                AssemblyResolvedError err = (AssemblyResolvedError)sol;
                return AssemblyResolution.error(err.getError(), res);
            }
            if (sol instanceof AssemblyResolvedPatterns) {
                AssemblyResolvedPatterns solcon = (AssemblyResolvedPatterns)sol;
                AssemblyResolvedPatterns check = res.combine(solcon);
                if (null == check) {
                    return AssemblyResolution.error("A context change caused a conflict: " + sol, res);
                }
                res = check;
            } else {
                AssemblyResolvedBackfill solbf = (AssemblyResolvedBackfill)sol;
                res = res.combine(solbf);
            }
            DBG.println("Combined: " + res.lineToString());
        }
        return res;
    }

    public AssemblyResolvedPatterns applyContextChangesForward(Map<String, Long> vals, AssemblyResolvedPatterns fromLeft) {
        AssemblyResolvedPatterns res = fromLeft;
        for (ContextChange chg : this.contextChanges) {
            if (!(chg instanceof ContextOp)) continue;
            ContextOp cop = (ContextOp)chg;
            MaskedLong val = SOLVER.valueForResolution(cop.getPatternExpression(), vals, res);
            res = res.writeContextOp(cop, val);
        }
        return res;
    }

    public Stream<AssemblyResolvedPatterns> applyPatternsForward(int shift, AssemblyResolvedPatterns fromLeft) {
        if (this.patterns.isEmpty()) {
            DBG.println("No patterns for " + this.getLocation() + "?(hash=" + System.identityHashCode(this) + ")");
        }
        return this.patterns.stream().map(pat -> fromLeft.combine(pat.shift(shift)));
    }

    @Override
    public int compareTo(AssemblyConstructorSemantic that) {
        return this.toString().compareTo(that.toString());
    }
}

