/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.model.iface2.DbgModelTargetProcess;
import agent.dbgeng.model.iface2.DbgModelTargetRegisterContainerAndBank;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.iface2.DbgModelTargetThreadContainer;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetRegisterContainerImpl;
import agent.dbgeng.model.impl.DbgModelTargetStackImpl;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Thread", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Registers", type=DbgModelTargetRegisterContainerImpl.class, required=true, fixed=true), @TargetAttributeType(name="Stack", type=DbgModelTargetStackImpl.class, required=true, fixed=true), @TargetAttributeType(name="_arch", type=String.class), @TargetAttributeType(type=Void.class)})
public class DbgModelTargetThreadImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetThread {
    public static final TargetSteppable.TargetStepKindSet SUPPORTED_KINDS = TargetSteppable.TargetStepKindSet.of((TargetSteppable.TargetStepKind[])new TargetSteppable.TargetStepKind[]{TargetSteppable.TargetStepKind.FINISH, TargetSteppable.TargetStepKind.LINE, TargetSteppable.TargetStepKind.OVER, TargetSteppable.TargetStepKind.OVER_LINE, TargetSteppable.TargetStepKind.RETURN, TargetSteppable.TargetStepKind.UNTIL, TargetSteppable.TargetStepKind.EXTENDED});
    protected final DbgThread thread;
    protected final DbgModelTargetRegisterContainerImpl registers;
    protected final DbgModelTargetStackImpl stack;
    private DbgModelTargetProcess process;
    private Integer base = 16;

    protected static String indexThread(DebugThreadId debugThreadId) {
        return debugThreadId.id();
    }

    protected static String indexThread(DbgThread thread) {
        return DbgModelTargetThreadImpl.indexThread(thread.getId());
    }

    protected static String keyThread(DbgThread thread) {
        return PathUtils.makeKey((String)DbgModelTargetThreadImpl.indexThread(thread));
    }

    public DbgModelTargetThreadImpl(DbgModelTargetThreadContainer threads, DbgModelTargetProcess process, DbgThread thread) {
        super(threads.getModel(), (TargetObject)threads, DbgModelTargetThreadImpl.keyThread(thread), "Thread");
        this.getModel().addModelObject(thread, (TargetObject)this);
        this.getModel().addModelObject(thread.getId(), (TargetObject)this);
        this.process = process;
        this.thread = thread;
        this.registers = new DbgModelTargetRegisterContainerImpl(this);
        this.stack = new DbgModelTargetStackImpl(this, process);
        this.changeAttributes(List.of(), List.of(), TargetMethod.AnnotatedTargetMethod.collectExports((MethodHandles.Lookup)MethodHandles.lookup(), (AbstractDebuggerObjectModel)threads.getModel(), (TargetObject)this), "Methods");
        this.accessible = false;
        this.changeAttributes(List.of(), List.of(this.registers, this.stack), Map.of("_accessible", false, "_display", this.getDisplay(), "_supported_step_kinds", SUPPORTED_KINDS), "Initialized");
        this.setExecutionState(this.convertState(thread.getState()), "Initialized");
        this.getManager().addEventsListener(this);
    }

    public String getDisplay() {
        if (this.thread == null) {
            return "[unknown]";
        }
        DebugThreadId id = this.thread.getId();
        Long tid = this.thread.getTid();
        if (this.getManager().isKernelMode()) {
            Long offset;
            if (id.isSystem()) {
                return "[" + id.id() + "]";
            }
            Object tidstr = Long.toString(tid, this.base);
            if (this.base == 16) {
                tidstr = "0x" + (String)tidstr;
            }
            return (offset = this.thread.getOffset()) == null ? "[" + (String)tidstr + "]" : "[" + (String)tidstr + " : " + Long.toHexString(offset) + "]";
        }
        if (tid < 0L) {
            return "[" + id.id() + "]";
        }
        Object tidstr = Long.toString(tid, this.base);
        if (this.base == 16) {
            tidstr = "0x" + (String)tidstr;
        }
        return "[" + id.id() + ":" + (String)tidstr + "]";
    }

    @Override
    public void threadStateChangedSpecific(DbgState state, DbgReason reason) {
        TargetExecutionStateful.TargetExecutionState targetState = this.convertState(state);
        String executionType = this.thread.getExecutingProcessorType().description;
        this.changeAttributes(List.of(), List.of(), Map.of("_state", targetState, "_arch", executionType), reason.desc());
        this.registers.threadStateChangedSpecific(state, reason);
        this.stack.threadStateChangedSpecific(state, reason);
    }

    @Override
    public CompletableFuture<Void> step(TargetSteppable.TargetStepKind kind) {
        switch (kind) {
            case SKIP: {
                throw new UnsupportedOperationException(kind.name());
            }
        }
        return this.model.gateFuture(this.thread.step(this.convertToDbg(kind)));
    }

    @Override
    public CompletableFuture<Void> step(Map<String, ?> args) {
        return this.model.gateFuture(this.thread.step(args));
    }

    @Override
    public CompletableFuture<Void> setActive() {
        DbgManagerImpl manager = this.getManager();
        return manager.setActiveThread(this.thread);
    }

    public DbgModelTargetRegisterContainerAndBank getRegisters() {
        return this.registers;
    }

    @Override
    public DbgModelTargetStackImpl getStack() {
        return this.stack;
    }

    @Override
    public DbgThread getThread() {
        return this.thread;
    }

    public DbgModelTargetProcess getProcess() {
        return this.process;
    }

    @Override
    public boolean isAccessible() {
        return this.accessible;
    }

    @Override
    public String getExecutingProcessorType() {
        return this.thread.getExecutingProcessorType().description;
    }

    public void setBase(Object value) {
        this.base = (Integer)value;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay()), "Started");
    }
}

