/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.model.impl;

import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgReason;
import agent.dbgeng.manager.DbgState;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgRegister;
import agent.dbgeng.model.iface2.DbgModelTargetRegister;
import agent.dbgeng.model.iface2.DbgModelTargetRegisterContainerAndBank;
import agent.dbgeng.model.iface2.DbgModelTargetThread;
import agent.dbgeng.model.impl.DbgModelImpl;
import agent.dbgeng.model.impl.DbgModelTargetObjectImpl;
import agent.dbgeng.model.impl.DbgModelTargetRegisterImpl;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerRegisterAccessException;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.ConversionUtils;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="RegisterContainer", elements={@TargetElementType(type=DbgModelTargetRegisterImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(name="_descriptions", type=DbgModelTargetRegisterContainerImpl.class), @TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class DbgModelTargetRegisterContainerImpl
extends DbgModelTargetObjectImpl
implements DbgModelTargetRegisterContainerAndBank {
    protected final DbgThread thread;
    protected final Map<String, DbgModelTargetRegister> registersByName = new HashMap<String, DbgModelTargetRegister>();
    private Map<String, byte[]> values = new HashMap<String, byte[]>();

    public DbgModelTargetRegisterContainerImpl(DbgModelTargetThread thread) {
        super(thread.getModel(), (TargetObject)thread, "Registers", "RegisterContainer");
        this.thread = thread.getThread();
        if (!this.getModel().isSuppressDescent()) {
            this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            this.changeAttributes(List.of(), List.of(), Map.of("_descriptions", this), "Initialized");
        }
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return this.thread.listRegisters().thenAccept(regs -> {
            List registers;
            if (regs.size() != this.registersByName.size()) {
                DbgModelImpl impl = (DbgModelImpl)this.model;
                for (DbgRegister reg : regs) {
                    impl.deleteModelObject(reg);
                }
                this.registersByName.clear();
            }
            DbgModelTargetRegisterContainerImpl dbgModelTargetRegisterContainerImpl = this;
            synchronized (dbgModelTargetRegisterContainerImpl) {
                registers = regs.stream().map(this::getTargetRegister).collect(Collectors.toList());
            }
            this.setElements(registers, Map.of(), "Refreshed");
            if (!this.getCachedElements().isEmpty()) {
                this.readRegistersNamed(this.getCachedElements().keySet());
            }
        });
    }

    public void threadStateChangedSpecific(DbgState state, DbgReason reason) {
        if (!state.equals((Object)DbgState.RUNNING)) {
            this.readRegistersNamed(this.getCachedElements().keySet());
        }
    }

    @Override
    public synchronized DbgModelTargetRegister getTargetRegister(DbgRegister register) {
        DbgModelImpl impl = (DbgModelImpl)this.model;
        TargetObject modelObject = impl.getModelObject(register);
        if (modelObject != null) {
            return (DbgModelTargetRegister)modelObject;
        }
        DbgModelTargetRegisterImpl reg = new DbgModelTargetRegisterImpl(this, register);
        this.registersByName.put(register.getName(), reg);
        return reg;
    }

    public CompletableFuture<? extends Map<String, byte[]>> readRegistersNamed(Collection<String> names) {
        return this.model.gateFuture((CompletableFuture)((CompletableFuture)((CompletableFuture)this.thread.listRegisters().thenCompose(regs -> {
            if (regs.size() != this.registersByName.size() || this.getCachedElements().isEmpty()) {
                return this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
            }
            return AsyncUtils.nil();
        })).thenCompose(__ -> {
            LinkedHashSet<DbgRegister> toRead = new LinkedHashSet<DbgRegister>();
            for (String regname : names) {
                DbgModelTargetRegister reg = this.registersByName.get(regname);
                if (reg == null) continue;
                DbgRegister register = reg.getRegister();
                toRead.add(register);
            }
            return this.thread.readRegisters(toRead);
        })).thenApply(vals -> {
            LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>();
            for (DbgRegister dbgReg : vals.keySet()) {
                DbgModelTargetRegister reg = this.getTargetRegister(dbgReg);
                BigInteger value = (BigInteger)vals.get(dbgReg);
                byte[] bytes = ConversionUtils.bigIntegerToBytes((int)dbgReg.getSize(), (BigInteger)value);
                result.put(dbgReg.getName(), bytes);
                this.changeAttrs(reg, value);
            }
            this.values = result;
            this.broadcast().registersUpdated((TargetObject)this.getProxy(), result);
            return result;
        }));
    }

    public CompletableFuture<Void> writeRegistersNamed(Map<String, byte[]> values) {
        DbgManagerImpl manager = this.getManager();
        return this.model.gateFuture((CompletableFuture)((CompletableFuture)((CompletableFuture)this.thread.listRegisters().thenCompose(regs -> this.requestElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER))).thenCompose(__ -> {
            Map regs = this.getCachedElements();
            LinkedHashMap<DbgRegister, BigInteger> toWrite = new LinkedHashMap<DbgRegister, BigInteger>();
            for (Map.Entry ent : values.entrySet()) {
                String regname = (String)ent.getKey();
                DbgModelTargetRegister reg = (DbgModelTargetRegister)regs.get(regname);
                if (reg == null) {
                    throw new DebuggerRegisterAccessException("No such register: " + regname);
                }
                BigInteger val = new BigInteger(1, (byte[])ent.getValue());
                toWrite.put(reg.getRegister(), val);
                this.changeAttrs(reg, val);
            }
            return this.thread.writeRegisters(toWrite);
        })).thenAccept(__ -> {
            ((DbgEventsListener)manager.getEventListeners().invoke()).threadStateChanged(this.thread, this.thread.getState(), DbgCause.Causes.UNCLAIMED, DbgReason.Reasons.NONE);
            this.broadcast().registersUpdated((TargetObject)this.getProxy(), values);
        }));
    }

    private void changeAttrs(DbgModelTargetRegister reg, BigInteger value) {
        String oldval = (String)reg.getCachedAttributes().get("_value");
        String valstr = Long.toUnsignedString(value.longValue(), 16);
        String newval = value.longValue() == 0L ? reg.getName() : reg.getName() + " : " + valstr;
        reg.changeAttributes(List.of(), Map.of("_value", valstr, "_display", newval), "Refreshed");
        reg.setModified(!valstr.equals(oldval));
    }

    public Map<String, byte[]> getCachedRegisters() {
        return this.values;
    }
}

