/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.dbgeng.DebugModuleInfo;
import agent.dbgeng.manager.DbgCause;
import agent.dbgeng.manager.DbgEventsListener;
import agent.dbgeng.manager.DbgModule;
import agent.dbgeng.manager.cmd.DbgListSymbolsCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgMinimalSymbol;
import agent.dbgeng.manager.impl.DbgProcessImpl;
import ghidra.async.AsyncLazyValue;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DbgModuleImpl
implements DbgModule {
    DbgManagerImpl manager;
    protected final DbgProcessImpl process;
    protected final String name;
    private DebugModuleInfo info;
    protected final AsyncLazyValue<Map<String, DbgMinimalSymbol>> minimalSymbols = new AsyncLazyValue(this::doGetMinimalSymbols);

    public DbgModuleImpl(DbgManagerImpl manager, DbgProcessImpl process, DebugModuleInfo info) {
        this.manager = manager;
        this.process = process;
        this.info = info;
        this.name = info.getModuleName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void add() {
        this.process.addModule(this);
        ((DbgEventsListener)this.manager.getEventListeners().invoke()).moduleLoaded(this.process, this.info, DbgCause.Causes.UNCLAIMED);
    }

    public void remove() {
        this.process.removeModule(this.name);
        ((DbgEventsListener)this.manager.getEventListeners().invoke()).moduleUnloaded(this.process, this.info, DbgCause.Causes.UNCLAIMED);
    }

    @Override
    public String getImageName() {
        return this.info == null ? this.getName() : this.info.getImageName();
    }

    @Override
    public String getModuleName() {
        return this.info == null ? this.getName() : this.info.getModuleName();
    }

    @Override
    public Long getKnownBase() {
        return this.info == null ? 0L : this.info.baseOffset;
    }

    @Override
    public Integer getSize() {
        return this.info == null ? 0 : this.info.moduleSize;
    }

    @Override
    public Integer getTimeStamp() {
        return this.info == null ? 0 : this.info.timeDateStamp;
    }

    protected CompletableFuture<Map<String, DbgMinimalSymbol>> doGetMinimalSymbols() {
        return this.manager.execute(new DbgListSymbolsCommand(this.manager, this.process, this));
    }

    @Override
    public CompletableFuture<Map<String, DbgMinimalSymbol>> listMinimalSymbols() {
        return this.minimalSymbols.request();
    }

    public DebugModuleInfo getInfo() {
        return this.info;
    }
}

