/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugClient;
import agent.dbgeng.dbgeng.DebugProcessInfo;
import agent.dbgeng.dbgeng.DebugSystemObjects;
import agent.dbgeng.dbgeng.DebugThreadId;
import agent.dbgeng.dbgeng.DebugThreadInfo;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgThread;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgProcessCreatedEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import ghidra.util.Msg;
import java.util.Map;

public class DbgAttachKernelCommand
extends AbstractDbgCommand<DbgThread> {
    private DbgProcessCreatedEvent created = null;
    private boolean completed = false;
    private Map<String, ?> args;

    public DbgAttachKernelCommand(DbgManagerImpl manager, Map<String, ?> args) {
        super(manager);
        this.args = args;
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            this.completed = true;
        } else if (evt instanceof DbgProcessCreatedEvent) {
            this.created = (DbgProcessCreatedEvent)evt;
        }
        return this.completed && this.created != null;
    }

    @Override
    public DbgThread complete(DbgPendingCommand<?> pending) {
        DebugProcessInfo info = (DebugProcessInfo)this.created.getInfo();
        DebugThreadInfo tinfo = info.initialThreadInfo;
        DebugSystemObjects so = this.manager.getSystemObjects();
        DebugThreadId tid = so.getThreadIdByHandle(tinfo.handle);
        return this.manager.getThread(tid);
    }

    @Override
    public void invoke() {
        if (!System.getenv().containsKey("_NT_SYMBOL_PATH")) {
            Msg.warn((Object)this, (Object)"_NT_SYMBOL_PATH is undefined - you may need to define it or run .sympath");
        }
        DebugClient dbgeng = this.manager.getClient();
        long flags = (Long)this.args.get("Flags");
        String options = (String)this.args.get("Options");
        dbgeng.attachKernel(flags, options);
        this.manager.waitForEventEx();
    }
}

