/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.impl.dbgeng.dataspaces;

import agent.dbgeng.dbgeng.COMUtilsExtra;
import agent.dbgeng.dbgeng.DbgEng;
import agent.dbgeng.dbgeng.DebugDataSpaces;
import agent.dbgeng.impl.dbgeng.dataspaces.DebugDataSpacesInternal;
import agent.dbgeng.jna.dbgeng.dataspaces.IDebugDataSpaces;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import javax.help.UnsupportedOperationException;

public class DebugDataSpacesImpl1
implements DebugDataSpacesInternal {
    private final DbgEng.OpaqueCleanable cleanble;
    private final IDebugDataSpaces jnaData;

    public DebugDataSpacesImpl1(IDebugDataSpaces jnaData) {
        this.cleanble = DbgEng.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public DebugDataSpaces.DebugMemoryBasicInformation queryVirtual(long offset) {
        throw new UnsupportedOperationException("Not implemented in this interface");
    }

    @Override
    public int readVirtual(long offset, ByteBuffer into, int len) {
        if (len > into.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesRead = new WinDef.ULONGByReference();
        WinNT.HRESULT hr = this.jnaData.ReadVirtual(ullOffset, into, ulLen, pulBytesRead);
        if (hr.equals((Object)COMUtilsExtra.E_CANNOT_READ)) {
            return 0;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        int read = pulBytesRead.getValue().intValue();
        into.position(read + into.position());
        return read;
    }

    @Override
    public int writeVirtual(long offset, ByteBuffer from, int len) {
        if (len > from.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesWritten = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WriteVirtual(ullOffset, from, ulLen, pulBytesWritten));
        int written = pulBytesWritten.getValue().intValue();
        from.position(written + from.position());
        return written;
    }

    @Override
    public int readVirtualUncached(long offset, ByteBuffer into, int len) {
        if (len > into.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesRead = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadVirtualUncached(ullOffset, into, ulLen, pulBytesRead));
        int read = pulBytesRead.getValue().intValue();
        into.position(read + into.position());
        return read;
    }

    @Override
    public int writeVirtualUncached(long offset, ByteBuffer from, int len) {
        if (len > from.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesWritten = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WriteVirtualUncached(ullOffset, from, ulLen, pulBytesWritten));
        int written = pulBytesWritten.getValue().intValue();
        from.position(written + from.position());
        return written;
    }

    @Override
    public int readPhysical(long offset, ByteBuffer into, int len) {
        if (len > into.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesRead = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadPhysical(ullOffset, into, ulLen, pulBytesRead));
        int read = pulBytesRead.getValue().intValue();
        into.position(read + into.position());
        return read;
    }

    @Override
    public int writePhysical(long offset, ByteBuffer from, int len) {
        if (len > from.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesWritten = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WritePhysical(ullOffset, from, ulLen, pulBytesWritten));
        int written = pulBytesWritten.getValue().intValue();
        from.position(written + from.position());
        return written;
    }

    @Override
    public int readControl(int processor, long offset, ByteBuffer into, int len) {
        if (len > into.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONG ulProcessor = new WinDef.ULONG((long)processor);
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesRead = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadControl(ulProcessor, ullOffset, into, ulLen, pulBytesRead));
        int read = pulBytesRead.getValue().intValue();
        into.position(read + into.position());
        return read;
    }

    @Override
    public int writeControl(int processor, long offset, ByteBuffer from, int len) {
        if (len > from.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONG ulProcessor = new WinDef.ULONG((long)processor);
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesWritten = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WriteControl(ulProcessor, ullOffset, from, ulLen, pulBytesWritten));
        int written = pulBytesWritten.getValue().intValue();
        from.position(written + from.position());
        return written;
    }

    @Override
    public int readBusData(int busDataType, int busNumber, int slotNumber, long offset, ByteBuffer into, int len) {
        if (len > into.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONG ulBusDataType = new WinDef.ULONG((long)busDataType);
        WinDef.ULONG ulBusNumber = new WinDef.ULONG((long)busNumber);
        WinDef.ULONG ulSlotNumber = new WinDef.ULONG((long)slotNumber);
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesRead = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadBusData(ulBusDataType, ulBusNumber, ulSlotNumber, ullOffset, into, ulLen, pulBytesRead));
        int read = pulBytesRead.getValue().intValue();
        into.position(read + into.position());
        return read;
    }

    @Override
    public int writeBusData(int busDataType, int busNumber, int slotNumber, long offset, ByteBuffer from, int len) {
        if (len > from.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONG ulBusDataType = new WinDef.ULONG((long)busDataType);
        WinDef.ULONG ulBusNumber = new WinDef.ULONG((long)busNumber);
        WinDef.ULONG ulSlotNumber = new WinDef.ULONG((long)slotNumber);
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesWritten = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WriteBusData(ulBusDataType, ulBusNumber, ulSlotNumber, ullOffset, from, ulLen, pulBytesWritten));
        int written = pulBytesWritten.getValue().intValue();
        from.position(written + from.position());
        return written;
    }

    @Override
    public int readIo(int interfaceType, int busNumber, int addressSpace, long offset, ByteBuffer into, int len) {
        if (len > into.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONG ulInterfaceType = new WinDef.ULONG((long)interfaceType);
        WinDef.ULONG ulBusNumber = new WinDef.ULONG((long)busNumber);
        WinDef.ULONG ulAddressSpace = new WinDef.ULONG((long)addressSpace);
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesRead = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadIo(ulInterfaceType, ulBusNumber, ulAddressSpace, ullOffset, into, ulLen, pulBytesRead));
        int read = pulBytesRead.getValue().intValue();
        into.position(read + into.position());
        return read;
    }

    @Override
    public int writeIo(int interfaceType, int busNumber, int addressSpace, long offset, ByteBuffer from, int len) {
        if (len > from.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONG ulInterfaceType = new WinDef.ULONG((long)interfaceType);
        WinDef.ULONG ulBusNumber = new WinDef.ULONG((long)busNumber);
        WinDef.ULONG ulAddressSpace = new WinDef.ULONG((long)addressSpace);
        WinDef.ULONGLONG ullOffset = new WinDef.ULONGLONG(offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesWritten = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WriteIo(ulInterfaceType, ulBusNumber, ulAddressSpace, ullOffset, from, ulLen, pulBytesWritten));
        int written = pulBytesWritten.getValue().intValue();
        from.position(written + from.position());
        return written;
    }

    @Override
    public long readMsr(int msr) {
        WinDef.ULONG ulNumber = new WinDef.ULONG((long)msr);
        WinDef.ULONGLONGByReference pulValue = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadMsr(ulNumber, pulValue));
        return pulValue.getValue().longValue();
    }

    @Override
    public void writeMsr(int msr, long value) {
        WinDef.ULONG ulNumber = new WinDef.ULONG((long)msr);
        WinDef.ULONGLONG ullValue = new WinDef.ULONGLONG(value);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WriteMsr(ulNumber, ullValue));
    }

    @Override
    public int readDebuggerData(int offset, ByteBuffer into, int len) {
        if (len > into.remaining()) {
            throw new BufferOverflowException();
        }
        WinDef.ULONG ulOffset = new WinDef.ULONG((long)offset);
        WinDef.ULONG ulLen = new WinDef.ULONG((long)len);
        WinDef.ULONGByReference pulBytesRead = new WinDef.ULONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadDebuggerData(ulOffset, into, ulLen, pulBytesRead));
        int read = pulBytesRead.getValue().intValue();
        into.position(read + into.position());
        return read;
    }

    @Override
    public long virtualToPhysical(long offset) {
        throw new UnsupportedOperationException("Not implemented in this interface");
    }
}

