/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import docking.theme.gui.GThemeValuesCache;
import docking.theme.gui.ThemeColorPaletteTable;
import docking.theme.gui.ThemeColorTable;
import docking.theme.gui.ThemeColorTree;
import docking.theme.gui.ThemeFontTable;
import docking.theme.gui.ThemeIconTable;
import docking.theme.gui.ThemeTable;
import docking.theme.gui.ThemeTableContext;
import docking.theme.gui.ThemeUtils;
import docking.widgets.OptionDialog;
import docking.widgets.combobox.GhidraComboBox;
import generic.theme.GIcon;
import generic.theme.Gui;
import generic.theme.LafType;
import generic.theme.ThemeEvent;
import generic.theme.ThemeListener;
import generic.theme.ThemeManager;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ThemeEditorDialog
extends DialogComponentProvider {
    private static ThemeEditorDialog INSTANCE;
    private JButton saveButton;
    private GhidraComboBox<LafType> combo;
    private ItemListener comboListener = this::themeComboChanged;
    private ThemeListener listener = new DialogThemeListener();
    private JTabbedPane tabbedPane;
    private ThemeColorTable colorTable;
    private ThemeFontTable fontTable;
    private ThemeIconTable iconTable;
    private ThemeColorTree colorTree;
    private ThemeColorTable paletteTable;
    private ThemeManager themeManager;
    private GThemeValuesCache valuesCache;

    public ThemeEditorDialog(ThemeManager themeManager) {
        super("Configure Theme: " + themeManager.getActiveTheme().getName(), false);
        this.themeManager = themeManager;
        this.addWorkPanel(this.createMainPanel());
        this.addDismissButton();
        this.addButton(this.createSaveButton());
        this.setPreferredSize(1100, 500);
        this.setRememberSize(false);
        this.updateButtons();
        this.createActions();
        Gui.addThemeListener((ThemeListener)this.listener);
        this.setHelpLocation(new HelpLocation("Theming", "Edit_Theme"));
    }

    private void createActions() {
        DockingAction incrementFontsAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Increment All Fonts", this.getTitle()).toolBarIcon((Icon)new GIcon("icon.theme.font.increment"))).description("Increases all font sizes by 1")).helpLocation(new HelpLocation("Theming", "Increment_Fonts"))).onAction(e -> this.adjustFonts(1))).build();
        this.addAction(incrementFontsAction);
        DockingAction decrementFontsAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Decrement All Fonts", this.getTitle()).toolBarIcon((Icon)new GIcon("icon.theme.font.decrement"))).toolBarGroup("A")).description("Decreases all font sizes by 1")).helpLocation(new HelpLocation("Theming", "Decrement_Fonts"))).onAction(e -> this.adjustFonts(-1))).build();
        this.addAction(decrementFontsAction);
        DockingAction reloadDefaultsAction = ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Restore Theme Values", this.getTitle()).toolBarIcon((Icon)new GIcon("icon.refresh"))).toolBarGroup("B")).description("Reloads default values from the filesystem and restores the original theme values.")).helpLocation(new HelpLocation("Theming", "Reload_Theme"))).onAction(e -> this.restoreCallback())).build();
        this.addAction(reloadDefaultsAction);
        DockingAction resetValueAction = (DockingAction)((AbstractActionBuilder)((AbstractActionBuilder)((AbstractActionBuilder)((AbstractActionBuilder)((AbstractActionBuilder)((ActionBuilder)new ActionBuilder("Restore Value", this.getTitle()).popupMenuPath("Restore Value")).withContext(ThemeTableContext.class)).enabledWhen(c -> c.isChanged())).popupWhen(c -> true)).helpLocation(new HelpLocation("Theming", "Restore_Value"))).onAction(c -> c.getThemeValue().installValue(this.themeManager))).build();
        this.addAction(resetValueAction);
        DockingAction showSystemValuesAction = (DockingAction)((AbstractActionBuilder)((AbstractActionBuilder)((AbstractActionBuilder)((AbstractActionBuilder)((ActionBuilder)new ActionBuilder("Toggle Show System Values", this.getTitle()).popupMenuPath("Toggle Show System Values")).withContext(ThemeTableContext.class)).popupWhen(c -> true)).helpLocation(new HelpLocation("Theming", "Toggle_Show_System_Values"))).onAction(context -> this.toggleSystemValues((ThemeTableContext<?>)context))).build();
        this.addAction(showSystemValuesAction);
    }

    private void toggleSystemValues(ThemeTableContext<?> context) {
        ThemeTable themeTable;
        boolean isShowing = (themeTable = context.getThemeTable()).isShowingSystemValues();
        themeTable.setShowSystemValues(!isShowing);
    }

    private void adjustFonts(int amount) {
        this.themeManager.adjustFonts(amount);
    }

    @Override
    protected void dismissCallback() {
        if (this.handleChanges()) {
            this.close();
        }
    }

    private boolean handleChanges() {
        if (this.themeManager.hasThemeChanges()) {
            int result = OptionDialog.showYesNoCancelDialog(null, "Save Theme Changes?", "You have changed the theme.\n Do you want to save your changes?");
            if (result == 0) {
                return false;
            }
            if (result == 1) {
                return ThemeUtils.saveThemeChanges(this.themeManager);
            }
            this.themeManager.restoreThemeValues();
        }
        return true;
    }

    protected void saveCallback() {
        ThemeUtils.saveThemeChanges(this.themeManager);
    }

    private void restoreCallback() {
        int result;
        if (this.themeManager.hasThemeChanges() && (result = OptionDialog.showYesNoDialog(null, "Restore Theme Values?", "This will discard all of your theme changes. Continue?")) != 1) {
            return;
        }
        this.themeManager.restoreThemeValues();
    }

    private void reset() {
        this.colorTree.rebuild();
        this.colorTable.reloadAll();
        this.paletteTable.reloadAll();
        this.fontTable.reloadAll();
        this.iconTable.reloadAll();
        this.updateButtons();
    }

    private void resetSelectedLookAndFeel() {
        Swing.runLater(() -> {
            try {
                this.combo.removeItemListener(this.comboListener);
                this.combo.setSelectedItem(this.themeManager.getActiveTheme().getLookAndFeelType());
            }
            finally {
                this.combo.addItemListener(this.comboListener);
            }
        });
    }

    private void themeComboChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        LafType lafType = (LafType)e.getItem();
        if (!this.themeManager.hasThemeValueChanges()) {
            this.setLookAndFeel(lafType);
            return;
        }
        int result = OptionDialog.showOptionDialog(null, "Discard Changes?", "Changing the Look and Feel type will cause you to lose your changes.\nIf you would like to keep your changes, cancel this dialog and then save the theme\nWould you like to continue?", "Lose Changes");
        if (result == 0) {
            this.resetSelectedLookAndFeel();
            return;
        }
        this.setLookAndFeel(lafType);
    }

    private void setLookAndFeel(LafType lafType) {
        this.themeManager.setLookAndFeel(lafType, lafType.usesDarkDefaults());
        if (lafType == LafType.GTK) {
            this.setStatusText("Warning - Themes using the GTK LookAndFeel do not support changing java component colors, fonts or icons.", MessageType.WARNING);
        } else {
            this.setStatusText("");
        }
        this.colorTree.rebuild();
        this.colorTable.reloadAll();
        this.paletteTable.reloadAll();
        this.fontTable.reloadAll();
        this.iconTable.reloadAll();
    }

    private void updateButtons() {
        boolean hasChanges = this.themeManager.hasThemeChanges();
        this.saveButton.setEnabled(hasChanges);
    }

    private JComponent createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(this.buildControlPanel(), "North");
        panel.add(this.buildTabedTables());
        return panel;
    }

    private Component buildControlPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.buildThemeCombo(), "West");
        panel.setName("gthemePanel");
        return panel;
    }

    private Component buildThemeCombo() {
        JPanel panel = new JPanel();
        List<LafType> lafs = this.getSupportedLookAndFeels();
        this.combo = new GhidraComboBox<LafType>(lafs);
        this.combo.setSelectedItem(this.themeManager.getActiveTheme().getLookAndFeelType());
        this.combo.addItemListener(this.comboListener);
        panel.add((Component)new JLabel("Look And Feel: "), "West");
        panel.add(this.combo);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        return panel;
    }

    private List<LafType> getSupportedLookAndFeels() {
        LafType[] lafTypes = LafType.values();
        Comparator comparator = (a, b) -> a.getName().compareTo(b.getName());
        return Arrays.stream(lafTypes).filter(laf -> laf.isSupported()).sorted(comparator).toList();
    }

    private Component buildTabedTables() {
        this.tabbedPane = new JTabbedPane();
        this.valuesCache = new GThemeValuesCache(this.themeManager);
        this.colorTable = new ThemeColorTable(this.themeManager, this.valuesCache);
        this.iconTable = new ThemeIconTable(this.themeManager, this.valuesCache);
        this.fontTable = new ThemeFontTable(this.themeManager, this.valuesCache);
        this.colorTree = new ThemeColorTree(this.themeManager);
        this.paletteTable = new ThemeColorPaletteTable(this.themeManager, this.valuesCache);
        this.tabbedPane.add("Colors", this.colorTable);
        this.tabbedPane.add("Fonts", this.fontTable);
        this.tabbedPane.add("Icons", this.iconTable);
        this.tabbedPane.add("Color Tree", this.colorTree);
        this.tabbedPane.add("Palette", this.paletteTable);
        return this.tabbedPane;
    }

    private JButton createSaveButton() {
        this.saveButton = new JButton("Save");
        this.saveButton.setMnemonic('S');
        this.saveButton.setName("Save");
        this.saveButton.addActionListener(e -> this.saveCallback());
        this.saveButton.setToolTipText("Saves changed values to a new Theme");
        return this.saveButton;
    }

    public static void editTheme(ThemeManager themeManager) {
        if (INSTANCE != null) {
            INSTANCE.toFront();
            return;
        }
        INSTANCE = new ThemeEditorDialog(themeManager);
        DockingWindowManager.showDialog(INSTANCE);
    }

    public static ThemeEditorDialog getRunningInstance() {
        return INSTANCE;
    }

    @Override
    public void close() {
        Gui.removeThemeListener((ThemeListener)this.listener);
        super.close();
        INSTANCE = null;
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        ActionContextProvider contextProvider = (ActionContextProvider)((Object)this.tabbedPane.getSelectedComponent());
        return contextProvider.getActionContext(event);
    }

    private class DialogThemeListener
    implements ThemeListener {
        private DialogThemeListener() {
        }

        public void themeChanged(ThemeEvent event) {
            ThemeEditorDialog.this.valuesCache.clear();
            if (event.haveAllValuesChanged()) {
                ThemeEditorDialog.this.reset();
                return;
            }
            if (event.hasAnyColorChanged()) {
                ThemeEditorDialog.this.colorTable.reloadCurrent();
                ThemeEditorDialog.this.colorTree.rebuild();
                ThemeEditorDialog.this.paletteTable.reloadCurrent();
            }
            if (event.hasAnyFontChanged()) {
                ThemeEditorDialog.this.fontTable.reloadCurrent();
            }
            if (event.hasAnyIconChanged()) {
                ThemeEditorDialog.this.iconTable.reloadCurrent();
            }
            ThemeEditorDialog.this.updateButtons();
        }
    }
}

