/*
 * Decompiled with CFR 0.152.
 */
package docking.action.builder;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.actions.KeyBindingUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public abstract class AbstractActionBuilder<T extends DockingActionIf, C extends ActionContext, B extends AbstractActionBuilder<T, C, B>> {
    private final Predicate<C> ALWAYS_TRUE = e -> true;
    protected String name;
    protected String owner;
    protected Class<? extends ActionContext> actionContextClass;
    protected KeyBindingType keyBindingType = KeyBindingType.INDIVIDUAL;
    protected Consumer<C> actionCallback;
    private String description = "";
    private boolean isEnabled = true;
    private HelpLocation helpLocation;
    private String[] menuPath;
    private Icon menuIcon;
    private String menuSubGroup;
    private String menuGroup;
    private int menuMnemonic = -1;
    private Icon popupIcon;
    private String[] popupPath;
    private String popupGroup;
    private String popupSubGroup;
    private Icon toolbarIcon;
    private String toolBarGroup;
    private String toolBarSubGroup;
    private KeyStroke keyBinding;
    private Predicate<C> enabledPredicate = null;
    private Predicate<C> popupPredicate = null;
    private Predicate<C> validContextPredicate = this.ALWAYS_TRUE;
    private When windowWhen;
    private boolean supportsDefaultContext = false;

    public AbstractActionBuilder(String name, String owner) {
        this.name = name;
        this.owner = owner;
        this.actionContextClass = ActionContext.class;
    }

    protected abstract B self();

    public abstract T build();

    public T buildAndInstall(Tool tool) {
        T action = this.build();
        tool.addAction((DockingActionIf)action);
        return action;
    }

    public T buildAndInstallLocal(ComponentProvider provider) {
        T action = this.build();
        provider.addLocalAction((DockingActionIf)action);
        return action;
    }

    public B description(String text) {
        this.description = text;
        return this.self();
    }

    public B enabled(boolean b) {
        this.isEnabled = b;
        return this.self();
    }

    public B sharedKeyBinding() {
        this.keyBindingType = KeyBindingType.SHARED;
        return this.self();
    }

    public B helpLocation(HelpLocation help) {
        this.helpLocation = help;
        return this.self();
    }

    public B menuPath(String ... pathElement) {
        this.menuPath = pathElement;
        return this.self();
    }

    public B menuGroup(String group) {
        this.menuGroup = group;
        return this.self();
    }

    public B menuGroup(String group, String subGroup) {
        this.menuGroup = group;
        this.menuSubGroup = subGroup;
        return this.self();
    }

    public B menuIcon(Icon icon) {
        this.menuIcon = icon;
        return this.self();
    }

    public B menuMnemonic(int mnemonic) {
        this.menuMnemonic = mnemonic;
        return this.self();
    }

    public B popupMenuPath(String ... pathElement) {
        this.popupPath = pathElement;
        return this.self();
    }

    public B popupMenuGroup(String group) {
        this.popupGroup = group;
        return this.self();
    }

    public B popupMenuGroup(String group, String subGroup) {
        this.popupGroup = group;
        this.popupSubGroup = subGroup;
        return this.self();
    }

    public B popupMenuIcon(Icon icon) {
        this.popupIcon = icon;
        return this.self();
    }

    public B toolBarIcon(Icon icon) {
        this.toolbarIcon = icon;
        return this.self();
    }

    public B toolBarIcon(String iconFilepath) {
        this.toolbarIcon = ResourceManager.loadImage((String)iconFilepath);
        return this.self();
    }

    public B toolBarGroup(String group) {
        this.toolBarGroup = group;
        return this.self();
    }

    public B toolBarGroup(String group, String subGroup) {
        this.toolBarGroup = group;
        this.toolBarSubGroup = subGroup;
        return this.self();
    }

    public B keyBinding(KeyStroke keyStroke) {
        this.keyBinding = keyStroke;
        return this.self();
    }

    public B keyBinding(String keyStrokeString) {
        this.keyBinding = KeyBindingUtils.parseKeyStroke(keyStrokeString);
        if (this.keyBinding == null && keyStrokeString != null) {
            Msg.warn((Object)this, (Object)("Can't parse KeyStroke: " + keyStrokeString));
        }
        return this.self();
    }

    public B onAction(Consumer<C> action) {
        this.actionCallback = action;
        return this.self();
    }

    public B enabledWhen(Predicate<C> predicate) {
        this.enabledPredicate = Objects.requireNonNull(predicate);
        return this.self();
    }

    public B popupWhen(Predicate<C> predicate) {
        this.popupPredicate = Objects.requireNonNull(predicate);
        return this.self();
    }

    public B validContextWhen(Predicate<C> predicate) {
        this.validContextPredicate = Objects.requireNonNull(predicate);
        if (this.enabledPredicate == null) {
            this.enabledPredicate = this.ALWAYS_TRUE;
        }
        return this.self();
    }

    public B inWindow(When when) {
        this.windowWhen = when;
        return this.self();
    }

    public <AC2 extends ActionContext, B2 extends AbstractActionBuilder<T, AC2, B2>> B2 withContext(Class<AC2> newActionContextClass) {
        return this.withContext(newActionContextClass, false);
    }

    public <AC2 extends ActionContext, B2 extends AbstractActionBuilder<T, AC2, B2>> B2 withContext(Class<AC2> newActionContextClass, boolean useDefaultContext) {
        if (this.actionContextClass != ActionContext.class) {
            throw new IllegalStateException("Can't set the ActionContext type more than once");
        }
        this.supportsDefaultContext = useDefaultContext;
        if (this.enabledPredicate == null) {
            this.enabledPredicate = this.ALWAYS_TRUE;
        }
        this.actionContextClass = newActionContextClass;
        B newSelf = this.self();
        return (B2)newSelf;
    }

    protected void validate() {
        if (this.actionCallback == null) {
            throw new IllegalStateException("Can't build a DockingAction without an action callback");
        }
        if (this.windowWhen == When.CONTEXT_MATCHES && this.actionContextClass == null) {
            throw new IllegalStateException("The InWindow state was set to \"CONTEXT_MATCHES\", but no context class was set. Use the \"withContext\" method");
        }
    }

    protected void decorateAction(DockingAction action) {
        action.setEnabled(this.isEnabled);
        action.setDescription(this.description);
        this.setMenuData(action);
        this.setToolbarData(action);
        this.setPopupMenuData(action);
        this.setKeyBindingData(action);
        if (this.helpLocation != null) {
            action.setHelpLocation(this.helpLocation);
        }
        if (this.enabledPredicate != null) {
            action.enabledWhen(this.adaptPredicate(this.enabledPredicate));
        }
        action.setContextClass(this.actionContextClass, this.supportsDefaultContext);
        action.validContextWhen(this.adaptPredicate(this.validContextPredicate));
        if (this.popupPredicate != null) {
            action.popupWhen(this.adaptPredicate(this.popupPredicate));
        }
        if (this.windowWhen == When.ALWAYS) {
            action.setAddToAllWindows(true);
        } else if (this.windowWhen == When.CONTEXT_MATCHES) {
            action.addToWindowWhen(this.actionContextClass);
        }
    }

    private Predicate<ActionContext> adaptPredicate(Predicate<C> predicate) {
        if (this.actionContextClass == ActionContext.class) {
            return predicate;
        }
        Predicate<ActionContext> predicateAdapter = ac -> this.actionContextClass.isInstance(ac) && predicate.test((ActionContext)ac);
        return predicateAdapter;
    }

    protected boolean isPopupAction() {
        return this.popupPath != null;
    }

    protected boolean isToolbarAction() {
        return this.toolbarIcon != null;
    }

    protected boolean isMenuAction() {
        return this.menuPath != null;
    }

    protected boolean isKeyBindingAction() {
        return this.keyBinding != null;
    }

    private void setPopupMenuData(DockingAction action) {
        if (this.isPopupAction()) {
            action.setPopupMenuData(new MenuData(this.popupPath, this.popupIcon, this.popupGroup, -1, this.popupSubGroup));
        }
    }

    private void setToolbarData(DockingAction action) {
        if (this.isToolbarAction()) {
            action.setToolBarData(new ToolBarData(this.toolbarIcon, this.toolBarGroup, this.toolBarSubGroup));
        }
    }

    private void setMenuData(DockingAction action) {
        if (this.isMenuAction()) {
            action.setMenuBarData(new MenuData(this.menuPath, this.menuIcon, this.menuGroup, this.menuMnemonic, this.menuSubGroup));
        }
    }

    private void setKeyBindingData(DockingAction action) {
        if (this.isKeyBindingAction()) {
            action.setKeyBindingData(new KeyBindingData(this.keyBinding));
        }
    }

    public static enum When {
        MAIN_WINDOW,
        ALWAYS,
        CONTEXT_MATCHES;

    }
}

