/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.menu.MenuHandler;
import ghidra.util.Swing;
import java.awt.event.ActionEvent;

public class MenuBarMenuHandler
extends MenuHandler {
    private final DockingWindowManager windowManager;

    public MenuBarMenuHandler(DockingWindowManager windowManager) {
        this.windowManager = windowManager;
    }

    @Override
    public void menuItemEntered(DockingActionIf action) {
        DockingWindowManager.setMouseOverAction(action);
    }

    @Override
    public void menuItemExited(DockingActionIf action) {
        DockingWindowManager.clearMouseOverHelp();
    }

    @Override
    public void processMenuAction(DockingActionIf action, ActionEvent event) {
        DockingWindowManager.clearMouseOverHelp();
        ActionContext context = this.windowManager.createActionContext(action);
        context.setSourceObject(event.getSource());
        Swing.runLater(() -> {
            this.windowManager.setStatusText("");
            if (action.isValidContext(context) && action.isEnabledForContext(context)) {
                if (action instanceof ToggleDockingActionIf) {
                    ToggleDockingActionIf toggleAction;
                    toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)action).isSelected());
                }
                action.actionPerformed(context);
            }
        });
    }
}

