/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentProvider;
import java.awt.Component;
import java.awt.event.MouseEvent;

public class DefaultActionContext
implements ActionContext {
    private ComponentProvider provider;
    private MouseEvent mouseEvent;
    private Object contextObject;
    private Object sourceObject;
    private int eventClickModifiers;
    private Component sourceComponent;

    public DefaultActionContext() {
        this(null, null);
    }

    public DefaultActionContext(ComponentProvider provider) {
        this(provider, null);
    }

    public DefaultActionContext(ComponentProvider provider, Component sourceComponent) {
        this(provider, sourceComponent, sourceComponent);
    }

    public DefaultActionContext(ComponentProvider provider, Object contextObject, Component sourceComponent) {
        this.provider = provider;
        this.contextObject = contextObject;
        this.sourceObject = sourceComponent;
        this.sourceComponent = sourceComponent;
    }

    private void lazyDeriveSourceComponent() {
        if (this.sourceComponent != null) {
            return;
        }
        if (this.sourceObject instanceof Component) {
            this.sourceComponent = (Component)this.sourceObject;
            return;
        }
        if (this.mouseEvent != null) {
            this.sourceComponent = this.mouseEvent.getComponent();
            return;
        }
        if (this.contextObject instanceof Component) {
            this.sourceComponent = (Component)this.contextObject;
        }
    }

    @Override
    public ComponentProvider getComponentProvider() {
        return this.provider;
    }

    @Override
    public Object getContextObject() {
        if (this.contextObject != null) {
            return this.contextObject;
        }
        return this;
    }

    @Override
    public DefaultActionContext setContextObject(Object contextObject) {
        this.contextObject = contextObject;
        return this;
    }

    @Override
    public Object getSourceObject() {
        return this.sourceObject;
    }

    @Override
    public void setEventClickModifiers(int modifiers) {
        this.eventClickModifiers = modifiers;
    }

    @Override
    public int getEventClickModifiers() {
        return this.eventClickModifiers;
    }

    @Override
    public boolean hasAnyEventClickModifiers(int modifiersMask) {
        return (this.eventClickModifiers & modifiersMask) != 0;
    }

    @Override
    public DefaultActionContext setSourceObject(Object sourceObject) {
        this.sourceObject = sourceObject;
        return this;
    }

    @Override
    public DefaultActionContext setMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mouseEvent = e;
            this.eventClickModifiers = e.getModifiersEx();
        }
        return this;
    }

    @Override
    public MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    @Override
    public Component getSourceComponent() {
        this.lazyDeriveSourceComponent();
        return this.sourceComponent;
    }

    public String toString() {
        return "{\n\tprovider: " + this.provider + ",\n\tcontextObject: " + this.contextObject + ",\n\tsourceObject: " + this.sourceObject + ",\n\tsourceComponent: " + this.sourceComponent + ",\n\tmouseEvent: " + this.mouseEvent + "\n}";
    }
}

