/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.manager.impl;

import agent.frida.frida.FridaClient;
import agent.frida.frida.FridaClientReentrant;
import agent.frida.frida.FridaEng;
import agent.frida.frida.FridaModuleInfo;
import agent.frida.frida.FridaProcessInfo;
import agent.frida.frida.FridaRegionInfo;
import agent.frida.frida.FridaSessionInfo;
import agent.frida.frida.FridaThreadInfo;
import agent.frida.gadp.impl.AbstractClientThreadExecutor;
import agent.frida.gadp.impl.FridaClientThreadExecutor;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaCommand;
import agent.frida.manager.FridaEvent;
import agent.frida.manager.FridaEventsListener;
import agent.frida.manager.FridaExport;
import agent.frida.manager.FridaFrame;
import agent.frida.manager.FridaImport;
import agent.frida.manager.FridaKernelMemoryRegionInfo;
import agent.frida.manager.FridaKernelModule;
import agent.frida.manager.FridaManager;
import agent.frida.manager.FridaMemoryRegionInfo;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaScript;
import agent.frida.manager.FridaSection;
import agent.frida.manager.FridaSession;
import agent.frida.manager.FridaState;
import agent.frida.manager.FridaStateListener;
import agent.frida.manager.FridaSymbol;
import agent.frida.manager.FridaTarget;
import agent.frida.manager.FridaThread;
import agent.frida.manager.cmd.AbstractFridaCommand;
import agent.frida.manager.cmd.FridaAddProcessCommand;
import agent.frida.manager.cmd.FridaAddSessionCommand;
import agent.frida.manager.cmd.FridaAttachCommand;
import agent.frida.manager.cmd.FridaAttachDeviceByIdCommand;
import agent.frida.manager.cmd.FridaAttachDeviceByTypeCommand;
import agent.frida.manager.cmd.FridaCommandError;
import agent.frida.manager.cmd.FridaConsoleExecCommand;
import agent.frida.manager.cmd.FridaGetSessionAttributesCommand;
import agent.frida.manager.cmd.FridaInterceptFunctionCommand;
import agent.frida.manager.cmd.FridaLaunchProcessCommand;
import agent.frida.manager.cmd.FridaLaunchProcessWithOptionsCommand;
import agent.frida.manager.cmd.FridaListAvailableDevicesCommand;
import agent.frida.manager.cmd.FridaListAvailableProcessesCommand;
import agent.frida.manager.cmd.FridaListHeapMemoryRegionsCommand;
import agent.frida.manager.cmd.FridaListKernelMemoryRegionsCommand;
import agent.frida.manager.cmd.FridaListKernelModulesCommand;
import agent.frida.manager.cmd.FridaListMemoryRegionsCommand;
import agent.frida.manager.cmd.FridaListModuleExportsCommand;
import agent.frida.manager.cmd.FridaListModuleImportsCommand;
import agent.frida.manager.cmd.FridaListModuleSectionsCommand;
import agent.frida.manager.cmd.FridaListModuleSymbolsCommand;
import agent.frida.manager.cmd.FridaListModulesCommand;
import agent.frida.manager.cmd.FridaListProcessesCommand;
import agent.frida.manager.cmd.FridaListRegistersCommand;
import agent.frida.manager.cmd.FridaListSessionsCommand;
import agent.frida.manager.cmd.FridaListStackFramesCommand;
import agent.frida.manager.cmd.FridaListThreadsCommand;
import agent.frida.manager.cmd.FridaPendingCommand;
import agent.frida.manager.cmd.FridaRemoveProcessCommand;
import agent.frida.manager.cmd.FridaRequestActivationCommand;
import agent.frida.manager.cmd.FridaRequestFocusCommand;
import agent.frida.manager.cmd.FridaSetExceptionHandlerCommand;
import agent.frida.manager.cmd.FridaStalkThreadCommand;
import agent.frida.manager.cmd.FridaWatchMemoryCommand;
import agent.frida.manager.evt.AbstractFridaEvent;
import agent.frida.manager.evt.FridaCommandDoneEvent;
import agent.frida.manager.evt.FridaConsoleOutputEvent;
import agent.frida.manager.evt.FridaInterruptEvent;
import agent.frida.manager.evt.FridaMemoryRegionAddedEvent;
import agent.frida.manager.evt.FridaMemoryRegionRemovedEvent;
import agent.frida.manager.evt.FridaMemoryRegionReplacedEvent;
import agent.frida.manager.evt.FridaModuleLoadedEvent;
import agent.frida.manager.evt.FridaModuleReplacedEvent;
import agent.frida.manager.evt.FridaModuleUnloadedEvent;
import agent.frida.manager.evt.FridaProcessCreatedEvent;
import agent.frida.manager.evt.FridaProcessExitedEvent;
import agent.frida.manager.evt.FridaProcessReplacedEvent;
import agent.frida.manager.evt.FridaProcessSelectedEvent;
import agent.frida.manager.evt.FridaRunningEvent;
import agent.frida.manager.evt.FridaSelectedFrameChangedEvent;
import agent.frida.manager.evt.FridaSessionCreatedEvent;
import agent.frida.manager.evt.FridaSessionExitedEvent;
import agent.frida.manager.evt.FridaSessionReplacedEvent;
import agent.frida.manager.evt.FridaSessionSelectedEvent;
import agent.frida.manager.evt.FridaStateChangedEvent;
import agent.frida.manager.evt.FridaStoppedEvent;
import agent.frida.manager.evt.FridaThreadCreatedEvent;
import agent.frida.manager.evt.FridaThreadExitedEvent;
import agent.frida.manager.evt.FridaThreadReplacedEvent;
import agent.frida.manager.evt.FridaThreadSelectedEvent;
import agent.frida.model.iface1.FridaModelTargetActiveScope;
import agent.frida.model.iface1.FridaModelTargetFocusScope;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import ghidra.async.AsyncReference;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.HandlerMap;
import ghidra.lifecycle.Internal;
import ghidra.util.Msg;
import ghidra.util.TriConsumer;
import ghidra.util.datastruct.ListenerSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;

public class FridaManagerImpl
implements FridaManager {
    public FridaClient.DebugStatus status;
    protected AbstractClientThreadExecutor executor;
    protected FridaClientReentrant reentrantClient;
    private List<FridaPendingCommand<?>> activeCmds = new ArrayList();
    protected final Map<String, FridaSession> sessions = new LinkedHashMap<String, FridaSession>();
    protected FridaTarget curSession = null;
    private final Map<String, FridaSession> unmodifiableSessions = Collections.unmodifiableMap(this.sessions);
    protected final Map<String, Map<String, FridaProcess>> processes = new LinkedHashMap<String, Map<String, FridaProcess>>();
    protected final Map<String, Map<String, FridaThread>> threads = new LinkedHashMap<String, Map<String, FridaThread>>();
    protected final Map<String, Map<String, FridaModule>> modules = new LinkedHashMap<String, Map<String, FridaModule>>();
    protected final Map<String, Map<String, FridaMemoryRegionInfo>> regions = new LinkedHashMap<String, Map<String, FridaMemoryRegionInfo>>();
    protected final Map<String, FridaKernelModule> kmodules = new LinkedHashMap<String, FridaKernelModule>();
    protected final Map<String, FridaKernelMemoryRegionInfo> kregions = new LinkedHashMap<String, FridaKernelMemoryRegionInfo>();
    protected final AsyncReference<FridaState, FridaCause> state = new AsyncReference(null);
    private final HandlerMap<FridaEvent<?>, Void, FridaClient.DebugStatus> handlerMap = new HandlerMap();
    private final Map<Class<?>, FridaClient.DebugStatus> statusMap = new LinkedHashMap();
    private final ListenerSet<FridaEventsListener> listenersEvent = new ListenerSet(FridaEventsListener.class, true);
    private FridaTarget currentTarget;
    private FridaSession currentSession;
    private FridaProcess currentProcess;
    private FridaThread currentThread;
    private volatile boolean waiting = false;
    private boolean kernelMode = false;
    private CompletableFuture<String> continuation;
    private Map<String, FridaScript> scripts = new HashMap<String, FridaScript>();

    public FridaManagerImpl() {
        this.defaultHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(String processId, String id) {
        Map<String, Map<String, FridaThread>> map = this.threads;
        synchronized (map) {
            if (this.threads.get(processId).remove(id) == null) {
                throw new IllegalArgumentException("There is no thread with id " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FridaThread getThread(FridaProcess process, String tid) {
        Map<String, Map<String, FridaThread>> map = this.threads;
        synchronized (map) {
            return this.threads.get(FridaClient.getId(process)).get(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThreadIfAbsent(FridaProcess process, FridaThread thread) {
        Map<String, Map<String, FridaThread>> map = this.threads;
        synchronized (map) {
            Map<String, FridaThread> map2 = this.threads.get(FridaClient.getId(process));
            if (map2 == null) {
                map2 = new HashMap<String, FridaThread>();
                this.threads.put(FridaClient.getId(process), map2);
            }
            if (thread == null) {
                return;
            }
            String id = FridaClient.getId(thread);
            FridaThread pred = map2.get(id);
            if (!map2.containsKey(id) || !thread.equals(pred)) {
                FridaThreadInfo info = new FridaThreadInfo(thread);
                if (!map2.containsKey(id)) {
                    this.getClient().processEvent(new FridaThreadCreatedEvent(info));
                } else {
                    this.getClient().processEvent(new FridaThreadReplacedEvent(info));
                }
                map2.put(id, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void removeProcess(String sessionId, String id, FridaCause cause) {
        Map<String, Map<String, FridaProcess>> map = this.processes;
        synchronized (map) {
            FridaProcess proc = this.processes.get(sessionId).remove(id);
            if (proc == null) {
                throw new IllegalArgumentException("There is no process with id " + id);
            }
            HashSet<String> toRemove = new HashSet<String>();
            String processId = FridaClient.getId(proc);
            for (String tid : this.threads.get(processId).keySet()) {
                FridaThread thread = this.threads.get(processId).get(tid);
                String pid = FridaClient.getId(thread.getProcess());
                if (!pid.equals(id)) continue;
                toRemove.add(tid);
            }
            for (String tid : toRemove) {
                this.removeThread(processId, tid);
            }
            ((FridaEventsListener)this.getEventListeners().invoke()).processRemoved(id, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FridaProcess getProcess(FridaSession session, String id) {
        Map<String, Map<String, FridaProcess>> map = this.processes;
        synchronized (map) {
            String sessionId = FridaClient.getId(session);
            FridaProcess result = this.processes.get(sessionId).get(id);
            if (result == null) {
                throw new IllegalArgumentException("There is no process with id " + id);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessIfAbsent(FridaSession session, FridaProcess process) {
        Map<String, Map<String, FridaProcess>> map = this.processes;
        synchronized (map) {
            String sessionId = FridaClient.getId(session);
            Map<String, FridaProcess> map2 = this.processes.get(sessionId);
            if (map2 == null) {
                map2 = new HashMap<String, FridaProcess>();
                this.processes.put(sessionId, map2);
            }
            String id = FridaClient.getId(process);
            FridaProcess pred = map2.get(id);
            if (!map2.containsKey(id) || !process.equals(pred)) {
                FridaProcessInfo info = new FridaProcessInfo(process);
                if (!map2.containsKey(id)) {
                    this.getClient().processEvent(new FridaProcessCreatedEvent(info));
                } else {
                    this.getClient().processEvent(new FridaProcessReplacedEvent(info));
                }
                map2.put(id, process);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void removeSession(String id, FridaCause cause) {
        Map<String, FridaSession> map = this.sessions;
        synchronized (map) {
            if (this.sessions.remove(id) == null) {
                throw new IllegalArgumentException("There is no session with id " + id);
            }
            ((FridaEventsListener)this.getEventListeners().invoke()).sessionRemoved(id, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FridaSession getSession(String id) {
        Map<String, FridaSession> map = this.sessions;
        synchronized (map) {
            FridaSession result = this.sessions.get(id);
            if (result == null) {
                throw new IllegalArgumentException("There is no session with id " + id);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionIfAbsent(FridaSession session) {
        Map<String, FridaSession> map = this.sessions;
        synchronized (map) {
            String id = FridaClient.getId(session);
            FridaSession pred = this.sessions.get(id);
            if (!this.sessions.containsKey(id) || !session.equals(pred)) {
                FridaSessionInfo info = new FridaSessionInfo(session);
                if (this.sessions.containsKey(id)) {
                    this.getClient().processEvent(new FridaSessionReplacedEvent(info));
                } else {
                    this.getClient().processEvent(new FridaSessionCreatedEvent(info));
                }
                this.sessions.put(id, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModule(FridaProcess process, String id) {
        Map<String, Map<String, FridaModule>> map = this.modules;
        synchronized (map) {
            if (this.modules.get(FridaClient.getId(process)).remove(id) == null) {
                throw new IllegalArgumentException("There is no module with id " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FridaModule getModule(FridaProcess process, String id) {
        Map<String, Map<String, FridaModule>> map = this.modules;
        synchronized (map) {
            return this.modules.get(FridaClient.getId(process)).get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModuleIfAbsent(FridaProcess process, FridaModule module) {
        Map<String, Map<String, FridaModule>> map = this.modules;
        synchronized (map) {
            String sessionId = FridaClient.getId(process);
            Map<String, FridaModule> map2 = this.modules.get(sessionId);
            if (map2 == null) {
                map2 = new HashMap<String, FridaModule>();
                this.modules.put(sessionId, map2);
            }
            if (module == null) {
                return;
            }
            String id = FridaClient.getId(module);
            FridaModule pred = map2.get(id);
            if (!map2.containsKey(id) || !module.equals(pred)) {
                FridaModuleInfo info = new FridaModuleInfo(process, module);
                if (!map2.containsKey(id)) {
                    this.getClient().processEvent(new FridaModuleLoadedEvent(info));
                } else {
                    this.getClient().processEvent(new FridaModuleReplacedEvent(info));
                }
                map2.put(id, module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKernelModuleIfAbsent(FridaKernelModule module) {
        Map<String, FridaKernelModule> map = this.kmodules;
        synchronized (map) {
            if (module == null) {
                return;
            }
            String id = FridaClient.getId(module);
            FridaKernelModule pred = this.kmodules.get(id);
            if (!this.kmodules.containsKey(id) || !module.equals(pred)) {
                FridaModuleInfo info = new FridaModuleInfo(module);
                if (!this.kmodules.containsKey(id)) {
                    this.getClient().processEvent(new FridaModuleLoadedEvent(info));
                } else {
                    this.getClient().processEvent(new FridaModuleReplacedEvent(info));
                }
                this.kmodules.put(id, module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemoryRegion(FridaProcess process, String id) {
        Map<String, Map<String, FridaMemoryRegionInfo>> map = this.regions;
        synchronized (map) {
            if (this.regions.get(FridaClient.getId(process)).remove(id) == null) {
                throw new IllegalArgumentException("There is no region with id " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FridaMemoryRegionInfo getMemoryRegion(FridaProcess process, String id) {
        Map<String, Map<String, FridaMemoryRegionInfo>> map = this.regions;
        synchronized (map) {
            return this.regions.get(FridaClient.getId(process)).get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemoryRegionIfAbsent(FridaProcess process, FridaMemoryRegionInfo region) {
        Map<String, Map<String, FridaMemoryRegionInfo>> map = this.regions;
        synchronized (map) {
            String sessionId = FridaClient.getId(process);
            Map<String, FridaMemoryRegionInfo> map2 = this.regions.get(sessionId);
            if (map2 == null) {
                map2 = new HashMap<String, FridaMemoryRegionInfo>();
                this.regions.put(sessionId, map2);
            }
            String id = FridaClient.getId(region);
            FridaMemoryRegionInfo pred = map2.get(id);
            if (!map2.containsKey(id) || !region.equals(pred)) {
                FridaRegionInfo info = new FridaRegionInfo(process, region);
                if (!map2.containsKey(id)) {
                    this.getClient().processEvent(new FridaMemoryRegionAddedEvent(info));
                } else {
                    this.getClient().processEvent(new FridaMemoryRegionReplacedEvent(info));
                }
                map2.put(id, region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKernelMemoryRegionIfAbsent(FridaKernelMemoryRegionInfo region) {
        Map<String, FridaKernelMemoryRegionInfo> map = this.kregions;
        synchronized (map) {
            String id = FridaClient.getId(region);
            FridaKernelMemoryRegionInfo pred = this.kregions.get(id);
            if (!this.kregions.containsKey(id) || !region.equals(pred)) {
                FridaRegionInfo info = new FridaRegionInfo(region);
                if (!this.kregions.containsKey(id)) {
                    this.getClient().processEvent(new FridaMemoryRegionAddedEvent(info));
                } else {
                    this.getClient().processEvent(new FridaMemoryRegionReplacedEvent(info));
                }
                this.kregions.put(id, region);
            }
        }
    }

    @Override
    public Map<String, FridaThread> getKnownThreads(FridaProcess process) {
        String processId = FridaClient.getId(process);
        Map<String, FridaThread> map = this.threads.get(processId);
        if (map == null) {
            map = new HashMap<String, FridaThread>();
            this.threads.put(FridaClient.getId(process), map);
        }
        return map;
    }

    @Override
    public Map<String, FridaProcess> getKnownProcesses(FridaSession target) {
        String sessionId = FridaClient.getId(target);
        Map<String, FridaProcess> map = this.processes.get(sessionId);
        if (map == null) {
            map = new HashMap<String, FridaProcess>();
            this.processes.put(sessionId, map);
        }
        return map;
    }

    @Override
    public Map<String, FridaSession> getKnownSessions() {
        return this.unmodifiableSessions;
    }

    @Override
    public Map<String, FridaModule> getKnownModules(FridaProcess process) {
        String processId = FridaClient.getId(process);
        Map<String, FridaModule> map = this.modules.get(processId);
        if (map == null) {
            map = new HashMap<String, FridaModule>();
            this.modules.put(processId, map);
        }
        return map;
    }

    @Override
    public Map<String, FridaMemoryRegionInfo> getKnownRegions(FridaProcess process) {
        String processId = FridaClient.getId(process);
        Map<String, FridaMemoryRegionInfo> map = this.regions.get(processId);
        if (map == null) {
            map = new HashMap<String, FridaMemoryRegionInfo>();
            this.regions.put(processId, map);
        }
        return map;
    }

    @Override
    public CompletableFuture<Void> start(String[] args) {
        this.state.set(null, (Object)FridaCause.Causes.UNCLAIMED);
        boolean create = true;
        if (args.length == 0) {
            this.executor = new FridaClientThreadExecutor(() -> FridaClient.debugCreate().createClient());
        } else {
            this.executor = new FridaClientThreadExecutor(() -> FridaClient.debugCreate().createClient());
            create = false;
        }
        this.executor.setManager(this);
        AtomicReference<Boolean> creat = new AtomicReference<Boolean>(create);
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then((Executor)this.executor, seq -> {
            this.doExecute((Boolean)creat.get());
            seq.exit();
        }).finish().exceptionally(exc -> {
            Msg.error((Object)this, (Object)"start failed");
            return null;
        });
    }

    protected void doExecute(Boolean create) {
        FridaClient client = this.executor.getClient();
        this.reentrantClient = client;
        this.status = client.getExecutionStatus();
    }

    @Override
    public boolean isRunning() {
        return !this.executor.isShutdown() && !this.executor.isTerminated();
    }

    @Override
    public void terminate() {
        this.executor.execute(100, client -> {
            Msg.debug((Object)this, (Object)"Disconnecting DebugClient from session");
            client.endSession(this.getCurrentTarget(), FridaClient.DebugEndSessionFlags.DEBUG_END_DISCONNECT);
        });
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
        this.terminate();
    }

    @Override
    public <T> CompletableFuture<T> execute(FridaCommand<? extends T> cmd) {
        assert (cmd != null);
        FridaPendingCommand pcmd = new FridaPendingCommand(cmd);
        if (this.executor.isCurrentThread()) {
            try {
                this.addCommand(cmd, pcmd);
            }
            catch (Throwable exc2) {
                pcmd.completeExceptionally(exc2);
            }
        } else {
            CompletableFuture.runAsync(() -> this.addCommand(cmd, pcmd), this.executor).exceptionally(exc -> {
                pcmd.completeExceptionally((Throwable)exc);
                return null;
            });
        }
        return pcmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addCommand(FridaCommand<? extends T> cmd, FridaPendingCommand<T> pcmd) {
        FridaManagerImpl fridaManagerImpl = this;
        synchronized (fridaManagerImpl) {
            if (!cmd.validInState((FridaState)((Object)this.state.get()))) {
                throw new FridaCommandError("Command " + cmd + " is not valid while " + this.state.get());
            }
            this.activeCmds.add(pcmd);
        }
        cmd.invoke();
        this.processEvent(new FridaCommandDoneEvent(cmd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FridaClient.DebugStatus processEvent(FridaEvent<?> evt) {
        FridaState newState;
        if (this.state == null) {
            this.state.set((Object)FridaState.FRIDA_THREAD_STOPPED, (Object)FridaCause.Causes.UNCLAIMED);
        }
        if ((newState = evt.newState()) != null && !(evt instanceof FridaCommandDoneEvent)) {
            Msg.debug((Object)this, (Object)(evt + " transitions state to " + newState));
            this.state.set((Object)newState, (Object)evt.getCause());
        }
        boolean cmdFinished = false;
        ArrayList toRemove = new ArrayList();
        for (FridaPendingCommand<?> fridaPendingCommand : this.activeCmds) {
            cmdFinished = fridaPendingCommand.handle(evt);
            if (!cmdFinished) continue;
            fridaPendingCommand.finish();
            toRemove.add(fridaPendingCommand);
        }
        for (FridaPendingCommand<Object> fridaPendingCommand : toRemove) {
            this.activeCmds.remove(fridaPendingCommand);
        }
        FridaManagerImpl fridaManagerImpl = this;
        synchronized (fridaManagerImpl) {
            FridaClient.DebugStatus ret;
            boolean bl = this.isWaiting();
            this.waiting = false;
            FridaClient.DebugStatus debugStatus = ret = evt.isStolen() ? null : (FridaClient.DebugStatus)((Object)this.handlerMap.handle(evt, null));
            if (ret == null) {
                ret = FridaClient.DebugStatus.NO_CHANGE;
            }
            this.waiting = ret.equals((Object)FridaClient.DebugStatus.NO_DEBUGGEE) ? false : bl;
            return ret;
        }
    }

    @Override
    public void addStateListener(FridaStateListener listener) {
        this.state.addChangeListener((TriConsumer)listener);
    }

    @Override
    public void removeStateListener(FridaStateListener listener) {
        this.state.removeChangeListener((TriConsumer)listener);
    }

    public ListenerSet<FridaEventsListener> getEventListeners() {
        return this.listenersEvent;
    }

    @Override
    public void addEventsListener(FridaEventsListener listener) {
        this.getEventListeners().add((Object)listener);
    }

    @Override
    public void removeEventsListener(FridaEventsListener listener) {
        this.getEventListeners().remove((Object)listener);
    }

    private void defaultHandlers() {
        this.handlerMap.put(FridaInterruptEvent.class, this::processInterrupt);
        this.handlerMap.put(FridaThreadCreatedEvent.class, this::processThreadCreated);
        this.handlerMap.put(FridaThreadReplacedEvent.class, this::processThreadReplaced);
        this.handlerMap.put(FridaThreadExitedEvent.class, this::processThreadExited);
        this.handlerMap.put(FridaThreadSelectedEvent.class, this::processThreadSelected);
        this.handlerMap.put(FridaProcessCreatedEvent.class, this::processProcessCreated);
        this.handlerMap.put(FridaProcessReplacedEvent.class, this::processProcessReplaced);
        this.handlerMap.put(FridaProcessExitedEvent.class, this::processProcessExited);
        this.handlerMap.put(FridaSessionCreatedEvent.class, this::processSessionCreated);
        this.handlerMap.put(FridaSessionReplacedEvent.class, this::processSessionReplaced);
        this.handlerMap.put(FridaSessionExitedEvent.class, this::processSessionExited);
        this.handlerMap.put(FridaProcessSelectedEvent.class, this::processProcessSelected);
        this.handlerMap.put(FridaSelectedFrameChangedEvent.class, this::processFrameSelected);
        this.handlerMap.put(FridaModuleLoadedEvent.class, this::processModuleLoaded);
        this.handlerMap.put(FridaModuleReplacedEvent.class, this::processModuleReplaced);
        this.handlerMap.put(FridaModuleUnloadedEvent.class, this::processModuleUnloaded);
        this.handlerMap.put(FridaMemoryRegionAddedEvent.class, this::processMemoryRegionAdded);
        this.handlerMap.put(FridaMemoryRegionReplacedEvent.class, this::processMemoryRegionReplaced);
        this.handlerMap.put(FridaModuleUnloadedEvent.class, this::processModuleUnloaded);
        this.handlerMap.put(FridaStateChangedEvent.class, this::processStateChanged);
        this.handlerMap.putVoid(FridaCommandDoneEvent.class, this::processDefault);
        this.handlerMap.putVoid(FridaStoppedEvent.class, this::processDefault);
        this.handlerMap.putVoid(FridaRunningEvent.class, this::processDefault);
        this.handlerMap.putVoid(FridaConsoleOutputEvent.class, this::processConsoleOutput);
        this.statusMap.put(FridaProcessCreatedEvent.class, FridaClient.DebugStatus.BREAK);
        this.statusMap.put(FridaProcessExitedEvent.class, FridaClient.DebugStatus.NO_DEBUGGEE);
        this.statusMap.put(FridaStateChangedEvent.class, FridaClient.DebugStatus.NO_CHANGE);
        this.statusMap.put(FridaStoppedEvent.class, FridaClient.DebugStatus.BREAK);
        this.statusMap.put(FridaInterruptEvent.class, FridaClient.DebugStatus.BREAK);
    }

    @Override
    public void updateState(FridaSession session) {
        FridaSession candidateSession;
        FridaProcess process;
        this.getSessionAttributes(session);
        this.currentSession = session;
        this.currentProcess = process = session.getProcess();
        if (!(this.currentSession != null && this.currentSession.equals(process.getSession()) || (candidateSession = this.currentProcess.getSession()) == null)) {
            this.currentSession = candidateSession;
        }
        this.addSessionIfAbsent(this.currentSession);
        this.addProcessIfAbsent(this.currentSession, this.currentProcess);
        this.addThreadIfAbsent(this.currentProcess, this.currentThread);
    }

    protected <T> FridaClient.DebugStatus processDefault(AbstractFridaEvent<T> evt, Void v) {
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processInterrupt(FridaInterruptEvent evt, Void v) {
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processThreadCreated(FridaThreadCreatedEvent evt, Void v) {
        FridaThread thread;
        this.currentThread = thread = ((FridaThreadInfo)evt.getInfo()).thread;
        ((FridaEventsListener)this.getEventListeners().invoke()).threadCreated(thread, FridaCause.Causes.UNCLAIMED);
        ((FridaEventsListener)this.getEventListeners().invoke()).threadSelected(thread, null, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processThreadReplaced(FridaThreadReplacedEvent evt, Void v) {
        FridaThread thread = ((FridaThreadInfo)evt.getInfo()).thread;
        ((FridaEventsListener)this.getEventListeners().invoke()).threadReplaced(thread, FridaCause.Causes.UNCLAIMED);
        ((FridaEventsListener)this.getEventListeners().invoke()).threadSelected(thread, null, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processThreadExited(FridaThreadExitedEvent evt, Void v) {
        ((FridaEventsListener)this.getEventListeners().invoke()).threadExited(this.currentThread, this.currentProcess, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processThreadSelected(FridaThreadSelectedEvent evt, Void v) {
        this.currentThread = evt.getThread();
        ((FridaEventsListener)this.getEventListeners().invoke()).threadSelected(this.currentThread, evt.getFrame(), evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processFrameSelected(FridaSelectedFrameChangedEvent evt, Void v) {
        this.currentThread = evt.getThread();
        ((FridaEventsListener)this.getEventListeners().invoke()).threadSelected(this.currentThread, evt.getFrame(), evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processProcessCreated(FridaProcessCreatedEvent evt, Void v) {
        FridaProcessInfo info = (FridaProcessInfo)evt.getInfo();
        FridaProcess proc = info.process;
        ((FridaEventsListener)this.getEventListeners().invoke()).processAdded(proc, FridaCause.Causes.UNCLAIMED);
        ((FridaEventsListener)this.getEventListeners().invoke()).processSelected(proc, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processProcessReplaced(FridaProcessReplacedEvent evt, Void v) {
        FridaProcessInfo info = (FridaProcessInfo)evt.getInfo();
        FridaProcess proc = info.process;
        ((FridaEventsListener)this.getEventListeners().invoke()).processReplaced(proc, FridaCause.Causes.UNCLAIMED);
        ((FridaEventsListener)this.getEventListeners().invoke()).processSelected(proc, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processProcessExited(FridaProcessExitedEvent evt, Void v) {
        FridaThread thread = this.getCurrentThread();
        FridaProcess process = this.getCurrentProcess();
        ((FridaEventsListener)this.getEventListeners().invoke()).threadExited(thread, process, evt.getCause());
        ((FridaEventsListener)this.getEventListeners().invoke()).processExited(process, evt.getCause());
        ((FridaEventsListener)this.getEventListeners().invoke()).processRemoved(process.getPID().toString(), evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processProcessSelected(FridaProcessSelectedEvent evt, Void v) {
        this.currentProcess = evt.getProcess();
        ((FridaEventsListener)this.getEventListeners().invoke()).processSelected(this.currentProcess, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processSessionCreated(FridaSessionCreatedEvent evt, Void v) {
        FridaSessionInfo info = (FridaSessionInfo)evt.getInfo();
        ((FridaEventsListener)this.getEventListeners().invoke()).sessionAdded(info.session, FridaCause.Causes.UNCLAIMED);
        ((FridaEventsListener)this.getEventListeners().invoke()).sessionSelected(info.session, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processSessionReplaced(FridaSessionReplacedEvent evt, Void v) {
        FridaSessionInfo info = (FridaSessionInfo)evt.getInfo();
        ((FridaEventsListener)this.getEventListeners().invoke()).sessionReplaced(info.session, FridaCause.Causes.UNCLAIMED);
        ((FridaEventsListener)this.getEventListeners().invoke()).sessionSelected(info.session, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processSessionExited(FridaSessionExitedEvent evt, Void v) {
        this.removeSession(evt.sessionId, FridaCause.Causes.UNCLAIMED);
        ((FridaEventsListener)this.getEventListeners().invoke()).sessionRemoved(evt.sessionId, evt.getCause());
        ((FridaEventsListener)this.getEventListeners().invoke()).threadExited(this.currentThread, this.currentProcess, evt.getCause());
        ((FridaEventsListener)this.getEventListeners().invoke()).processExited(this.currentProcess, evt.getCause());
        ((FridaEventsListener)this.getEventListeners().invoke()).processRemoved(this.currentProcess.getPID().toString(), evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processModuleLoaded(FridaModuleLoadedEvent evt, Void v) {
        FridaModuleInfo info = (FridaModuleInfo)evt.getInfo();
        long n = info.getNumberOfModules();
        FridaProcess process = info.getProcess();
        int i = 0;
        while ((long)i < n) {
            ((FridaEventsListener)this.getEventListeners().invoke()).moduleLoaded(process, info, i, evt.getCause());
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processModuleReplaced(FridaModuleReplacedEvent evt, Void v) {
        FridaModuleInfo info = (FridaModuleInfo)evt.getInfo();
        long n = info.getNumberOfModules();
        FridaProcess process = info.getProcess();
        int i = 0;
        while ((long)i < n) {
            ((FridaEventsListener)this.getEventListeners().invoke()).moduleReplaced(process, info, i, evt.getCause());
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processModuleUnloaded(FridaModuleUnloadedEvent evt, Void v) {
        FridaModuleInfo info = (FridaModuleInfo)evt.getInfo();
        long n = info.getNumberOfModules();
        FridaProcess process = info.getProcess();
        int i = 0;
        while ((long)i < n) {
            ((FridaEventsListener)this.getEventListeners().invoke()).moduleUnloaded(process, info, i, evt.getCause());
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processMemoryRegionAdded(FridaMemoryRegionAddedEvent evt, Void v) {
        FridaRegionInfo info = (FridaRegionInfo)evt.getInfo();
        long n = info.getNumberOfRegions();
        FridaProcess process = info.getProcess();
        int i = 0;
        while ((long)i < n) {
            ((FridaEventsListener)this.getEventListeners().invoke()).regionAdded(process, info, i, evt.getCause());
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processMemoryRegionReplaced(FridaMemoryRegionReplacedEvent evt, Void v) {
        FridaRegionInfo info = (FridaRegionInfo)evt.getInfo();
        long n = info.getNumberOfRegions();
        FridaProcess process = info.getProcess();
        int i = 0;
        while ((long)i < n) {
            ((FridaEventsListener)this.getEventListeners().invoke()).regionReplaced(process, info, i, evt.getCause());
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processMemoryRegionRemoved(FridaMemoryRegionRemovedEvent evt, Void v) {
        FridaRegionInfo info = (FridaRegionInfo)evt.getInfo();
        long n = info.getNumberOfRegions();
        FridaProcess process = info.getProcess();
        int i = 0;
        while ((long)i < n) {
            ((FridaEventsListener)this.getEventListeners().invoke()).regionRemoved(process, info, i, evt.getCause());
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected FridaClient.DebugStatus processStateChanged(FridaStateChangedEvent evt, Void v) {
        String id;
        this.status = FridaClient.DebugStatus.fromArgument(evt.newState());
        String string = id = this.currentThread == null ? FridaClient.getId(this.currentProcess) : FridaClient.getId(this.currentThread);
        if (this.status.equals((Object)FridaClient.DebugStatus.NO_DEBUGGEE)) {
            this.waiting = false;
            if (((FridaState)((Object)this.state.get())).equals((Object)FridaState.FRIDA_THREAD_HALTED)) {
                if (this.currentThread != null) {
                    this.processEvent(new FridaRunningEvent(id));
                }
                this.processEvent(new FridaProcessExitedEvent(0));
                this.processEvent(new FridaSessionExitedEvent(FridaClient.getId(this.currentSession), 0));
            }
            return FridaClient.DebugStatus.NO_DEBUGGEE;
        }
        if (this.status.equals((Object)FridaClient.DebugStatus.BREAK)) {
            this.waiting = false;
            FridaProcess process = this.getCurrentProcess();
            if (process != null) {
                this.processEvent(new FridaProcessSelectedEvent(process));
                if (this.currentThread != null) {
                    FridaThreadInfo tinfo = new FridaThreadInfo(this.currentThread);
                    this.processEvent(new FridaThreadSelectedEvent(tinfo));
                }
            }
            this.processEvent(new FridaStoppedEvent(id));
            return FridaClient.DebugStatus.BREAK;
        }
        if (this.status.equals((Object)FridaClient.DebugStatus.GO)) {
            this.waiting = true;
            this.processEvent(new FridaRunningEvent(id));
            return FridaClient.DebugStatus.GO;
        }
        this.waiting = false;
        return FridaClient.DebugStatus.NO_CHANGE;
    }

    protected FridaClient.DebugStatus processSessionSelected(FridaSessionSelectedEvent evt, Void v) {
        FridaSession session = evt.getSession();
        ((FridaEventsListener)this.getEventListeners().invoke()).sessionSelected(session, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected void processConsoleOutput(FridaConsoleOutputEvent evt, Void v) {
        if (evt.getOutput() != null) {
            ((FridaEventsListener)this.getEventListeners().invoke()).consoleOutput(evt.getOutput(), evt.getMask());
        }
    }

    @Override
    public CompletableFuture<Void> listThreads(FridaProcess process) {
        return this.execute(new FridaListThreadsCommand(this, process));
    }

    @Override
    public CompletableFuture<Map<String, FridaProcess>> listProcesses(FridaSession session) {
        return this.execute(new FridaListProcessesCommand(this, session));
    }

    @Override
    public CompletableFuture<List<Pair<String, String>>> listAvailableProcesses() {
        return this.execute(new FridaListAvailableProcessesCommand(this));
    }

    @Override
    public CompletableFuture<List<Pair<String, String>>> listAvailableDevices() {
        return this.execute(new FridaListAvailableDevicesCommand(this));
    }

    @Override
    public CompletableFuture<Map<String, FridaSession>> listSessions() {
        return this.execute(new FridaListSessionsCommand(this));
    }

    @Override
    public CompletableFuture<Map<String, FridaFrame>> listStackFrames(FridaThread thread) {
        return this.execute(new FridaListStackFramesCommand(this, thread));
    }

    @Override
    public CompletableFuture<Map<String, String>> listRegisters(FridaThread thread) {
        return this.execute(new FridaListRegistersCommand(this, thread));
    }

    @Override
    public CompletableFuture<Void> listModules(FridaProcess process) {
        return this.execute(new FridaListModulesCommand(this, process));
    }

    public CompletableFuture<Void> listKernelModules() {
        return this.execute(new FridaListKernelModulesCommand(this));
    }

    @Override
    public CompletableFuture<Map<String, FridaSection>> listModuleSections(FridaModule module) {
        return this.execute(new FridaListModuleSectionsCommand(this, module));
    }

    @Override
    public CompletableFuture<Map<String, FridaSymbol>> listModuleSymbols(FridaModule module) {
        return this.execute(new FridaListModuleSymbolsCommand(this, module));
    }

    @Override
    public CompletableFuture<Map<String, FridaImport>> listModuleImports(FridaModule module) {
        return this.execute(new FridaListModuleImportsCommand(this, module));
    }

    @Override
    public CompletableFuture<Map<String, FridaExport>> listModuleExports(FridaModule module) {
        return this.execute(new FridaListModuleExportsCommand(this, module));
    }

    @Override
    public CompletableFuture<Void> listMemory(FridaProcess process) {
        return this.execute(new FridaListMemoryRegionsCommand(this, process));
    }

    public CompletableFuture<Void> listKernelMemory() {
        return this.execute(new FridaListKernelMemoryRegionsCommand(this));
    }

    @Override
    public CompletableFuture<Void> listHeapMemory(FridaProcess process) {
        return this.execute(new FridaListHeapMemoryRegionsCommand(this, process));
    }

    @Override
    public CompletableFuture<Void> setExceptionHandler(FridaProcess process) {
        return this.execute(new FridaSetExceptionHandlerCommand(this, process));
    }

    @Override
    public CompletableFuture<Void> getSessionAttributes(FridaSession session) {
        return this.execute(new FridaGetSessionAttributesCommand(this, session));
    }

    @Override
    public CompletableFuture<FridaProcess> addProcess() {
        return this.execute(new FridaAddProcessCommand(this));
    }

    @Override
    public CompletableFuture<Void> removeProcess(FridaProcess process) {
        return this.execute(new FridaRemoveProcessCommand(this, process.getSession(), process.getPID().toString()));
    }

    @Override
    public CompletableFuture<FridaSession> addSession() {
        return this.execute(new FridaAddSessionCommand(this));
    }

    @Override
    public CompletableFuture<?> attach(String pid) {
        return this.execute(new FridaAttachCommand(this, pid));
    }

    @Override
    public CompletableFuture<?> attachDeviceById(String id) {
        return this.execute(new FridaAttachDeviceByIdCommand(this, id));
    }

    @Override
    public CompletableFuture<?> attachDeviceByType(String id) {
        return this.execute(new FridaAttachDeviceByTypeCommand(this, id));
    }

    @Override
    public CompletableFuture<?> launch(String fileName, List<String> args) {
        return this.execute(new FridaLaunchProcessCommand(this, fileName, args));
    }

    @Override
    public CompletableFuture<?> launch(Map<String, ?> args) {
        return this.execute(new FridaLaunchProcessWithOptionsCommand(this, args));
    }

    public FridaClient getClient() {
        return this.executor.getClient();
    }

    public FridaThread getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(FridaThread thread) {
        this.currentThread = thread;
    }

    public void setCurrentThreadById(String tid) {
        this.currentProcess = this.currentSession.getProcess();
        if (this.currentProcess != null) {
            String key = FridaClient.getId(this.currentProcess);
            this.currentThread = this.threads.get(key).get(tid);
        }
    }

    public FridaProcess getCurrentProcess() {
        return this.currentProcess;
    }

    public FridaSession getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(FridaSession session) {
        this.currentSession = session;
    }

    @Override
    public FridaTarget getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public void setCurrentTarget(FridaTarget target) {
        this.currentTarget = target;
    }

    public CompletableFuture<Void> requestFocus(FridaModelTargetFocusScope scope, TargetObject obj) {
        return this.execute(new FridaRequestFocusCommand(this, scope, obj));
    }

    public CompletableFuture<Void> requestActivation(FridaModelTargetActiveScope activator, TargetObject obj) {
        return this.execute(new FridaRequestActivationCommand(this, activator, obj));
    }

    @Override
    public CompletableFuture<Void> console(String command) {
        if (this.continuation != null) {
            String prompt = command.equals("") ? "(frida)" : ">>>";
            ((FridaEventsListener)this.getEventListeners().invoke()).promptChanged(prompt);
            this.continuation.complete(command);
            this.setContinuation(null);
            return AsyncUtils.nil();
        }
        return this.execute(new FridaConsoleExecCommand(this, command, FridaConsoleExecCommand.Output.CONSOLE)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command) {
        return this.execute(new FridaConsoleExecCommand(this, command, FridaConsoleExecCommand.Output.CAPTURE));
    }

    @Override
    public FridaState getState() {
        if (this.currentThread == null) {
            return null;
        }
        if (this.currentThread != null) {
            return FridaState.FRIDA_THREAD_RUNNING;
        }
        return this.currentThread.getState();
    }

    @Override
    public FridaProcess currentProcess() {
        return this.getCurrentProcess();
    }

    @Override
    public CompletableFuture<Void> waitForPrompt() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<? extends Map<String, ?>> getRegisterMap(List<String> path) {
        return null;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public boolean isKernelMode() {
        return this.kernelMode;
    }

    public void setKernelMode(boolean kernelMode) {
        this.kernelMode = kernelMode;
    }

    public void setContinuation(CompletableFuture<String> continuation) {
        this.continuation = continuation;
    }

    @Override
    public FridaClient.DebugStatus getStatus() {
        return this.status;
    }

    public FridaScript loadPermanentScript(AbstractFridaCommand<?> caller, String name, String scriptText) {
        caller.setName(name);
        Pointer options = FridaEng.createOptions(name);
        FridaScript script = FridaEng.createScript(this.currentSession, scriptText, options);
        NativeLong signal = FridaEng.connectSignal(script, "message", (__s, message, data, userData) -> caller.parse(message, data), null);
        script.setSignal(signal);
        FridaEng.loadScript(script);
        this.scripts.put(name, script);
        return script;
    }

    public void unloadPermanentScript(String name) {
        FridaScript script = this.scripts.get(name);
        NativeLong signal = script.getSignal();
        FridaEng.disconnectSignal(script, signal);
        FridaEng.unloadScript(script);
        FridaEng.unref(script);
    }

    public FridaScript loadScript(AbstractFridaCommand<?> caller, String name, String scriptText) {
        caller.setName(name);
        Pointer options = FridaEng.createOptions(name);
        String wrapperText = scriptText.contains("result") ? "var result = '';" + scriptText + "var msg = { key: '" + name + "', value: result};send(JSON.stringify(msg));" : "send(JSON.stringify(" + scriptText + "));";
        FridaScript script = FridaEng.createScript(this.currentSession, wrapperText, options);
        if (script != null) {
            NativeLong signal = FridaEng.connectSignal(script, "message", (__s, message, data, userData) -> caller.parse(message, data), null);
            script.setSignal(signal);
            FridaEng.loadScript(script);
            caller.setScript(script);
            FridaEng.disconnectSignal(script, signal);
            FridaEng.unloadScript(script);
            FridaEng.unref(script);
        }
        return script;
    }

    @Override
    public void enableDebugger(FridaSession session, int port) {
        FridaEng.enableDebugger(session, new NativeLong((long)port));
    }

    public CompletableFuture<Void> stalkThread(String tid, Map<String, ?> arguments) {
        return this.execute(new FridaStalkThreadCommand(this, tid, arguments));
    }

    public CompletableFuture<Void> interceptFunction(String address, Map<String, ?> arguments) {
        return this.execute(new FridaInterceptFunctionCommand(this, address, arguments));
    }

    public CompletableFuture<Void> watchMemory(Map<String, ?> arguments) {
        return this.execute(new FridaWatchMemoryCommand(this, arguments));
    }
}

